/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.strategy;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.EmbConstants;
import com.sobey.bsp.cms.site.Transcode2JSON;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.notice.AutoPush;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentInfoLogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSet;
import com.sobey.bsp.schema.SCMS_TranscodegroupSchema;
import com.sobey.cms.interfaces.tool.impl.ChannelRecordInterfaceImpl;
import com.sobey.cms.interfaces.tool.impl.MediaEditCutInterfaceImpl;
import com.sobey.scms.contentinfo.DemandVideoLib;
import com.sobey.scms.contentinfo.interfaces.impl.ImageInfoInterfaceImpl;
import com.sobey.scms.contentinfo.interfaces.util.CallBackMainService;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.contentinfo.log.DemandMeidaLog;
import com.sobey.scms.search.ContentSearchMediator;
import com.sobey.scms.trasncode.format.MBMediaTransFileFormat;
import com.sobey.scms.trasncode.format.MBOssMediaMoveFileFormat;
import com.sobey.scms.trasncode.format.PCMediaTransFileFormat;
import com.sobey.scms.trasncode.format.PCOssMediaMoveFileFormat;
import com.sobey.scms.trasncode.strategy.TranscodeStrategy;
import com.sobey.scms.trasncode.util.TranscodeUtil;
import com.sobey.scms.trasncode.workflow.ExtractFrameStep;
import com.sobey.scms.trasncode.workflow.GenerateTransTailStep;
import com.sobey.scms.trasncode.workflow.GenerateVlengthStep;
import com.sobey.scms.trasncode.workflow.GenrateNoSplitHeaderStep;
import com.sobey.scms.trasncode.workflow.MediaMoveStep;
import com.sobey.scms.trasncode.workflow.MediaTransStep;
import com.sobey.scms.trasncode.workflow.TranscodeStepable;
import com.sobey.scms.trasncode.workflow.TranscodeWorkFlow;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class NoSplitTranscodeStrategy
implements TranscodeStrategy {
    static Logger logger = Logger.getLogger(NoSplitTranscodeStrategy.class);
    private TranscodeWorkFlow workFlow;
    public static String basePath = Config.getContextRealPath() + "WEB-INF/classes/template/";

    public NoSplitTranscodeStrategy() {
        ArrayList steps = new ArrayList();
        this.workFlow = new TranscodeWorkFlow(steps);
    }

    public String generateXml(SCMS_TranscodegroupSchema transcodeGroup, Map map) {
        StringBuilder sb = new StringBuilder();
        try {
            GenrateNoSplitHeaderStep headerStep = new GenrateNoSplitHeaderStep(basePath + "mpc-nosplit-header.vm");
            headerStep.wrapParams2JSON(transcodeGroup, map);
            this.workFlow.addStep((TranscodeStepable)headerStep);
            this.addTransSteps(transcodeGroup, map);
            if (map.get("keyFrameFlag").equals("1")) {
                int index = Integer.parseInt(map.get("index").toString());
                String alias = SiteUtil.getAlias((String)map.get("siteId").toString());
                String bathimagedir = Config.getValue((String)"winImageDir") + alias + "\\";
                map.put("bathimagedir", bathimagedir);
                map.put("count", ++index);
                ExtractFrameStep extractFrameStep = new ExtractFrameStep(basePath + "mpc-nosplit-extractframe.vm");
                extractFrameStep.wrapParams2JSON(transcodeGroup, map);
                this.workFlow.addStep((TranscodeStepable)extractFrameStep);
            }
            GenerateVlengthStep vLengthStep = new GenerateVlengthStep(basePath + "mpc-split-vlength.vm");
            vLengthStep.wrapParams2JSON(transcodeGroup, map);
            this.workFlow.addStep((TranscodeStepable)vLengthStep);
            GenerateTransTailStep tailStep = new GenerateTransTailStep(basePath + "mpc-common-tail.vm");
            this.workFlow.addStep((TranscodeStepable)tailStep);
            sb.append(this.workFlow.execute());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void addTransSteps(SCMS_TranscodegroupSchema transcodeGroup, Map map) {
        try {
            int index = 0;
            Long siteId = Long.parseLong(map.get("siteId").toString());
            JSONObject paramObj = JSONObject.fromObject((Object)transcodeGroup.getParam());
            String tid = transcodeGroup.getTid();
            DataTable dt = TranscodeUtil.findTranscodeByParentid((String)tid, (long)siteId, (boolean)false);
            EmbConstants.initFormatMap();
            String winDir = Config.getValue((String)"winVideoDir") + SiteUtil.getAlias((long)siteId) + "/vod/";
            JSONArray waterFiles = paramObj.getJSONArray("waterFiles");
            JSONObject waterFile = null;
            map.put("winDir", StringUtil.replaceAllToBack_Slant((String)winDir));
            for (int i = 0; i < dt.getRowCount(); ++i) {
                JSONObject tsParams;
                String tsCodeRate;
                String tsFlag;
                String pcTransFlag = "1";
                String transTSFlag = "0";
                Transcode2JSON transcode = TranscodeUtil.getTranscode2JSON((String)dt.getString(i, "availableParam"));
                String waterFlag = "0";
                String birate = dt.getString(i, "name");
                String commonFlag = StringUtil.isNotEmpty((String)transcode.getCommonFlag()) ? transcode.getCommonFlag() : "0";
                map.put("transcode", transcode);
                for (int j = 0; j < waterFiles.size(); ++j) {
                    waterFile = waterFiles.getJSONObject(i);
                    if (!waterFile.getString("name").equals(birate)) continue;
                    if (!StringUtil.isNotEmpty((String)waterFile.getString("waterFilePath"))) break;
                    waterFlag = "1";
                    break;
                }
                if (waterFlag.equals("1")) {
                    map.put("paramObj", paramObj);
                    map.put("waterFile", waterFile);
                    map.put("waterMarkFlag", "1");
                }
                if (StringUtil.isNotEmpty((String)transcode.getPcTransFlag()) && transcode.getPcTransFlag().equals("0")) {
                    pcTransFlag = "0";
                }
                if (pcTransFlag.equals("1")) {
                    map.put("index", ++index);
                    map.put("codeRate", transcode.getVideoCodeRate());
                    map.put("rename", "");
                    if (commonFlag.equals("1")) {
                        map.put("groupType", "MP4_CM");
                    } else if (commonFlag.equals("0")) {
                        map.put("groupType", "MP4_PC");
                    }
                    MediaTransStep mediaTransStep = new MediaTransStep(basePath + "mpc-nosplit-trans.vm", 1);
                    mediaTransStep.wrapParams2JSON(transcodeGroup, map);
                    this.workFlow.addStep((TranscodeStepable)mediaTransStep);
                    if (SiteUtil.isSupportOSSStorage((long)siteId)) {
                        map.put("index", ++index);
                        if (commonFlag.equals("1")) {
                            map.put("groupType", "MP4_CM_OSS");
                        } else if (commonFlag.equals("0")) {
                            map.put("groupType", "MP4_PC_OSS");
                        }
                        MediaMoveStep mediaMoveStep = new MediaMoveStep(basePath + "mpc-move-oss.vm", 5);
                        mediaMoveStep.wrapParams2JSON(transcodeGroup, map);
                        this.workFlow.addStep((TranscodeStepable)mediaMoveStep);
                    }
                }
                JSONObject tt = JSONObject.fromObject((Object)dt.getString(i, "availableParam"));
                if ((!pcTransFlag.equals("0") || !tt.has("tsParams")) && (!tt.has("tsParams") || !commonFlag.equals("0")) || (transTSFlag = (tsFlag = tt.getJSONObject("tsParams").getString("transTSFlag"))).equals("0") || "1080P\u6682\u65e0\u7801\u7387\u53ef\u9009".equals(tsCodeRate = (tsParams = tt.getJSONObject("tsParams")).getString("tsCodeRate"))) continue;
                map.put("index", ++index);
                map.put("codeRate", tsCodeRate);
                map.put("groupType", "MP4_MB");
                transcode.setBreadthAdapt(tsParams.getString("mbBreadthAdapt"));
                if (tsParams.has("mbBreadthWidth")) {
                    transcode.setBreadthWidth(tsParams.getString("mbBreadthWidth"));
                    transcode.setBreadthHeight(tsParams.getString("mbBreadthHeight"));
                }
                if (tsParams.has("rename") && "1".equals(tsParams.getString("rename"))) {
                    map.put("rename", "_mb");
                } else {
                    map.put("rename", "");
                }
                MediaTransStep mbTransStep = new MediaTransStep(basePath + "mpc-nosplit-trans.vm", 1);
                mbTransStep.wrapParams2JSON(transcodeGroup, map);
                this.workFlow.addStep((TranscodeStepable)mbTransStep);
                if (!SiteUtil.isSupportOSSStorage((long)siteId)) continue;
                map.put("index", ++index);
                map.put("groupType", "MP4_MB_OSS");
                MediaMoveStep mediaMoveStep = new MediaMoveStep(basePath + "mpc-move-oss.vm", 5);
                mediaMoveStep.wrapParams2JSON(transcodeGroup, map);
                this.workFlow.addStep((TranscodeStepable)mediaMoveStep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String parseXml(Document doc) {
        Boolean flag = false;
        Node mpcNotify = doc.selectSingleNode("//MPCNotify");
        String contentSourceId = "";
        if (null != mpcNotify) {
            QueryBuilder qb;
            SCMS_ContentinfoSchema contentinfo;
            SCMS_ContentinfoSet contnetinfoSet;
            Date date = new Date();
            Node statusNode = mpcNotify.selectSingleNode("//NotifyEvent");
            Node taskIdNode = mpcNotify.selectSingleNode("//TaskGUID");
            int status = 0;
            if (StringUtil.isNotEmpty((String)statusNode.getText())) {
                status = Integer.parseInt(statusNode.getText());
            }
            System.out.print("\u8fd4\u56de\u7684\u72b6\u6001\u503c\u4e3astatus************" + status + "***********\n");
            if (StringUtil.isNotEmpty((String)taskIdNode.getText())) {
                contentSourceId = taskIdNode.getText();
            }
            if ((contnetinfoSet = (contentinfo = new SCMS_ContentinfoSchema()).query(qb = new QueryBuilder("where contentsourceid ='" + contentSourceId + "'"))) != null && contnetinfoSet.size() > 0) {
                contentinfo = contnetinfoSet.get(0);
                long oldStatus = contentinfo.getStatus();
                if (2L != oldStatus && 3L != oldStatus) {
                    return "1";
                }
                Long siteId = contentinfo.getSiteid();
                if (status == 256) {
                    List mediaFile = mpcNotify.selectNodes("MediaFile");
                    if (mediaFile != null && mediaFile.size() > 0) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        NoSplitTranscodeStrategy.getParsedProgramLength((List)mediaFile, map);
                        Transaction trans1 = new Transaction();
                        String xml = doc.asXML();
                        SCMS_TranscodegroupSchema transCodeGroup = new SCMS_TranscodegroupSchema();
                        transCodeGroup.setID(Long.valueOf(contentinfo.getTranscodeid().intValue()));
                        transCodeGroup.fill();
                        DataTable dtTranscode = TranscodeUtil.findTranscodeByParentid((String)transCodeGroup.getTid(), (long)contentinfo.getSiteid(), (boolean)false);
                        String baseDir = StringUtil.replaceAllToBack_Slant((String)(Config.getValue((String)"winVideoDir") + SiteUtil.getAlias((long)contentinfo.getSiteid())));
                        String transcodeSource = "";
                        Node transcodeSourceN = doc.selectSingleNode("//MPCNotify//TaskInfo//Data//transcodeSource");
                        if (null != transcodeSourceN) {
                            transcodeSource = transcodeSourceN.getText();
                        }
                        map.put("trans", trans1);
                        map.put("contentinfo", contentinfo);
                        map.put("mediaFileList", mediaFile);
                        map.put("baseDir", baseDir);
                        map.put("dtTranscode", dtTranscode);
                        map.put("transcodeSource", transcodeSource);
                        PCOssMediaMoveFileFormat transFileFormat = null;
                        if (SiteUtil.isSupportOSSStorage((long)siteId)) {
                            if (xml.contains("<GroupType>MP4_PC_OSS</GroupType>") || xml.contains("<GroupType>MP4_CM_OSS</GroupType>")) {
                                transFileFormat = new PCOssMediaMoveFileFormat();
                                transFileFormat.parseXml(map);
                            }
                            if (xml.contains("<GroupType>MP4_MB_OSS</GroupType>") || xml.contains("<GroupType>MP4_CM_OSS</GroupType>")) {
                                transFileFormat = new MBOssMediaMoveFileFormat();
                                transFileFormat.parseXml(map);
                            }
                        } else {
                            if (xml.contains("<GroupType>MP4_PC</GroupType>") || xml.contains("<GroupType>MP4_CM</GroupType>")) {
                                transFileFormat = new PCMediaTransFileFormat();
                                transFileFormat.parseXml(map);
                            }
                            if (xml.contains("<GroupType>MP4_MB</GroupType>") || xml.contains("<GroupType>MP4_CM</GroupType>")) {
                                transFileFormat = new MBMediaTransFileFormat();
                                transFileFormat.parseXml(map);
                            }
                        }
                        logger.info((Object)("\u6e90\u6587\u4ef6\u8def\u5f84**********" + map.get("srcFileName")));
                        NoSplitTranscodeStrategy.parseKeyframes(map);
                        NoSplitTranscodeStrategy.saveAndPublish(map);
                        flag = true;
                    }
                } else if (status == 8 || status == 2048) {
                    Transaction trans = new Transaction();
                    contentinfo.setStatus(Long.valueOf(3L));
                    contentinfo.setModifyTime(date);
                    trans.add((Schema)contentinfo, 2);
                    DemandMeidaLog demandLog = new DemandMeidaLog();
                    demandLog.addContentinfoLog(trans, contentinfo.getContentID().longValue(), "UPDATE", "\u89c6\u9891MPC\u667a\u80fd\u5206\u7247\u8f6c\u7801\u5931\u8d25\u66f4\u65b0", date, "\u4e91\u8f6c\u7801");
                    trans.commit();
                    String[] contentIds = new String[]{contentinfo.getContentID().toString()};
                    AutoPush.autoFailCallBack((String[])contentIds, (Long)contentinfo.getSiteid(), (int)5);
                    CallBackMainService thread = new CallBackMainService(contentinfo.getContentID().longValue(), contentinfo.getSiteid().longValue(), "1");
                    thread.start();
                }
            }
        }
        if (flag.booleanValue()) {
            ChannelRecordInterfaceImpl.mpcTransCodeCallBack((int)1, (String)contentSourceId);
            MediaEditCutInterfaceImpl.mpcTransCodeCallBack((int)1, (int)5, (String)contentSourceId);
        } else {
            ChannelRecordInterfaceImpl.mpcTransCodeCallBack((int)0, (String)contentSourceId);
            MediaEditCutInterfaceImpl.mpcTransCodeCallBack((int)0, (int)5, (String)contentSourceId);
        }
        return flag != false ? "1" : "0";
    }

    private static void getParsedProgramLength(List mediaFile, Map map) {
        Long prolength = 0L;
        double duration = 0.0;
        JSONObject sourceMediainfo = new JSONObject();
        try {
            for (int i = 0; i < mediaFile.size(); ++i) {
                String groupType;
                Node node = (Node)mediaFile.get(i);
                Node groupTypeNode = node.selectSingleNode("GroupType");
                String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                if (!"videoLenth".equals(groupType)) continue;
                Node fileParamNode = node.selectSingleNode("FileParam");
                Node durationNode = fileParamNode.selectSingleNode("Duration");
                Node fileSizeNode = fileParamNode.selectSingleNode("FileSize");
                Node VideoFormatNode = fileParamNode.selectSingleNode("VideoFormat");
                Node ImageWidthNode = fileParamNode.selectSingleNode("ImageWidth");
                Node ImageHeightNode = fileParamNode.selectSingleNode("ImageHeight");
                Node KeyFrameRateNode = fileParamNode.selectSingleNode("KeyFrameRate");
                Node AudioFormatNode = fileParamNode.selectSingleNode("AudioFormat");
                long programLength = Long.parseLong(durationNode.getText());
                duration = Math.floor(Double.parseDouble(String.valueOf(programLength)) / 1.0E7);
                prolength = programLength / 10000L;
                sourceMediainfo.put((Object)"fileSize", (Object)fileSizeNode.getText());
                sourceMediainfo.put((Object)"duration", (Object)prolength);
                sourceMediainfo.put((Object)"videoFormat", (Object)VideoFormatNode.getText());
                sourceMediainfo.put((Object)"audioFormat", (Object)AudioFormatNode.getText());
                sourceMediainfo.put((Object)"imageWidth", (Object)ImageWidthNode.getText());
                sourceMediainfo.put((Object)"imageHeight", (Object)ImageHeightNode.getText());
                sourceMediainfo.put((Object)"keyFrameRate", (Object)KeyFrameRateNode.getText());
            }
            System.out.println("----\u6e90\u89c6\u9891\u4fe1\u606f111-----" + sourceMediainfo.toString());
            map.put("programLength", prolength);
            map.put("sourceMediaInfo", sourceMediainfo.toString());
            map.put("duration", duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseKeyframes(Map map) {
        block14: {
            SCMS_ContentinfoSchema contentinfo = (SCMS_ContentinfoSchema)map.get("contentinfo");
            String transcodeSource = (String)map.get("transcodeSource");
            List mediaFile = (List)map.get("mediaFileList");
            Transaction trans = (Transaction)map.get("trans");
            String programLength = map.get("programLength").toString();
            JSONObject keyFramesJo = new JSONObject();
            ArrayList keyFrames = new ArrayList();
            String alias = SiteUtil.getAlias((long)contentinfo.getSiteid());
            String basedir = StringUtil.replaceAllToSlant((String)(Config.getValue((String)"winImageDir") + alias));
            String sourceSystemID = contentinfo.getSourceSystemID().toString();
            String keyFrame = contentinfo.getKeyFrame();
            String picName = contentinfo.getTitle();
            LinkedHashMap<String, String> imageMap = new LinkedHashMap<String, String>();
            String defaultImage = "";
            String totalImagePath = "";
            try {
                String imagePath;
                for (int i = 0; i < mediaFile.size(); ++i) {
                    String groupType;
                    Node node = (Node)mediaFile.get(i);
                    Node groupTypeNode = node.selectSingleNode("GroupType");
                    Node fileNameNode = node.selectSingleNode("FileName");
                    String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                    if (!"PIC_OUT".equals(groupType)) continue;
                    imagePath = fileNameNode.getText();
                    Node imageSizeNode = node.selectSingleNode("MediaType");
                    String imageSize = imageSizeNode.getText();
                    if (imageSize.indexOf("_") > 0) {
                        imageMap.put(imageSize, imagePath);
                        continue;
                    }
                    totalImagePath = fileNameNode.getText();
                }
                ImageInfoInterfaceImpl iii = new ImageInfoInterfaceImpl();
                if (!"UPLOAD".equals(transcodeSource) && !"QUICKDEMOLTION".equals(transcodeSource)) break block14;
                if (imageMap.size() > 0) {
                    int count = 0;
                    for (Map.Entry entry : imageMap.entrySet()) {
                        String imageSize = (String)entry.getKey();
                        imagePath = StringUtil.replaceAllToSlant((String)((String)entry.getValue()));
                        if (imagePath.indexOf("/upload/Image/default/") != -1) {
                            imagePath = imagePath.substring(imagePath.lastIndexOf("/upload/Image/default/"));
                        }
                        if (count == imageMap.size() / 2) {
                            defaultImage = imagePath;
                        }
                        JSONObject imageInfo = new JSONObject();
                        if (imageSize.indexOf("_") > 0) {
                            String width = imageSize.split("_")[0];
                            String height = imageSize.split("_")[1];
                            imageInfo.put((Object)"width", (Object)width);
                            imageInfo.put((Object)"height", (Object)height);
                        }
                        imageInfo.put((Object)"imageUrl", (Object)imagePath);
                        imageInfo.put((Object)"contentId", (Object)contentinfo.getContentID());
                        imageInfo.put((Object)"contentSourceId", (Object)contentinfo.getContentSourceId());
                        imageInfo.put((Object)"mediaType", (Object)5);
                        imageInfo.put((Object)"terminal", (Object)1);
                        iii.saveImageInfo(imageInfo, trans);
                        ++count;
                    }
                } else {
                    int count = 0;
                    String[] imagePaths = totalImagePath.split(";");
                    for (int i = imagePaths.length - 1; i >= 0; --i) {
                        String imagePath2 = StringUtil.replaceAllToSlant((String)imagePaths[i]);
                        if (imagePath2.indexOf("/upload/Image/default/") != -1) {
                            imagePath2 = imagePath2.substring(imagePath2.lastIndexOf("/upload/Image/default/"));
                        }
                        if (count == imageMap.size() / 2) {
                            defaultImage = imagePath2;
                        }
                        JSONObject imageInfo = new JSONObject();
                        imageInfo.put((Object)"imageUrl", (Object)imagePath2);
                        imageInfo.put((Object)"contentId", (Object)contentinfo.getContentID());
                        imageInfo.put((Object)"contentSourceId", (Object)contentinfo.getContentSourceId());
                        imageInfo.put((Object)"mediaType", (Object)5);
                        imageInfo.put((Object)"terminal", (Object)1);
                        iii.saveImageInfo(imageInfo, trans);
                        ++count;
                    }
                }
                contentinfo.setProgramLength(programLength);
                if (!"1".equals(sourceSystemID) && !"6".equals(sourceSystemID) || StringUtil.isEmpty((String)keyFrame)) {
                    contentinfo.setKeyFrame(StringUtil.replaceAllToSlant((String)defaultImage));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void saveAndPublish(Map map) {
        String statusFlag = "";
        String statusValue = "";
        Date date = new Date();
        Transaction trans = (Transaction)map.get("trans");
        SCMS_ContentinfoSchema contentinfo = (SCMS_ContentinfoSchema)map.get("contentinfo");
        String styleTypes = contentinfo.getStyleTypes();
        String isPublish = null == contentinfo.getIsPublish() ? "" : contentinfo.getIsPublish().toString();
        try {
            String workFlowId = new QueryBuilder("select WORKFLOWID from scms_site where id='" + contentinfo.getSiteid() + "'").executeString();
            if (StringUtil.isEmpty((String)workFlowId) || "0".equals(workFlowId)) {
                if (StringUtil.isNotEmpty((String)isPublish) && "0".equals(isPublish)) {
                    statusFlag = "0";
                    statusValue = "0";
                    contentinfo.setStatus(Long.valueOf(0L));
                } else {
                    statusFlag = "0";
                    statusValue = "1";
                    contentinfo.setStatus(Long.valueOf(1L));
                    contentinfo.setPublishDate(date);
                }
            } else {
                statusFlag = "0";
                statusValue = "-1";
                contentinfo.setStatus(Long.valueOf(-1L));
            }
            if (StringUtil.isNotEmpty((String)styleTypes)) {
                styleTypes = styleTypes.substring(0, styleTypes.length() - 1);
            }
            contentinfo.setSourceMediaInfo((String)map.get("sourceMediaInfo"));
            contentinfo.setModifyTime(date);
            contentinfo.setContentPath("/vod/");
            contentinfo.setStyleTypes(styleTypes);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String createTime = format.format(contentinfo.getCreateTime());
            SCMS_ContentInfoLogSchema log = new SCMS_ContentInfoLogSchema();
            log.setID(NoUtil.getMaxID((String)"ContentInfoLogId"));
            log.setContentId(contentinfo.getContentID().longValue());
            log.setAction("UPDATE");
            log.setActionDetail("\u89c6\u9891MPC\u8f6c\u7801\u6210\u529f\u66f4\u65b0");
            log.setAddTime(new Date());
            log.setAddUser("\u4e91\u8f6c\u7801");
            trans.add((Schema)log, 1);
            trans.add((Schema)contentinfo, 2);
            String[] contentIds = new String[]{contentinfo.getContentID().toString()};
            if (trans.commit()) {
                ContentSearchMediator.publishVideo2Search((String)ContentUtil.idsArrayToString((String[])contentIds), (String)SiteUtil.getAlias((long)contentinfo.getSiteid()), (long)contentinfo.getSiteid());
                if ("1".equals(statusValue)) {
                    AutoPush.autoPushCDN((String[])contentIds, (Long)contentinfo.getSiteid(), (int)5);
                }
                CallBackMainService thread = new CallBackMainService(contentinfo.getContentID().longValue(), contentinfo.getSiteid().longValue(), "0");
                thread.start();
                DemandVideoLib.generateStaticVideoFile((String)statusValue, (String[])contentIds, (String)contentinfo.getSiteid().toString(), (String)contentinfo.getSourceSystemName(), (String)contentinfo.getTsPlayUrl(), (String)contentinfo.getMp4PlayUrl(), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

