/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.strategy;

import com.sobey.bsp.schema.SCMS_TranscodegroupSchema;
import com.sobey.scms.trasncode.strategy.AudioTranscodeStrategy;
import com.sobey.scms.trasncode.strategy.NoSplitTranscodeStrategy;
import com.sobey.scms.trasncode.strategy.PolicyTranscodeStrategy;
import com.sobey.scms.trasncode.strategy.SplitTranscodeStrategy;
import com.sobey.scms.trasncode.strategy.TranscodeStrategy;
import com.sobey.scms.trasncode.util.TransCodeSendMessage;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;

public class StrategyContext {
    static Logger logger = Logger.getLogger(StrategyContext.class);
    private TranscodeStrategy transcodeStrategy;

    public TranscodeStrategy getTranscodeStrategy() {
        return this.transcodeStrategy;
    }

    public void setTranscodeStrategy(TranscodeStrategy transcodeStrategy) {
        this.transcodeStrategy = transcodeStrategy;
    }

    public void generateXml(Map map) {
        try {
            Long transcodeGroupId = Long.parseLong(map.get("transcodeGroupId").toString());
            SCMS_TranscodegroupSchema transcodeGroup = new SCMS_TranscodegroupSchema();
            transcodeGroup.setID(transcodeGroupId);
            if (transcodeGroup.fill()) {
                if (0 != transcodeGroup.getPolicyId() && transcodeGroup.getPolicyId() > 0) {
                    this.transcodeStrategy = new PolicyTranscodeStrategy();
                } else if (transcodeGroup.getGroupType() == 5) {
                    this.transcodeStrategy = transcodeGroup.getStrategyType() == 1 ? new SplitTranscodeStrategy() : new NoSplitTranscodeStrategy();
                } else if (transcodeGroup.getGroupType() == 6) {
                    this.transcodeStrategy = new AudioTranscodeStrategy();
                }
                String xml = this.transcodeStrategy.generateXml(transcodeGroup, map);
                logger.info((Object)("*****MPC\u8f6c\u7801request XML****" + xml));
                String back = TransCodeSendMessage.sendMessage((String)xml, (String)map.get("siteId").toString());
                logger.info((Object)("*****MPC\u8f6c\u7801response XML*****" + back));
            }
        }
        catch (Exception e) {
            logger.info((Object)"\u751f\u6210\u8f6c\u7801\u534f\u8bae\u5f02\u5e38", (Throwable)e);
        }
    }

    public String parseXml(String isSplit, Document doc) {
        String status = "";
        try {
            Node contentType = doc.selectSingleNode("//MPCNotify//TaskInfo//Data//ContentType");
            this.transcodeStrategy = null != contentType && "mp3".equals(contentType.getText()) ? new AudioTranscodeStrategy() : (null != isSplit && "0".equals(isSplit) ? new NoSplitTranscodeStrategy() : new SplitTranscodeStrategy());
            status = this.transcodeStrategy.parseXml(doc);
            logger.info((Object)"\u89e3\u6790\u8f6c\u7801\u8fd4\u56de\u534f\u8bae\u6b63\u5e38");
        }
        catch (Exception e) {
            logger.info((Object)"\u89e3\u6790\u8f6c\u7801\u8fd4\u56de\u534f\u8bae\u5f02\u5e38", (Throwable)e);
        }
        return status;
    }
}

