/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.virtualchannel;

import com.chinamcloud.common.storage.util.PathUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.common.util.FormatDateUtil;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_VirtualChannelConfigSchema;
import com.sobey.bsp.schema.SCMS_VirtualChannelConfigSet;
import com.sobey.scms.channel.util.ChannelLibUtil;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.virtualchannel.VchannerThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class VirtualChannelActList
extends Page {
    private static final Logger log = LoggerFactory.getLogger(VirtualChannelActList.class);
    private static Mapx versionMap = new Mapx();

    public static void dg2DataBind(DataGridAction dga) {
        String vid = dga.getParam("vid");
        String currentDate = dga.getParam("currentDate");
        String startDate = dga.getParam("startDate");
        String endDate = dga.getParam("endDate");
        StringBuffer queryCondition = new StringBuffer();
        if (StringUtil.isEmpty((String)vid)) {
            return;
        }
        if (StringUtil.isEmpty((String)currentDate)) {
            currentDate = FormatDateUtil.format2DateByFormat((Date)new Date(), (String)"yyyy-MM-dd");
        }
        if (StringUtil.isNotEmpty((String)startDate)) {
            queryCondition.append(" and V.date >= '" + startDate + "'");
        }
        if (StringUtil.isNotEmpty((String)endDate)) {
            queryCondition.append(" and V.date <= '" + endDate + "'");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select V.id, V.type, V.startTime, V.endTime, V.ProgramLength, V.content,").append("V.CreateName, V.date, V.cid, V.startPoint, V.endPoint, CL.Name, CT.title, CT.SeriesName, CT.Part, ").append("'' as ContentType, '' as RelaContentTitle, '' as ProLength,'' as isedit ").append("from scms_virtualchannelconfig V ").append("LEFT JOIN scms_channels CL on V.cid=CL.id ").append("LEFT JOIN scms_contentinfo CT on V.cid=CT.CONTENTID ").append("where V.date='" + currentDate + "' and V.vid='" + vid + "' " + queryCondition.toString() + " ").append("order by V.startTime");
        StringBuilder countSql = new StringBuilder();
        countSql.append("select count(*) from scms_virtualchannelconfig V ").append("LEFT JOIN scms_channels CL on V.cid=CL.id ").append("LEFT JOIN scms_contentinfo CT on V.cid=CT.CONTENTID ").append("where V.date='" + currentDate + "' and V.vid='" + vid + "' " + queryCondition.toString() + "");
        QueryBuilder qb = new QueryBuilder();
        qb.setSQL(countSql.toString());
        dga.setTotal(qb);
        qb.setSQL(sql.toString());
        DataTable dt = qb.executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        DataColumn[] dc = new DataColumn[dt.getColCount()];
        Object[] values = new Object[dt.getColCount()];
        for (int j = 0; j < dt.getColCount(); ++j) {
            dc[j] = dt.getDataColumn(j);
            values[j] = "";
        }
        if (dt == null || dt.getRowCount() == 0) {
            dga.bindData(dt);
            return;
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String contentType = dt.getString(i, "type");
            long programLength = dt.getLong(i, "ProgramLength");
            String relaContentTitle = "";
            if (contentType.equals("0")) {
                contentType = "\u76f4\u64ad";
                relaContentTitle = dt.getString(i, "Name");
            } else if (contentType.equals("1")) {
                contentType = "\u666e\u901a\u8282\u76ee";
                relaContentTitle = dt.getString(i, "title");
            } else if (contentType.equals("2")) {
                String part;
                contentType = "\u7535\u89c6\u5267";
                String string = part = StringUtil.isNotEmpty((String)dt.getString(i, "Part")) ? dt.getString(i, "Part") : "";
                if (StringUtil.isNotEmpty((String)part)) {
                    if (part.charAt(0) == '0' && part.charAt(1) == '0') {
                        part = String.valueOf(part.charAt(2));
                    } else if (part.charAt(0) == '0') {
                        part = part.substring(1, part.length());
                    }
                }
                relaContentTitle = dt.getString(i, "SeriesName") + part;
            }
            dt.set(i, "ContentType", (Object)contentType);
            dt.set(i, "RelaContentTitle", (Object)relaContentTitle);
            dt.set(i, "isedit", (Object)"2");
            dt.set(i, "ProLength", (Object)DateUtil.getTimeStr((long)(programLength / 1000L)));
        }
        dga.bindData(dt);
    }

    public void generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"playbillDate\":\"").append("").append("\",");
        builder.append("\"loopFlag\":\"").append("").append("\",");
        builder.append("\"timeZone\":\"").append("").append("\",");
        builder.append("\"pollingTime\":\"").append("").append("\",");
        builder.append("\"version\":\"").append("").append("\",");
        builder.append("\"playbills\":[");
        for (int i = 0; i < 10; ++i) {
            builder.append("{\"startTime\":\"").append("").append("\",");
            builder.append("\"druation\":\"").append("").append("\",");
            builder.append("\"endTime\":\"").append("").append("\",");
            builder.append("\"title\":\"").append("").append("\",");
            builder.append("\"url\":\"").append("").append("\",");
            builder.append("\"startPosition\":\"").append("").append("\",");
            builder.append("\"playMode\":\"").append("").append("\",");
            if (i == 9) {
                builder.append("\"type\":\"").append("").append("\"}");
                continue;
            }
            builder.append("\"type\":\"").append("").append("\"},");
        }
        builder.append("]}");
    }

    public void addSave() {
        String actList = this.$V("actList");
        if (StringUtil.isNotEmpty((String)actList)) {
            try {
                JSONObject jo = JSONObject.fromObject((Object)actList);
                String vid = jo.getString("vid");
                String date = jo.getString("date");
                JSONArray ja = jo.getJSONArray("playerbills");
                if (ja != null && !ja.isEmpty()) {
                    SCMS_VirtualChannelConfigSchema virtualConfig = null;
                    Transaction trans = new Transaction();
                    for (int i = 0; i < ja.size(); ++i) {
                        JSONObject playerBill = ja.getJSONObject(i);
                        virtualConfig = new SCMS_VirtualChannelConfigSchema();
                        String startTime = playerBill.getString("startTime");
                        String endTime = playerBill.getString("endTime");
                        long programlength = Long.parseLong(playerBill.getString("programlength"));
                        String title = playerBill.getString("content");
                        String type = playerBill.getString("type");
                        String cid = playerBill.getString("cid");
                        virtualConfig.setId(Long.valueOf(NoUtil.getMaxID((String)"VirtualConfigID")));
                        virtualConfig.setVid(vid);
                        virtualConfig.setCid(cid);
                        virtualConfig.setDate(date);
                        virtualConfig.setStarttime(startTime);
                        virtualConfig.setEndtime(endTime);
                        virtualConfig.setProgramlength(Long.valueOf(programlength));
                        virtualConfig.setContent(title);
                        virtualConfig.setCreateName(playerBill.getString("createName"));
                        virtualConfig.setType(type);
                        virtualConfig.setStartPoint(playerBill.getString("startPoint"));
                        virtualConfig.setEndPoint(playerBill.getString("endPoint"));
                        virtualConfig.setStatus(Integer.valueOf(1));
                        trans.add((Schema)virtualConfig, 1);
                    }
                    if (trans.commit()) {
                        this.Response.setStatus(1);
                        this.Response.setMessage("\u65b0\u589e\u4fdd\u5b58\u8282\u76ee\u5355\u6210\u529f");
                    } else {
                        this.Response.setStatus(0);
                        this.Response.setMessage("\u65b0\u589e\u4fdd\u5b58\u8282\u76ee\u5355\u5931\u8d25");
                    }
                }
                this.generatePlayerAct(date, vid, ja);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.Response.setStatus(0);
                this.Response.setMessage("\u65b0\u589e\u4fdd\u5b58\u8282\u76ee\u5355\u51fa\u9519");
            }
        }
    }

    public static void dg1DataBind(DataGridAction dga) {
        String name = (String)dga.getParams().get((Object)"Name");
        StringBuilder condition = new StringBuilder();
        String sql = "select id,imageUrl,mediaType,name,createtime,expireddate,createUser,status,'' as ctype,'' as publish,'' as ctime,'' as exdate,'' as cstatus from scms_channels where status=1 ";
        String startDate = dga.getParam("startDate");
        String endDate = dga.getParam("endDate");
        if (StringUtil.isNotEmpty((String)startDate)) {
            condition.append(" and date(createtime) >= '" + startDate + "'");
        }
        if (StringUtil.isNotEmpty((String)endDate)) {
            condition.append(" and date(createtime) <= '" + endDate + "'");
        }
        sql = sql + condition.toString();
        String countSql = "select count(*) from scms_channels where 1=1 ";
        if (StringUtil.isNotEmpty((String)name)) {
            sql = sql + " and name like '%" + name + "%'";
            countSql = countSql + " and name like '%" + name + "%'";
        }
        sql = sql + " order by createtime desc";
        DataTable dt = new QueryBuilder(sql).executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String type = dt.getString(i, "type");
            type = type.equals("8") ? "\u7535\u89c6\u76f4\u64ad" : "\u5e7f\u64ad\u76f4\u64ad";
            dt.set(i, "ctype", (Object)type);
            int status = dt.getInt(i, "status");
            if (status == 0) {
                dt.set(i, "cstatus", (Object)"\u672a\u53d1\u5e03");
            } else {
                dt.set(i, "cstatus", (Object)"\u5df2\u53d1\u5e03");
            }
            dt.set(i, "ctime", (Object)dt.getString(i, "createtime"));
        }
        dga.setTotal(new QueryBuilder(countSql));
        dga.bindData(dt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePlayerAct(String date, String vid, JSONArray ja) {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("program://j:");
        builder.append("{\"playbillDate\":\"").append(date).append("\",");
        String isRep = new QueryBuilder("select isRepeat from scms_virtualchannel where id='" + vid + "'").executeString();
        builder.append("\"loopFlag\":\"").append(isRep.equals("1") ? "true" : "false").append("\",");
        builder.append("\"timeZone\":\"").append("8").append("\",");
        builder.append("\"pollingTime\":\"").append("5").append("\",");
        long version = 0L;
        if (versionMap.containsKey((Object)(vid + "_" + date))) {
            version = versionMap.getLong((Object)(vid + "_" + date));
            versionMap.put((Object)(vid + "_" + date), ++version);
        } else {
            version = 1L;
            versionMap.put((Object)(vid + "_" + date), 1);
        }
        builder.append("\"version\":\"").append(version).append("\",");
        builder.append("\"playbills\":[");
        JSONArray jaall = new JSONArray();
        for (i = 0; i < ja.size(); ++i) {
            String Starttime = "";
            String endtime = "";
            if (i == 0) {
                Starttime = "00:00:00";
                endtime = ja.getJSONObject(i).getString("startTime");
                this.mergeDayAndWeek(vid, date, Starttime, endtime, 0, jaall);
            }
            endtime = "";
            jaall.add((Object)ja.getJSONObject(i));
            Starttime = ja.getJSONObject(i).getString("endTime");
            if (ja.size() > i + 1) {
                endtime = ja.getJSONObject(i + 1).getString("startTime");
            }
            if (StringUtil.isEmpty((String)endtime)) {
                endtime = "23:59:59";
            }
            this.mergeDayAndWeek(vid, date, Starttime, endtime, 1, jaall);
        }
        if (ja.size() == 0) {
            this.mergeDayAndWeek(vid, date, "00:00:00", "23:59:59", 0, jaall);
        }
        ja.clear();
        ja = jaall;
        for (i = 0; i < ja.size(); ++i) {
            String startPoint;
            JSONObject playerBill = ja.getJSONObject(i);
            long programlength = Long.parseLong(playerBill.getString("programlength"));
            String type = playerBill.getString("type");
            String cid = playerBill.getString("cid");
            String url = "";
            builder.append("{\"startTime\":\"").append(date + " " + playerBill.getString("startTime")).append("\",");
            builder.append("\"druation\":\"").append(programlength / 1000L).append("\",");
            builder.append("\"endTime\":\"").append(date + " " + playerBill.getString("endTime")).append("\",");
            builder.append("\"title\":\"").append(playerBill.getString("content")).append("\",");
            if (StringUtil.isNotEmpty((String)type) && "0".equals(type)) {
                String screenshot = "";
                JSONArray pcJa = ChannelLibUtil.getUrlJSONArrayByType((String)cid, (long)Application.getCurrentSiteID(), (int)16, (String)"PC", (boolean)false);
                if (pcJa != null) {
                    screenshot = pcJa.toString();
                }
                if (StringUtil.isNotEmpty((String)screenshot)) {
                    JSONArray screenshotArray = JSONArray.fromObject((Object)screenshot);
                    int m = 0;
                    int maxKcode = 0;
                    for (int j = 0; j < screenshotArray.size(); ++j) {
                        String kcode;
                        JSONObject jo = screenshotArray.getJSONObject(j);
                        if (jo.getString("url").indexOf("fmt=h264_") <= 0 || jo.getString("url").indexOf("k_flv") <= 0 || Integer.parseInt(kcode = jo.getString("url").substring(jo.getString("url").indexOf("fmt=h264_") + 9, jo.getString("url").indexOf("k_flv"))) <= maxKcode) continue;
                        maxKcode = Integer.parseInt(kcode);
                        m = j;
                    }
                    JSONObject urljo = screenshotArray.getJSONObject(m);
                    String title = urljo.getString("title");
                    String lurl = urljo.getString("url");
                    String sds = "{\"title\":\"" + title + "\",\"url\":\"" + lurl + "\"}";
                    url = "mr://j:[" + sds + "]";
                }
                builder.append("\"url\":\"").append(url.replace("\"", "\\\"")).append("\",");
            } else {
                url = ContentUtil.getSeriesUrlBySourceSystemName((String)String.valueOf(Application.getCurrentSiteID()), (String)new QueryBuilder("select sourcesystemname from scms_contentinfo where ContentSourceId='" + cid + "'").executeString(), (int)1);
                builder.append("\"url\":{\"playerUrl\":\"").append(url.replace("\"", "\\\"")).append("\",");
                builder.append("\"status\":\"1\",");
                String catalogId = new QueryBuilder("select catalogId from scms_contentinfo where contentid='" + cid + "'").executeString();
                builder.append("\"catalogId\":\"" + catalogId + "\"").append("},");
            }
            String string = startPoint = playerBill.has("startPoint") ? playerBill.getString("startPoint") : "";
            if (StringUtil.isNotEmpty((String)startPoint)) {
                builder.append("\"startPosition\":\"").append(startPoint).append("\",");
                builder.append("\"playMode\":\"").append("false").append("\",");
            } else {
                builder.append("\"startPosition\":\"").append("0").append("\",");
                builder.append("\"playMode\":\"").append("true").append("\",");
            }
            String string2 = type = type.equals("0") ? "live" : "vod";
            if (i == ja.size() - 1) {
                builder.append("\"type\":\"").append(type).append("\"}");
                continue;
            }
            builder.append("\"type\":\"").append(type).append("\"},");
        }
        builder.append("]}");
        String alias = new QueryBuilder("select alias from scms_site").executeString();
        String filepath = PathUtil.builderPathEndSlash((String[])new String[]{Config.getValue((String)"linuxStaticFileDir"), alias, "/virtualChannel/", vid});
        filepath = filepath.replace("/", File.separator);
        log.info(filepath);
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((file = new File(filepath + date.replace("-", "") + ".json")).exists()) {
                file.delete();
            }
            file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(builder.toString().getBytes("UTF-8"));
            fileOutputStream.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println(builder.toString());
    }

    public Mapx initProgramLength(Mapx params) {
        String vid = params.getString((Object)"vid");
        String date = params.getString((Object)"currentDate");
        String sql = "select V.programlength from scms_virtualchannelconfig V LEFT JOIN scms_channels CL on V.cid=CL.id LEFT JOIN scms_contentinfo CT on V.cid=CT.CONTENTID where V.date='" + date + "' and V.vid='" + vid + "'";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        long sum = 0L;
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String programlength = dt.getString(i, "programlength");
            sum += Long.parseLong(programlength);
        }
        String length = DateUtil.getTimeStr((long)(sum / 1000L));
        params.put((Object)"programlength", (Object)length);
        return params;
    }

    public void editSave() {
        String actList = this.$V("actList");
        if (StringUtil.isNotEmpty((String)actList)) {
            try {
                JSONObject jo = JSONObject.fromObject((Object)actList);
                String vid = jo.getString("vid");
                String date = jo.getString("date");
                JSONArray ja = jo.getJSONArray("playerbills");
                if (ja != null && !ja.isEmpty()) {
                    SCMS_VirtualChannelConfigSchema virtualConfig = null;
                    Transaction trans = new Transaction();
                    int cflag = 0;
                    for (int i = 0; i < ja.size(); ++i) {
                        JSONObject playerBill = ja.getJSONObject(i);
                        virtualConfig = new SCMS_VirtualChannelConfigSchema();
                        cflag = playerBill.getInt("cflag");
                        if (cflag == 1) {
                            virtualConfig.setId(Long.valueOf(NoUtil.getMaxID((String)"VirtualConfigID")));
                            virtualConfig.setStatus(Integer.valueOf(1));
                        } else if (cflag == 2 || cflag == 3) {
                            virtualConfig.setId(Long.valueOf(Long.parseLong(playerBill.getString("id"))));
                            virtualConfig.fill();
                            if (cflag == 3) {
                                trans.add((Schema)virtualConfig, cflag);
                                ja.remove(i--);
                                continue;
                            }
                        }
                        String type = playerBill.getString("type");
                        String cid = playerBill.getString("cid");
                        virtualConfig.setVid(vid);
                        virtualConfig.setCid(cid);
                        virtualConfig.setDate(date);
                        virtualConfig.setStarttime(playerBill.getString("startTime"));
                        virtualConfig.setEndtime(playerBill.getString("endTime"));
                        virtualConfig.setProgramlength(Long.valueOf(Long.parseLong(playerBill.getString("programlength").trim() == null || "".equals(playerBill.getString("programlength").trim()) ? "0" : playerBill.getString("programlength"))));
                        virtualConfig.setContent(playerBill.getString("content"));
                        virtualConfig.setCreateName(playerBill.getString("createName"));
                        virtualConfig.setType(type);
                        virtualConfig.setStartPoint(playerBill.getString("startPoint"));
                        virtualConfig.setEndPoint(playerBill.getString("endPoint"));
                        trans.add((Schema)virtualConfig, cflag);
                    }
                    if (trans.commit()) {
                        this.Response.setStatus(1);
                        this.Response.setMessage("\u7f16\u8f91\u4fdd\u5b58\u8282\u76ee\u5355\u6210\u529f");
                    } else {
                        this.Response.setStatus(0);
                        this.Response.setMessage("\u7f16\u8f91\u4fdd\u5b58\u8282\u76ee\u5355\u5931\u8d25");
                    }
                }
                this.generatePlayerAct(date, vid, ja);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.Response.setStatus(0);
                this.Response.setMessage("\u7f16\u8f91\u4fdd\u5b58\u8282\u76ee\u5355\u51fa\u9519");
            }
        }
    }

    public void delete() {
        String id = this.$V("id");
        if (StringUtil.isNotEmpty((String)id)) {
            try {
                String sql = "delete from scms_virtualchannelconfig where id in (" + id + ")";
                int res = new QueryBuilder(sql).executeNoQuery();
                if (res > 0) {
                    this.Response.setStatus(1);
                    this.Response.setMessage("\u64cd\u4f5c\u6210\u529f");
                } else {
                    this.Response.setStatus(0);
                    this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.Response.setStatus(0);
                this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25");
            }
        }
    }

    public void copy() {
        String vid = this.$V("vid");
        String fromDate = this.$V("copyFromDate");
        String toDate = this.$V("copyToDate");
        try {
            Transaction trans = new Transaction();
            QueryBuilder qb = new QueryBuilder();
            SCMS_VirtualChannelConfigSchema channelConfig = new SCMS_VirtualChannelConfigSchema();
            qb.setSQL("where vid='" + vid + "' " + " and date='" + fromDate + "' order by starttime ");
            SCMS_VirtualChannelConfigSet copyFromSet = channelConfig.query(qb);
            qb.setSQL("where vid='" + vid + "' and" + " date='" + toDate + "' order by starttime ");
            SCMS_VirtualChannelConfigSet copyToSet = channelConfig.query(qb);
            if (copyToSet == null || copyToSet.size() == 0) {
                VirtualChannelActList.addCopySet((SCMS_VirtualChannelConfigSet)copyFromSet, (Transaction)trans, (String)toDate);
            } else {
                SCMS_VirtualChannelConfigSchema copyToChannelConfig = null;
                long copyFromStartTimeMillis = 0L;
                long copyFromEndTimeMillis = 0L;
                long copyToStartTimeMillis = 0L;
                long copyToEndTimeMillis = 0L;
                if (FormatDateUtil.date2Long((String)(toDate + " " + copyFromSet.get(0).getStarttime())) >= FormatDateUtil.date2Long((String)(toDate + " " + copyToSet.get(copyToSet.size() - 1).getEndtime())) || FormatDateUtil.date2Long((String)(toDate + " " + copyToSet.get(0).getStarttime())) >= FormatDateUtil.date2Long((String)(toDate + " " + copyFromSet.get(copyFromSet.size() - 1).getEndtime()))) {
                    VirtualChannelActList.addCopySet((SCMS_VirtualChannelConfigSet)copyFromSet, (Transaction)trans, (String)toDate);
                } else {
                    boolean isBreak = false;
                    for (int i = 0; i < copyFromSet.size(); ++i) {
                        channelConfig = (SCMS_VirtualChannelConfigSchema)copyFromSet.get(i).clone();
                        copyFromStartTimeMillis = FormatDateUtil.date2Long((String)(toDate + " " + channelConfig.getStarttime()));
                        copyFromEndTimeMillis = FormatDateUtil.date2Long((String)(toDate + " " + channelConfig.getEndtime()));
                        for (int j = 0; j < copyToSet.size(); ++j) {
                            copyToChannelConfig = copyToSet.get(j);
                            copyToStartTimeMillis = FormatDateUtil.date2Long((String)(toDate + " " + copyToChannelConfig.getStarttime()));
                            copyToEndTimeMillis = FormatDateUtil.date2Long((String)(toDate + " " + copyToChannelConfig.getEndtime()));
                            if (copyFromStartTimeMillis >= copyToEndTimeMillis) continue;
                            if (copyFromEndTimeMillis <= copyToStartTimeMillis) break;
                            if (!(copyFromStartTimeMillis >= copyToStartTimeMillis && copyFromStartTimeMillis < copyToEndTimeMillis || copyFromEndTimeMillis > copyToStartTimeMillis && copyFromEndTimeMillis <= copyToEndTimeMillis) && (copyFromStartTimeMillis >= copyToEndTimeMillis || copyFromEndTimeMillis <= copyToEndTimeMillis)) continue;
                            trans.add((Schema)copyToChannelConfig, 3);
                            if (j != copyToSet.size() - 1) continue;
                            isBreak = true;
                        }
                        if (isBreak) break;
                    }
                    VirtualChannelActList.addCopySet((SCMS_VirtualChannelConfigSet)copyFromSet, (Transaction)trans, (String)toDate);
                }
            }
            if (trans.commit()) {
                JSONArray ja = VirtualChannelActList.copyGenerateActListFile((String)vid, (String)toDate);
                this.generatePlayerAct(toDate, vid, ja);
                this.Response.setStatus(1);
                this.Response.setMessage("\u64cd\u4f5c\u6210\u529f");
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public static void addCopySet(SCMS_VirtualChannelConfigSet copyFromSet, Transaction trans, String toDate) {
        SCMS_VirtualChannelConfigSet copyToSet = new SCMS_VirtualChannelConfigSet();
        SCMS_VirtualChannelConfigSchema channelConfig = null;
        for (int i = 0; i < copyFromSet.size(); ++i) {
            channelConfig = (SCMS_VirtualChannelConfigSchema)copyFromSet.get(i).clone();
            channelConfig.setId(Long.valueOf(NoUtil.getMaxID((String)"VirtualConfigID")));
            channelConfig.setDate(toDate);
            copyToSet.add(channelConfig);
        }
        trans.add((SchemaSet)copyToSet, 1);
    }

    public static JSONArray copyGenerateActListFile(String vid, String date) {
        JSONArray ja = null;
        if (StringUtil.isEmpty((String)vid) || StringUtil.isEmpty((String)date)) {
            return null;
        }
        try {
            SCMS_VirtualChannelConfigSchema virtualConfig = new SCMS_VirtualChannelConfigSchema();
            SCMS_VirtualChannelConfigSet configSet = virtualConfig.query(new QueryBuilder("where vid='" + vid + "' and date='" + date + "'"));
            if (configSet == null || configSet.isEmpty()) {
                return null;
            }
            ja = new JSONArray();
            JSONObject jo = null;
            for (int i = 0; i < configSet.size(); ++i) {
                jo = new JSONObject();
                virtualConfig = configSet.get(i);
                jo.put((Object)"cid", (Object)virtualConfig.getCid());
                jo.put((Object)"type", (Object)virtualConfig.getType());
                jo.put((Object)"programlength", (Object)virtualConfig.getProgramlength());
                jo.put((Object)"startTime", (Object)virtualConfig.getStarttime());
                jo.put((Object)"endTime", (Object)virtualConfig.getEndtime());
                jo.put((Object)"startPoint", (Object)virtualConfig.getStartPoint());
                jo.put((Object)"content", (Object)virtualConfig.getContent());
                ja.add((Object)jo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ja;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSourceItems() {
        JSONObject jo = new JSONObject();
        int status = 1;
        try {
            jo.put((Object)"liveInfo", (Object)this.getLiveSourceItems());
            jo.put((Object)"videoInfo", (Object)this.getVideoSourceItems());
            jo.put((Object)"catInfo", (Object)this.getCategory());
        }
        catch (Exception e) {
            e.printStackTrace();
            status = 0;
        }
        finally {
            this.Response.setStatus(status);
            this.Response.setMessage(jo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLiveSourceItems() {
        JSONObject jo = new JSONObject();
        JSONArray ja = new JSONArray();
        try {
            DataTable dt = new QueryBuilder("select id, name, imageUrl  from scms_channels  where mediaType=8  and status=1 ").executeDataTable();
            if (dt != null && dt.getRowCount() != 0) {
                String imageHttpPre = SiteUtil.getImageDomainBySiteId((long)Application.getCurrentSiteID()) + Application.getCurrentSiteAlias();
                JSONObject item = null;
                for (int i = 0; i < dt.getRowCount(); ++i) {
                    item = new JSONObject();
                    String imgurl = dt.getString(i, "imageUrl");
                    imgurl = StringUtil.isNotEmpty((String)imgurl) ? imageHttpPre + imgurl : "../../Default/images/channeldefault.JPG";
                    item.put((Object)"id", (Object)dt.getString(i, "id"));
                    item.put((Object)"name", (Object)dt.getString(i, "name"));
                    item.put((Object)"imgurl", (Object)imgurl);
                    ja.add((Object)item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            jo.put((Object)"liveItems", (Object)ja);
        }
        return jo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVideoSourceItems() {
        JSONObject json = new JSONObject();
        JSONArray ja = new JSONArray();
        boolean isResponsed = false;
        int status = 1;
        try {
            String videoInfo = this.$V("videoInfo");
            int page = 1;
            int pageSize = 10;
            int total = 0;
            StringBuilder conditions = new StringBuilder();
            if (StringUtil.isNotEmpty((String)videoInfo)) {
                DataTable cDT;
                String size;
                JSONObject jo = JSONObject.fromObject((Object)videoInfo);
                String name = jo.has("name") ? jo.getString("name") : "";
                String catalogid = jo.has("catalogid") ? jo.getString("catalogid") : "";
                String currentPage = jo.has("page") ? jo.getString("page") : "";
                String string = size = jo.has("size") ? jo.getString("size") : "";
                if (StringUtil.isNotEmpty((String)name)) {
                    conditions.append(" and title like '%" + name + "%' ");
                }
                if (StringUtil.isNotEmpty((String)catalogid) && (cDT = new QueryBuilder("select childcount, innercode from scms_catalog  where id=" + catalogid + "").executeDataTable()) != null && cDT.getRowCount() > 0) {
                    int childCount = cDT.getInt(0, "childcount");
                    StringBuilder sb = new StringBuilder();
                    sb.append(catalogid);
                    if (childCount > 0) {
                        String innerCode = cDT.getString(0, "innercode");
                        DataTable catalogDT = new QueryBuilder("select id from scms_catalog  where innercode like '%" + innerCode + "%'").executeDataTable();
                        for (int i = 0; i < catalogDT.getRowCount(); ++i) {
                            String cid = catalogDT.getString(i, "id");
                            if (cid.equals(catalogid)) continue;
                            sb.append("," + catalogDT.getString(i, "id"));
                        }
                    }
                    conditions.append(" and catalogid in (" + sb.toString() + ") ");
                }
                if (StringUtil.isNotEmpty((String)currentPage)) {
                    page = Integer.parseInt(currentPage);
                }
                if (StringUtil.isNotEmpty((String)size)) {
                    pageSize = Integer.parseInt(size);
                }
                isResponsed = true;
            }
            QueryBuilder qb = new QueryBuilder();
            String countSql = "select count(*) from scms_contentinfo  where status=1 " + conditions.toString() + "";
            qb.setSQL(countSql);
            total = qb.executeInt();
            String sql = "select contentid,ContentSourceId, title, programlength, keyframe from scms_contentinfo where status=1 " + conditions.toString() + "";
            qb.setSQL(sql);
            DataTable dt = qb.executePagedDataTable(pageSize, page - 1);
            JSONObject videoItem = null;
            String siteAlias = Application.getCurrentSiteAlias();
            long siteID = Application.getCurrentSiteID();
            String imageDomainBySiteId = SiteUtil.getImageDomainBySiteId((long)siteID);
            for (int j = 0; j < dt.getRowCount(); ++j) {
                long prop2 = dt.getLong(j, "programlength");
                String keyFrame = dt.getString(j, "keyframe");
                String frame = "../Images/vmsdefault.png";
                if (StringUtil.isNotEmpty((String)keyFrame)) {
                    frame = PathUtil.builderPath((String[])new String[]{imageDomainBySiteId, siteAlias, keyFrame});
                }
                videoItem = new JSONObject();
                videoItem.put((Object)"id", (Object)dt.getString(j, "ContentSourceId"));
                videoItem.put((Object)"title", (Object)dt.getString(j, "title"));
                videoItem.put((Object)"prolength", (Object)DateUtil.getTimeStr((long)(prop2 / 1000L)));
                videoItem.put((Object)"keyFrame", (Object)frame);
                ja.add((Object)videoItem);
            }
            json.put((Object)"total", (Object)total);
            json.put((Object)"count", (Object)(page * pageSize));
            json.put((Object)"page", (Object)page);
        }
        catch (Exception e) {
            e.printStackTrace();
            status = 0;
            return status;
        }
        finally {
            json.put((Object)"videoItems", (Object)ja);
            if (isResponsed) {
                this.Response.setStatus(status);
                this.Response.setMessage(json.toString());
                return null;
            }
            return json.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCategory() {
        JSONObject jo = new JSONObject();
        JSONArray ja = new JSONArray();
        String pid = StringUtil.isNotEmpty((String)this.$V("parentid")) ? this.$V("parentid") : "0";
        int status = 1;
        try {
            QueryBuilder qb = new QueryBuilder();
            String sql = "select id, name, childcount from scms_catalog  where siteid=" + Application.getCurrentSiteID() + "" + " and parentid=" + pid + " and type=5";
            qb.setSQL(sql);
            DataTable dt = qb.executeDataTable();
            JSONObject catItem = null;
            for (int i = 0; i < dt.getRowCount(); ++i) {
                String name;
                catItem = new JSONObject();
                String title = name = dt.getString(i, "name");
                boolean hasChildren = dt.getInt(i, "childcount") != 0;
                catItem.put((Object)"id", (Object)dt.getString(i, "id"));
                catItem.put((Object)"hasChildren", (Object)hasChildren);
                if (name.length() > 6) {
                    name = name.substring(0, 6) + "...";
                }
                catItem.put((Object)"name", (Object)name);
                catItem.put((Object)"title", (Object)title);
                ja.add((Object)catItem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status = 0;
            return status;
        }
        finally {
            jo.put((Object)"catItems", (Object)ja);
            if (!pid.equals("0")) {
                this.Response.setStatus(status);
                this.Response.setMessage(jo.toString());
                return null;
            }
            return jo.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getActListByCid() {
        JSONObject jo = new JSONObject();
        JSONArray ja = new JSONArray();
        boolean state = true;
        try {
            String cid = this.$V("cid");
            String date = this.$V("date");
            if (StringUtil.isEmpty((String)cid)) {
                state = false;
            } else {
                DataTable dt;
                if (StringUtil.isEmpty((String)date)) {
                    date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                }
                if ((dt = new QueryBuilder("select id, type, content, startTime, endTime, programlength, cid,status  from scms_virtualchannelconfig  where vid='" + cid + "' and date='" + date + "'" + " order by startTime asc").executeDataTable()) == null || dt.getRowCount() == 0) {
                    state = true;
                } else {
                    JSONObject actItem = null;
                    for (int i = 0; i < dt.getRowCount(); ++i) {
                        int nowdate;
                        String cContent = "";
                        cContent = dt.getString(i, "content");
                        if (cContent.length() > 10) {
                            cContent = cContent.substring(0, 10);
                            cContent = cContent + "...";
                        }
                        String status = dt.getString(i, "status");
                        int olddate = Integer.parseInt(date.replace("-", ""));
                        if (olddate >= (nowdate = Integer.parseInt(new SimpleDateFormat("yyyyMMdd").format(new Date())))) {
                            int nowtiem;
                            int endtime;
                            if (olddate == nowdate && dt.getString(i, "endTime") != "undefined" && (endtime = Integer.parseInt(dt.getString(i, "endTime").replace(":", ""))) <= (nowtiem = Integer.parseInt(new SimpleDateFormat("HH-mm-ss").format(new Date()).replace("-", "")))) {
                                status = "1";
                            }
                        } else {
                            status = "1";
                        }
                        actItem = new JSONObject();
                        actItem.put((Object)"status", (Object)status);
                        actItem.put((Object)"id", (Object)dt.getString(i, "id"));
                        actItem.put((Object)"type", (Object)dt.getString(i, "type"));
                        actItem.put((Object)"content", (Object)cContent);
                        actItem.put((Object)"startTime", (Object)dt.getString(i, "startTime"));
                        actItem.put((Object)"endTime", (Object)dt.getString(i, "endTime"));
                        actItem.put((Object)"prolength", (Object)dt.getString(i, "programlength"));
                        actItem.put((Object)"cid", (Object)dt.getString(i, "cid"));
                        ja.add((Object)actItem);
                    }
                    state = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            state = false;
        }
        finally {
            jo.put((Object)"state", (Object)state);
            jo.put((Object)"actList", (Object)ja);
            this.Response.setMessage(jo.toString());
        }
    }

    public void saveVactWeekPlan() {
        String weekPlan = this.$V("weekPlan");
        if (StringUtil.isEmpty((String)weekPlan)) {
            this.Response.setStatus(0);
            return;
        }
        try {
            JSONObject plan = JSONObject.fromObject((Object)weekPlan);
            String vid = plan.getString("vid");
            Iterator it = plan.keys();
            Transaction trans = new Transaction();
            SCMS_VirtualChannelConfigSchema actSchema = null;
            JSONArray ja = null;
            JSONObject weekDayPlan = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equals("vid") || (ja = JSONArray.fromObject((Object)plan.getJSONArray(key))) == null || ja.isEmpty()) continue;
                for (int i = 0; i < ja.size(); ++i) {
                    actSchema = new SCMS_VirtualChannelConfigSchema();
                    weekDayPlan = ja.getJSONObject(i);
                    String id = weekDayPlan.getString("id");
                    int cflag = weekDayPlan.getInt("cflag");
                    if (cflag == 1) {
                        actSchema.setId(Long.valueOf(NoUtil.getMaxID((String)"VirtualConfigID")));
                        actSchema.setStatus(Integer.valueOf(1));
                    } else {
                        actSchema.setId(Long.valueOf(Long.parseLong(id)));
                        actSchema.fill();
                        if (cflag == 3) {
                            trans.add((Schema)actSchema, cflag);
                            continue;
                        }
                    }
                    actSchema.setVid(vid);
                    actSchema.setCid(weekDayPlan.getString("cid"));
                    actSchema.setDate(key);
                    actSchema.setStarttime(weekDayPlan.getString("startTime"));
                    actSchema.setEndtime(weekDayPlan.getString("endTime"));
                    actSchema.setProgramlength(Long.valueOf(Long.parseLong(weekDayPlan.getString("programlength").trim() == null || "".equals(weekDayPlan.getString("programlength").trim()) ? "0" : weekDayPlan.getString("programlength"))));
                    actSchema.setContent(weekDayPlan.getString("content"));
                    actSchema.setCreateName(weekDayPlan.getString("createName"));
                    actSchema.setType(weekDayPlan.getString("type"));
                    trans.add((Schema)actSchema, cflag);
                }
            }
            if (trans.commit()) {
                this.Response.setStatus(1);
                this.Response.setMessage("\u4fdd\u5b58\u4e32\u8054\u5355\u6210\u529f");
                Date date = new Date();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                actSchema = new SCMS_VirtualChannelConfigSchema();
                SCMS_VirtualChannelConfigSet vccSet = new SCMS_VirtualChannelConfigSet();
                SCMS_VirtualChannelConfigSet vccSet1 = new SCMS_VirtualChannelConfigSet();
                String sql = "where vid='" + vid + "'and date >='" + df.format(date) + "'   and   date LIKE  '%-%'  order by date,startTime ";
                vccSet = actSchema.query(new QueryBuilder(sql));
                ArrayList<String> checkDataList = new ArrayList<String>();
                checkDataList.add(df.format(date));
                for (int i = 0; i < vccSet.size(); ++i) {
                    String date1 = vccSet.get(i).getDate();
                    if (checkDataList.contains(date1)) continue;
                    checkDataList.add(date1);
                }
                for (String dates : checkDataList) {
                    JSONArray jal = new JSONArray();
                    String sql1 = "where vid='" + vid + "'and  date LIKE  '%-%'  and date  = '" + dates + "' order by date,startTime";
                    vccSet1 = actSchema.query(new QueryBuilder(sql1));
                    for (int j = 0; j < vccSet1.size(); ++j) {
                        jal.add((Object)this.insertJsonObjec(vccSet1.get(j), vccSet1.get(j).getStarttime(), vccSet1.get(j).getEndtime()));
                    }
                    this.generatePlayerAct(dates, vid, jal);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u4fdd\u5b58\u4e32\u8054\u5355\u5931\u8d25");
        }
    }

    public void getVactWeekPlanByVID() {
        String vid = this.$V("vid");
        if (StringUtil.isEmpty((String)vid)) {
            this.Response.setStatus(0);
            return;
        }
        try {
            SCMS_VirtualChannelConfigSchema actSchema = new SCMS_VirtualChannelConfigSchema();
            SCMS_VirtualChannelConfigSet actSet = actSchema.query(new QueryBuilder("where vid='" + vid + "' and date like '%weekday%' order by date,startTime"));
            if (actSet == null || actSet.isEmpty()) {
                this.Response.setStatus(0);
                return;
            }
            String weekDay = "";
            JSONObject jo = new JSONObject();
            JSONArray ja = null;
            JSONObject weekDayPlan = null;
            for (int i = 0; i < actSet.size(); ++i) {
                actSchema = actSet.get(i);
                weekDayPlan = new JSONObject();
                if (!weekDay.equals(actSchema.getDate())) {
                    if (weekDay.contains("weekday")) {
                        jo.put((Object)weekDay, ja);
                    }
                    weekDay = actSchema.getDate();
                    ja = new JSONArray();
                }
                weekDayPlan.put((Object)"id", (Object)actSchema.getId());
                weekDayPlan.put((Object)"startTime", (Object)actSchema.getStarttime());
                weekDayPlan.put((Object)"endTime", (Object)actSchema.getEndtime());
                weekDayPlan.put((Object)"programlength", (Object)actSchema.getProgramlength());
                weekDayPlan.put((Object)"cid", (Object)actSchema.getCid());
                weekDayPlan.put((Object)"type", (Object)actSchema.getType());
                weekDayPlan.put((Object)"content", (Object)actSchema.getContent());
                ja.add((Object)weekDayPlan);
            }
            jo.put((Object)weekDay, ja);
            this.Response.setStatus(1);
            this.Response.setMessage(jo.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
        }
    }

    public static void updataVchannerStatus(long sitid, String videoSourceId, String status, int type) {
        VchannerThread vt = new VchannerThread(sitid, videoSourceId, status, type);
        vt.start();
    }

    public Boolean mergeDayAndWeek(String vid, String date, String preEndTime, String nextStartTime, int index, JSONArray ja) {
        Boolean flag = true;
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        try {
            Date d1 = df.parse(nextStartTime);
            Date d2 = df.parse(preEndTime);
            long diff = d1.getTime() - d2.getTime();
            if (diff / 1000L >= 5L) {
                SCMS_VirtualChannelConfigSchema actSchema = new SCMS_VirtualChannelConfigSchema();
                SCMS_VirtualChannelConfigSet vccSet = new SCMS_VirtualChannelConfigSet();
                String sql1 = "where vid ='" + vid + "'   and starttime <='" + preEndTime + "' and   endtime >= '" + nextStartTime + "' and  date = '" + VirtualChannelActList.getDayofweek((String)date) + "' order by date,startTime";
                String sql2 = "where vid ='" + vid + "'   and ((endtime >='" + preEndTime + "' and starttime <= '" + preEndTime + "') or (starttime >='" + preEndTime + "' and endtime <= '" + nextStartTime + "' ) or (starttime <='" + nextStartTime + "' and endtime >= '" + nextStartTime + "' )) and date = '" + VirtualChannelActList.getDayofweek((String)date) + "' order by date,startTime";
                String sql0 = "where vid ='" + vid + "'   and starttime <='" + nextStartTime + "' and  date = '" + VirtualChannelActList.getDayofweek((String)date) + "' order by date,startTime";
                if (index == 0) {
                    vccSet = actSchema.query(new QueryBuilder(sql0));
                    for (int i = 0; i < vccSet.size(); ++i) {
                        actSchema = vccSet.get(i);
                        String endtime = actSchema.getEndtime();
                        String starttime = actSchema.getStarttime();
                        if (Long.parseLong(VirtualChannelActList.getDuration((String)nextStartTime, (String)actSchema.getEndtime())) > 0L) {
                            endtime = nextStartTime;
                        }
                        ja.add((Object)this.insertJsonObjec(actSchema, starttime, endtime));
                    }
                } else {
                    vccSet = actSchema.query(new QueryBuilder(sql1));
                    if (vccSet.size() > 0) {
                        actSchema = vccSet.get(0);
                        ja.add((Object)this.insertJsonObjec(actSchema, preEndTime, nextStartTime));
                    } else {
                        vccSet = actSchema.query(new QueryBuilder(sql2));
                        for (int i = 0; i < vccSet.size(); ++i) {
                            actSchema = vccSet.get(i);
                            String endtime = actSchema.getEndtime();
                            String starttime = actSchema.getStarttime();
                            if (Long.parseLong(VirtualChannelActList.getDuration((String)preEndTime, (String)actSchema.getStarttime())) < 0L) {
                                starttime = preEndTime;
                            }
                            if (Long.parseLong(VirtualChannelActList.getDuration((String)nextStartTime, (String)actSchema.getEndtime())) > 0L) {
                                endtime = nextStartTime;
                            }
                            ja.add((Object)this.insertJsonObjec(actSchema, starttime, endtime));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        return flag;
    }

    public JSONObject insertJsonObjec(SCMS_VirtualChannelConfigSchema Schema2, String startTime, String endTime) {
        JSONObject jb = new JSONObject();
        jb.put((Object)"programlength", (Object)VirtualChannelActList.getDuration((String)startTime, (String)endTime));
        jb.put((Object)"type", (Object)Schema2.getType());
        jb.put((Object)"cid", (Object)Schema2.getCid());
        jb.put((Object)"startTime", (Object)startTime);
        jb.put((Object)"endTime", (Object)endTime);
        jb.put((Object)"content", (Object)Schema2.getContent());
        jb.put((Object)"startPosition", (Object)Schema2.getStartPoint());
        return jb;
    }

    public static String getDuration(String startTime, String endTime) {
        String duration = "0";
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        try {
            Date d1 = df.parse(endTime);
            Date d2 = df.parse(startTime);
            long diff = d1.getTime() - d2.getTime();
            return diff + "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return duration;
        }
    }

    public static String getDayofweek(String date) {
        String weekStr = "";
        try {
            Calendar cal = Calendar.getInstance();
            if (date.equals("")) {
                cal.setTime(new Date(System.currentTimeMillis()));
            } else {
                cal.setTime(new Date(VirtualChannelActList.getDateByStr2((String)date).getTime()));
            }
            int weekday = cal.get(7);
            switch (weekday) {
                case 1: {
                    weekStr = "weekday_6";
                    break;
                }
                case 2: {
                    weekStr = "weekday_0";
                    break;
                }
                case 3: {
                    weekStr = "weekday_1";
                    break;
                }
                case 4: {
                    weekStr = "weekday_2";
                    break;
                }
                case 5: {
                    weekStr = "weekday_3";
                    break;
                }
                case 6: {
                    weekStr = "weekday_4";
                    break;
                }
                case 7: {
                    weekStr = "weekday_5";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return weekStr;
    }

    public static Date getDateByStr2(String dd) {
        Date date;
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dd);
        }
        catch (Exception e) {
            date = null;
            e.printStackTrace();
        }
        return date;
    }
}

