/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.virtualchannel;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.common.util.FormatDateUtil;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_VirtualChannelSchema;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.apache.axis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualChannelLib
extends Page {
    private static final Logger log = LoggerFactory.getLogger(VirtualChannelLib.class);

    public static void dg1DataBind(DataGridAction dga) {
        String sortString = StringUtil.isNotEmpty((String)dga.getParam("_ZVING_SORTSTRING")) ? dga.getParam("_ZVING_SORTSTRING") + "," : "";
        String sql = "select id,imgurl,name,isRepeat,createtime,expiretime,ispublish,'' as ctime,'' as exdate,'' as crepeat,'' as cpublish,'' as cstatus, '' as host, '' as timeServer, '' as hasActList from scms_virtualchannel where siteid=" + Application.getCurrentSiteID() + "";
        String countSql = "select count(*) from scms_virtualchannel where siteid=" + Application.getCurrentSiteID();
        sql = sql + " order by " + sortString + "createtime desc";
        String alias = Application.getCurrentSiteAlias();
        String playerLocation = SiteUtil.getStaticFileDomainBySiteId((long)Application.getCurrentSiteID()) + alias + "/virtualChannel";
        String timeServer = Config.getValue((String)"vms.hosts.address") + "/getSystemTime";
        String currentDate = FormatDateUtil.format2DateByFormat((Date)new Date(), (String)"yyyy-MM-dd");
        DataTable dt = new QueryBuilder(sql).executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String imgUrl;
            Long ispublish;
            String vid = dt.getString(i, "id");
            String isRepeat = dt.getLong(i, "isRepeat") == 0L ? "\u5426" : "\u662f";
            dt.set(i, "crepeat", (Object)isRepeat);
            if (StringUtil.isEmpty((String)dt.getString(i, "ispublish"))) {
                dt.set(i, "ispublish", (Object)"0");
            }
            if ((ispublish = Long.valueOf(dt.getLong(i, "ispublish"))) == 1L) {
                dt.set(i, "cstatus", (Object)"\u64a4\u9500");
            } else {
                dt.set(i, "cstatus", (Object)"\u53d1\u5e03");
            }
            DataTable actList = new QueryBuilder("select id from scms_virtualchannelconfig  where vid='" + vid + "' and date='" + currentDate + "'").executeDataTable();
            if (actList != null && actList.getRowCount() != 0) {
                dt.set(i, "hasActList", (Object)"true");
            } else {
                dt.set(i, "hasActList", (Object)"false");
            }
            if (!StringUtil.isEmpty((String)dt.getString(i, "createtime"))) {
                dt.set(i, "ctime", (Object)dt.getString(i, "createtime"));
            }
            if (!StringUtil.isEmpty((String)dt.getString(i, "expiretime"))) {
                SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
                String nowStr = formatter1.format(DateUtil.parseDate((String)dt.getString(i, "expiretime")));
                dt.set(i, "exdate", (Object)nowStr);
            }
            imgUrl = StringUtil.isNotEmpty((String)(imgUrl = dt.getString(i, "imgurl"))) && !"../../Default/images/channeldefault.JPG".equals(imgUrl) ? SiteUtil.getImageDomainBySiteId((long)Application.getCurrentSiteID()) + alias + imgUrl : "../../Default/images/channeldefault.JPG";
            dt.set(i, "imgurl", (Object)imgUrl);
            dt.set(i, "host", (Object)playerLocation);
            dt.set(i, "timeServer", (Object)timeServer);
        }
        dga.setTotal(new QueryBuilder(countSql));
        dga.dataTable2JSON(dt);
    }

    public void addSave() {
        String name = this.$V("name").trim();
        try {
            String relativeUrl = this.$V("filedata");
            String formatStr = "yyyy-MM-dd HH:mm:ss";
            String isRepeat = this.$V("isRepeat");
            SimpleDateFormat formatter = new SimpleDateFormat(formatStr);
            String createTime = formatter.format(new Date());
            long siteID = Application.getCurrentSiteID();
            SCMS_VirtualChannelSchema scms_virtualChannelSchema = new SCMS_VirtualChannelSchema();
            scms_virtualChannelSchema.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            scms_virtualChannelSchema.setSiteid(Long.valueOf(siteID));
            scms_virtualChannelSchema.setName(name);
            scms_virtualChannelSchema.setImgurl(relativeUrl);
            scms_virtualChannelSchema.setIsRepeat(Long.valueOf(Long.parseLong(isRepeat)));
            scms_virtualChannelSchema.setCreatetime(createTime);
            scms_virtualChannelSchema.setInfo(this.$V("info").trim());
            scms_virtualChannelSchema.setExpiretime(this.$V("exdate"));
            DBConnPool.setDBConnPool((Long)siteID);
            Transaction transaction = new Transaction();
            transaction.add((Schema)scms_virtualChannelSchema, 1);
            transaction.commit();
            if (StringUtil.isNotEmpty((String)relativeUrl)) {
                this.Response.setMessage("\u65b0\u589e\u9891\u9053\u6210\u529f!");
            } else {
                this.Response.setMessage("\u65b0\u589e\u9891\u9053\u6210\u529f! \u8bf7\u6839\u636e\u9700\u8981 \u4e0a\u4f20\u53f0\u6807");
            }
            UserLog.log((String)"Channel", (String)"CreateChannel", (String)("\u65b0\u589e\u865a\u62df\u76f4\u64ad\u9891\u9053" + name + "\u6210\u529f"), (String)this.Request.getClientIP());
        }
        catch (Exception e) {
            log.error("\u65b0\u5efa\u865a\u62df\u76f4\u64ad\u9047\u5230\u5f02\u5e38", (Throwable)e);
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
            UserLog.log((String)"Channel", (String)"CreateChannel", (String)("\u65b0\u589e\u865a\u62df\u76f4\u64ad\u9891\u9053" + name + "\u5931\u8d25"), (String)this.Request.getClientIP());
        }
    }

    public void editSave() {
        String name = this.$V("name");
        try {
            String id = this.$V("id");
            SCMS_VirtualChannelSchema scms_virtualChannelSchema = new SCMS_VirtualChannelSchema();
            scms_virtualChannelSchema.setId(id);
            if (!scms_virtualChannelSchema.fill()) {
                this.Response.setStatus(0);
                this.Response.setMessage("\u6570\u636e\u5e93\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
                return;
            }
            String isRepeat = this.$V("isRepeat");
            String info = this.$V("info");
            String relativeUrl = this.$V("filedata");
            String exdate = this.$V("exdate");
            scms_virtualChannelSchema.setName(name);
            scms_virtualChannelSchema.setImgurl(relativeUrl);
            scms_virtualChannelSchema.setExpiretime(exdate);
            scms_virtualChannelSchema.setInfo(info);
            scms_virtualChannelSchema.setIsRepeat(Long.valueOf(Long.parseLong(isRepeat)));
            Transaction transaction = new Transaction();
            transaction.add((Schema)scms_virtualChannelSchema, 2);
            transaction.commit();
            this.Response.setMessage("\u4fdd\u5b58\u6210\u529f!");
            this.Response.setStatus(1);
            UserLog.log((String)"Channel", (String)"UpdateChannel", (String)("\u7f16\u8f91\u865a\u62df\u76f4\u64ad\u9891\u9053" + name + "\u6210\u529f"), (String)this.Request.getClientIP());
        }
        catch (Exception e) {
            log.error("\u7f16\u8f91\u865a\u62df\u76f4\u64ad\u9047\u5230\u5f02\u5e38", (Throwable)e);
            this.Response.setStatus(0);
            this.Response.setMessage("\u53d1\u751f\u9519\u8bef!");
            UserLog.log((String)"Channel", (String)"UpdateChannel", (String)("\u7f16\u8f91\u865a\u62df\u76f4\u64ad\u9891\u9053" + name + "\u5931\u8d25"), (String)this.Request.getClientIP());
        }
    }

    public static Mapx initVirtualChannel(Mapx params) {
        String id = params.getString((Object)"id");
        if (StringUtils.isEmpty((String)id)) {
            params.put((Object)"absoluteUrl", (Object)"../../Default/images/channeldefault.JPG");
            params.put((Object)"relativeUrl", (Object)"");
            return params;
        }
        String sql = "select id,imgurl,createtime,name,expiretime,isRepeat,info from scms_virtualchannel where id='" + id + "'";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        Mapx map = new Mapx();
        String alias = Application.getCurrentSiteAlias();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            for (int j = 0; j < dt.getColCount(); ++j) {
                String columnName = dt.getDataColumn(j).getColumnName();
                if (columnName.equals("isRepeat")) {
                    if (dt.getInt(i, j) == 1) {
                        map.put((Object)"isRepeat1", (Object)"");
                        map.put((Object)"isRepeat0", (Object)"checked");
                        continue;
                    }
                    if (dt.getInt(i, j) != 0) continue;
                    map.put((Object)"isRepeat0", (Object)"");
                    map.put((Object)"isRepeat1", (Object)"checked");
                    continue;
                }
                if (columnName.equals("imgurl")) {
                    String relativeUrl = dt.getString(i, j);
                    if (StringUtil.isNotEmpty((String)relativeUrl)) {
                        String absoluteUrl = SiteUtil.getImageDomainBySiteId((long)Application.getCurrentSiteID()) + alias + relativeUrl;
                        map.put((Object)"relativeUrl", (Object)relativeUrl);
                        map.put((Object)"absoluteUrl", (Object)absoluteUrl);
                        continue;
                    }
                    map.put((Object)"relativeUrl", (Object)"");
                    map.put((Object)"absoluteUrl", (Object)"../../Default/images/channeldefault.JPG");
                    continue;
                }
                map.put((Object)columnName, dt.get(i, j));
            }
        }
        return map;
    }

    public void delete() {
        String ids = this.$V("ids");
        String[] newIds = ids.split(",");
        StringBuffer sb = new StringBuffer();
        ArrayList<String> IdList = new ArrayList<String>();
        for (int i = 0; i < newIds.length; ++i) {
            IdList.add(newIds[i]);
            newIds[i] = i < newIds.length - 1 ? "'" + newIds[i] + "'," : "'" + newIds[i] + "'";
            sb.append(newIds[i]);
        }
        ids = sb.toString();
        Transaction trans = new Transaction();
        try {
            QueryBuilder qb = new QueryBuilder("delete from scms_virtualchannelconfig where cid in (" + ids + ")");
            trans.add(qb);
            qb = new QueryBuilder("delete from scms_virtualchannel where id in (" + ids + ")");
            trans.add(qb);
            if (trans.commit()) {
                UserLog.log((String)"Channel", (String)"DeleteChannel", (String)("\u5220\u9664ID\u4e3a: " + ids + " \u7684\u865a\u62df\u76f4\u64ad\u9891\u9053\u6210\u529f"), (String)this.Request.getClientIP());
                this.Response.setStatus(1);
                this.Response.setMessage("\u5220\u9664\u865a\u62df\u76f4\u64ad\u9891\u9053\u6210\u529f");
                return;
            }
            UserLog.log((String)"Channel", (String)"DeleteChannel", (String)("\u5220\u9664ID\u4e3a: " + ids + " \u7684\u865a\u62df\u76f4\u64ad\u9891\u9053\u5931\u8d25"), (String)this.Request.getClientIP());
        }
        catch (Exception e) {
            e.printStackTrace();
            UserLog.log((String)"Channel", (String)"DeleteChannel", (String)("\u5220\u9664ID\u4e3a: " + ids + " \u7684\u865a\u62df\u76f4\u64ad\u9891\u9053\u5931\u8d25"), (String)this.Request.getClientIP());
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
        }
    }

    public void publish() {
        String id = this.$V("id");
        String type = this.$V("status");
        if (StringUtil.isEmpty((String)id) || StringUtil.isEmpty((String)type)) {
            this.Response.setStatus(0);
            this.Response.setMessage("\u9519\u8bef\u7684\u53c2\u6570!");
            return;
        }
        QueryBuilder qb = new QueryBuilder();
        String op = "";
        if ("online".equals(type)) {
            op = "\u53d1\u5e03";
            qb.setSQL("update scms_virtualchannel set ispublish=1, publishdate=now() where id='" + id + "'");
        } else if ("offline".equals(type)) {
            op = "\u64a4\u9500";
            qb.setSQL("update scms_virtualchannel set ispublish=0 where id='" + id + "'");
        }
        try {
            qb.executeNoQuery();
            this.Response.setMessage(op + "\u64cd\u4f5c\u6210\u529f!");
            this.Response.setStatus(1);
        }
        catch (Throwable e) {
            this.Response.setStatus(0);
            e.printStackTrace();
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
        }
    }
}

