<!DOCTYPE html>
<%@include file="../../Include/Init.jsp"%>
<%@ taglib uri="controls" prefix="sobey"%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>数据库集群管理</title>
<link href="../../Default/styles/style.css" type="text/css" rel="stylesheet"/>
<link href="../../NewFramework/Style/framework.css" type="text/css" rel="stylesheet"/>
<script type="text/javascript" src="../../Plugin/jquery/jquery-1.8.3.js"></script>
<script src="../../Default/scripts/main.js"></script>
<script src="../../Framework/Main.js"></script>
<script src="../../NewFramework/Main.js"></script>
<style type="text/css">
	.btn{
		font-size: 12px;
	}
	
	.well-small {
	    overflow: hidden;
	}
</style>
<script>

Page.onLoad(function(){
	updateStatus();
});

function updateStatus(){
	Server.sendRequest("com.sobey.bsp.vms.business.adminservicemodule.dbconnection.action.DBConnectionAction.showStatus",
			null, function(response) {
			var totalCount = response.get("totalCount");
			var isUsingCount = response.get("isUsingCount");
			var surplusCount = response.get("surplusCount");
			
			jQuery("#isUsingCount").html(" "+isUsingCount);
			jQuery("#surplusCount").html(" "+surplusCount);
		});
}

function add(){
	var diag = new Dialog("Diag1");
	diag.Width = 500;
	diag.Height = 400;
	diag.Title = "添加数据库连接";
	diag.ShowTitleRow = true;
	diag.ShowButtonRow = true;
	diag.MoveDirection = false;
	diag.URL = "DBConnectionDialog.jsp";
	diag.CancelEvent = function(){
		diag.close();
	}
	diag.OKEvent = addSave;
	diag.show();
	
}

function edit(){
	
	var arr = dg1.gridBody.getSelectedRowsData();
	if(!arr||arr.length==0){
		MsgPop("请先选择要修改的行！");
		return;
	}
	if(arr.length > 1){ 
		MsgPop("只能选择一行进行修改！");
		return;
	}
	var id  = arr.join();
	var diag = new Dialog("Diag1");
	diag.Width = 500;
	diag.Height = 400;
	diag.Title = "添加数据库连接";
	diag.ShowTitleRow = true;
	diag.ShowButtonRow = true;
	diag.MoveDirection = false;
	diag.URL = "DBConnectionDialog.jsp?id="+id;
	diag.CancelEvent = function(){
		diag.close();
	}
	diag.OKEvent = editSave;
	diag.show();
}

function editSave(){
	jQuery('#form2').vmsForm({
		method: "com.sobey.bsp.vms.business.adminservicemodule.dbconnection.action.DBConnectionAction.save", 
		autoCommit: true
	}, function(response){
		MsgPop(response.Message,function(){
			if(response.Status==1){
				$D.close();
				dg1.loadData();
				updateStatus();
			}
		});
	});
	
}

function addSave(){

	jQuery('#form2').vmsForm({
		method: "com.sobey.bsp.vms.business.adminservicemodule.dbconnection.action.DBConnectionAction.add", 
		autoCommit: true
	}, function(response){
		MsgPop(response.Message,function(){
			if(response.Status==1){
				$D.close();
				dg1.loadData();
				updateStatus();
				
			}
		});
	});
}



function del(){
	var arr = dg1.gridBody.getSelectedRowsData();
	if(!arr||arr.length==0){
		MsgPop("请先选择要删除的行！");
		return;
	}
	
	Dialog.confirm("确定要删除该数据库连接吗？",function(){
		var dc = new DataCollection();	
		dc.add("ids",arr.join());
		jQuery.vmsAjax("com.sobey.bsp.vms.business.adminservicemodule.dbconnection.action.DBConnectionAction.del", dc, function(response){
			MsgPop(response.Message,function(){
				if(response.Status==1){
					dg1.loadData();
					updateStatus();
				}
			});
		})
	});
}


jQuery(function(){
	jQuery('#dg1').vmsDataGrid({operations:[{text: '批量删除', handler: del}]});
})

</script>
</head>
<body>

<div class="topBox">
	<div class="siteMap">
		<a href="javascript:void(0)" class="first" >VMS</a><a href="javascript:void(0)">服务管理</a><a href="javascript:void(0)" class="last" >数据库连接管理</a>
	</div>
	<a style="margin-right: 10px" href="javascript:" class="uploadVideo button01" onclick="del()">删除</a>
	<a style="margin-right: 10px" href="javascript:" class="uploadVideo button01" onclick="edit()">修改</a> 
	<a style="margin-right: 10px" href="javascript:" class="uploadVideo button01" onclick="add()">新增</a>
	
</div>
<div class="contentBox">
	<div class="contentBoxRight" style="width:100%">
		<div class="topSearch">
			<div class="searchSub" style="float: left;margin-left: 25px">
				<span>已使用连接:<font color="green"><b id="isUsingCount"></b></font>
				&nbsp;&nbsp;&nbsp;
				剩余连接数: <font color="red"><b id="surplusCount"></b></font>
				</span>
			</div>
		</div>
		<table width="100%" cellpadding="2" cellspacing="0" class="tableList" 
           	id="dg1" method="com.sobey.bsp.vms.business.adminservicemodule.dbconnection.action.DBConnectionAction.dg1DataBind">
             <tr ztype="head">
               <td width="4%" ztype="RowNo"><b>序号</b></td>
               <td width="5%" ztype="checkbox" field="id">&nbsp;</td>
               <td width="25%" class="left"><b>数据库连接地址</b></td>
               <td width="10%" class="left"><b>数据库名称</b></td>
               <td width="8%" class="left"><b>使用状态</b></td>
               <td width="10%" class="left"><b>占用站点</b></td>
               <td width="10%" class="left"><b>站点邮箱</b></td>
               <td width="8%" class="left"><b>租户ID</b></td>
               <td width="10%" class="left"><b>初始化连接数</b></td>
               <td width="10%" class="left"><b>最大连接数</b></td>
             </tr>
             <tr class='hide'>
				<td width="4%">&nbsp;</td>
				<td width="5%">&nbsp;</td>
				<td width="25%" class="left">${Address}</td>
				<td width="10%" class="left">${Name}</td>
				<td width="8%" class="left">${isUsing}</td>
				<td width="10%" class="left"><font color='red'>${siteName}</font></td>
				<td width="10%" class="left">${siteEmail}</td>
				<td width="8%" class="left">${tenantId}</td>
				<td width="10%" class="left">${InitConnCount}</td>
				<td width="10%" class="left">${MaxConnCount}</td>
			</tr>
           </table>
    </div>
	<br clear="both" />
</div>
<script>
jQuery('#SearchType').live('focus',function(){
	if(jQuery(this).val() == '请输入配置项类别或名称')jQuery(this).val('');
});
jQuery('#SearchType').live('blur',function(){
	if(jQuery(this).val() == '')jQuery(this).val('请输入配置项类别或名称');
});
</script>
</body>
</html>
