<!DOCTYPE html>
<%@include file="../../Include/Init.jsp"%>
<%@ taglib uri="controls" prefix="sobey"%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>配置</title>
<link href="../../Default/styles/style.css" type="text/css" rel="stylesheet"/>
<link href="../../NewFramework/Style/framework.css" type="text/css" rel="stylesheet"/>
<script type="text/javascript" src="../../Plugin/jquery/jquery-1.8.3.js"></script>
<script src="../../Default/scripts/main.js"></script>
<script src="../../Framework/Main.js"></script>
<script src="../../NewFramework/Main.js"></script>
<style type="text/css">
	.btn{
		font-size: 12px;
	}
	
	.well-small {
	    overflow: hidden;
	}
	.inputtext {
		width: initial;
	}
	.tableCutStr {
		white-space: nowrap;
		overflow: hidden;
		text-overflow: ellipsis;
	}
</style>
<script>
function add(){
	var diag = new Dialog("Diag1");
	diag.Width = 500;
	diag.Height = 330;
	diag.Title = "新建配置项";
	diag.ShowTitleRow = true;
	diag.ShowButtonRow = true;
	diag.MoveDirection = false;
	diag.URL = "ConfigDialog.jsp";
	diag.CancelEvent = function(){
		diag.close();
	}
	diag.OKEvent = addSave;
	diag.show();
	
}

//增加修改方法 11.6.2
function edit(dr){
	
	var dt = DataGrid.getSelectedData("dg1");
	if(dt.getRowCount()==0){
		
		MsgPop("请先选择要修改的行!");
		return;
	}
	dr = dt.getDataRow(0);
	var name=dr.get("name");
	var value=dr.get("value");
	var timeflag="false";
	var type=dr.get("type");
	var diag = new Dialog("Diag1");
	diag.Width = 400;
	diag.Height = 180;
	diag.Title = "修改配置项";
	
	if(type=="cms.media.cardTimeshift"){
		
		diag.URL = "Platform/ConfigDialogForTimeShift.jsp?flag="+"true";
		}else{
    	diag.URL = "Platform/ConfigDialog.jsp?flag="+"true";
		}
	diag.onLoad = function(){
		
		
		$DW.Form.setValue(dr,"form2");
		$DW.$S('Value',value);
		$DW.$S('Name',name);
	};
	diag.OKEvent = editSave;
	diag.show();
}

function addSave(){
	if(!/^[\w\-\.]+$/.test($V("Type"))){
		MsgPop("类别和名称中含有不规则字符\",\^\"");
		return;
	}
	var dc = new DataCollection(),
		name = dc.get("Name");
	dc.add("Name",name);
	jQuery('#form2').vmsForm({
		method: "com.sobey.bsp.platform.ConfigSys.add", 
		dc: dc, 
		autoCommit: true
	}, function(response){
		MsgPop(response.Message,function(){
			if(response.Status==1){
				$D.close();
				dg1.loadData();
			}
		});
	});
}

function editSave(){
	if(!/^[\w\-\.]+$/.test($DW.$V("Type"))){
		MsgPop("类别和名称中含有不规则字符\",\^\"");
		return;
	}
	var dc = new DataCollection(),
		name = dc.get("Name");
	dc.add("Name",name);
	jQuery('#form2').vmsForm({
		method: "com.sobey.bsp.platform.ConfigSys.edit", 
		dc: dc, 
		autoCommit: true
	}, function(response){
		MsgPop(response.Message, function(){
			if(response.Status==1){
				$D.close();
				dg1.loadData();
			}
		});
	});
}

function save(){
	dg1.gridBody.checkAndCancelEdit();
	dg1.saveModifiedRows("com.sobey.bsp.platform.ConfigSys.dg1Edit");
}

function del(){
	var arr = dg1.getSelectedRows();
	var typeArr = dg1.getSelectedRowsValue();
	if(!typeArr||typeArr.length==0){
		MsgPop("请先选择要删除的行！");
		return;
	}
	Dialog.confirm("确定要删除该配置项吗？",function(){
		var dc = new DataCollection();
		var siteIds = "";
		dc.add("types",typeArr.join());
        arr.each(function(){
            var _this = jQuery(this),
            siteId = _this.find("#siteId").val();
            siteIds += siteId + ",";
        });
        dc.add("siteIds", siteIds);
		jQuery.vmsAjax("com.sobey.bsp.platform.ConfigSys.del", dc, function(response){
			MsgPop(response.Message,function(){
				if(response.Status==1){
					dg1.loadData();
				}
			});
		})
	});
}

function doSearch(){
	var searchType = "",
		dc = new DataCollection();
	if($V("SearchType") != "请输入配置项类别或名称"){
		searchType = $V("SearchType").trim();
	}
	dc.add(Constant.PageIndex, 0);
	dc.add('SearchType', searchType);
	dg1.loadData(dc);
}

document.onkeydown = function(event){
	event = getEvent(event);
	if(event.keyCode==13){
		var ele = event.srcElement || event.target;
		if(ele.id == 'SearchType'||ele.id == 'Submitbutton'){
			doSearch();
		}
	}
}

function delKeyWord(flag) {
	if(flag){
		if ($V("SearchType") == "请输入配置项类别或名称") {
			$S("SearchType","");
		}
		return;
	}
	if($V("SearchType") == ""){
		$S("SearchType","请输入配置项类别或名称");
	}
}
jQuery(function(){
	jQuery('#dg1').vmsDataGrid({operations:[{text: '批量删除', handler: del}]});
})

</script>
</head>
<body>

<div class="topBox">
	<div class="siteMap">
		<a href="javascript:void(0)" class="first" >VMS</a><a href="javascript:void(0)">系统管理</a><a href="javascript:void(0)" class="last" >配置项管理</a>
	</div>
	<a style="margin-right: 10px" href="javascript:" class="uploadVideo button01" onclick="del()">删除</a>
	<a style="margin-right: 10px" href="javascript:" class="uploadVideo button01" onclick="save()">保存</a> 
	<a style="margin-right: 10px" href="javascript:" class="uploadVideo button01" onclick="add()">新增</a>
	
</div>
<div class="contentBox">
	<div class="contentBoxRight" style="width:100%">
		<div class="topSearch">
			<div class="searchSub">
			  	<input class="focus" id="SearchType" type="text" value="请输入配置项类别或名称" >
				<input type="button" onclick="doSearch()"/>
			</div>
			<br clear="both" />
		</div>
		<table width="100%" cellpadding="2" cellspacing="0" class="tableList" style="table-layout: fixed;"
           	id="dg1" method="com.sobey.bsp.platform.ConfigSys.dg1DataBind">
             <tr ztype="head">
               <td  width="3%" ztype="RowNo"><b>序号</b></td>
               <td width="5%" ztype="checkbox" field="type">&nbsp;</td>
               <td width="17%" class="left"><b>配置项类别</b></td>
               <td width="17%" class="left"><b>配置项名称</b></td>
               <td width="30%" class="left"><b>配置项值<span style="background-color: white;color:red;">(地址以“/”结尾)</span></b></td>
               <td width="30%" class="left"><b>配置项描述</b></td>
             </tr>
             <tr editable='true' class='hide'>
               <td align="center">&nbsp;</td>
               <td>&nbsp;</td>
               <td class="videoTitle left tableCutStr" editable='true' editType='text' editColumn='type' title='${type}'>${type}</td>
               <td class="left tableCutStr" editable='true' editType='text' editColumn='name' title='${name}'>${name}</td>
               <td class="left tableCutStr" editable='true' editType='text' editColumn='value' title='${value}'>${value}</td>
               <td class="left tableCutStr" editable='true' editType='text' editColumn='prop1' title='${prop1}'>${prop1}</td>
               <td style="display:none;" >
                   <input type="hidden" id="siteId" value="${siteId}" />
               </td>
             </tr>
           </table>
    </div>
	<br clear="both" />
</div>
<script>
jQuery('#SearchType').live('focus',function(){
	if(jQuery(this).val() == '请输入配置项类别或名称')jQuery(this).val('');
});
jQuery('#SearchType').live('blur',function(){
	if(jQuery(this).val() == '')jQuery(this).val('请输入配置项类别或名称');
});
</script>
</body>
</html>
