(function($){
	$(function(){
		setStatus();
		setDate();
		setPointerStyles();
		//computeSparedArea();
		$('#dg1').vmsDataGrid({operations: [{text: '批量删除', handler: batchDel, args: {name: "John"}}, {text: '批量编目', handler: batchEdit, args: {name:"Leon"}}]}, function(){
			
		});
		function batchDel(obj) {
			alert(obj.name);
		}
		function batchEdit(obj) {
			alert(obj.name);
		}
		$('div.main-area').on('click', 'div.switch-key', function(event){
			event.stopPropagation();
			event.preventDefault();
			var _this = $(this);
			var _parent = _this.parent().parent();
			var livePannel = $('div.live-pannel');
			var pannel_pointer = $('span.pannel_pointer');
			var host = _parent.find('input[name=host]').val();
			var playerUrl = _parent.find('input[name=playerUrl]').val();
			var cid = _parent.find('input[type=checkbox]').val();
				
			if (livePannel.hasClass('hide')) {
				livePannel
						.removeClass('hide')
						.animate({right: '0px'}, 'fast', function(){
							var index = _parent.index('tr:gt(0)');
							var top = parseInt(_parent.css('height'), 10) * index;
							pannel_pointer
								.removeClass('hide')
								.animate({top: '+=' + top});
						});
				_this.attr('isEdit', 'true');
				loadLivePlayerByID(playerUrl, 'live_player', cid, getFullUrl(_parent), false);
				appendChannelInfo(_parent);
				appendFormatInfo(_parent);
				fillParentBlank(true);
				//computeSparedArea(true);
			} else {
				if (_this.attr('isEdit') == 'true') {
					livePannel
							.animate({right: '-440px'}, 'fast', function(){
								pannel_pointer
										.addClass('hide')
										.css('top', 
											pannel_pointer.attr('basetop') + 'px');
							}).addClass('hide');
					_this.removeAttr('isEdit');
					//computeSparedArea();
					fillParentBlank(false);
				} else {
					var relativeTR = $('div[isEdit=true]');
					var relaIndex = relativeTR.parent().parent().index('tr:gt(0)');
					relativeTR.removeAttr('isEdit');
					_this.attr('isEdit', 'true');
					var index = _parent.index('tr:gt(0)') - relaIndex;
					var top = parseInt(_parent.css('height'), 10) * index;
					pannel_pointer
						.animate({top: '+=' + top});
					loadLivePlayerByID(playerUrl, 'live_player', cid, getFullUrl(_parent), false);
					appendChannelInfo(_parent);
					appendFormatInfo(_parent);
					//computeSparedArea(true);
					fillParentBlank(true);
				}
			}
		}).on('dblclick', 'td.live-title', function(e){
			e.stopPropagation();
			
			var _this = $(this);
			var _parent = _this.parent();
			editLiveChannel(_parent.find('input[type=checkbox]').val(), _this.next().attr('status'));
		});
		
		$('div.main-area').on('click', 'div.btn', function(e){
			e.preventDefault();
			e.stopPropagation();
			
			var _this = $(this);
			var _switch = _this.parent();
			var _parent = _this.parent().parent().parent();
			var status = _parent.attr('status') == '0' ? 'online' : 'offline';
			var cid = _parent.parent().find('input[type=checkbox]').val();
			
			triggerPannelAndRemovePlayer();
			publish(cid, status, function(){
				if(status == 'online') {
					_parent.attr('status', '1');
					_this.text('撤销').attr('statusName', '撤销').attr('status', '1').animate({left:'25px'});
					_switch.removeClass('closed').addClass('open');
				} else {
					_parent.attr('status', '0');
					_this.text('发布').attr('statusName', '发布').attr('status', '0').animate({left:'-1px'});
					_switch.removeClass('open').addClass('closed');
				}
			});
		});
		
		$('div.open_box').hover(function(){
			$(this).addClass('open_box_hover');
			$('ul.open_ul').addClass('show');
		}, function(){
			$(this).removeClass('open_box_hover');
			$('ul.open_ul').removeClass('show');
		});
		
		$('div.live-operations').on('click', 'a.edit,a.del,a.actList,a.playerCode,a.preview', function(event){
			event.stopPropagation();
			var _this = $(this);
			var cid = getCurrentCID();
			
			if (_this.hasClass('edit')) {
				editLiveChannel(cid, $('div[isEdit=true]').parent().prev().attr('status'));
			} else if (_this.hasClass('del')) {
				delLiveChannel(cid);
			} else if (_this.hasClass('actList')) {
				addOrEditActList(cid);
			} else if (_this.hasClass('playerCode')) {
				getPlayerCode(cid);
			} else if (_this.hasClass('preview')) {
				previewChannel(cid);
			}
			
			triggerPannelAndRemovePlayer();
			
		});
		
		$('span.slideIcon').on('click', function(event){
			event.stopPropagation();
			
			var _this = $(this);
			
			_this
				.hasClass('slideDown') 
						? _this.removeClass('slideDown') 
						: _this.addClass('slideDown'); 
			_this
				.parent()
				.parent()
				.hasClass('live-outputstream') 
						? $('div.stream-info').slideToggle() 
						: $('div.channel-info').slideToggle();
			
		});
		$("#createChannel").on('click', function(){
			addLiveChannel();
		});
		$("ul.qieHuanBt").on('click', 'li.m1,li.m2', function(e){
			e.preventDefault();
			
			var _this = $(this);
			var _div = $('div.z-live');
			var _channelDG = $('#dg1');
			var _openBox = $('div.open_box');
			
			if (_this.hasClass('m1')) {
				if (_channelDG.hasClass('hide')) {
					_this
						.find('span')
						.addClass('on');
					$('li.m2')
						.find('span')
						.removeClass('on');
					_openBox.removeClass('hide');
					_channelDG.removeClass('hide');
					_div.addClass('hide').find('ul').html("");
					dg1.loadData();
				}
			} else if (_this.hasClass('m2')) {
				if (_div.hasClass('hide')) {
					_this
						.find('span')
						.addClass('on');
					$('li.m1')
						.find('span')
						.removeClass('on');
					_div.removeClass('hide');
					_channelDG.addClass('hide');
					_openBox.addClass('hide');
					triggerPannelAndRemovePlayer();
					loadChannelTVMode();
					//computeSparedArea();
				}
			}
		});
		$(".z-live li").live({
			mouseenter:function(){
				$(this).find(".t").show().stop().animate({
					marginTop:-42,
					height:42
				});
			},
			mouseleave:function(){
				$(this).find(".t").stop().animate({
					marginTop:0,
					height:0
				},'normal',function(){
					$(this).hide();
				});
			}
		});
		
		$("img.close-btn").live('click', function(e){
			e.stopPropagation();
			
			var _this = $(this);
			var _parent = _this.parents('div.t'); 
			var cid = _parent.siblings('input[type=checkbox]').val();
			delLiveChannel(cid);
			
		});
		
		$('.tableListRightBoxCloseBt').click(function(e){
			e.stopPropagation();
			triggerPannelAndRemovePlayer();
		})
		
	});
	
	function getCurrentCID(){
		var currentTR = $("div[isEdit=true]").parent().parent();
		var cid = currentTR.find('input[type=checkbox]').val();
		
		return cid;
	}
	
	function getFullUrl(tr) {
		var urlSpans = tr.find('td:last').find('span');
		var fullUrl = "";
		if (urlSpans.length > 0) {
			urlSpans.each(function(){
				var _span = $(this);
				
				if (_span.hasClass('outputstream-pc')) {
					fullUrl = _span.attr('title');
					return false;
				}
			})
		}
		
		return fullUrl;
	}
	
	function loadChannelTVMode(){
		var _channelDG = $('#dg1').find('div.grid-body').find('table tbody');
		var _tr = _channelDG.find('tr');
		
		if (_tr.length == 0) {
			return;
		} else if (_tr.length == 1) {
			if (typeof _tr.attr("id") == 'undefined') {
				return;
			}
		}
		var _div = $('div.z-live');
		var _ul = _div.find("ul");
		
		_tr.each(function(index){
			var _this = $(this);
			var channelName = _this.find('td:eq(2)').html();
			var status = _this.find('td:eq(3)').attr('status');
			var channelShortName = channelName;
			var fullUrl = getFullUrl(_this) || "";
			var cid = _this.find('input[type=checkbox]').val();
			var host = _this.find('input[name=host]').val();
			var playerUrl = _parent.find('input[name=playerUrl]').val();
			var hasActList = _this.attr("hasActList");
				
			if ((index + "").length == 1) {
				index = "0" + index;
			}
			var obj = {
				id: index,
				cid: cid,
				channelName: channelName,
				status: status,
				statusClass: (status == '0') ? 'closed' : 'open',
				statusText: (status == '0') ? '发布' : '撤销',
				actInfo: (hasActList == 'true') ? "" : '暂无节目单' 
			};
			var _channelTV = createChannelTVElement(obj);
			_channelTV.appendTo(_ul);
			loadLivePlayerByID(playerUrl, _channelTV.find('div.live-tv-player').attr('id'), cid, fullUrl, true);
		});
	}
	
	function createChannelTVElement(obj) {
		if (typeof obj == 'undefined' || typeof obj != 'object') {
			return null;
		} else {
			return $("<li><div class='t' status='"+obj.status+"'>"
					+ " <div class='audiot'>"
					+ " <div class='switch fl "+obj.statusClass+"'>"
					+ "    <div class='btn'>"+obj.statusText+"</div>"
                    + " </div>"
                    + " <img src='images/z-cancl.gif' width='12' height='12' class='close-btn fr'/>"
                    + " </div>"
                    + "</div>"
                    + "<div class='c'>"
                	+ " <div id='live_player_"+obj.id+"' class='live-tv-player'></div>"
                	+ "</div>"
                    + "<p class='f'>"
                	+ " <span class='fr mark'>"+obj.channelName+"</span>"
                    + " "+obj.actInfo+""
                    + "</p><input type='checkbox' class='hide' name='"+obj.cid+"' value='"+obj.cid+"'></li>");
		}
	}
	
	function loadLivePlayerByID(playerUrl, id, cid, url, isShowControl, w, h) {
		var playerPannel = document.getElementById(""+id+"");
		var nodeName = playerPannel.nodeName;
		
		/*if (nodeName.toLowerCase() == 'object' 
				|| nodeName.toLowerCase == 'embed') {
			playerPannel.PlayNew(url, 'seekableLiveS');
			
			return;
		}*/
		var $player = $(playerPannel);
		if (typeof w == 'undefined') {
			w = $player.width();
		}
		if (typeof h == 'undefined') {
			h = $player.height();
		}
		createPlayer4mini(playerUrl, w, h, id, "p2pLiveS", cid, isShowControl);
	}
	
	function publish(cid,status, func){
		var dc  = new DataCollection();
		dc.add("id",cid);
		dc.add("status",status);
		Server.sendRequest("com.sobey.scms.channel.ChannelLib.publish",dc,function(response){
			MsgPop(response.Message, function(){
				if(response.Status==1){
					if (typeof func == 'function') {
						func();
					}
					if ($('li.m2').find('span').hasClass('on')) {
						$('table.tableList').addClass('hide');
					}
					refreshChannelTVs(cid, status);
				}
			});
		});
	}
	
	function refreshChannelTVs(cid, status){
		var _li = $('div.z-live ul').find('li');
		if (_li.length > 0) {
			var currentLi = _li.find("input[name='"+cid+"']").parent();
			if (status == 'del') {
				currentLi.remove();
				return;
			}
			var currentStatus = (status == 'online') ? '1' : '0';
			var _switch = currentLi.find('div.switch');
			var currentStatusText = (status == 'online') ? '撤销' : '发布';
			currentLi.find('div.t').attr('status', currentStatus);
			_switch.hasClass('open') 
				? _switch.removeClass('open').addClass('closed') 
				: _switch.removeClass('closed').addClass('open');
			currentLi.find('div.btn').html(currentStatusText);
		}
	}
	
	function triggerPannelAndRemovePlayer(){
		var currentObj = $("div[isEdit=true]");
		
		if (currentObj.length > 0) {
			currentObj.trigger('click');
			$("#live_player").remove();
			$(".tableListRightBoxCloseBt").after("<div id='live_player' class='live-player'></div>");
		}
	}
	
	function getPlayerCode(cid){
		var diag = new Dialog("Dialog2");
		diag.Width = 706;
		diag.Height = 424;
		diag.Title = "直播预览";
		diag.URL = "ChannelPlayerCode.jsp?id="+cid;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = false;
		diag.onLoad = function(){
			var id = 'video_player';
			var _parent = $("input[value="+cid+"]").parent().parent();
			var url = getFullUrl(_parent);
			var host = _parent.find('input[name=host]').val();
			var playerUrl = _parent.find('input[name=playerUrl]').val();
			
			loadLivePlayerByID(playerUrl, id, cid, url, true);
		}
		diag.show();
	}
	
	function previewChannel(cid){
		window.open("ChannelPreview.jsp?id="+cid);
	}
	
	function addLiveChannel(){
		window.isEdit = false;
		var pannelHeight = $('div.live-pannel').height();
		var diag = new Dialog("Diag2");
		diag.Width = document.body.clientWidth;
		diag.Height = Math.max(document.body.scrollHeight, pannelHeight) - diag.Top;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "新增直播频道";
		diag.URL = "ChannelLibDialog.jsp?flag=0";
		diag.onLoad = function(){
			triggerPannelAndRemovePlayer();
			upload('form1');
			var configItem = new ActItem(null, {type: 'LiveConfigItem', operation: 'AddConfig', parent: 'config_wrapper'});
			configItem.show();
			$(".select").each(function(){
				$(this).selectCopy();
			}); 
		};
		diag.show();
	}

	function editLiveChannel(cid, status){
		var pannelHeight = $('div.live-pannel').height();
		var diag = new Dialog("Diag2");
		window.isEdit = true;
		window.cid = cid;
		diag.Width = document.body.clientWidth-diag.Left;
		diag.Height = Math.max(document.body.scrollHeight, pannelHeight) - diag.Top;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "编辑直播频道";
		diag.URL = "ChannelLibDialog.jsp?id="+cid+"&flag=1";
		diag.onLoad = function(){
			if (status == '1') {
				$('#saveBtn').hide();
			}
			upload('form1');
		};
		diag.show();
	}

	function delLiveChannel(cid){
		Dialog.confirm('确认删除此直播频道吗?', function(){
			var dc = new DataCollection();
			dc.add("ids", cid);
			Server.sendRequest("com.sobey.scms.channel.ChannelLib.delete", dc, function(response){
				MsgPop(response.Message, function(){
					triggerPannelAndRemovePlayer();
					var isShow = jQuery("#dg1").hasClass('hide') ? false : true;
					dg1.loadData(function(){
						if (!isShow) {
							$('#dg1').addClass('hide');
						}
						refreshChannelTVs(cid, 'del');
					});
				});
			});
		}, function(){
			return false;
		});
	}

	function addOrEditActList(cid){
		var pannelHeight = $('div.live-pannel').height();
		var diag = new Dialog("Diag2");
		window.cid = cid;
		diag.Width = document.body.clientWidth-diag.Left;
		diag.Height = Math.max(document.body.scrollHeight, pannelHeight) - diag.Top;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "直播节目单";
		diag.URL = "LiveActList.jsp?id="+cid+"";
		diag.onLoad = function(){
			$(".fabuyu").height($(window).height());
		};
		diag.show();
	}

	

	function setPointerStyles(){
		var _pannel = $('div.live-pannel');
		var width = parseInt(_pannel.width(), 10);
		var paddingLeft = parseInt(_pannel.css('paddingLeft'), 10);
		var paddingRight = parseInt(_pannel.css('paddingRight'), 10);
		var totalWidth = width + paddingLeft + paddingRight;
		$('span.pannel_pointer').css('right', totalWidth + 'px');
	}

	function checkedAll(obj){
		var checked = obj.checked ? true : false;
		if(checked){
			DataGrid.selectAll("dg1");
		}else{
			DataGrid.unselectAll("dg1");
		}
	} 

	function timeMove(){
		if($V("timeMove")=="0"){
			document.getElementById("timeMoveDay").style.display = "none";
			document.getElementById("dayNum").value = "0";
		}else{
			document.getElementById("timeMoveDay").style.display = "";
		}
	}
	
	function computeSparedArea(isPannelShow){
		var cObj = $('#dg1').hasClass('hide') ? $('div.z-live') : $("#dg1");
		var height = $(window).height()-$(".tableListPage").outerHeight(true)-10-cObj.outerHeight(true)-$(".topSearch").outerHeight(true)-jQuery(".topBox").outerHeight(true);
		if (isPannelShow) {
			height = parseInt($("div.live-pannel").height(), 10) - $('#dg1').find('tr:gt(0)').length * 40;
		}
		if(height<0){height=0;}
		$("#kongbai").height(height);
	}
	
	function setStatus(){
		var objs = $('div.aswitch');
		
		if (objs.length > 0) {
			objs.each(function(){
				var _this = $(this);
				var parent = _this.parent().parent();
				var status = parent.attr('status');
				
				if (status == '1') {
					_this.addClass('open');
				} else {
					_this.addClass('closed');
				}
			})
		}
	}
	
	function fillParentBlank(isShow) {
		var $pannel = $("div.live-pannel"),
			$parent = $pannel.parent();
		
		if (isShow == true) {
			if (!$parent.attr('orignalHeight')) {
				$parent.attr('orignalHeight', $parent.height());
			}
			$parent.height($pannel.height());
		} else {
			$parent.height($parent.attr('orignalHeight'));
		}
	}
})(window.jQuery);

function upload(){
	jQuery("#form1")
					.find("#img")
					.uploadify({
        				'buttonText': '选择台标',
        				'queueSizeLimit' : 1,
				        'swf'       : '../Site/jquery/uploadify/uploadify.swf',  
				        'uploader'  : '../servlet/WebFileUploadServlet?siteAlias='+alias+'&uploadType=image&siteid='+siteid,
				        'auto'      : true,
				        'fileDesc'	: '支持格式:jpg/gif/jpeg/png/bmp.', 
				      	'fileExt'	: '*.jpg;*.gif;*.jpeg;*.png',
				      	'queueID'	: 'file_queue',
				      	'onUploadSuccess' : function(file, data, response) {
				      		data = eval("(" + data + ")");
							var imageUrl = data.absoluteUrl;
				      		jQuery("#form1").find("#filedata").attr("value",imageUrl);
				      		jQuery("#form1").find("#imgurl").attr("src",imageUrl);
				    	}
   					 });  
}

function loadActList(cid, date, isParent) {
	var dc = new DataCollection();
	dc.add("cid", cid);
	dc.add("date", date);
	
	Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.getActListByCid", dc, function(response) {
		var json = eval('(' + response.Message+ ')');
		if (json.state) {
			if (isParent === true) {
				appendActList(json.actList);
			} else {
				ActItem.createBatchVLiveItems(json.actList);
			}
		}
	});
}

function appendActList(obj){
	if (typeof obj == 'undefined' || obj.length == 0) {
		return;
	} else {
		var _li = "", count = obj.length;
		if (count == 0) {
			jQuery('div.act-info').css("height", "30px");
			return;
		} else {
			for (var i = 0; i < count; i++) {
				var content = obj[i].content;
				if (typeof content != 'undefined' 
					&& content != "" && content.length > 10) {
					content = content.substring(0, 10) + "...";
				}
				_li += "<li id='act_li' class='act-li'>"
					+ " <span id='li_startTime'>"+obj[i].startTime+"</span>"
					+ " <span id='li_content' title='"+obj[i].content+"'>"+content+"</span>"
					+ " <span id='li_endTime'>"+obj[i].endTime+"</span>"
					+ " </li>";
			}
			jQuery("ul.act-ul").html(_li);
			jQuery('div.act-info').css("height", count * 30 + "px");
		}
	}
}

function appendChannelInfo(tr) {
	jQuery("#cID")
			.find("span:eq(1)")
			.html(tr.find("input[type=checkbox]").val());
	jQuery("#cName")
			.find("span:eq(1)")
			.html(tr.find("td:eq(2)").html());
	jQuery("#ctTime")
			.find("span:eq(1)")
			.html(tr.find("input[name=createTime]").val());
	jQuery("#epDate")
			.find("span:eq(1)")
			.html(tr.find("input[name=expireDate]").val());

	var timeShift = "";
	if (tr.find("input[name=timeShift]").val() == '1') {
		timeShift = "是";
	} else {
		timeShift = "否";
	}
	jQuery("#tShift")
			.find("span:eq(1)")
			.html(timeShift);
	jQuery("#tShiftDate")
			.find("span:eq(1)")
			.html(tr.find("input[name=timeShiftDate]").val());
}

function appendFormatInfo(tr) {
	var spans = tr.find('td:last').find('span');
	var length = spans.length;
	if (length > 0) {
		var info = "";
		spans.each(function(){
			var _this = jQuery(this);
			var url = _this.attr('title');
			var formatinfo = _this.html();
			var title = url;
			
			if (title.length > 50) {
				title = title.substring(0, 50) + '...';
			}
			info += "<li><span>"+formatinfo+"：</span>" 
					+ " <span class='stream-url' title='"+url+"'>"+title+"</span></li>";
		});
		jQuery('ul.stream-ul').html(info);
		jQuery("div.stream-info").css({
			height: length * 24 + "px"
		});
	}
}

function loadChannelInfo(){
	var currentTR = jQuery('div[isEdit=true]').parent().parent();
	var cname = currentTR.find('td:eq(2)').html();
	var date = jQuery('span.date-info').html();
	
	jQuery('span.channel').html(cname);
	jQuery('span.vdate-info').html(date);
}

function setDate(){
	var currentDate = new Date();
	var currentYear = currentDate.getFullYear();
	var currentMonth = currentDate.getMonth() + 1;
	var currentDay = currentDate.getDate();
	
	currentMonth = ((currentMonth + "").length < 2) 
			? "0" + currentMonth 
			: currentMonth;
	currentDay = ((currentDay + "").length < 2) 
			? "0" + currentDay 
			: currentDay;
	jQuery('span.date-info').html(currentYear + '-' + currentMonth + "-" + currentDay);
}
