/**
 * 直播节目单相关操作
 */
(function($){
	$(function(){
		setCurrentDate();
		loadChannelsAndActList();
		//importActList();
		loadDatePlugin();
		$('div.vaddspan').on('click', function(e){
			e.preventDefault();

			if (!isAbleToChangeActList()) {
				return;
			}
			var item = new ActItem(null, {type: 'LiveItem', operation: 'AddLiveAct', parent: 'VActWrapper'});
			item.show();
		});
		$('div.vactlist').on('mouseover mouseout', 'div.itembox,div.vaddspan,p.spared_item', function(e){
			e.preventDefault();

			var _this = $(this);

			(e.type == 'mouseover')
				? _this.addClass('hoverClass')
				: _this.removeClass('hoverClass');
		}).on('click', 'input[name=startTime],input[name=endTime]', function(e){
			e.preventDefault();

			var _this = $(this);
			var name = _this.attr("name");

			if (name == "startTime") {
				if (e.type == "click") {
					WdatePicker({dateFmt:'HH:mm:ss',onpicked:function(dp){
						checkStartInput(_this);

						}});
				}
			} else if (name == "endTime") {
				if (e.type == "click") {
					WdatePicker({
						dateFmt:'HH:mm:ss',
						startDate:_this.parent().find('input[name=startTime]').val(),
					//	alwaysUseStartDate:true,
						onpicked:function(dp)
						{
							checkEndInput(_this);
							}
					});
				}
			}
		}).on('focusin focusout','input[name=content]',function(e){
              e.preventDefault();
			var _this = $(this);
			var name = _this.attr("name");
			if (name == "content") {
				if (e.type == "focusout") {
					checkContent(_this);
				}
			}

		}).on('click.ActItem.event.add','p.spared_item', function(event){

				//var item = new ActItem(null, {type: 'LiveItem', operation: 'AddLiveAct', parent: 'VActWrapper'});
			if (!isAbleToChangeActList()) {
				return;
			}
			    var item = new ActItem(this, {operation: 'Insert'});
				item.show();
				return false;
		}).on('click', 'span.validate_span', function(e){


			var _parent =jQuery(e.target).parent();
			var validate =  _parent.find("[name='validate']").val();
			if(validate=="1"){
			_parent.css("background-color","");
			_parent.attr("title","");
			jQuery(e.target).attr("title","屏蔽节目");
			_parent.find("[name='validate']").val("0");
			jQuery(e.target).text("屏蔽");
			}else{
			_parent.find("[name='validate']").val("1");
			_parent.css("background-color","rgb(243, 82, 20)");
			_parent.attr("title","该节目已经被屏蔽");
			jQuery(e.target).attr("title","恢复节目");
			jQuery(e.target).text("恢复");
			}
			ActItem.editFlag = true;


			if (!isAbleToDelActList()) {

				return;
			}

		}).on('click', 'span.del_span', function(e) {
			e.preventDefault();

			if(!isAbleToChangeActList()){
				return;
			}
			//e.target 当前操作元素
			var _parent =jQuery(e.target).parent();
			//判断同级前后元素是什么，如果为spared_item，则不增加新的
			if(!_parent.prev().hasClass("spared_item")&&!_parent.next().hasClass("spared_item")&&_parent.next().length>0){
			var sparedItem = ActItem.prototype.createSparedItem.call();
			sparedItem.insertBefore(_parent);
			}
			//如果删除节目前后都有spared_item，则删除其中一个spared_item
			if(_parent.prev().hasClass("spared_item")&&_parent.next().hasClass("spared_item")){
				_parent.prev().remove();
			}
			//如果当前为最后一个节目而且上个元素为spared_item
			if(_parent.next().length==0&&_parent.prev().hasClass("spared_item")){
				_parent.prev().remove();
			}
			//如果当天节目全部被删除，则删除所有spared_item
			if($("div.itembox").length==1){
				$("p.spared_item").remove();
			}
			ActItem.prototype.delLiveActItem.call(this.parentNode);

		});
		$('#switch_channel').on('click', function(e){
			e.preventDefault();

			computeVLChannelHeight();
			$('div.LChannels_wrap').slideToggle();

		});
		$('a.edit-save').on('click', function(e){
			e.preventDefault();

			addOrEditSaveActList();
		});
		$('#copy').on('click', function(){
			copyActList();
		});
		$('div.LChannels_wrap').on('click', 'a.a-lchannel', function(e){
			e.preventDefault();

			var _this = $(this);
			if (_this.hasClass('a-cur')) {
				return false;
			}
			$('a.a-cur').removeClass('a-cur');
			_this.addClass('a-cur');
			$('#VActWrapper').html('');
			loadChannelActListById(_this.find('input').val());
			$('span.channel').html(_this.find('span').attr('title'));
		});

		$("img.back").on('click', function(e){
			e.stopPropagation();

			if (($('div.itembox').length > 0 && ActItem.isNewAct == true)
					|| ActItem.editFlag == true) {
				Dialog.confirm("节目单已作变更，是否保存？", function(){
					ActItem.addOrEditSaveLiveActList(function(){
						ActItem.delMap = {};
						ActItem.delIDs = [];
						ActItem.editFlag = false;
						closeAndLoadDG();
					});
				}, function(){
					ActItem.editFlag = false;
					closeAndLoadDG();
				});
			}  else {
				ActItem.editFlag = false;
				closeAndLoadDG();
			}
		});
	});

	function setCurrentDate(){
		$('span.vdate-info').html(DateUtil.getCurrentDate());
	}

	function getCurrentDate(){
		return $('span.vdate-info').html();
	}

	function loadChannelsAndActList(){
		if (typeof window.cid != 'undefined' && (window.cid.length > 0)) {
			loadChannels(window.cid);
			loadChannelActListById(window.cid);
		}
	}

	function computeVLChannelHeight(){
		if (typeof $('#LChannels').attr('originalHeight') != 'undefined') {
			return;
		}
		var _LChannels = $('#LChannels');
			_channelCount = _LChannels.find('a.a-lchannel').length,
			_width = parseInt(_LChannels.width(), 10),
			_channelHeight = parseInt(_LChannels.height(), 10),
			columnCount = Math.floor(_width/177),
			lineCount = Math.ceil(_channelCount/columnCount),
			_height = lineCount * 72;
		if (_channelCount) {
			_LChannels.css('height', "auto");
			_LChannels.attr('originalHeight', _height);
		}
	}

	function loadChannels(cid) {

		/*//加载当前页的频道信息
		var trs = $('#dg1').find('tr:gt(0)');
		if (trs.length > 0) {
			var channelInfo = "";
			trs.each(function(){
				var _this = $(this),
					name = _this
						.find('td:eq(2)')
						.text(),
					id = _this
					   .find('input[type=checkbox]')
					   .val(),
					status = _this.find('#status').attr('status'),
					channelName = name;

				if (name.length > 5) {
					name = name.substring(0, 5) + "...";
				}
				channelInfo += "<a href='javascript:void(0);' class='a-lchannel fl' status='"+status+"'>"
							+ "  <span title='"+channelName+"'>"+name+"</span>"
							+ "	 <input type='hidden' name='"+id+"' value='"+id+"'/>"
							+ "</a>";
			});
			$('div.lchannels')
					.html(channelInfo)
					.find("input[name="+cid+"]")
					.parent()
					.addClass('a-cur');
			$('span.channel').html($('a.a-cur').find('span').attr('title'));
		} else {
			return;
		}
		*/
		//改为加载所有的频道信息
		var date = getCurrentDate();
		var dc = new DataCollection();
		dc.add('date', date);
		dc.add('type',type);
		Server.sendRequest("com.sobey.scms.channel.ChannelLib.getAllChannels", dc, function(response){
			if (response.Status == 0) {
				//$D.close();
				Dialog.alert('加载频道信息出错，请重新加载');
				return;
			} else if (response.Status == 1) {
				var json = eval('(' + response.Message + ')');
				//var json = response.Message;
				var list = json.actList;
				var channelInfo = "";
				for(var i = 0 ;i < list.length;i++){
					var item = list[i];
					var _this = $(this);
					var	name = item.name;
					var	id = item.id;
					var	status = item.status;
						channelName = name;
					if (name.length > 5) {
						name = name.substring(0, 5) + "...";
					}
					channelInfo += "<a href='javascript:void(0);' class='a-lchannel fl' status='"+status+"'>"
								+ "  <span title='"+channelName+"'>"+name+"</span>"
								+ "	 <input type='hidden' name='"+id+"' value='"+id+"'/>"
								+ "</a>";
				}
				$('div.lchannels')
					.html(channelInfo)
					.find("input[name="+cid+"]")
					.parent()
					.addClass('a-cur');
				$('span.channel').html($('a.a-cur').find('span').attr('title'));
				importActList();
			}
		});
	}

	function loadChannelActListById(cid) {
		$('#VActWrapper').html("");
		var date = getCurrentDate();
		var dc = new DataCollection();
		dc.add('cid', cid);
		dc.add('date', date);
		Server.sendRequest("com.sobey.scms.channel.ChannelActList.getChannelActListById", dc, function(response){
			if (response.Status == 0) {
				$D.close();
				Dialog.alert('加载节目单出错，请重新加载');
			} else if (response.Status == 1) {
				var json = eval('(' + response.Message + ')');
				ActItem.createBatchLiveActItems(json.actList);
			}
		});
	}

	function loadDatePlugin(){
		var nowdate= DateUtil.getCurrentDate();
		WdatePicker({
			eCont:'dateArea',
			startDate:nowdate,
			alwaysUseStartDate:true,
			onpicked:function(dp){
				var pickedDate = dp.cal.getDateStr();

				if (pickedDate != $('span.vdate-info').html()) {
					if (($('div.itembox').length > 0 && ActItem.isNewAct == true)
							|| ActItem.editFlag == true) {
						alert("当前节目单已作变更，请保存");
					} else {
						$('#VActWrapper').html("");
						$('span.vdate-info').html(pickedDate);
						loadChannelActListById($('a.a-cur').find('input').val());
					}
				}
			}
		});
	}

	function checkStartInput(obj) {
		try {
			obj = (obj instanceof jQuery ? obj : jQuery(obj));
			var obhval=obj.val();
			var _parent = obj.parent(),
				endTimeMillis = DateUtil.getTimeMillis(
					_parent.find('input[name=endTime]').val()),
				startTimeMillis = DateUtil.getTimeMillis(obj.val()),
				start_time = _parent.find('input[name=start_Time]').val(),
				prevObj = _parent.prev();
				if(prevObj.hasClass("spared_item")){
					prevObj=prevObj.prev();
				}
			if (!isAbleToChangeActList(endTimeMillis)) {
				return;
			}
			if (startTimeMillis >= endTimeMillis) {
				alert("开始时间不能大于节目单的结束时间，请重新输入");
				obj.val(start_time);
				if (start_time.length > 0) {
					obj.removeClass('empty');
				}
				if(obhval==start_time){
					if(_parent.prev().hasClass("spared_item")){
							_parent.prev().remove();
							}
				}
				return true;
			} else if (prevObj.length > 0) {
				var prevEndTimeMillis = DateUtil.getTimeMillis(
						prevObj.find('input[name=endTime]').val());

				if (startTimeMillis > prevEndTimeMillis) {
					//当期节目开始时间大于前一节目结束时间
					if(!_parent.prev().hasClass("spared_item")){
						var sparedItem = ActItem.prototype.createSparedItem.call();
						sparedItem.insertBefore(_parent);
						}
				//	Dialog.alert("开始时间大于上一节目单的结束时间，请重新输入");
				//	obj.val(_parent.find('input[name=start_Time]').val());
				//	if (start_time.length > 0) {
				//		obj.removeClass('empty');
				//	}
					return false;
				} else if (startTimeMillis < prevEndTimeMillis) {
					alert("开始时间小于上一节目单的结束时间，请重新输入");
					obj.val(_parent.find('input[name=start_Time]').val());
					if (start_time.length > 0) {
						obj.removeClass('empty');
					}
					return false;
				}else {
					//当期节目开始时间等于前一节目结束时间
					//判断前一节点是否为spared元素
					if(_parent.prev().hasClass("spared_item")){
					//	var sparedItem = ActItem.prototype.createSparedItem.call();
					//	sparedItem.insertBefore(_parent);
						_parent.prev().remove();
						}

				}
			} else if(_parent.prev().length==0&&startTimeMillis>0){
				//当前操作节点为第一个节点
				var sparedItem = ActItem.prototype.createSparedItem.call();
				sparedItem.insertBefore(_parent);
			} else if(startTimeMillis==0){
				if(_parent.prev().hasClass("spared_item")){
					_parent.prev().remove();
					}
			}
			if (obj.val() == _parent.find('input[name=start_Time]').val()) {
				return;
			}
			if (obj.val().length > 0) {
				_parent
					.find('input[name=start_Time]')
					.val(obj.val());
				obj.removeClass('empty');
			} else {
				if (!obj.hasClass('empty')) {
					obj.addClass('empty');
				}
			}
			ActItem.setFlag();
		} catch (e) {
			Dialog.alert("开始时间输入不合法，请重新输入");
		}
	}

	function checkEndInput(obj) {
		try {
			obj = (obj instanceof jQuery ? obj : jQuery(obj));
			var _parent = obj.parent(),
				startTimeMillis = DateUtil.getTimeMillis(
					_parent.find('input[name=startTime]').val()),
				endTimeMillis = DateUtil.getTimeMillis(obj.val()),
				end_time = _parent.find('input[name=end_Time]').val(),
				nextObj = _parent.next();
				if(nextObj.hasClass("spared_item")){
					nextObj=nextObj.next();
				}
				if (!isAbleToChangeActList(endTimeMillis)) {
					obj.val(end_time);
					return;
				}
				if (endTimeMillis <= startTimeMillis) {
					alert("结束时间不能小于开始时间，请重新输入");
					obj.val(end_time);
					if (end_time.length > 0) {
						obj.removeClass('empty');
					}
					return false;
				} else if (nextObj.length > 0) {
					var nextStartTimeMillis = DateUtil.getTimeMillis(
							nextObj.find('input[name=startTime]').val());

					if (endTimeMillis > nextStartTimeMillis) {
						//Dialog.alert("结束时间不能大于下一节目单的开始时间，请重新输入");
						alert("结束时间不能大于下一节目单的开始时间，请重新输入");
						obj.val(_parent.find('input[name=end_Time]').val());
						if (end_time.length > 0) {
							obj.removeClass('empty');
						}
						return false;
					} else if(endTimeMillis == nextStartTimeMillis){
						//当前节目结束时间等于下次节目开始时间
						if(_parent.next().hasClass("spared_item")){
							_parent.next().remove();
						}

					}else{
						////当前节目结束时间小于下次节目开始时间
						if(!_parent.next().hasClass("spared_item")){
						var sparedItem = ActItem.prototype.createSparedItem.call();
						sparedItem.insertBefore(_parent.next());
						}
					}
				}
				if (obj.val() == _parent.find('input[name=end_Time]').val()) {
					return;
				}
				if (obj.val().length > 0) {
					_parent
						.find('input[name=end_Time]')
						.val(obj.val());
					obj.removeClass('empty');
				} else {
					if (!obj.hasClass('empty')) {
						obj.addClass('empty');
					}
				}
				ActItem.setFlag();
			} catch (e) {
				Dialog.alert("结束时间输入不合法，请重新输入");
			}
	}

	function checkContent(obj) {
		var isPublish = $('a.a-cur').attr('status') == 1 ? true : false,
			nowDate = DateUtil.getCurrentDate(),
			currentDate = getCurrentDate();

		if ((currentDate == nowDate) && isPublish) {
			if (obj.val() != obj.parent().find('input[name=content_hidden]').val()) {
				obj.val(obj.parent().find('input[name=content_hidden]').val());
				Dialog.alert("已发布的直播频道只能修改当天以后的节目单");
				return;
			}
		}
		if (obj.val() == obj.parent().find('input[name=content_hidden]').val()) {
			return;
		}
		if (obj.val().length > 0) {
			obj
				.removeClass('empty')
				.parent()
				.find('input[name=content_hidden]')
				.val(obj.val());
		} else {
			if (!obj.hasClass('empty')) {
				obj.addClass('empty');
			}
		}
		obj.attr("title",obj.parent().find('input[name=content_hidden]').val());
		ActItem.setFlag();
	}

	function isAbleToChangeActList(endTimeMillis) {
		var isPublish = $('a.a-cur').attr('status') == 1 ? true : false,
			nowDate = DateUtil.getCurrentDate(),
			currentDate = getCurrentDate(),
			nowTime = DateUtil.getTimeMillis(DateUtil.getCurrentTimeStr());
			if ((nowDate == currentDate && isPublish)) {

				alert("已发布的直播频道只能修改当天以后的节目单");
				return false;
			}
			if ((nowDate.replace("-", "") > currentDate.replace("-", ""))) {
				alert("不能修改当天以前的节目单");
				return false;
			}
			if ((nowDate.replace("-", "") == currentDate.replace("-", "")) && (endTimeMillis < nowTime)) {
				alert("只能修改当前时间以后的节目单");
				return false;
			}

			return true;
	}

	function isAbleToDelActList(endTimeMillis) {
		var isPublish = $('a.a-cur').attr('status') == 1 ? true : false,
			nowDate = DateUtil.getCurrentDate(),
			currentDate = getCurrentDate(),
			nowTime = DateUtil.getTimeMillis(DateUtil.getCurrentTimeStr());
			if ((nowDate == currentDate && isPublish)) {

				//alert("已发布的直播频道只能修改当天以后的节目单");
				return false;
			}
			if ((nowDate.replace("-", "") > currentDate.replace("-", ""))) {
				//alert("不能修改当天以前的节目单");
				return false;
			}
			if ((nowDate.replace("-", "") == currentDate.replace("-", "")) && (endTimeMillis < nowTime)) {
				//alert("只能修改当前时间以后的节目单");
				return false;
			}

			return true;
	}

	function addOrEditSaveActList(){
		if (($('div.itembox').length == 0 && (ActItem.delIDs.length == 0))
				|| (ActItem.editFlag == false && ActItem.isNewAct == false)) {
			Dialog.alert('节目单未作修改');
			return false;
		} else {
			if ($('input.empty').length > 0) {
				Dialog.alert("节目单信息未编辑完成，请完成后再保存");
				return false;
			}
			if (DateUtil.getTimeMillis(
							$("div.itembox")
								.last()
								.find('input[name=endTime]').val())
							< DateUtil.getTimeMillis("23:59:59")) {

				Dialog.confirm("节目单仍有空闲时间，是否保存？", function(){
					ActItem.addOrEditSaveLiveActList(function(){
						ActItem.delMap = {};
						ActItem.delIDs = [];
						ActItem.editFlag = false;
						$('#VActWrapper').html("");
						loadChannelActListById($('a.a-cur').find('input').val());
					});

				}, function(){
					return false;
				});
			} else {
				ActItem.addOrEditSaveLiveActList(function(){
					ActItem.delMap = {};
					ActItem.delIDs = [];
					ActItem.editFlag = false;
					$('#VActWrapper').html("");
					loadChannelActListById($('a.a-cur').find('input').val());
				});

			}
		}
	}

	function copyActList(){
		if (ActItem.editFlag == true) {
			Dialog.alert("当前节目单已作变更，请保存");
			return false;
		} else if ($('div.itembox').length == 0) {
			Dialog.alert("当前日期的节目单为空");
			return;
		} else {
			$('div.copy-date-area').css({opacity: '1'});
			WdatePicker({
				eCont:'copyDateArea',
				onpicked:function(dp){
					var pickedDate = dp.cal.getDateStr();
					var now = new Date();
					var nowStr = now.format("yyyy-MM-dd");
					if(pickedDate <= nowStr){
						MsgPop("只能复制到当前时间以后的节目单");
						return;
					}
					if (pickedDate == getCurrentDate()) {
						Dialog.alert("请选择与当前日期不同的日期");
						return false;
					} else {
						Dialog.confirm('复制操作有可能会覆盖原有的节目单信息，是否继续？', function(){
							var copyFromDate = getCurrentDate();
							var copyToDate = pickedDate;
							var cid = $('a.a-cur')
										.find('input')
										.val();
							var dc = new DataCollection();
							dc.add("copyFromDate", copyFromDate);
							dc.add("copyToDate", copyToDate);
							dc.add("cid", cid);
							Server.sendRequest("com.sobey.scms.channel.ChannelActList.copy", dc, function(response){
								MsgPop(response.Message);
								$('div.copy-date-area').css({opacity: '0'});
							});

						}, function(){
							return false;
						});
					}
				}
			});
		}
	}

	function importActList(){
		var cid = $('a.a-cur').find('input').val(),
			status = $('a.a-cur').attr('status');

		$("#actList").uploadify({
		    'buttonText': '导入节目单',
		    'queueSizeLimit' : 1,
		    'swf'       : '../../Plugin/VideoUploadify/uploadify.swf',
		    'uploader'  : 'ChannelUpload.jsp?cid='+cid+'&siteid='+siteid+'&status='+status,
		    'auto'      : false,
		    'fileDesc'	: '支持格式:xls/xlsx',
		  	'fileExt'	: '*.xls;*.xlsx',
		  	'queueID'	: 'file_queue',
		  	'onUploadSuccess' : function(file, data, response) {
		  		data = eval('(' +data+ ')');
		  		if(data.code == 1){
		  			loadChannelActListById(cid);
			  		Dialog.alert(data.message, function(){
						$("#file_queue").animate({"width":"0px"}, 500);
					});
		  		}else{
		  			Dialog.alert(data.message, function(){
						$("#file_queue").animate({"width":"0px"}, 500);
					});
		  		}
//		  		//处理eval函数兼容性
//		  		if (data.length > 1) {
//		  			data = data.substring(0,1);
//		  		}
//		  		//data = eval(data);
//			  	if(data=="1"){
//			  		loadChannelActListById(cid);
//			  		Dialog.alert("导入成功！", function(){
//			  			$("#file_queue").animate({"width":"0px"}, 500);
//			  		});
//				}else if (data == "0"){
//					Dialog.alert("导入失败！", function(){
//						$("#file_queue").animate({"width":"0px"}, 500);
//					});
//				} else if (data == '2') {
//					Dialog.alert("直播节目单模版中的播放时间衔接不正确，请修改后重新导入！", function(){
//						$("#file_queue").animate({"width":"0px"}, 500);
//					});
//				}
			},

			'onSelect' : function(file) {
				var name = file.name;
				var ext = name.substring(name.lastIndexOf(".")+1);
				if(ext!="xls" && ext!="xlsx"){
					Dialog.alert("对不起，您要导入的文件格式不对，目前仅支持xls,xlsx两种格式！");
					$('#actList').uploadify("cancel","*");
					return;
				}
				$("#file_queue").animate({"width":"370px"},2000);
				if (status == '1') {
					Dialog.confirm("该直播频道是已发布频道,是否继续?", function(){
						$("#actList").uploadify('upload', '*');
					}, function(){
						$('#actList').uploadify("cancel","*");
					});
				} else {
					$("#actList").uploadify('upload', '*');
				}
			}
		});
	}

	function cancelUpload(){
		$('#actList').uploadify("cancel","*");
		$("#file_queue").animate({"width":"0px"},2000);
	}

	function closeAndLoadDG(){
		$D.close('Diag2', function(){
			jQuery("body").css("overflow-y","auto");
			dg1.loadData();
		});
	}
})(window.jQuery);