(function($){
	$(function(){
		$("#createChannel").on('click', function(){
			//var ctype = jQuery('#hiddenType').val();
			//(ctype);
			//console.log(type);
			addLiveChannel();
		});
		
		$("#mainArea").on("click", "#editBtn", function() {
			var _this = $(this),
				_td = _this.parents("td"),
				_status = _td.find("#startRecord").attr("status");
			
			if (_status != 0) {
				Dialog.alert("该频道处于录制中，请停止并退出后操作");
				return;
			}
			editLiveChannel();
		}).on("click", "#delBtn", function() {
			var _this = $(this),
				_td = _this.parents("td"),
				_status = _td.find("#startRecord").attr("status");
			
			if (_status == 0) {
				Dialog.confirm("是否要删除该直播频道?", function(){
					delChannel();
				});
				
			} else {
				Dialog.alert("该频道处于录制中，请停止并退出后操作");
				return;
			}
			
		}).on("click", "#startRecord", function() {
			var _this = $(this),
				status = _this.attr("status");
			
			if (status != 0) {
				Dialog.alert("直播录制正在进行中，请稍后再试");
				return;
			}
			var dc = new DataCollection(),
				id = dg1.gridBody.getSelectedRowsData().join();
			
			dc.add("id", id);
			Server.sendRequest("com.sobey.scms.devicechannel.DeviceChannelLib.getStreamUrlById", dc, function(response) {
				if (response.Status == 1) {
					if (status == 0) {
						_this.attr("status", 1).parents("td").siblings("td.recordstatus").html("准备录制");
						updateStatus(1, function() {
							startRecording(response.Message);
						});
					}
				} else {
					Dialog.alert("该直播频道未配置直播流地址，请配置后再操作");
				}
			});
			
		}).on("click", "#changeStatus", function() {
			var _this = $(this),
			    status = _this.attr("status");
			
			changeStatus(status);
		}).on("click", "#getPlayerCode", function() {
			var _this = $(this),
				id = _this.attr("cid");
			
			getPlayerCode(id);
		}).on("click", "#preview", function() {
			var _this = $(this),
				id = _this.attr("cid");
			
			preview(id);
		});
	});
	
	function addLiveChannel(){
		$("body").css("overflow-y","hidden");
		window.isEdit = false;
		var diag = new Dialog("Diag2");
		diag.Width = calWidth();
		var eleMent = document.all ? "body" : window;
		diag.Height = jQuery(eleMent).height()-2;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "新建设备直播频道";
		diag.URL = "DeviceChannelLibDialog.jsp?flag=0&type=" + type;
		diag.onLoad = function(){				
			$('div.config-item').find('input[name=formatType]').on('keyup', function(e){
				var _this = $(this);
				var value = _this.val();
				var patrn=/^[0-9]{1,20}$/; 
				if (!patrn.exec(value)){
					var newvalue = value.replace(/[^0-9]/ig,"");
					if(newvalue==""){
					}
					_this.val(newvalue);
				} 
			});
		};
		diag.show();
	}
	
	function editLiveChannel() {
		var arr = dg1.gridBody.getSelectedRowsData();
		$("body").css("overflow-y","hidden");
		window.isEdit = true;
		var diag = new Dialog("Diag2");
		diag.Width = calWidth();
		var eleMent = document.all ? "body" : window;
		diag.Height = jQuery(eleMent).height()-2;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "编辑设备直播频道";
		diag.URL = "DeviceChannelLibDialog.jsp?flag=1&id="+arr.join();
		diag.onLoad = function(){
			$('div.config-item').find('input[name=formatType]').on('keyup', function(e){
				var _this = $(this);
				var value = _this.val();
				var patrn=/^[0-9]{1,20}$/; 
				if (!patrn.exec(value)){
					var newvalue = value.replace(/[^0-9]/ig,"");
					if(newvalue==""){
					}
					_this.val(newvalue);
				} 
			});
		};
		diag.show();
	}
	
	function delChannel() {
		var arr = dg1.gridBody.getSelectedRowsData(),
			dc = new DataCollection();
		
		dc.add("id", arr.join());
		
		Server.sendRequest("com.sobey.scms.devicechannel.DeviceChannelLib.delete", dc, function(response) {
			MsgPop(response.Message, function() {
				dg1.loadData();
			});
		});
	}
	
	function startRecording(streamUrl) {
		var arr = dg1.gridBody.getSelectedRowsData();
		
		$("body").css("overflow-y","hidden");
		window.isEdit = true;
		var diag = new Dialog("Diag2");
		diag.Width = calWidth();
		var eleMent = document.all ? "body" : window;
		diag.Height = jQuery(eleMent).height()-2;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "编辑设备直播频道";
		diag.URL = "DeviceLiveRecording.jsp?id="+arr.join()+"&streamUrl="+streamUrl;
		diag.onLoad = function(){
		};
		diag.show();
	}
	
	//更新录制状态
	function updateStatus(status, func) {
		var dc = new DataCollection(),
			id = dg1.gridBody.getSelectedRowsData().join();
		
		dc.add("id", id);
		dc.add("status", status);
		Server.sendRequest("com.sobey.scms.devicechannel.DeviceChannelLib.updateStatusById", dc, func);
	}
	
	function changeStatus(status) {
		var arr = dg1.gridBody.getSelectedRowsData();
		var diag = new Dialog("Diag1");
		diag.Width = 500;
		diag.Height = 300;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = false;
		diag.Title = "变更状态";
		diag.URL = "DeviceChangeStatus.jsp?id="+arr.join()+"&status="+status;
		diag.onLoad = function(){
		};
		diag.show();
	}
	
	function getPlayerCode(cid){
		var diag = new Dialog("Diag1");		
		diag.Width = 700;
		diag.Height = 422;
		diag.Title = "设备直播播放器代码";
		diag.URL = "../../VideoModule/Default/PlayerCode.jsp?contentId="+cid+"&mediaType=17";
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = false;
		diag.onLoad = function(){};
		diag.show();
	}
	
	function preview(id) {
		window.open("../../VideoModule/Default/PlayerPreview.jsp?mediaType=17&contentId="+id);
	}
})(window.jQuery);
