var DateUtil = {};

DateUtil.getTimeMillis = function(timeStr) {
	if(timeStr){
		var idx = timeStr.indexOf(":");
		var hourMillis, minuteMillis, secondMillis, totalMillis = 0;
		var timeArray = [];
		var i = 0;
		
		while (idx != -1) {
			timeArray[i] = timeStr.substring(0, idx);
			timeStr = timeStr.substring(idx + 1);
			idx = timeStr.indexOf(":");
			i++;
			if (idx == -1) {
				timeArray[i] = timeStr;
			}
		}
		
		if (timeArray.length > 0) {
			hourMillis = parseInt(timeArray[0], 10) * 3600000;
			minuteMillis = parseInt(timeArray[1], 10) * 60000;
			secondMillis = parseInt(timeArray[2], 10) * 1000;
			totalMillis = hourMillis + minuteMillis + secondMillis;
		}
		return totalMillis;
	}
}

DateUtil.getTimeStr = function(second) {
	var timeStr = "";
	var hourStr = "00", minuteStr = "00", secondStr = "00";

	if (second >= (60 * 60)) {
		var hour = second / (60 * 60);
		second = second % 3600;
		hourStr = parseInt(hour, 10) + "";
		
		if(hourStr.length == 1){
			hourStr = "0" + hourStr;
		}
	} 
	if (second >= 60) {
		
		minuteStr = parseInt(second / 60, 10) + "";
		if(minuteStr.length == 1) {
			minuteStr = "0" + minuteStr;
		}
		second = second % 60 + "";
	} 
	if (second < 60){
		secondStr = parseInt(second, 10) + "";
		if(secondStr.length == 1 ){
			secondStr = "0" + secondStr ;
		}
	}
	timeStr += hourStr + ":" + minuteStr + ":" + secondStr;
	return timeStr;

}

DateUtil.getCurrentTimeMillis = function(){
	return DateUtil.getTimeMillis(DateUtil.getCurrentTimeStr());
}

DateUtil.getCurrentTimeStr = function() {
	var currentDate = new Date(),
		hours = currentDate.getHours() + "",
		minutes = currentDate.getMinutes() + "",
		seconds = currentDate.getSeconds() + "";
	
	hours = (hours.length == 2) ? hours : '0' + hours;
	minutes = (minutes.length == 2) ? minutes : '0' + minutes;
	seconds = (seconds.length == 2) ? seconds : '0' + seconds;
	
	return (hours + ":" + minutes + ":" + seconds);
}

DateUtil.getCurrentDate = function(){
	var currentDate = new Date(),
		currentYear = currentDate.getFullYear(),
		currentMonth = currentDate.getMonth() + 1,
		currentDay = currentDate.getDate();
	
	currentMonth = ((currentMonth + "").length < 2) 
			? "0" + currentMonth 
			: currentMonth;
	currentDay = ((currentDay + "").length < 2) 
			? "0" + currentDay 
			: currentDay;
	
	return currentYear + "-" + currentMonth + "-" + currentDay;
}

DateUtil.getCurrentDateTime = function(){
	return (DateUtil.getCurrentDate() + " " + DateUtil.getCurrentTimeStr());
}