var wideCatelogId = 0;
(function($){
	var currentPrevTR, currentNextTR, x, y, isNewWeekPlan = true, 
		isWeekPlanEdit = false, 
		delWeekPlanMap = {
			weekday_0: [],
			weekday_1: [],
			weekday_2: [],
			weekday_3: [],
			weekday_4: [],
			weekday_5: [],
			weekday_6: []
		};
	$(function(){
		var nowdate= DateUtil.getCurrentDate();
		WdatePicker({
			startDate:nowdate,
			alwaysUseStartDate:true,
			eCont:'dateArea',
			onpicked:function(dp){
				var pickedDate = dp.cal.getDateStr();
				if (pickedDate != $('span.vdate-info').html()) {
					if (($('div.itembox').length > 0 && ActItem.isNewAct == true)
							|| ActItem.editFlag == true) {
						Dialog.alert("当前节目单已作变更，请保存");
					} else {
						$('#VActWrapper').html("");
						$('span.vdate-info').html(pickedDate);
						loadActList(currentVID, pickedDate , false);
					}
				}
			}
		});
		loadChannelInfo();
		checkAddOrEdit();
		$("#VActWrapper").on('mouseover mouseout', 'div.itembox,p.spared_item', function(event){
			event.preventDefault();
			var _this = $(this);
			
			if (event.type == 'mouseover') {
				_this.addClass("hoverClass");
			} else if (event.type == 'mouseout') {
				_this.removeClass('hoverClass');
			}
		}).on('click.ActItem.event.add', 'span.insert_span,p.spared_item', function(event){
			var item = new ActItem(this.className == 'insert_span' 
						? this.parentNode 
						: this, {operation: 'Insert'});
			item.show();
			return false;
		}).on('click.ActItem.event.del', 'span.del_span', function(event) {
			ActItem.prototype.delVLiveItem.call(this.parentNode);
			return false;
		}).on('click.ActItem.event.addSource', 'div.source_add', function(event){
			var sourceWrapper = $("div.source_wrapper");
			
			if (sourceWrapper.find("div.src_content")
							 .attr("isLoaded") == 'false') {
				initSourceItems(this.parentNode);
				return false;
			} else if (sourceWrapper
						.find("div.src_content")
						.attr("isLoaded") == 'true') {
				if ($(this.parentNode).next().attr("id") == sourceWrapper.attr("id")) {
					sourceWrapper
								.insertAfter($("#VActAddSpan"))
								.addClass("hide");
				} else{
					if (sourceWrapper.hasClass("hide")) {
						sourceWrapper.removeClass("hide");
					}
					sourceWrapper.insertAfter($(this.parentNode));
				}
				
				return false;
			}
				
		}).on('click.ActItem.event.addAct', 'a.live_link,a.video_link', function(){
			
			var _this = $(this);
			var target = _this.parents('div.source_wrapper').prev();
			if (_this.hasClass('live_link')) {
				target	
					.find('span.source_info')
					.attr('title', _this.find('span').attr("title"))
					.text(_this.find('span').attr("title").length > 10 ? 
							_this.find('span').attr("title").substring(0,10)+"...":
								_this.find('span').attr("title"));
				target	
					.find('span.source_type')
					.text('直播');
				target
					.find('#cid')
					.val(_this.attr('id'));
				target
					.find('#type')
					.val('0');
				ActItem.setFlag();
				target.removeAttr("title");
				target.removeAttr("style");
			} else if (_this.hasClass('video_link')) {
				checkAddVideoSource(target, _this);
			}
			//$('div.source_add').trigger('click');
			_this.parents('#SourceWrapper').prev().find('div.source_add').trigger('click');
		}).on('blur.ActItem.event.editActTime', 'input[name=startTime],input[name=endTime]', function(){
			var _this = $(this);
			var name = _this.attr('name');
			
			if (name == 'startTime') {
				//checkStartTime(_this);
			} else if (name == 'endTime') {
			
				checkEndTime(_this);
			}
		});
		
		$("img.back").on('click', function(e){
			e.stopPropagation();
			if (($('div.itembox').length > 0 && ActItem.isNewAct == true)
					|| ActItem.editFlag == true) {
				Dialog.confirm("节目单已作变更，是否保存？", function(){
					if (ActItem.isNewAct == true) {
						ActItem.addSaveActList(currentVID, function(){
							closeAndLoadDG();
						});
					} else if (ActItem.editFlag == true) {
						ActItem.editSaveActList(currentVID, function(){
							ActItem.delMap = {};
							ActItem.delIDs = [];
							ActItem.editFlag = false;
							closeAndLoadDG();
						});
						
					}
				}, function(){
					closeAndLoadDG();
				});
			} else if (isWeekPlanEdit == true || isWeekPlanEdit == true) {
				Dialog.confirm("串联单计划已作变更，是否保存？", function(){
					addOrEditSaveWeekPlan(function(){
						closeAndLoadDG();
					});
				}, function(){
					closeAndLoadDG();
				});
			} else {
				closeAndLoadDG();
			}
		});
		
		$('#Submitbutton').on('click', function(e){
			e.stopPropagation();
			var _dropdown = $("div.dropdown-wrapper").children("div.show");
			var catalogid = 0;
			var name = $('div.cat-search').find('input[name=Name]').val();
			var _spanCurrent = _dropdown.find('span.cat_current');
			var _aCurrent = _dropdown.find('a.cat_current');
			
			if (_spanCurrent.length > 0) {
				catalogid = _spanCurrent.attr('id');
			} else if (_aCurrent.length > 0) {
				catalogid = _aCurrent.hasClass('collapsed') 
						? _aCurrent.parent().parent().attr('id') 
						: _aCurrent.parent().attr('id'); 
			}
			
			getVideosByCatalogIDAndName(catalogid, name);
			
		});
		
		jQuery("#add_div").click(function(){
			var item = new ActItem();
			item.show();
		});
		jQuery("li.title_li").on("mouseover mouseout click", function(event){
			event.preventDefault();
			var _this = jQuery(this);
			
			if (event.type == 'mouseover') {
				_this.addClass('cur');	
			} else if (event.type == 'mouseout') {
				if (_this.attr("type") == '0') {
					if (jQuery("#live_source").hasClass("hide")) {
						_this.removeClass('cur');
					} else {
						return false;
					}
				} else if (_this.attr("type") == '1') {
					if (jQuery("#video_source").hasClass("hide")) {
						_this.removeClass('cur');
					} else {
						return false;
					}
				}
				
			} else if (event.type == 'click') {
				var liveSource = jQuery("#live_source");
				var videoSource = jQuery("#video_source");
				
				if (_this.attr("type") == "0") {
					if (!_this.hasClass('cur')) {
						_this.addClass('cur');
					}
					if (liveSource.hasClass("hide")) {
						liveSource.removeClass("hide");
					}
					if (!videoSource.hasClass("hide")) {
						videoSource.addClass("hide");
					}
					_this.next().removeClass("cur");
				} else if (_this.attr("type") == "1") {
					if (!_this.hasClass('cur')) {
						_this.addClass('cur');
					}
					if (videoSource.hasClass("hide")) {
						videoSource.removeClass("hide");
					}
					if (!liveSource.hasClass("hide")) {
						liveSource.addClass("hide");
						liveSource.removeClass("cur");
					}
					_this.prev().removeClass("cur");
				}
			}
		});
		jQuery(".accordion_link").click(function(){
			jQuery("#dropwrapper").slideToggle();
		});
		jQuery("#dropwrapper").on("mouseover mouseout click", "a.cat_link,a.jump,span.cat_parent,a.backup", function(event) {
			event.preventDefault();
			var _this = jQuery(this);
			
			if (event.type == 'mouseover') {
				(_this.hasClass('jump')) 
							? _this.addClass("jump-hover") 
							: _this.addClass("hoverClass");  
			} else if (event.type == 'mouseout') {
				(_this.hasClass('jump')) 
						? _this.removeClass("jump-hover") 
						: _this.removeClass("hoverClass");  

			} else if (event.type == 'click') {
				if (_this.hasClass('cat_link') || _this.hasClass('cat_parent')) {
					if (!_this.hasClass('cat_current')) {
						var catalogid = _this.hasClass('cat_parent') 
									? _this.attr('id') 
									: (_this.parent().hasClass('cat_item') 
											? _this.parent().attr("id") 
											: _this.parent().parent().attr("id"));
						_this.parents('div.dropdown-menu')
										.find(".cat_current")
										.removeClass("cat_current");
						_this.addClass("cat_current");
						$('a.accordion_link').html(_this.text() + "<b class='caret'></b>");
						wideCatelogId = catalogid;
						getVideosByCatalogID(catalogid);
					}
				} else if (_this.hasClass("jump")) {
					var pid = _this.parent().parent().attr("id");
					var wrapper = jQuery("#wrap"+pid+"");
					
					if (wrapper && wrapper.length > 0) {
						animateWrapper(_this);
					} else {
						getCatalogsByParentID(pid, _this);
					}
				} else if (_this.hasClass('backup')) {
					var previd = _this.attr('previd');
					_this
						.parents('div.dropdown-menu')
						.removeClass("show")
						.addClass("hide");
					jQuery("#wrap"+previd+"")
							.removeClass("hide")
							.addClass("show")
							.find("#"+_this.parent().attr('id')+"")
							.find("a.cat_link")
							.removeClass('cat_current')
							.trigger('click');
				}
				$("a.accordion_link").trigger('click');	
			}
		});
		jQuery("ul.live-items").on("mouseover mouseout", "li.live_li", function(event){
			event.preventDefault();
			var _this = jQuery(this);
			
			if (event.type == 'mouseover') {
				 _this.addClass("live_li_hover"); 
			} else if (event.type == 'mouseout') {
				 _this.removeClass("live_li_hover");  

			}
		});
		jQuery("ul.video-items").on("mouseover mouseout", "a.video_link", function(event){
			event.preventDefault();
			var _this = jQuery(this);
			
			if (event.type == 'mouseover') {
				 _this.addClass("video_link_hover"); 
			} else if (event.type == 'mouseout') {
				 _this.removeClass("video_link_hover");  

			}
		});
		$("#editSave").on('click', function(){
			if (($('div.itembox').length == 0 && (ActItem.delIDs.length == 0)) 
					|| (ActItem.editFlag == false && ActItem.isNewAct == false)) {
				Dialog.alert('节目单未作修改');
				return false;
			} else {
				
				if ($('spared_item').length > 0 
						|| DateUtil.getTimeMillis(
								$("div.itembox")
									.last()
									.find('input[name=endTime]').val()) 
								< DateUtil.getTimeMillis("23:59:59")) {
					
					Dialog.confirm("节目单仍有空闲时间，是否保存？", function(){
						if (ActItem.isNewAct == true) {
							ActItem.addSaveActList(currentVID, function(){
								$("#VActWrapper").html("");
								loadActList(currentVID, $('span.vdate-info').html() , false);
								ActItem.isNewAct = false;
								ActItem.editFlag = false;
							});
						} else {
							ActItem.editSaveActList(currentVID, function(){
								$("#VActWrapper").html("");
								loadActList(currentVID, $('span.vdate-info').html() , false);
								ActItem.delMap = {};
								ActItem.delIDs = [];
								ActItem.editFlag = false;
							});
							
						}
					}, function(){
						return false;
					});
				}else{
					
					Dialog.confirm("当前已无节目单信息，是否保存？", function(){
						ActItem.editSaveActList(currentVID, function(){
							$("#VActWrapper").html("");
							loadActList(currentVID, $('span.vdate-info').html() , false);
							ActItem.delMap = {};
							ActItem.delIDs = [];
							ActItem.editFlag = false;
						});
					}, function(){
						return false;
					});
				}
			}
		});
		$('#copy').on('click', function(){
			if (ActItem.editFlag == true) {
				Dialog.alert("当前节目单已作变更，请保存");
				return false;
			} else if ($('div.itembox').length == 0) {
				Dialog.alert("当前日期的节目单为空");
				return;
			} else {
				$('div.copy-date-area').css({opacity: '1'});
				WdatePicker({
					eCont:'copyDateArea',
					onpicked:function(dp){
						var pickedDate = dp.cal.getDateStr();
						if (pickedDate == $('span.vdate-info').html()) {
							Dialog.alert("请选择与当前日期不同的日期");
							return false;
						} else {
							Dialog.confirm('复制操作有可能会覆盖原有的节目单信息，是否继续？', function(){
								var copyFromDate = $('span.vdate-info').html();
								var copyToDate = pickedDate;
								var dc = new DataCollection();
								dc.add("copyFromDate", copyFromDate);
								dc.add("copyToDate", copyToDate);
								dc.add("vid", currentVID);
								Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.copy", dc, function(response){
									MsgPop(response.Message);
									$('div.copy-date-area').css({opacity: '0'});
								});
								
							}, function(){
								return false;
							});
						}
					}
				});
			}
		});
		$('div.act-switch ul.qieHuanBt').on('click', 'li.m1,li.m2', function(e){
			e.preventDefault();
			
			if (ActItem.editFlag == true) {
				Dialog.alert("当前节目单已作变更，请保存");
				return false;
			}
			var _this = $(this);
			var _singleList = $('div.single-actlist');
			var _multiList = $('div.multiple-actlist');
			var _saveWeekPlan = $('#saveVactWeekPlan');
			
			if (_this.hasClass('m1')) {
				if (_singleList.hasClass('hide')) {
					$('div.act-switch span.on').removeClass('on');
					_this.find('span').addClass('on');
					_multiList.animate({opacity: '0'}, 500, function(){
						_singleList.removeClass('hide').animate({opacity: '1'}, 500);
						
					}).addClass('hide');
					_saveWeekPlan.addClass('hide');
				} 
			} else {
				setDateTimeStyles();
				if (_multiList.hasClass('hide')) {
					$('div.act-switch span.on').removeClass('on');
					_this.find('span').addClass('on');
					_singleList.animate({opacity: '0'}, 500, function(){
						if (isNewWeekPlan == true) {
							loadVactWeekPlan();
						}
						_multiList.removeClass('hide').animate({opacity: '1'}, 500);
						$.Move($("div.c_zhoudanFloatBox"));
						_saveWeekPlan.removeClass('hide');
					}).addClass('hide');
				}
			}
		});
		
		
		$(".c_zhoudanFloatBox").on('click', 'a.live_link,a.video_link', function(e){
			e.preventDefault();
			var _this = $(this);
			var target = _this.parents('div.source_wrapper').prev().prev();
			var checkedBox = $("div.c_zhoudanFloatBox").find("div.second").find("input[type=checkbox]:checked");
			
			if (_this.hasClass('live_link')) {
				var sourceDiv = target.find('#source_div');
				sourceDiv
					.find('em')
					.text('直播');
				sourceDiv
					.find('span')
					.attr("title",_this.find('span').attr("title"))
					.text(_this.find('span').attr("title").length > 17 ? 
							_this.find('span').attr("title").substring(0,17)+"...":
								_this.find('span').attr("title"));
				target
					.find('#cid')
					.val(_this.attr('id'));
				target
					.find('#type')
					.val('0');	
				
			} else if (_this.hasClass('video_link')) {
				getAddedVideoSource(target, _this);
			}
			
			if (checkedBox.length > 0) {
				checkedBox.trigger("click").attr("checked", "checked");
			}
		});
		//.on('focusin focusout', 'input[name=startTime],input[name=endTime]', function(e){
			/*e.preventDefault();
			
			var _this = $(this);
			if (e.type == 'focusin') {
				if (_this.hasClass('Wdate')) {
					return false;
				} else {
					WdatePicker({skin:'whyGreen',dateFmt:'HH:mm:ss',onpicked:function(dp){
						alert(dp.cal.getDateStr());
					}});
					$(this).addClass("Wdate");
				}
				
			}
			
			*/
//		});
		
		$(".c_chuanlianbianjiBox table td").live({
			mouseenter:function(){
				if($(this).attr("isblank")=="false"){
					$(this).find("a").text("点击修改");
				}else{
					$(this).find("a").text("点击添加");
				}
				$(this).addClass("hover").children(".add").show().siblings().hide();
			},
			mouseleave:function(){
				$(this).removeClass("hover").children(".add").hide().siblings().show();
			}
		});
		$(".add").live("click",function(){
			var _this = $(this);
			var sibling = _this.siblings('div');
			var floatBox = $(".c_zhoudanFloatBox");
			var _currentTR = _this.parent().parent();
			var _currentTD = _this.parent();
			x=_currentTD.index();
			y=_currentTR.index();
			if (sibling.length > 0) {
				var vid = getVactID(sibling.attr('id'));
				var startTime = sibling.find('input[name=startTime]').val();
				var endTime = sibling.find('input[name=endTime]').val();
				var cid = sibling.find('input[name=cid]').val();
				var type = sibling.find('input[name=type]').val();
				var programlength = sibling.find('input[name=programlength]').val();
				var content = sibling.find('p').html();
				var source_div = floatBox.find('#source_div');
				
				floatBox.find('input[name=startTime]').val(startTime);
				floatBox.find('input[name=endTime]').val(endTime);
				floatBox.find('input[name=st_time]').val(startTime);
				floatBox.find('input[name=ed_time]').val(endTime);
				floatBox.find('input[name=cid]').val(cid);
				floatBox.find('input[name=type]').val(type);
				floatBox.find('input[name=programlength]').val(programlength);
				floatBox.find('input[name=vid]').val(vid);
				source_div.find('em').html((type == '0' ? '直播' : '视频'));
				source_div.find('span').html(content);
			} else {
				var prevTR;
				var eTime;
				do {
					prevTR = _currentTR.prev();
					
					if (prevTR.hasClass('weekdays')) {
						eTime = "00:00:00";
						break;
					} else {
						var prevTD = prevTR.find("td:eq("+x+")");
						var _div = prevTD.find('div');
						
						if (_div.length > 0) {
							eTime = _div.find('input[name=endTime]').val();
							break;
						}
					}
					_currentTR = prevTR;
				} while(typeof prevTR != 'undefined' && prevTR.length > 0);
				floatBox.find('input[name=startTime]').val(eTime);
				floatBox.find('input[name=st_time]').val(eTime);
			}
			var zuobiao=_this.offset();
			var l=zuobiao.left-86;
			if(l+floatBox.width() > $(".c_chuanlianbianjiBox table").offset().left+$(".c_chuanlianbianjiBox table").width())l=$(".c_chuanlianbianjiBox table").offset().left+$(".c_chuanlianbianjiBox table").width()-$(".c_zhoudanFloatBox").width()-20;
			floatBox.css({
				left:l,
				top:zuobiao.top+20
			}).show().find('div.second').find("input[type=checkbox]:eq("+(x+1)+")").attr("checked", "checked");
		});
		$(".allCheck").click(function(){
			var floatBox = $('.c_zhoudanFloatBox');
			if($(this).is(":checked")){
				floatBox
					.find('input[type=checkbox]:gt(0)')
					.attr('checked', 'checked')	
					.trigger('click')
					.attr('checked', 'checked');
			}else{
				floatBox
					.find('input[type=checkbox]:gt(0)')
					.removeAttr('checked')
					.trigger('click')
					.removeAttr('checked');
			}
		});
		
		/*$(".c_zhoudanFloatBox").focusout(function(e){
			e.preventDefault();
			
			var floatBox = $(this);
			
		});*/
		
		$("div.multiple-actlist").on("click", function(e){
			var target = $(e.target);
			var floatBox = $("div.c_zhoudanFloatBox");
			if (target && (target.attr('class') != 'add' || target.parent().attr('class') != 'add') 
					&& target.attr('class') != floatBox.attr("class") 
					&& (target.parents('div.c_zhoudanFloatBox').length == 0)
					&& floatBox.css("display") == "block") {
				var source_div = floatBox.find('#source_div');
				floatBox.find('input[name=startTime]').val("");
				floatBox.find('input[name=endTime]').val("");
				floatBox.find('input[name=st_time]').val("");
				floatBox.find('input[name=ed_time]').val("");
				floatBox.find('input[name=cid]').val("");
				floatBox.find('input[name=programlength]').val("");
				floatBox.find('input[name=type]').val("");
				floatBox.find('input[name=vid]').val("");
				floatBox.find('input[type=checkbox]').removeAttr('checked');
				source_div.find('em').html('直播');
				source_div.find('span').html('');
				floatBox.hide();
			}
		});
		
		$(".c_zhoudanFloatBox .closeBt").click(function(){
			var floatBox = $(".c_zhoudanFloatBox");
			var checkedBox = floatBox.find('input[type=checkbox]:checked').removeAttr("checked");
			if (checkedBox.length > 0) {
				checkedBox.trigger("click").removeAttr("checked");
			}
			
			checkedBox.attr("checked","checked");
			
		});
		
		$(".c_zhoudanFloatBox>.second>input[type='checkbox']:gt(0)").on('click', function(e){
			var editBox = $(".c_chuanlianbianjiBox");
			var table=editBox.find("table");
			var index=$(this).next().attr("xinqi");
			var currentTR = table.find("tr").eq(y);
			var tds = currentTR.children();
			var currentTD = tds.eq(index);
			var prevTR = currentTR.prev();
			var nextTR = currentTR.next();
			currentPrevTR = prevTR;
			currentNextTR = nextTR;
			if($(this).is(":checked")){
				var infoBox=$('.c_zhoudanFloatBox').find('div.first');
				var start=infoBox.find("input:first").val();
				var end=infoBox.find("input:last").val();
				var dst=infoBox.find("div.fl>span").text();
				var cid=infoBox.find('input[name=cid]').val();
				var vid=infoBox.find('input[name=vid]').val() || "";
				if (cid.length == 0) {
					Dialog.alert('节目单信息未填写完整');
					return;
				}
				if(start.length == 0){
					Dialog.alert('请先填写节目开始时间！');
					return;
				}if( end.length == 0){
					Dialog.alert('请先填写节目结束时间！');
					return;
				}
				var programlength=DateUtil.getTimeMillis(end)-DateUtil.getTimeMillis(start);
				var type=infoBox.find('input[name=type]').val();
				var currentStartTime = DateUtil.getTimeMillis(start);
				var currentEndTime = DateUtil.getTimeMillis(end);
				if (compareWithPrevObjs(currentStartTime, currentTR, prevTR, index) == false) {
					return;
				}
				if (compareWithNextObjs(currentEndTime, currentTR, nextTR, index) == false) {
					return;
				}
				var currentDiv = currentTD.find('div');
				
				if (currentDiv.length > 0) {
					var id = getVactID(currentDiv.attr('id'));
					
					if (id.length > 0) {
						vid = id;
					} else {
						vid = "";
					}
				} else {
					vid = "";
				}
				var html='<a href="javascript:void(0);" class="add">点击添加</a>'
					  + " <div id='vact_"+vid+"' class='vact-week-plan'>"+start+"-"+end+"<p>"+dst+"</p>"
					  + "   <input type='hidden' name='startTime' id='startTime' value='"+start+"'/>"
					  + "   <input type='hidden' name='endTime' id='endTime' value='"+end+"'/>"
					  + "   <input type='hidden' name='cid' id='cid' value='"+cid+"'/>"
					  + "   <input type='hidden' name='programlength' id='programlength' value='"+programlength+"'/>"
					  + "   <input type='hidden' name='type' id='type' value='"+type+"'/></div>";
				currentTD
					.attr('isBlank', 'false')
					.html(html);
				isWeekPlanEdit = true;
			}else{
				var currentDiv = currentTD.find('div');
				
				if (currentDiv.length > 0) {
					var vid = getVactID(currentDiv.attr('id'));
					
					if (vid && vid.length > 0) {
						isWeekPlanEdit = true;
						delWeekPlanMap['weekday_'+index].push(vid);
					}
				}
				currentTD
					.attr('isBlank', 'true')
					.html('<a href="javascript:void(0);" class="add">点击添加</a>');
				if (currentTR.find('td[isBlank=true]').length == 7) {
					if (typeof prevTR != 'undefined' && prevTR.length > 0 
							&& prevTR.find('td[isBlank=true]').length == 7) {
						prevTR.remove();
						y = currentTR.index();
					}
					if (typeof nextTR != 'undefined' && nextTR.length > 0 
							&& nextTR.find('td[isBlank=true]').length == 7) {
						nextTR.remove();
					}
				}
			}
			//reloadWeekByJs();
		});
		$('#source_div').on('click', function(e){
			e.preventDefault();
			var sourceWrapper = $("div.source_wrapper");
			var _second = $('div.second');
			
			if (_second.next().attr('id') == sourceWrapper.attr('id')
					&& !sourceWrapper.hasClass('hide')) {
				sourceWrapper
					.insertAfter($("#VActAddSpan"))
					.addClass("hide");
			} else if (sourceWrapper.find("div.src_content")
							 .attr("isLoaded") == 'false') {
				initSourceItems(_second);
			} else {
				$('div.source_wrapper')
							.removeClass('hide')
							.appendTo('div.c_zhoudanFloatBox');
			}
		});
		$('#saveVactWeekPlan').on('click', function(e){
			e.preventDefault();
			if (isNewWeekPlan == true 
					|| (isNewWeekPlan == false && isWeekPlanEdit == true)) {
				addOrEditSaveWeekPlan();
			}
		});
		
	});
	
	
	
	function cloneAndinsertBeforeTR(tr, index) {
		var cloneTr = tr.clone();
		cloneTr
			.find("td")
			.attr('isBlank', 'true')
			.html('<a href="javascript:void(0);" class="add">点击添加</a>');
		//cloneTr.find('td').eq(index).attr('isBlank', 'true');
		tr.before(cloneTr);
		
		return tr.prev();
	}
	
	function cloneAndinsertAfterTR(tr, index) {
		var cloneTr = tr.clone();
		cloneTr
			.find("td")
			.attr('isBlank', 'true')
			.html('<a href="javascript:void(0);" class="add">点击添加</a>');
		//cloneTr.find('td').eq(index).attr('isBlank', 'true');
		tr.after(cloneTr);
		
		return tr.next();
	}
	
	function compareWithPrevObjs(currentStartTime, currentTR, prevTR, index){
		if (prevTR.hasClass('weekdays')) {
			if (currentStartTime != 0) {
				if (prevTR.index() == (currentTR.index() - 1)) {
					cloneAndinsertBeforeTR(currentTR);
					y = currentTR.index();
				}
			}
		} else {
			var prevTD = prevTR.children().eq(index);
			var prevDIV = prevTD.find('div');
			
			if (prevDIV.length > 0) {
				var prevEndTime = DateUtil.getTimeMillis(
						prevDIV.find('input[name=endTime]').val());
				
				if (currentStartTime < prevEndTime) {
					Dialog.alert('当前节目单开始时间小于上一节目单的结束时间');
					return false;
				} else if (currentStartTime > prevEndTime) {
					if (prevTR.index() == (currentTR.index() - 1)) {
						cloneAndinsertBeforeTR(currentTR);
						y = currentTR.index();
					}
				} 
			} else {
				currentPrevTR = prevTR;
				prevTR = prevTR.prev();
				return	compareWithPrevObjs(currentStartTime, currentTR, prevTR, index);
			}
		}
		
	}
	
	function compareWithNextObjs(currentEndTime, currentTR, nextTR, index) {
		if (typeof nextTR == 'undefined' || nextTR == null || nextTR.length == 0) {
			if (((currentEndTime != DateUtil.getTimeMillis("23:59:59")) 
					&& (currentNextTR.length == 0)) 
					|| ((currentEndTime != DateUtil.getTimeMillis("23:59:59")) 
					&& (currentNextTR.find('td').eq(index).attr('isBlank') == 'false'))) {
				cloneAndinsertAfterTR(currentTR);
			}
		} else {
			var nextTD = nextTR.children().eq(index);
			var nextDIV = nextTD.find('div');
			
			if (nextDIV.length > 0) {
				var nextStartTime = DateUtil.getTimeMillis(
						nextDIV.find('input[name=startTime]').val());
				if (currentEndTime > nextStartTime) {
					Dialog.alert('当前节目单结束时间大于下一节目单的开始时间');
					return false;
				} else if (currentEndTime < nextStartTime) {
					if (nextTR.index() == currentTR.index() + 1) {
						cloneAndinsertAfterTR(currentTR);
					}
				}
			} else {
				currentNextTR = nextTR;
				nextTR = nextTR.next();
			 return	compareWithNextObjs(currentEndTime, currentTR, nextTR, index);
			}
		}
	}
	
	function getAddedVideoSource(target, obj) {
		var sourceDiv = $('#source_div');
		var endTime = DateUtil.getTimeMillis(target.find('input[name=startTime]').val())
				+ DateUtil.getTimeMillis(obj.attr('prolength'));
		endTime = DateUtil.getTimeStr(endTime/1000);
		
		target.find('input[name=endTime]').val(endTime);
		target.find('input[name=ed_time]').val(endTime);
		target.find('#cid').val(obj.attr('id'));
		target.find('#type').val('1');
		target.find('#programlength').val(DateUtil.getTimeMillis(obj.attr('prolength')));
		sourceDiv.find('em').text('视频');
		var title = obj.attr('title').length > 10?obj.attr('title').substring(0,10)+"...":obj.attr('title');
		sourceDiv.find('span').text(title);
	}
	
	function setDateTimeStyles(){
		var _first = $('div.first');
		
		_first.find('img:eq(0)').css({
			'margin-right': '0px',
			'left': '-445px'
		});
		_first.find('img:eq(1)').css({
			'margin-right': '0px',
			'left': '-45px'
		});
	}
	
	function getVactID(vid) {
		if (typeof vid == 'undefined' || vid.length == 0) {
			return "";
		} else {
			var idx = vid.indexOf('_');
			
			if (idx != -1) {
				vid = vid.substring(idx + 1);
				
				if (vid && vid.length > 0) {
					return vid;
				} else {
					return "";
				}
			} 
		}
	}
	
	function addOrEditSaveWeekPlan(){
		var json = "{\"vid\":\""+currentVID+"\",";
		var args = arguments;
		
		$('.c_chuanlianbianjiBox').find('tr:eq(1)').find('td').each(function(index){
			var _this = $(this);
			var weekDay = _this.attr('weekday');
			
			json += getWeekDayItems(weekDay);
			
			if (index < 6) {
				json += ",";
			}
		});
		json += "}";
		var dc = new DataCollection();
		dc.add('weekPlan', json);
		Server.sendRequest('com.sobey.scms.virtualchannel.VirtualChannelActList.saveVactWeekPlan', dc, function(response){
			MsgPop(response.Message);
			loadVactWeekPlan();
			isNewWeekPlan = false;
			isWeekPlanEdit = false;
			if (typeof args[0] == 'function'){
				args[0]();
			}
		});
	}
	
	function getWeekDayItems(weekDay){
		var weekDayItem = "\""+weekDay+"\":[";
		var items = $("td[weekday="+weekDay+"]").find('div.vact-week-plan');
		var isAllDel = (items.length > 0) ? false : true;
		if (isAllDel == false) {
			items.each(function(index){
				var _this = $(this);
				var cflag = 1;
				var id = getVactID(_this.attr('id'));
				
				if (id.length > 0) {
					cflag = 2;
				}
				weekDayItem += "{\"id\":\""+id+"\",\"cflag\":"+cflag+"," 
							  + "\"cid\":\""+(_this.find('input[name=cid]').val())+"\","
							  + "\"type\":\""+(_this.find('input[name=type]').val())+"\","
							  + "\"startTime\":\""+(_this.find('input[name=startTime]').val())+"\","
							  + "\"endTime\":\""+(_this.find('input[name=endTime]').val())+"\","
							  + "\"programlength\":\""+(_this.find('input[name=programlength]').val())+"\","
							  + "\"content\":\""+(_this.find('p').html())+"\","
							  + "\"createName\":\"admin\"}";
				if (index < (items.length - 1)) {
					weekDayItem += ",";
				}
			});
		}
		if (delWeekPlanMap[weekDay].length > 0) {
			if (isAllDel == false) {
				weekDayItem += ",";
			}
			for (var i = 0; i < delWeekPlanMap[weekDay].length; i++) {
				var id = delWeekPlanMap[weekDay][i];
				
				weekDayItem += "{\"id\":\""+id+"\",\"cflag\":3}";
				if (i < delWeekPlanMap[weekDay].length - 1) {
					weekDayItem += ",";
				}
			}
		}
		weekDayItem += "]";
		return weekDayItem;
	}
	
	function loadVactWeekPlan(){
		var dc = new DataCollection();
		dc.add("vid", currentVID);
		Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.getVactWeekPlanByVID", dc, function(response){
			if (response.Status == 0) {
				isNewWeekPlan = true;
			} else {
				var json = eval('(' + response.Message + ')');
				freshWeekDate(json);
			}
		});
	}
	
	
	function reloadWeekByJs(){
		var jsonss = "{";
		$('.c_chuanlianbianjiBox').find('tr:eq(1)').find('td').each(function(index){
			var _this = $(this);
			var weekDay = _this.attr('weekday');
			
			jsonss += getWeekDayItems(weekDay);
			
			if (index < 6) {
				jsonss += ",";
			}
		});
		jsonss += "}";
		var json = eval('(' + jsonss + ')');
		freshWeekDate(json);
	}
	
	
	
	
	function freshWeekDate(Date){

		var json =Date;
		isNewWeekPlan = false;
		var maxLength = 0;
		var maxMap = {};
		var weekDays = [];
		var weekdayMap = {};
		var firstTR = $('.c_chuanlianbianjiBox').find('tr:eq(1)');
		$('.c_chuanlianbianjiBox').find('tr').each(function(index){
			if(index ==1){
				
				firstTR.find('td').each(function(){
					if($(this).attr("isblank")=="false"){
						$(this).attr("isblank","true");
						$(this).find('div').remove();
					}
				});
			}
			if(index>1){
				$(this).remove();
			}
		});
		var finalEndTime = "23:59:59";
		for (var i = 0; i < 7; i++) {
			var key = "weekday_" + i;
			if (typeof json[key] != 'undefined' && json[key].length > 0) {
				var itemLength = json[key].length;
				if (itemLength >= maxLength) {
					maxLength = itemLength;
					maxMap["maxWeekDay"] = key;
				}
				weekDays.push(key);
			}
		}
		
		for (var j = 0; j < maxLength; j++) {
			for (var k = 0; k < weekDays.length; k++) {
				var currentItem = json[weekDays[k]][j];
				if (typeof currentItem != 'undefined' && currentItem != null) {
					var startTime = DateUtil.getTimeMillis(currentItem.startTime);
					var index = getVactID(weekDays[k]);
					var html=" <div id='vact_"+currentItem.id+"' class='vact-week-plan'>"+currentItem.startTime+"-"+currentItem.endTime+"<p>"+currentItem.content+"</p>"
						   + "   <input type='hidden' name='startTime' id='startTime' value='"+currentItem.startTime+"'/>"
						   + "   <input type='hidden' name='endTime' id='endTime' value='"+currentItem.endTime+"'/>"
						   + "   <input type='hidden' name='cid' id='cid' value='"+currentItem.cid+"'/>"
						   + "   <input type='hidden' name='programlength' id='programlength' value='"+currentItem.programlength+"'/>"
						   + "   <input type='hidden' name='type' id='type' value='"+currentItem.type+"'/></div>";
					var currentTD, currentTR;
					
					if (typeof weekdayMap[weekDays[k]] == 'undefined') {
						if (startTime == 0) {
							currentTR = firstTR;
						} else {
							var nextTR = firstTR.next();
							if (typeof nextTR == 'undefined' || nextTR.length == 0) {
								nextTR = cloneAndinsertAfterTR(firstTR);
							}
							currentTR = nextTR;
						}
						  
					} else {
						currentTD = weekdayMap[weekDays[k]];
						currentTR = currentTD.parent();
						var prevEndTime = DateUtil.getTimeMillis(currentTD.find('input[name=endTime]').val());
						var nextTR = currentTR.next();
						
						if (typeof nextTR == 'undefined' || nextTR.length == 0) {
							nextTR = cloneAndinsertAfterTR(currentTR);
						}
						if (startTime > prevEndTime) {
							var nnextTR = nextTR.next();
							if (typeof nnextTR == 'undefined' || nnextTR.length == 0) {
								nnextTR = cloneAndinsertAfterTR(nextTR);
							}
							nextTR = nnextTR;
						}
						currentTR = nextTR;
					}
					if (currentItem.endTime != finalEndTime) {
						if (currentTR.next().length == 0) {
							cloneAndinsertAfterTR(currentTR);
						}
					}
					currentTD = currentTR.find('td').eq(index);
					currentTD
						.attr('isBlank', 'false')
						.append(html);
					weekdayMap[weekDays[k]] = currentTD;
				}
			}
		}
	
	}
	
	function closeAndLoadDG(){
		ActItem.editFlag = false;
		$D.close('Diag2',function(){
			jQuery("body").css("overflow-y","auto");
			dg1.loadData();
		});
	}
	
	function loadChannelInfo(){
		var currentTR = $("input[value="+currentVID+"]").parent().parent();
		var cname = currentTR.find('td:eq(2)').html();
		var date = $('span.date-info').html();
		
		$('span.channel').html(cname);
		$('span.vdate-info').html(date);
	}
})(window.jQuery);

function checkOnpickedTime(obj, dp) {
	var _this = jQuery(obj);
	var _parent = _this.parent();
	var cid = _parent.find('#cid').val();
	var type = _parent.find('#type').val();
	var checkedBox = jQuery("div.c_zhoudanFloatBox").find("div.second").find("input[type=checkbox]:checked");
	
	if (_this.attr('name') == 'startTime') {
		var startTime = DateUtil.getTimeMillis(_this.val());
		var endTime = DateUtil.getTimeMillis(_parent.find('input[name=endTime]').val());
		var st_time = _parent.find('#st_time').val() || "";
		if (startTime >= endTime) {
			Dialog.alert('节目单开始时间不能大于结束时间');
			_this.val(st_time);
			return;
		}
		if (typeof cid != 'undefined' && cid != null && cid.length > 0) {
			if (type == '1') {
				var programlength = parseInt(_parent.find('#programlength').val(), 10);
				endTime = DateUtil.getTimeStr((startTime + programlength)/1000);
				_parent.find('input[name=endTime]').val(endTime);
				_parent.find('input[name=ed_time]').val(endTime);
			}
			if (checkedBox.length > 0) {
				checkedBox.trigger("click").attr('checked', 'checked');
			}
		}
		_parent.find('input[name=st_time]').val(_this.val());
		if (typeof endTime != 'undefined' && endTime) {
			if (typeof endTime == 'string') {
				endTime = DateUtil.getTimeMillis(endTime);
			}
			_parent.find('#programlength').val(endTime - startTime);
		}
	} else if (_this.attr('name') == 'endTime') {
		var endTime = DateUtil.getTimeMillis(_this.val());
		var startTime = DateUtil.getTimeMillis(_parent.find('input[name=startTime]').val());
		var ed_time = _parent.find('#ed_time').val() || "";
		if (endTime <= startTime ) {
			Dialog.alert("节目单结束时间不能小于开始时间");
			_this.val(ed_time);
			return;
		}
		if (typeof cid != 'undefined' && cid != null && cid.length > 0) {
			if (type == '1') {
				var programlength = parseInt(_parent.find('#programlength').val(), 10);
				var prolength = endTime - startTime;
				
				if (prolength > programlength) {
					Dialog.alert('设定节目单时长大于所选节目时长,请重新设定');
					_this.val(ed_time);
					return;
				}
			}
			if (checkedBox.length > 0) {
				checkedBox.trigger("click").attr('checked', 'checked');
			}
		}
		_parent.find('input[name=ed_time]').val(_this.val());
		if (typeof startTime != 'undefined' && startTime) {
			_parent.find('#programlength').val(endTime - startTime);
		}
	}
}

function initSourceItems(obj){
	Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.initSourceItems", null, function(response){
		var json = eval('(' + response.Message + ')');
		var liveItems = json.liveInfo.liveItems;
		var videoItems = json.videoInfo.videoItems;
		var catItems = json.catInfo.catItems;
		
		appendLiveItems(liveItems);
		appendVideoItems(videoItems);
		appendCateforyItems(catItems);
		
		var sourceWrapper = jQuery("div.source_wrapper");
		sourceWrapper
					 .find("div.src_content")
					 .attr("isLoaded", "true");
		sourceWrapper
					 .insertAfter(jQuery(obj))
					 .removeClass("hide");
		scrollTable(json.videoInfo);
	});
}

function appendLiveItems(liveItems){
	var ja = eval(liveItems);
	var _li = "";
	
	if (typeof ja != 'undefined' && ja.length > 0) {
		for (var i = 0; i < ja.length; i++) {
			var name = ja[i].name;
			if(name.length > 10){
				name = name.substring(0,10)+"...";
			}
			_li += "<li class='live_li'><a class='live_link' id='"+ja[i].id+"'>" 
					+ " <img src='"+ja[i].imgurl+"'/><span title='"+ja[i].name+"'>"+name+"</span></a></li>"; 
		}
		
	}
	
	jQuery("#live_items").html(_li);
}

function appendVideoItems(videoItems){
	var ja = eval(videoItems);
	var _li = "";
	
	if (typeof ja != 'undefined' && ja.length > 0) {
		for (var i = 0; i < ja.length; i++) {
			var title = ja[i].title || "";
			
			if (title.length > 3) {
				title = title.substring(0, 3) + "...";
			}
			_li += "<li class='video_li'><a class='video_link' id='"+ja[i].id+"' title='"+ja[i].title+"' prolength='"+ja[i].prolength+"'>" 
					+ " <img src='"+ja[i].keyFrame+"'/></a>"
					+ " <ul id='video_info' class='video-info'>"
					+ " <li class='video-info-li'><span class='left_span'>名称:</span>"
					+ " <span class='right_span'>"+title+"</span></li>"
					+ " <li class='video-info-li'><span class='left_span'>时长:</span>"
					+ " <span class='right_span'>"+ja[i].prolength+"</span></li>"		
					+ " </ul></li>"; 
		}
		
	}else{
		_li = "<div style='text-align:center;line-height:60px'>暂无数据</div>";
	}
	
	jQuery("#video_items").append(_li);
}

function appendCateforyItems(catItems, parent){
	var ja = eval(catItems);
	var _li = "";
	
	if (typeof ja != 'undefined' && ja.length > 0) {
		for (var i = 0; i < ja.length; i++) {
			_li += "<li class='cat_item' id='"+ja[i].id+"'  title='"+ ja[i].title +"'>";		
					
			if (ja[i].hasChildren == true) {
				_li += " <span><a href='#' class='jump'>"
						+ " <span class='img'></span></a>"
						+ " <a class='cat_link collapsed'>"+ja[i].name+"</a>"
						+ " </span>";
			} else {
				_li += "<a class='cat_link'>"+ja[i].name+"</a>";
			}
			_li += "</li>";
		}
		
	}
	
	if (typeof parent == 'undefined') {
		jQuery("#cat_ul_0").html(_li);
	} else {
		var newCatObj = jQuery("<div id='wrap"+parent.pid+"' class='wrap-menu dropdown-menu hide'>"
				+ " <span class='cat_parent' id='"+parent.pid+"'>"
				+ " <a class='backup' href='javascript:void(0);' previd='"+parent.ancestorid+"'></a>"+parent.name+"</span>"
				+ " <ul class='dropdown' id='cat_ul_"+parent.pid+"'></ul></div>");
		newCatObj
		         .find("ul.dropdown")
		         .html(_li);
		newCatObj.appendTo(jQuery("div.dropdown-wrapper"));
	}
}

function scrollTable(json){
	var isLocked = false, total = json.total || 0, page = json.page || 1, 
		count = json.count || 0, target = jQuery("div.video-box");
	
	target.on("mousewheel.scrollTable scroll.scrollTable", function(e){
		e.stopPropagation();
		
		_scroll();
	});
	
	function _scroll(){
		if (!isLocked && (count < total) 
				&& target.scrollTop() + target.height() > target[0].scrollHeight - 20) {
			loadPage();
		}
	}
	
	function loadPage(){
		isLocked = true;
		var dc = new DataCollection();
		//var catalogid = jQuery(".cat_current").parent().attr("id");
		catalogid =wideCatelogId;
		var videoInfo = "{\"page\": "+(++page)+", \"size\":10, \"catalogid\":"+catalogid+"}";
		dc.add("videoInfo", videoInfo);
		Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.getVideoSourceItems", dc, function(response) {
			var jo = eval('(' + response.Message + ')');
			page = jo.page, total = jo.total, count = jo.count;
			appendVideoItems(jo.videoItems);
			isLocked = false;
		});
		
	}
}

function getVideosByCatalogID(catalogid) {
	var videoInfo = "{\"page\": 1, \"size\":10, \"catalogid\":"+catalogid+"}";
	var dc = new DataCollection();
	dc.add("videoInfo", videoInfo);
	Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.getVideoSourceItems", dc, function(response) {
		var jo = eval('(' + response.Message + ')');
		scrollTable(jo);
		jQuery("ul.video-items").html("");
		appendVideoItems(jo.videoItems);
	});
}

function getVideosByCatalogIDAndName(catalogid, name) {
	var videoInfo = "{\"page\": 1, \"size\":10, \"catalogid\":"+catalogid+", \"name\": \""+name+"\"}";
	var dc = new DataCollection();
	dc.add("videoInfo", videoInfo);
	Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.getVideoSourceItems", dc, function(response) {
		var jo = eval('(' + response.Message + ')');
		scrollTable(jo);
		jQuery("ul.video-items").html("");
		appendVideoItems(jo.videoItems);
	}); 
}
function getCatalogsByParentID(pid, obj) {
	var dc = new DataCollection();
	dc.add("parentid", pid);
	Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.getCategory", dc, function(response){
		var json = eval('(' + response.Message + ')');
		var parent = {};
		parent.pid = pid;
		parent.name = obj.siblings('a.cat_link').text();
		parent.ancestorid = obj.parents('div.dropdown-menu')
								.find('span.cat_parent')
								.attr('id');
		appendCateforyItems(json.catItems, parent);
		animateWrapper(obj);
	});
}

function animateWrapper(obj){
	var _this = obj;
	var pid = _this.parent().parent().attr("id");
	var wrapper = jQuery("#wrap"+pid+"");
	var targetObj = jQuery("div.dropdown-wrapper").find('div.show');
	
	if (targetObj && targetObj.length > 0) {
		targetObj.each(function(){
			jQuery(this)
						.removeClass("show")
						.addClass("hide");
		});
	}
	wrapper.animate({right: "0px"}, 'fast', function(){
		wrapper
			.removeClass("hide")
			.addClass('show')
			.find("span.cat_parent")
			.trigger('click');
		
	});
}

function checkAddVideoSource(target, obj) {
	var nextStartTime, sourceProlength = DateUtil.getTimeMillis(obj.attr('prolength')),
	endTime = DateUtil.getTimeMillis(
						target.find('#startTime').val()) + sourceProlength;
	
	var nextItem = target.next().next();
	if (nextItem && nextItem.length > 0) {
		var sparedItem;
		if (nextItem.hasClass('spared_item')) {
			sparedItem = nextItem;
			nextItem = nextItem.next();
		}
		nextStartTime = DateUtil.getTimeMillis(
								nextItem
									.find('#startTime')
									.val());
		if (endTime > nextStartTime) {
			Dialog.alert("节目单结束时间大于下一节目单的开始时间，请重新挑选");
			return;
		} else if (endTime == nextStartTime) {
			addVideoItemInfo(target, obj, endTime);
			if (sparedItem && sparedItem.length > 0) {
				sparedItem.remove();
				return;
			}
		} else if (endTime < nextStartTime) {
			addVideoItemInfo(target, obj, endTime);
			if (!sparedItem){
				sparedItem = ActItem.prototype.createSparedItem.call();
				sparedItem.insertBefore(nextItem);
				return;
			}
		}
	}  else {
		addVideoItemInfo(target, obj, endTime);
	}
}

function addVideoItemInfo(target, obj, endTime) {
	target.removeAttr("title");
	target.removeAttr("style");
	ActItem.setFlag();
	endTime = DateUtil.getTimeStr(endTime/1000);
	if(endTime>"23:59:59"){
		endTime = "23:59:59";
	}
	var title = obj.attr('title').length > 10 ? obj.attr('title').substring(0, 10) + "..." : obj.attr('title');
	target	
		.find('span.source_info')
		.attr('title', obj.attr('title'))
		.text(title);
	target	
		.find('span.source_type')
		.html('视频');
	target
		.find('#cid')
		.val(obj.attr('id'));
	target
		.find('#type')
		.val('1');
	target
		.find('#endTime')
		.val(endTime);
	target
		.find("#end_time")
		.val(endTime);
	target
		.find("#programlength")
		.val(DateUtil.getTimeMillis(endTime) 
				- DateUtil.getTimeMillis(
						target.find("#startTime").val()));
}

function checkStartTime(obj) {
	obj = (obj instanceof jQuery) ? obj : jQuery(obj);
	var _parent = obj.parent();
	var origStartTime = DateUtil.getTimeMillis(
			_parent
				.find('input[name=start_time]')
				.val());
	var startTime = DateUtil.getTimeMillis(obj.val());
	var endTime = DateUtil.getTimeMillis(
					_parent.find("#endTime").val());

	if (origStartTime == startTime) {
		return;
	}
	if (startTime >= endTime) {
		Dialog.alert('节目单开始时间必须小于节目单结束时间');
		obj.val(DateUtil.getTimeStr(origStartTime/1000));
		return;
	}
	var prevItem = _parent.prev();
	if (prevItem && prevItem.length > 0) {
		var origPrevItem;
		if(!prevItem.hasClass('itembox')&&prevItem.hasClass('spared_item')) {
			origPrevItem = prevItem;
		}
		if (!prevItem || prevItem.length == 0) {
			if ((typeof origPreItem != 'undefined') 
					&& origPrevItem.hasClass('spared_item') && (startTime == 0)) {
				origPrevItem.remove();
			} 
		} else {
			var prevEndTime = DateUtil.getTimeMillis(
					prevItem
							.find('input[name=endTime]')
							.val());
			if (startTime < prevEndTime) {
				Dialog.alert('节目单开始时间不能大于上一节目单的结束时间');
				obj.val(DateUtil.getTimeStr(origStartTime/1000));
				return;
			} else if (startTime == prevEndTime) {
				if ((typeof origPrevItem != 'undefined')
						&& origPrevItem.hasClass('spared_item')) {
					origPrevItem.remove();
				}
			} else if (startTime > prevEndTime) {
				if (!origPrevItem || origPrevItem.length == 0){
					var sparedItem = ActItem.prototype.createSparedItem.call();
					sparedItem.insertBefore(_parent);
				}
			}
			
		}
	} else {
		if (startTime > origStartTime) {
			var sparedItem = ActItem.prototype.createSparedItem.call();
			sparedItem.insertBefore(_parent);
		}
	}
	if (origStartTime > startTime 
			&& (_parent.find('.source_info').html().length > 0)) {
		Dialog.alert('设定节目时长大于选定节目时长，请重新挑选节目');
		removeItemInfo(_parent);
		return;
	}
	setItemInfo(_parent);
	ActItem.setFlag();
}

function checkEndTime(obj) {
	obj = (obj instanceof jQuery) ? obj : jQuery(obj);
	var _parent = obj.parent();
	var origEndTime = DateUtil.getTimeMillis(
			_parent
				.find('input[name=end_time]')
				.val());
	var endTime = DateUtil.getTimeMillis(obj.val());
	var startTime = DateUtil.getTimeMillis(
					_parent.find("#startTime").val());

	if (origEndTime == endTime) {
		return;
	}
	if (endTime <= startTime) {
		Dialog.alert('节目单结束时间必须大于节目单开始时间');
		obj.val(DateUtil.getTimeStr(origEndTime/1000));
		return;
	}
	var nextItem = _parent.next();
	
	if (nextItem && nextItem.length > 0) {
		var origNextItem;
		while (!nextItem.hasClass('itembox')) {
			if (nextItem.hasClass('spared_item')) {
				origNextItem = nextItem;
			}
			nextItem = nextItem.next();
		}
		if (nextItem && nextItem.length > 0) {
			var nextStartTime = DateUtil.getTimeMillis(
					nextItem
							.find('input[name=startTime]')
							.val());
			if (endTime > nextStartTime) {
				Dialog.alert('节目单结束时间不能大于下一节目单的开始时间');
				obj.val(DateUtil.getTimeStr(origEndTime/1000));
				return;
			} else if (endTime == nextStartTime) {
				if ((typeof origNextItem != 'undefined')
						&& origNextItem.hasClass('spared_item')) {
					origNextItem.remove();
				}
			} else if (endTime < nextStartTime) {
				if (!origNextItem || origNextItem.length == 0){
					var sparedItem = ActItem.prototype.createSparedItem.call();
					sparedItem.insertBefore(nextItem);
				}
			}
			
		}
	}
	if (origEndTime < endTime 
			&& (_parent.find('.source_info').html().length > 0)&&(_parent.find('.source_type').html()!="直播")) {
		Dialog.alert('设定节目时长大于选定节目时长，请重新挑选节目');
		removeItemInfo(_parent);
		return;
	}
	setItemInfo(_parent);
	ActItem.setFlag();
}

function removeItemInfo(obj) {
	var startTime = obj.find('input[name=startTime]').val();
	var endTime = obj.find('input[name=endTime]').val(); 
	
	obj
		.find('input[name=start_time]')
		.val(startTime);
	obj
		.find('input[name=end_time]')
		.val(endTime);
	obj
		.find('input[name=cid]')
		.val('');
	obj
		.find('input[name=programlength]')
		.val(DateUtil.getTimeMillis(endTime) - DateUtil.getTimeMillis(startTime));
	obj
		.find('input[name=type]')
		.val('');
	obj
		.find('.source_info')
		.html('');
}

function setItemInfo(obj) {
	var startTime = obj.find('input[name=startTime]').val();
	var endTime = obj.find('input[name=endTime]').val(); 
	obj
		.find('input[name=start_time]')
		.val(startTime);
	obj
		.find('input[name=end_time]')
		.val(endTime);
	obj
		.find('input[name=programlength]')
		.val(DateUtil.getTimeMillis(endTime) - DateUtil.getTimeMillis(startTime));
}

function checkAddOrEdit(){
	if (typeof window.isEdit != 'undefined' && window.isEdit == true) {
		loadActList(currentVID, jQuery('span.vdate-info').html(), false);
	} else {
		return;
	}
}