(function($){
	$(function(){
		setStatus();
		setDate();
		setPointerStyles();
		computeSparedArea();

		var dc = new DataCollection();
        jQuery('#dg1').vmsDataGrid({dc:dc,operations:[{text:"批量删除",handler:deleteVirtualChannels}]});


		$('div.main-area').on('click', 'div.switch-key', function(event){
			event.stopPropagation();
			event.preventDefault();
			var _this = $(this);
			var _parent = _this.parent().parent();
			var livePannel = $('div.live-pannel');
			var pannel_pointer = $('span.pannel_pointer');
			
			if (livePannel.hasClass('hide')) {
				livePannel
						.removeClass('hide')
						.animate({right: '0px'}, 'fast', function(){
							var index = _parent.index('tr:gt(0)');
							var top = parseInt(_parent.css('height'), 10) * index;
							pannel_pointer
								.removeClass('hide')
								.animate({top: '+=' + top});
						});
				_this.attr('isEdit', 'true');
				var vid = getCurrentVID();
				loadVLivePlayerByID("live_player", "live://program:" + vid, getHost(vid), getTimeServer(vid), false);
				appendChannelInfo(_parent);
				loadActList(_parent.find('input[type=checkbox]').val(), 
						$('span.date-info').html(), 
						true, function(){
					fillParentBlank(true);
				});
				
			} else {
				if (_this.attr('isEdit') == 'true') {
					livePannel
							.animate({right: '-440px'}, 'fast', function(){
								pannel_pointer
										.addClass('hide')
										.css('top', 
											pannel_pointer.attr('basetop') + 'px');
							}).addClass('hide');
					_this.removeAttr('isEdit');
					fillParentBlank(false);
				} else {
					var relativeTR = $('div[isEdit=true]');
					var relaIndex = relativeTR.parent().parent().index('tr:gt(0)');
					relativeTR.removeAttr('isEdit');
					_this.attr('isEdit', 'true');
					var index = _parent.index('tr:gt(0)') - relaIndex;
					var top = parseInt(_parent.css('height'), 10) * index;
					var vid = getCurrentVID();
					pannel_pointer
						.animate({top: '+=' + top});
					loadVLivePlayerByID("live_player", "live://program:" + vid, getHost(vid), getTimeServer(vid),false);
					appendChannelInfo(_parent);
					loadActList(_parent.find('input[type=checkbox]').val(), 
							$('span.date-info').html(), 
							true, function(){
						fillParentBlank(true);
					});
				}
			}
		}).on('dblclick', 'td.vlive-title', function(e){
			e.stopPropagation();
			
			var _this = $(this);
			
			var _parent = _this.parent();
			editVLiveChannel(_parent.find('input[type=checkbox]').val(), _this.next().attr('status'));
		});
		
		$('div.main-area').on('click', 'div.aswitch', function(e){
			e.preventDefault();
			e.stopPropagation();
			
			var _this = $(this);
			var _child = _this.find('div.btn');
			var _parent = _this.parent().parent();
			var status = _parent.attr('status') == '0' ? 'online' : 'offline';
			var cid = _parent.parent().find('input[type=checkbox]').val();
			
			triggerVPannelAndRemovePlayer();
			publish(cid, status, function(){
				if(status == 'online') {
					_parent.attr('status', '1');
					_child.attr('statusName', '撤销').attr('status', '1').animate({left:'25px'});
					_this.removeClass('closed').addClass('open');
				} else {
					_parent.attr('status', '0');
					_child.attr('statusName', '发布').attr('status', '0').animate({left:'-1px'});
					_this.removeClass('open').addClass('closed');
				}
			});
		});
		
		$('div.open_box').hover(function(){
			$(this).addClass('open_box_hover');
			$('ul.open_ul').addClass('show');
		}, function(){
			$(this).removeClass('open_box_hover');
			$('ul.open_ul').removeClass('show');
		});
		
		$('div.live-operations').on('click', 'a.edit,a.del,a.actList,a.playerCode,a.preview', function(event){
			event.stopPropagation();
			var _this = $(this);
			var vid = getCurrentVID();
			
			if (_this.hasClass('edit')) {
				editVLiveChannel(vid, $('div[isEdit=true]').parent().prev().attr('status'));
			} else if (_this.hasClass('del')) {
				delVLiveChannel(vid);
			} else if (_this.hasClass('actList')) {
				addOrEditActList(vid);
			} else if (_this.hasClass('playerCode')) {
				getVChannelPlayerCode(vid);
			} else if (_this.hasClass('preview')) {
				previewVChannel(vid);
			}
			if(!_this.hasClass('playerCode')){
				triggerVPannelAndRemovePlayer();
			}	
		});
		
		$('span.slideIcon').on('click', function(event){
			event.stopPropagation();
			
			var _this = $(this);
			
			_this
				.hasClass('slideDown') 
						? _this.removeClass('slideDown') 
						: _this.addClass('slideDown'); 
			_this
				.parent()
				.parent()
				.hasClass('live-actlist') 
						? $('div.act-info').slideToggle() 
						: $('div.channel-info').slideToggle();
			
		});
		$("#createVirtualChannel").on('click', function(){
			addVLiveChannel();
		});
		
		$(".topSearch ul.qieHuanBt").on('click', 'li.m1,li.m2', function(e){
			e.preventDefault();
			
			var _this = $(this);
			var _div = $('div.z-live');
			var _channelDG = $('#dg1');
			//var _openBox = $('div.open_box');
			
			if (_this.hasClass('m1')) {
				if (_channelDG.hasClass('hide')) {
					_this
						.find('span')
						.addClass('on');
					$('.topSearch li.m2')
						.find('span')
						.removeClass('on');
					//_openBox.removeClass('hide');
					_channelDG.removeClass('hide');
					_div.addClass('hide').find('ul').html('');
					dg1.loadData();
				}
			} else if (_this.hasClass('m2')) {
				if (_div.hasClass('hide')) {
					_this
						.find('span')
						.addClass('on');
					$('.topSearch li.m1')
						.find('span')
						.removeClass('on');
					_div.removeClass('hide').height(_channelDG.css('height'));
					_channelDG.addClass('hide');
					//_openBox.addClass('hide');
					triggerVPannelAndRemovePlayer();
					loadVChannelTVMode();
					computeSparedArea();
				}
			}
		});
		$(".z-live li").live({
			mouseenter:function(){
				$(this).find(".t").show().stop().animate({
					marginTop:-42,
					height:42
				});
			},
			mouseleave:function(){
				$(this).find(".t").stop().animate({
					marginTop:0,
					height:0
				},'normal',function(){
					$(this).hide();
				});
			}
		});
		
		$("img.close-btn").live('click', function(e){
			e.stopPropagation();
			
			var _this = $(this);
			var _parent = _this.parents('div.t'); 
			var vid = _parent.siblings('input[type=checkbox]').val();
			delVLiveChannel(vid);
		});
		
		$('.tableListRightBoxCloseBt').click(function(e){
			e.stopPropagation();
			
			triggerVPannelAndRemovePlayer();
		});
		function deleteVirtualChannels(){
			var arr =  dg1.gridBody.getSelectedRowsData() ;
			if(arr.length==0){
				MsgPop("请先选中需要删除的数据");
				return;
			}
			//状态验证
			for(var  i = 0 ; i<arr.length; i++){				
				if('1'==jQuery("#vlc_"+arr[i]).find("[status]").attr("status")){
					MsgPop("发布状态的频道不能删除！<br/>频道名称："+jQuery("#vlc_"+arr[i]).find(".vlive-title").text());
					return;
				}
			}
			Dialog.confirm('确认删除所选的'+arr.length+'个虚拟直播频道吗?', function(){
				var dc = new DataCollection();	
				dc.add("ids", arr);
				$.vmsAjax("com.sobey.scms.virtualchannel.VirtualChannelLib.delete", dc ,function(response){
					MsgPop(response.Message, function(){
						var isShow = jQuery("#dg1").hasClass('hide') ? false : true;
						dg1.loadData(function(){
							if (!isShow) {
								jQuery('#dg1').addClass('hide');
							}
							refreshVChannelTVs(vid, 'del');
						});
					});
				});
			}, function(){
				return false;
			});
		};
	});
	
	function getCurrentVID(){
		var currentTR = $("div[isEdit=true]").parent().parent();
		var vid = currentTR.find('input[type=checkbox]').val();
		
		return vid;
	}
	
	function getHost(vid){
		var host = $("input[value="+vid+"]")
				.parent()
				.parent()
				.find('input[name=host]')
				.val();
		
		return host;
	}
	
	function getTimeServer(vid){
		var host = $("input[value="+vid+"]")
				.parent()
				.parent()
				.find('input[name=timeServer]')
				.val();
		
		return host;
	}
	
	function getVChannelPlayerCode(vid){
		var diag = new Dialog("Diag1");
		var liveType = jQuery('#hiddenType').val();
		diag.Width = 700;
		diag.Height = 422;
		diag.Title = "虚拟直播播放器代码";
		diag.URL = "../../VideoModule/Default/PlayerCode.jsp?contentId="+vid+"&mediaType=16";
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = false;
		diag.onLoad = function(){};
		diag.show();
	}
	
	function previewVChannel(vid){
		window.open('../../VideoModule/Default/PlayerPreview.jsp?mediaType=16&contentId='+vid+'&d='+new Date().getTime());
	}
	
	function triggerVPannelAndRemovePlayer(){
		var currentObj = $("div[isEdit=true]");
		
		if (currentObj.length > 0) {
			currentObj.trigger('click');
			$("#live_player").remove();
			$(".tableListRightBoxCloseBt").after("<div id='live_player' class='live-player'></div>");
		}
	}
	
	function loadVChannelTVMode(){
		var _channelDG = $('#dg1');
		var _tr = _channelDG.find('tr:gt(0)');
		
		if (_tr.length == 0) {
			return;
		} else if (_tr.length == 1) {
			if (typeof _tr.attr("id") == 'undefined') {
				return;
			}
		}
		var _div = $('div.z-live');
		var _ul = _div.find('ul');
		
		_tr.each(function(index){
			var _this = $(this);
			var channelName = _this.find('td:eq(2)').html();
			var status = _this.find('td:eq(3)').attr('status');
			var channelShortName = channelName;
			var fullUrl = "live://program:" + _this.find('input[type=checkbox]').val();
			var host = _this.find('input[name=host]').val();
			var timeServer = _this.find("input[name=timeServer]").val();
			var vid = _this.find('input[type=checkbox]').val();
			var hasActList = _this.attr('hasActList');
				
			if ((index + "").length == 1) {
				index = "0" + index;
			}
			var obj = {
				id: index,
				vid: vid,
				channelName: channelName,
				status: status,
				statusClass: (status == '0') ? 'closed' : 'open',
				statusText: (status == '0') ? '发布' : '撤销',
				actInfo: (hasActList == 'true') ? '' : '暂无节目单'
			};
			var _channelTV = createVChannelTVElement(obj);
			if (status == '0') {
				_channelTV.find('div.btn').animate({left: '0px'});
			} else {
				_channelTV.find('div.btn').animate({left: '27px'});
			}
			_channelTV.appendTo(_ul);
			loadVLivePlayerByID(_channelTV.find('div.live-tv-player').attr('id'), fullUrl, host, timeServer, true);
		});
	}
	
	function createVChannelTVElement(obj) {
		if (typeof obj == 'undefined' || typeof obj != 'object') {
			return null;
		} else {
			return $("<li><div class='t' status='"+obj.status+"'>"
					+ " <div class='audiot'>"
					+ " <div class='aswitch fl "+obj.statusClass+"'>"
					+ "    <div class='btn'></div>"
                    + " </div>"
                    + " <img src='images/z-cancl.gif' width='12' height='12' class='close-btn fr'/>"
                    + "</div>"
                    + "</div>"
                    + "<div class='c'>"
                	+ " <div id='live_player_"+obj.id+"' class='live-tv-player'></div>"
                	+ "</div>"
                    + "<p class='f'>"
                	+ " <span class='fr mark'>"+obj.channelName+"</span>"
                    + " "+obj.actInfo+""
                    + "</p><input type='checkbox' class='hide' name='"+obj.vid+"' value='"+obj.vid+"'></li>");
		}
	}
	
	function loadVLivePlayerByID(id, url, host, timeServer, isShowControl, w, h) {
		var playerPannel = document.getElementById(""+id+"");
		var nodeName = playerPannel.nodeName;
		
		/*if (nodeName.toLowerCase() == 'object' 
				|| nodeName.toLowerCase == 'embed') {
			playerPannel.PlayNew(url, 'seekableLiveS');
			
			return;
		}*/
		var $player = $(playerPannel);
		if (typeof w == 'undefined') {
			w = $player.width();
		}
		if (typeof h == 'undefined') {
			h = $player.height();
		}
		createVirPlayer4mini(w, h, id, "virtualLiveMedia", url, host, isShowControl, timeServer);
	}
	
	function publish(cid, status, func){
		var dc  = new DataCollection();
		dc.add("id",cid);
		dc.add("status",status);
		Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelLib.publish",dc,function(response){
			MsgPop(response.Message, function(){
				if(response.Status==1){
					if (typeof func == 'function') {
						func();
					}
					if ($('li.m2').find('span').hasClass('on')) {
						$('table.tableList').addClass('hide');
					}	
					refreshVChannelTVs(cid, status);
				}
			});
		});
	}
	
	function setStatus(){
		var objs = $('div.aswitch');
		
		if (objs.length > 0) {
			objs.each(function(){
				var _this = $(this);
				var parent = _this.parent().parent();
				var status = parent.attr('status');
				
				if (status == '1') {
					_this.addClass('open');
				} else {
					_this.addClass('closed');
				}
			})
		}
	}
	
	function refreshVChannelTVs(cid, status){
		var _li = $('div.z-live ul').find('li');
		if (_li.length > 0) {
			var currentLi = _li.find("input[name='"+cid+"']").parent();
			if (status == 'del') {
				currentLi.remove();
				return;
			}
			var currentStatus = (status == 'online') ? '1' : '0';
			var _switch = currentLi.find('div.switch');
			var currentStatusText = (status == 'online') ? '开启' : '关闭';
			currentLi.find('div.t').attr('status', currentStatus);
			_switch.hasClass('open') 
				? _switch.removeClass('open').addClass('closed') 
				: _switch.removeClass('closed').addClass('open');
		}
	}
	
	function addVLiveChannel(){
		jQuery("body").css("overflow-y","hidden");
		var pannelHeight = $('div.live-pannel').height();
		var diag = new Dialog("Diag2");
		diag.Width = calWidth()-5;
		diag.Height = jQuery(window).height()-2;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "新增虚拟直播频道";
		diag.URL = "VirtualChannelLibDialog.jsp?flag=0";
		diag.onLoad = function(){
			$("#channelProps").css("height",pannelHeight - 300);
			triggerVPannelAndRemovePlayer();
			upload('form1');
		};
		diag.show();
	}

	function editVLiveChannel(vid, status){
		jQuery("body").css("overflow-y","hidden");
		var pannelHeight = $('div.live-pannel').height();
		var diag = new Dialog("Diag2");
		diag.Width = calWidth()-5;
		diag.Height = jQuery(window).height()-2;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "编辑虚拟直播频道";
		diag.URL = "VirtualChannelLibDialog.jsp?id="+vid+"&flag=1";
		diag.onLoad = function(){
			$("#channelProps").css("height",pannelHeight - 300);
			if (status == '1') {
				$('#saveBtn').hide();
			}
			upload('form1');
		};
		diag.show();
	}

	function delVLiveChannel(vid){
		Dialog.confirm('确认删除此虚拟直播频道吗?', function(){
			var dc = new DataCollection();
			dc.add("ids", vid);
			
			$.vmsAjax("com.sobey.scms.virtualchannel.VirtualChannelLib.delete", dc ,function(response){
				MsgPop(response.Message, function(){
					var isShow = jQuery("#dg1").hasClass('hide') ? false : true;
					dg1.loadData(function(){
						if (!isShow) {
							jQuery('#dg1').addClass('hide');
						}
						refreshVChannelTVs(vid, 'del');
					});
				});
			});
		}, function(){
			return false;
		});
	}

	function addOrEditActList(vid){
		jQuery("body").css("overflow-y","hidden");
		var pannelHeight = jQuery('div.live-pannel').height();
		window.currentVID = vid;
		window.isEdit = false;
		if ($('li.act-li').length > 0) {
			window.isEdit = true;
		}
		var diag = new Dialog("Diag2");
		diag.Width = calWidth() - 15;
		diag.Height = jQuery(window).height() - 5;
		diag.ShowTitleRow = false;
		diag.ShowButtonRow = false;
		diag.MoveDirection = true;
		diag.Title = "虚拟直播节目单";
		diag.URL = "VLiveActList.jsp?id="+vid+"";
		diag.onLoad = function(){
			$(".fabuyu").height(jQuery(window).height()-jQuery(".topBox").outerHeight(true)-45);
			
		};
		diag.show();
	}

	
	function appendChannelInfo(tr) {
		var status = (tr.find('td:eq(3)').attr('status') == '0') ? '未发布' : '已发布';
		$("#cName")
				.find("span:eq(1)")
				.html(tr.find("td:eq(2)").html());
		$("#channelStatus")
				.find("span:eq(1)")
				.html(status);
		$("#isChannelRepeat")
				.find("span:eq(1)")
				.html(tr.find("td:eq(5)").html());
		$("#ctTime")
				.find("span:eq(1)")
				.html(tr.find("td:eq(6)").html());
		$("#epDate")
				.find("span:eq(1)")
				.html(tr.find("td:eq(7)").html());
	}

	

	function setDate(){
		var currentDate = new Date();
		var currentYear = currentDate.getFullYear();
		var currentMonth = currentDate.getMonth() + 1;
		var currentDay = currentDate.getDate();
		
		currentMonth = ((currentMonth + "").length < 2) 
				? "0" + currentMonth 
				: currentMonth;
		currentDay = ((currentDay + "").length < 2) 
				? "0" + currentDay 
				: currentDay;
		$('span.date-info').html(currentYear + '-' + currentMonth + "-" + currentDay);
	}

	function setPointerStyles(){
		var _pannel = $('div.live-pannel');
		var width = parseInt(_pannel.width(), 10);
		var paddingLeft = parseInt(_pannel.css('paddingLeft'), 10);
		var paddingRight = parseInt(_pannel.css('paddingRight'), 10);
		var totalWidth = width + paddingLeft + paddingRight;
		$('span.pannel_pointer').css('right', totalWidth + 'px');
	}

	

	function upload(){
		$("#form1")
						.find("#img")
						.uploadify({
	        				'buttonText': '选择台标',
	        				'queueSizeLimit' : 1,
					        'swf'       : '../../Plugin/VideoUploadify/uploadify.swf',  
					        'uploader'  : '../../servlet/WebFileUploadServlet?siteAlias='+alias+'&uploadType=image&mediaStyle=live&siteid='+siteid,
					        'auto'      : true,
					        'fileDesc'	: '支持格式:jpg/gif/jpeg/png/bmp.', 
					      	'fileExt'	: '*.jpg;*.gif;*.jpeg;*.png',
					      	'queueID'	: 'file_queue',
					      	'onUploadSuccess' : function(file, data, response) {
					      		data = eval("(" + data + ")");
								var relativeUrl = data.relativeUrl;
								var absoluteUrl = data.absoluteUrl;
					          	$("#form1").find("#filedata").attr("value",relativeUrl);
					          	$("#form1").find("#imgurl").attr("src",absoluteUrl);
					    	}
	   					 });  
	}

	function checkedAll(obj){
		var checked = obj.checked ? true : false;
		if(checked){
			DataGrid.selectAll("dg1");
		}else{
			DataGrid.unselectAll("dg1");
		}
	} 

	function computeSparedArea(isPannelShow){
		var cObj = $('#dg1').hasClass('hide') ? $('div.z-live') : $("#dg1");
		var height = $(window).height()-$(".tableListPage").outerHeight(true)-10-cObj.outerHeight(true)-$(".topSearch").outerHeight(true)-jQuery(".topBox").outerHeight(true);
		if (isPannelShow) {
			height = parseInt($("div.live-pannel").height(), 10) - $('#dg1').find('tr:gt(0)').length * 40;
		}
		if(height<0){height=0;}
		$("#kongbai").height(height);
	}
	
	function fillParentBlank(isShow) {
		var $pannel = $("div.live-pannel"),
			$parent = $pannel.parent();
		if (isShow == true) {
			if (!$parent.attr('orignalHeight')) {
				$parent.attr('orignalHeight', $parent.height());
			}
			$parent.height($pannel.height());
		} else {
			$parent.height($parent.attr('orignalHeight'));
		}
	}
})(window.jQuery);

function loadActList(cid, date, isParent, callback) {
	var dc = new DataCollection();
	dc.add("cid", cid);
	dc.add("date", date);
	
	Server.sendRequest("com.sobey.scms.virtualchannel.VirtualChannelActList.getActListByCid", dc, function(response) {
		var json = eval('(' + response.Message+ ')');
		
		if (json.state) {
			if (isParent === true) {
				appendActList(json.actList, callback);
			} else {
				ActItem.createBatchVLiveItems(json.actList);
			}
		}
	});
}

function appendActList(obj, callback){
	if (typeof obj == 'undefined') {
		return;
	} else {
		var _li = "", 
			count = obj.length,
			_pannel = jQuery("div.live-pannel"),
			pannelHeight = parseInt(_pannel.height(), 10);
		
		if (!_pannel.attr('lastHeight')) {
			_pannel.attr('lastHeight', pannelHeight);
		};
		if (count == 0) {
			jQuery('div.act-info').css("height", "30px").children("span").html("暂无节目单！").removeClass('hide');
			jQuery("ul.act-ul").html("");
			_pannel.css("height", _pannel.attr('lastHeight') + "px");
		} else {
			for (var i = 0; i < count; i++) {
				var content = obj[i].content;
				if (typeof content != 'undefined' 
					&& content != "" && content.length > 10) {
					content = content.substring(0, 10) + "...";
				}
				_li += "<li id='act_li' class='act-li'>"
					+ " <span id='li_startTime' class='li-span'>"+obj[i].startTime+"</span>"
					+ " <span id='li_content' title='"+obj[i].content+"' class='li-span'>"+content+"</span>"
					+ " <span id='li_endTime' class='li-span'>"+obj[i].endTime+"</span>"
					+ " </li>";
			}
			var _height = count * 40;
				
			if (_height > 100) {
				_pannel.css("height", parseInt(_pannel.attr('lastHeight'), 10) + (_height - 100) + "px");
			} else {
				_pannel.css("height", _pannel.attr('lastHeight') + "px");
			}
			jQuery('div.act-info').css("height", count * 40 + "px").children("span").html("").addClass('hide');
			jQuery("ul.act-ul").html(_li);
		}
		if (typeof callback == 'function') {
			callback();
		}
	}
}

function addOrSaveVChannel(flag) {

	var method = "com.sobey.scms.virtualchannel.VirtualChannelLib.addSave";
	if (flag == '1') {
		method = "com.sobey.scms.virtualchannel.VirtualChannelLib.editSave";
	}
	var name=jQuery("#name").val();
	if(name.length>20){
		alert("频道标题不超过20个字");
		return;
	}
	jQuery("#form1").vmsForm({
		method: method, 
		autoCommit: true 
	}, function (response) {
		$D.close("Diag2");
		MsgPop(response.Message, function(){
		jQuery('#_MainArea', window.parent.document).attr("src","ChannelModule/VirtualChannelManage/VLiveChannelLib.jsp");
		});
	}); 
	
}