(function($) {
	function uploadUtil(ele, ops) {
		this.init(ele, ops);
	}

	uploadUtil.prototype = {
		init : function(ele, ops) {
			this.ele = ele;
			this.ops = $.extend({}, $.fn.uploadPlugin.defaults, ops);	
			var $this = this;
			
			this.ele.click(function() {
				$this.pickFile($this.ops);			
			});
		},

		pickFile : function(ops) {
			var data = {
				op: "pickfile",
				single: 0,
				suffix: ops.fileExts
			},
			json = JSON.stringify(data),
			$this = this;
			
			$.ajax({
				url: ops.url + "?json="+json+"&wrapper=success_jsonpCallback",
				type: 'GET',
				dataType: "jsonp",
				jsonpCallback: "success_jsonpCallback"
			}).done(function(data) {
				if (data && data.result == 1) {
					fileHandler.showFiles.call($this, data.files, ops);
				}
			});
		},
		
		add : function(ops) {
			var cid = Math.uuid().replace(new RegExp("-","g"),""),
				date = new Date(),
				y = date.getFullYear(),
				m = date.getMonth() + 1,
				d = date.getDate();
			
			if ( m < 10) {
				m = "0" + m;
			}
			if( d < 10) {
				d = "0" + d;
			}
			this.ops = $.extend(this.ops, ops);
			var basePath = this.ops.cp + this.ops.alias + "/" + y + "/" + m + "/" + d + "/",
				fileData = fileHandler.getFiles.call(this, this.ops),
				metadata = {
					cid: this.ops.cid,
					tid: this.ops.tid,
					sid: this.ops.sid,
					csids: fileData.csids,
					fileSizes: fileData.fileSizes,
					mType: this.ops.mType,
					uName: this.ops.uName
				};
			
			var data = {
				op: "add",
				type: "upload",
				name: "vmsupload",
				host: this.ops.host,
				port: this.ops.port, 
				usr: this.ops.usr,
				pwd: this.ops.pwd,
				system: "vms",
				cid: cid,
				path: basePath,
				metadata: metadata,
				feedback: {method: "json", url:[this.ops.callBackUrl]},
				files: fileData.files,
			},
			json = JSON.stringify(data);
			
			$.ajax({
				url: this.ops.url + "?json="+json+"&wrapper=success_jsonpCallback",
				type: 'GET',
				dataType: "jsonp",
				jsonpCallback: "success_jsonpCallback"
			}).done(function(data) {
				if (data && data.result == 1) {
					MsgPop("任务已成功添加至MCloud客户端,请查看");
				}
			});
		}
	}

	var fileHandler = {
		showFiles: function(files, ops) {
			var html = "";
				
			for (var i = 0; i < files.length; i++) {
				var contentSourceId = Math.uuid().replace(new RegExp("-","g"),""),
					filePath = files[i].path,
					fileSize = files[i].size,
					fileName = filePath.substring(filePath.lastIndexOf("/") + 1),
					desFileName = new Date().getTime() + fileName.substring(fileName.lastIndexOf(".")),
					
					div = '<div id="'+contentSourceId+'_user" class="fenlei">'+
					  '<input type="hidden" value="'+fileName+'" name="tfcfilename" id="tfcfilename_'+contentSourceId+'"/>'+
					  '<input type="hidden" value="'+desFileName+'" name="tfcdesfilename" id="tfcdesfilename_'+contentSourceId+'"/>'+
	      		  	  '<input type="hidden" value="'+filePath+'" name="tfcfilepath" id="tfcfilepath_'+contentSourceId+'"/>'+
	      		      '<input type="hidden" value="'+contentSourceId+'" name="tfccontentSourceId" id="'+contentSourceId+'"/>'+
	      		      '<input type="hidden" value="'+fileSize+'" name="tfcfilesize" id="tfcfilesize_'+contentSourceId+'"/>'+
	      		      '<em title="'+fileName+'">'+fileName+'</em>'+
	      		      '<i class="x" onclick="cancelUpload(\''+contentSourceId+'\')"></i></div>';
				
				html += div;
			}
			$("#"+ops.fileWrapper).append(html);
		},
		
		getFiles: function(ops) {
			var fileWrapper = $("#"+ops.fileWrapper),
				files = [],
				fileSizes = "",
				csids = "";
			
			fileWrapper.find("div.fenlei").each(function() {
				var _this = $(this),
					fileSrc = _this.find("input[name=tfcfilepath]").val(),
					fileName = _this.find("em").html(),
					desFileName = _this.find("input[name=tfcdesfilename]").val(),
					fileSize = _this.find("input[name=tfcfilesize]").val() + "",
					csid = _this.find("input[name=tfccontentSourceId]").val(),
					file = {
						name: fileName,
						src: fileSrc,
						abs: 0,
						des: desFileName
					};
				
				files.push(file);
				fileSizes += fileSize + ",";
				csids += csid + ",";
			});
			fileSizes = (fileSizes.length > 0)
				? fileSizes.substring(0, fileSizes.lastIndexOf(",")) : "";
			csids = (csids.length > 0)
				? csids.substring(0, csids.lastIndexOf(",")) : "";
			
			return {
				files: files,
				fileSizes: fileSizes,
				csids: csids
			};
		}
	}
	
	$.fn.uploadPlugin = function(ops) {
		return this.each(function () {
		      var $this = $(this)
		        , data = $this.data('uploadUtil')
		        , options = typeof ops == 'object' && ops;
		      
		      if (!data) {
		    	  $this.data('uploadUtil', (data = new uploadUtil($this, options))); 
		      } 
		      window[$this.attr("id")] = data;
		});
	}

	$.fn.uploadPlugin.defaults = {
		url: "http://127.0.0.1:8890/r",
		cp: "/mdntest.sobeycache.com/vmstest",
		alias: "/source/tfc",
		host: "download.gmediaupload.com",
		port: "8880",
		usr: "sobey",
		pwd: "sobey",
		fileWrapper: "uploadFiles",
		callBackUrl: "http://localhost:8081/vms-cms/TFCUploadVideo"
	}
})(window.jQuery);
