function Progress(taskID,title,w,h){
	this.TaskID = taskID;
	this.Title = title;
	if(h){
		this.Height = h;
	}else{
		this.Height = 190;
	}
	if(w){
		this.Width = w;
	}else{
		this.Width = 400;
	}
}

Progress.prototype.show = function(func){
	var diag = new Dialog("DialogProgress"+this.TaskID);
	diag.Width = this.Width;
	diag.Top = 200;
	diag.Height = this.Height;
	diag.Title = this.Title;
	diag.ShowButtonRow = true;
	diag.ShowTitleRow = true;
	diag.MoveDirection = false;
	diag.URL = "javascript:void(0);";
	var id = this.TaskID;
	diag.OKEvent = function(){
		Progress.stop(id);
	};
	diag.show();
	var win = $(diag.ID);
	var doc = window.document;
	var arr = [];
	arr.push("<table width='100%' height='100%' border='0'><tr>");
	arr.push("  <td align='center' valign='middle'>");
	arr.push("	<div id='Info' style='text-align:left;width:100%;font-size:12px'>&nbsp;</div><br>");
	arr.push("      <table width='100%' border='1' cellpadding='1' cellspacing='0' class='progressBox'>");
	arr.push("      <tr><td class='progressBg'>");
	arr.push("				<table width='1%' border='0' cellpadding='0' cellspacing='0' id='tableP'>");
	arr.push("          <tr><td class='progressLight'>-</td></tr>");
	arr.push("          <tr><td class='progressShadow'>-</td></tr>");
	arr.push("        </table></td></tr></table></td></tr></table>");
	arr.push("<style>.progressBox{border:#ddd 1px solid}");
	arr.push(".progressBg{ background:#ddd url("+Server.ContextPath+"Framework/Images/progressBg.gif);}");
	arr.push(".progressLight{font-size:5px; line-height:5px; color:#99bb00; background:#99bb00}");
	arr.push(".progressShadow{font-size:5px; line-height:6px; color:#779911; background:#779911}");
	arr.push("table,td{border-collapse: collapse; border-spacing: 0;}</style>");
	var div = doc.createElement("div");
	div.setAttribute("style", "height:"+(this.Height-70)+"px");
	div.innerHTML = arr.join('');
	win.parentNode.replaceChild(div, win);
	diag.ParentWindow.$D = diag;
	diag.OKButton.innerHTML = "取消当前任务";
	diag.CancelButton.innerHTML = "关闭进度窗口";
	this.Dialog = diag;
	Progress.getInfo(this.TaskID);
}

Progress.getInfo = function(taskID){
	var dc = new DataCollection();
	dc.add("TaskID",taskID);
	Server.sendRequest("com.sobey.bsp.framework.messages.LongTimeTaskPage.getInfo",dc,function(response){
		if(response.Status==0){
			Dialog.alert(response.Message);
		}else{
			if(Dialog.getInstance("DialogProgress"+taskID)==null){
				return;//有可能已经被用户手工关闭
			}
			var info = response.get("CurrentInfo");
			if(info!=null){
				document.getElementById("Info").innerHTML = info;
			}
			if(response.get("CompleteFlag")=="1"){
				document.getElementById("tableP").width = "100%";
				var diag = Dialog.getInstance("DialogProgress"+taskID);
				diag.OKButton.hide();
				if(response.get("ErrorFlag")!="1"){
					if(diag.onComplete){
						try{
							diag.onComplete();
						}catch(ex){
							alert(ex.message);
						}
					}
				}
			}else{
				var percent = response.get("Percent");
				if(percent=="0"){
					percent = "1";
				}
				document.getElementById("tableP").width = percent+"%";
				window.setTimeout(Progress.getInfo,1000,taskID);
			}
		}
	});
}

Progress.stop = function(taskID){
	var dc = new DataCollection();
	dc.add("TaskID",taskID);
	Server.sendRequest("com.sobey.bsp.framework.messages.LongTimeTaskPage.stop",dc,function(response){
		function isStopComplete(){
			Server.sendRequest("com.sobey.bsp.framework.messages.LongTimeTaskPage.stop",dc,function(response2){
				if(response2.Status==1){
					Dialog.alert("任务己取消");
					Dialog.getInstance("DialogProgress"+taskID).close();
				}else{
					window.setTimeout(isStopComplete,1000,taskID);
				}
			});
		}
		Dialog.getInstance("DialogProgress"+taskID).CancelButton.value = "正在取消任务...";
		Dialog.getInstance("DialogProgress"+taskID).CancelButton.disable();
		isStopComplete();
	});
}
