/**
 * 
 */
var cc = new function() {
	
	/**
	 * 以默认get方式，发送异步请求
	 * 
	 * @param uri 请求地址
	 * @param params 请求携带的参数
	 * @param callback，请求处理成功后的回调函数 
	 */
	this.getJSON = function(uri, params, callback) {
		this.ajax(uri, params, true, "get", callback);
	};

	/**
	 * 对jQuery的ajax()方法的封装，目的是为所有的ajax请求加一个isAjax参数来表明该请求是AJAX类型的请求
	 * 
	 * @param uri 请求地址
	 * @param params 请求携带的参数
	 * @param isAsync 指定请求是同步请求还是异步请求
	 * @param type, 请求方式："get" 或 "post"
	 * @param callback，请求处理成功后的回调函数
	 */
	this.ajax = function(uri, params, isAsync, type, callback) {
		// make sure params is defined
		if(typeof(params) == undefined){
			var params;
		}
		// add param isAjax to indicate it is an Ajax Request;
		params.isAjax = "true";
		// 解决由于IE缓存不清求URL的问题
		params.random = Math.random();
		// execute request
		$.ajax({
            url: uri,
            async: isAsync,
            type: type,
            dataType: "json",
            data: params,
            success:function(data) {
            	if ("登录超时，请重新登录！" == data.msg) {
    				window.top.location = "/login.bo";
    			} else {
    				callback(data);
    			}
            }     
		});
	};
};
