/**
 * 用于前后台（异步）请求交互的公共接口
 */
(function($){
	$.vmsAjax = function (method, dc, callback, options) {
		var option = $.extend({},
						$.vmsAjax.defaults,
						(typeof arguments[0] == 'object') 
								? arguments[0] : options);
		
		if (typeof option == 'object' && option['ajaxMethodName']) {
			$.vmsAjax[option['ajaxMethodName']](option);
		} else {
			$.vmsAjax.ajaxServer(method, dc, callback, option);
		}
	}
	
	$.extend($.vmsAjax, {
		//根据传入参数、配置项请求后台(默认：异步)
		ajaxServer: function(method, dc, callback, option) {
			try {
				if (typeof arguments[0] == 'undefined') {
					return;
				} else {
					var options = option;
					if (typeof arguments[0] == 'object') {
						options = $.extend(options, arguments[0]);
					}
					$.ajax({
						async: options.async, 
						type: options.type,
						url: options.ContextPath + options.MainServer,
						dataType: options.dataType,
						data: {
							_ZVING_METHOD: (typeof method == 'string') ? method : options.method, 
							_ZVING_DATA: (typeof dc != 'undefined' && dc)
									? htmlEncode(dc.toXML())
									: htmlEncode(options.dc.toXML()) || "", 
							_ZVING_URL: encodeURL(window.location.pathname)
						}
					}).done(function(data) {
						$.vmsAjax.ajaxSuccess(data, callback || options.callback);
					}).fail(function() {
						$.vmsAjax.ajaxFail(data, callback || options.callback);
					})
				}
			} catch (e) {
				alert(e);
			}
		},
		
		//请求成功后回调
		ajaxSuccess: function(data, callback) {
			var dc = new DataCollection();
			if (typeof data != 'undefined' && dc.parseXML(data)) {
				dc["Status"] = dc.get("_ZVING_STATUS");
				dc["Message"] = dc.get("_ZVING_MESSAGE");
				if(dc.get("_ZVING_SCRIPT")){
					eval(dc.get("_ZVING_SCRIPT"));
				}
			}
			if (typeof callback == 'function') {
				callback(dc);
			}
		},
		
		//请求失败后回调
		ajaxFail: function(data, callback) {
			var dc = new DataCollection();
			
			dc["Status"] = 0;
			dc["Message"] = "服务器发生异常,未获取到数据!";
			if (typeof callback == 'function') {
				callback(dc);
			}
			
		}
		
	});
	
	$.vmsAjax.defaults = {
		ContextPath: CONTEXTPATH,
		MainServer: 'MainServlet.jsp',
		type: 'POST',
		dataType: 'xml',
		async: true
	}
	
})(window.jQuery);
