/**
 * DataGrid相应接口、方法
 */
(function($) {
	//初始化DataGrid的入口
	$.fn.vmsDataGrid = function(options, callback) {
			var args = arguments;
		//创建DataGrid的DataHead并添加处理的相关方法
			var _gridHeader = $("<div/>")
						.attr("id", this.attr('id')+'_Header')
						.addClass('grid-header')
						.appendTo(this.parent())
						.html(this)
						.extend({
							//检查是否需要checkbox、是否需要排序
							checkAllConditions: function(dc) {
								return this.each(function(){
									var $this = $(this),
										gridHeader = $this.find('table tbody'),
										sortTDs = gridHeader.find('td[sortable=true]'),
										checkTD = gridHeader.find('td[ztype=checkbox]'),
										checkTreeTD = gridHeader.find('td[ztype=tree]'),
										checkRowNo = gridHeader.find('td[ztype=RowNo]');
									if(checkRowNo.length > 0){
										var index = checkRowNo.index();
										_gridBody.find('table tbody tr:eq(0)').find('td:eq('+index+')').html("${RowNo}");
									}
									if (checkTD.length > 0) {
										var field = checkTD.attr('field');
										var index = checkTD.index();
										$('<input/>')
											.attr('type', 'checkbox')
											.attr('id', $this.attr('id').substring(0,$this.attr('id').lastIndexOf("_")) + "_RowCheck_" + "${RowNo}")
											.attr('name', $this.attr('id').substring(0,$this.attr('id').lastIndexOf("_")) + "_RowCheck")
											.attr('value', "${"+field+"}")
											.appendTo(_gridBody.find('table tbody tr:eq(0)').find('td:eq('+index+')'));
									}
									if(checkTreeTD.length > 0){
										var field = checkTreeTD.attr('field');
										var level = checkTreeTD.attr("level");
										var index = checkTreeTD.index();
										$('<input/>').attr('type', 'checkbox')
											.attr('id', $this.attr('id').substring(0,$this.attr('id').lastIndexOf("_")) + "_TreeRowCheck_" + "${RowNo}")
											.attr('name', $this.attr('id').substring(0,$this.attr('id').lastIndexOf("_")) + "_TreeRowCheck")
											.attr('value', "${"+field+"}")
											.attr('level', "${"+level+"}")
											.attr('class', "inputCheckbox")
											.attr("style","margin-right:10px;float:left;")
											.attr('onclick', "treeCheckBoxClick(this)")
											.appendTo(_gridBody.find('table tbody tr:eq(0)').find('td:eq('+index+')'));
										_gridBody.find('table tbody tr:eq(0)').attr("level","${"+level+"}");
										_gridBody.find('table tbody tr:eq(0)').find('td:eq('+index+')').attr("level","${"+level+"}").attr("type","tree");
									}
									if (sortTDs.length > 0) {
										var sortArr = [];
										
										sortTDs.each(function(index) {
											var _this = $(this),
												sortfield = _this.attr('sortfield'),
												direction = _this.attr('direction');
											
											sortArr.push(sortfield + " " + direction + ",");
											$("<div/>")
												.attr('class', 'grid-sort-' + direction + ' fl')
												.on('click', function(e){
													e.stopPropagation();
													
													var _div = $(this),
														_td = _div.parent(),
														clazz = _div.attr('class'),
														sfield = _td.attr('sortfield'),
														direction = _td.attr('direction') == 'asc' ? 'desc' : "asc",
														sortString = sfield + " " + direction + ",";
														dc = new DataCollection();
												
													if (clazz) {
														_div.removeClass(clazz).addClass('fl');
													}
													_div.addClass("grid-sort-"+direction);
													_td.attr('direction', direction);
													dc.add(Constant.sortString, sortString);
													_grid.loadData(dc);
											}).appendTo(_this);
										});
										dc.add(Constant.sortString, sortArr.join(""));
									}
								})
							}
						});
			//创建DataGrid的Body并添加相关处理方法
			var _gridBody = $("<div/>")
						.attr("id", this.attr('id')+'_Body')
						.addClass('grid-body')
						.html(this.clone().addClass('hide'))
						.on('click', 'tr', function(e) {
							_gridBody.find('tr.on').removeClass('on').css("background-color", "").find('input[type=checkbox]').removeAttr('checked');
							$(this).addClass('on').css("background-color", "#E2E4E5").find('input[type=checkbox]').attr('checked', "checked");
						}).on('click', 'input[type=checkbox]', function(e){
							e.stopPropagation();
							
							var _this = $(this);
							
							if (_this.is(":checked")) {
								_this.parent().parent().addClass('on').css("background-color", "#E2E4E5");
							} else {
								_this.parent().parent().removeClass('on').css("background-color", "");
							}
						})
						.extend({
							//设置模板TD的宽度（与Header对齐）
							setTemplateWidth: function(){
								var $this = this,
									_tr = $this.find('table tbody tr');
								
								return this.each(function(){
									_gridHeader.find('table tbody tr td').each(function(index){
										var _this = $(this);
										
										if (_this.attr('width')) {
											_tr.find("td:eq("+index+")").attr("width", _this.attr('width'));
										}
									});
								});
							},
							
							//设置模板html（指含有${field}）
							setTemplateHTML: function() {
								this.data(Constant.templateBody, this.find('table tbody').html());
							},
							
							//处理模板html并将处理后的html、${field}分别存储在数组中
							dealTemplateHTML: function() {
								return this.each(function(){
									var $this = $(this);
									if ($this.data(Constant.templateBody)) {
										var reg = new RegExp("\\$\\{(\\w+?)\\}", "g");
											temHtml = $this.data(Constant.templateBody),
											tempHtmlArr = [],
											tempValues = [],
											prevIndex = 0;
										
										while ((result = reg.exec(temHtml)) != null) 
										{
											tempValues.push(result[0].substring(2, result[0].length - 1).toLocaleLowerCase());
											tempHtmlArr.push(temHtml.substring(prevIndex, result.index));
											prevIndex = reg.lastIndex;
										}
										tempHtmlArr.push(temHtml.substring(prevIndex, temHtml.length));
										$this.data('tempHTMLArr', tempHtmlArr);
										$this.data('tempValues', tempValues);
									}
								});
							},
							
							//解析后台传回的json数据，并根据处理后的模板html生成Grid-Body的html
							setInnerHTML: function(data){
								if (!this.data('tempValues')) {
									this.dealTemplateHTML();
								}
								var tempHTML = [];
								if(_gridHeader.find('td[ztype=tree]').length > 0){
									var jsonData = "[";
									for ( var i = 0; i < data.length; i++) {
										var item = data[i];
										if(!item.parentid || item.parentid=="0"){
											jsonData += JSON.stringify(item)+",";
											jsonData += this.setChild(data,item.id);
										}
									}
									jsonData = jsonData.substring(0,jsonData.lastIndexOf(","))+"]";
									data = eval(jsonData);
								}
								var htmlTD = [];
								for ( var i = 0; i < data.length; i++) {
									var item = data[i];
									if(_gridHeader.find('td[ztype=tree]').length > 0){
										var html = "";
										var level = item.treelevel,nextLevel = 0;
										for(var j = 0;j<level;j++){
											html += "<i style='padding:0 10px;float:left;'>&nbsp;</i>";
										}
										if(i != data.length - 1){
											nextLevel = data[i+1].treelevel;
										}
										if(level < nextLevel){
											var id = this.parent().attr('id');
											html += "<img src='"+Server.ContextPath+"/Framework/Images/butExpand.gif' " +
													"onclick='"+id+".gridBody.treeClick(this)' style='float:left;padding-right:10px;'/>&nbsp;";
										}else{
											html += "<img src='"+Server.ContextPath+"/Framework/Images/butNoChild.gif' style='float:left;padding-right:10px;'/>&nbsp;";
										}
										htmlTD.push(html);
									}
									for ( var j = 0; j < this.data('tempHTMLArr').length; j++) {
										tempHTML.push(this.data('tempHTMLArr')[j]);
										if (j < this.data('tempValues').length) {
											if(this.data('tempValues')[j] == 'rowno'){
												tempHTML.push(i+1);
											} else {
												tempHTML.push(item[this.data('tempValues')[j]]);
											}
										}
									}
								}
								
								var gridBodyTable = this.find('table');
								if (tempHTML.length > 0) {
									gridBodyTable
											.find('tbody')
											.html(tempHTML.join(""));
									for(var i=0;i<htmlTD.length;i++){
										gridBodyTable.find('tbody tr:eq('+i+') td[type=tree] input').before(htmlTD[i]);
									}
								} else if (tempHTML.length == 0) {
									var _tr = $('<tr/>').html("<td><font color='red' align='center'>暂无数据</td>");
									gridBodyTable.find('tbody').html(_tr);
								}
								gridBodyTable.removeClass('hide');
							},
							
							//计算Grid-Body的高度，并自动设置PageSize的大小
							computeGridBodyHeight: function(dc) {
								var $this = this;
								return this.each(function(){
									var topHeight = parseInt($(window.top.document.body).height(), 10),
										pageTopHeight = parseInt($(window.top.document.body).find('div.pageTop').height(), 10),
										gridHeaderTop = parseInt(_gridHeader.offset().top, 10);
										gridHeaderHeight = parseInt(_gridHeader.find('table').height(), 10),
										gridToolBarHeight = _grid.toolBar ? parseInt(_grid.toolBar.height(), 10) : 0,
										gridBodyHeight = topHeight - pageTopHeight - gridHeaderTop - gridHeaderHeight- gridToolBarHeight - 30,
										gridBodyWidth = _gridHeader.find('table').width();
										
									$this.css({
										width: gridBodyWidth,
										height: Math.floor((gridBodyHeight)/gridHeaderHeight) * $this.find('table').height() 
									});
									if (dc.map['scroll'] == 'true') {
										$this.css({
											"overflow-x": 'hidden',
											"overflow-y": 'auto'
										});
									} else {
										dc.add(Constant.size, Math.floor(gridBodyHeight/gridHeaderHeight));
									}
								});
							},
							//树菜单中父菜单获取子菜单
							setChild: function(data,id){
								var jsonData = "";
								for(var i=0;i<data.length;i++){
									var item = data[i];
									if(item.parentid == id){
										jsonData += JSON.stringify(item)+",";
										jsonData += this.setChild(data,item.id);
									}
								}
								return jsonData;
							},
							//
							treeClick: function(ele){
								var td = ele.parentNode;
								var tr,table;
								try{
									while(td){
										var tagName = td.tagName.toLowerCase();
										if(tagName=="tr"){
											tr = td;
										}
										if(tagName=="table"){
											table = td;
											break;
										}
										td = td.parentNode;
									}
								}catch(ex){alert(ex.message);}

								var hideFlag = false;
								if(ele.src.indexOf("butExpand")>0){
									ele.src = Server.ContextPath+"Framework/Images/butCollapse.gif";
									hideFlag = true;
								}else{
									ele.src = Server.ContextPath+"Framework/Images/butExpand.gif";
								}
								var rows = table.rows;
								var level = parseInt(tr.getAttribute("level"));
								for(var i=0;i<rows.length;i++){
									if(rows[i]===tr){
										for(var j=i+1;j<rows.length;j++){
											var r = $(rows[j]);
											if(parseInt(r.attr("level"))>level){
												if(hideFlag){
													if(r.css("display")!="none"){
														r.attr("_TreeHideLevel",level);
														r.css("display","none");
													}
												}else{
													if(r.attr("_TreeHideLevel")==level){
														r.css("display","");
														r.attr("_TreeHideLevel",null);
													}
												}
											}else{
												break;
											}
										}
										break;
									}
								}
							},
							//获取选中的行（jQuery数组的形式返回）
							getSelectedRows: function(){
								return this.find('input[type=checkbox]:checked').parent().parent();
							},
						
							//获取选中的行，以数组形式返回被选中的行
							getSelectedRowsData: function(){
								var rowData = [];
								
								this.find('input[type=checkbox]:checked').each(function(){
									var _this = $(this);
									
									rowData.push(_this.val());
								});
								
								return rowData;
							},
						
							checkPublishStatus: function(){
								$('.audiot>.aswitch').each(function(){
									var btn = $(this).children('.btn');
									if(btn.attr("status") == "1" ) {
										btn.text(btn.attr("statusName")).animate({left:'25px'});
										$(this).removeClass('closed').addClass('open');
									} else {
										btn.text(btn.attr("statusName")).animate({left:'-1px'});
										$(this).removeClass('open').addClass('closed');
									}
								});
								$(".contentBoxRight").countWidth([".tree"]);
							}
					});
			
			
			
			//创建DataGrid对象并添加相应处理方法
			var _grid = $("<div/>")
					.attr("id", this.attr('id'))
					.addClass('data-grid')
					.appendTo(_gridHeader.parent())
					.append(_gridHeader)
					.append(_gridBody)
					.extend({
						//默认的配置参数，通过设置属性修改
						defaults: (function() {
							var dc = new DataCollection();
							
							dc.add(Constant.page, "true");
							dc.add(Constant.pageIndex, 0);
							dc.add(Constant.size, 10);
							dc.add(Constant.total, 0);
							dc.add(Constant.method, "");
							dc.add("multiselect", "false");
							dc.add("scroll", "false");
							dc.add("autofill", "false");
							dc.add("lazy", "false");
							dc.add("dealmethod", "com.sobey.bsp.framework.controls.DataGridPage.doWork");
							
							return dc;
						})(), 
						
						//初始化DataGrid
						initGrid: function(options) {
							var $this = this;
							return this.each(function() {
								var dc = (function(_this, o){
									var dc = new DataCollection(),
										optionDC = (typeof o != 'undefined' && typeof o != 'function' 
												&& typeof o.dc != 'undefined' && o.dc instanceof DataCollection) 
												? o.dc 
												: new DataCollection(),
										attrs = _this.gridHeader.find('table')[0].attributes;
									
									for ( var i = 0; i < attrs.length; i++) {
										var key = attrs[i].name;
										
										if (typeof Constant[key] != 'undefined') {
											dc.add(Constant[key], attrs[i].value);
										} else if (typeof _this.defaults.map[key] != 'undefined') {
											dc.add(key, attrs[i].value);
										} else {
											continue;
										}
									}
									dc.add(Constant.id, _this.attr('id'));
									
									dc.map = $.extend(true, new Object(), _this.defaults.map, dc.map, optionDC.map);
									dc.valuetype = $.extend(true, new Object(), _this.defaults.valuetype, dc.valuetype, optionDC.valuetype);
									$.merge(dc.keys, _this.defaults.keys);
									$.merge(dc.keys, optionDC.keys);
									//判断是否需要ToolBar(批量操作、分页)
									if (dc.get(Constant.page) == 'true' 
										|| (typeof o != 'undefined' 
											&& typeof o.operations != 'undefined')) {
										_this.initToolBar(
												(typeof o != 'undefined' 
													&& typeof o.operations != 'undefined') 
													? o.operations : null);
									} 
									_this.gridHeader.checkAllConditions(dc);
									_this.gridBody.computeGridBodyHeight(dc).setTemplateWidth().setTemplateHTML();
									
									return dc;
								})($this, options);
								
								$this.data('params', dc);
							});
						},
						
						//加载更新DataGrid
						loadData: function(dc, callback) {
							var args = arguments;
							var $this = this;
							return this.each(function(){
								$this.data('isLoading', 'true'); 
								$this.checkLoadingStatus();
								if (args.length >= 1) {
									var dCollection;
									if (typeof dc != 'undefined' && dc instanceof DataCollection){
										dCollection = dc;
									}
									if (dCollection) {
										$.extend(true, $this.data('params').map, dCollection.map);
										$.extend(true, $this.data('params').valuetype, dCollection.valuetype);
										$.merge($this.data('params').keys, dCollection.keys);
									}
								}
								$.vmsAjax({method: $this.data('params').get("dealmethod"), dc: $this.data('params')}, null, function(response){
									$this.dealData(response);
									$this.checkLoadingStatus();
									$this.gridBody.checkPublishStatus();
									
									if (typeof args[0] == 'function') {
										args[0]();
									} else if (typeof callback == 'function') {
										callback();
									}
								});
							})
						},
						
						//处理后台传回的数据
						dealData: function(dc) {
							var $this = this;
							return this.each(function(){
								if (typeof dc != 'undefined' && dc instanceof DataCollection) {
									$this.data(Constant.gridData, dc.get(Constant.gridData));
									dc.remove(Constant.gridData);
									$.extend(true, $this.data('params').map, dc.map);
									$.extend(true, $this.data('params').valuetype, dc.valuetype);
									$.merge($this.data('params').keys, dc.keys);
									var json = eval('(' + $this.data(Constant.gridData) + ')');
									
									if ($this.data('params').get(Constant.page) == 'true') {
										if (json.total == 0) {
											if ($this.toolBar && $this.toolBar.gridPageBar) {
												$this.toolBar.gridPageBar.addClass('hide');
											}
										} else {
											if (json.data.length == 0) {
												$this.data('params').map[Constant.pageIndex] = 0;
												$this.loadData();
												return;
											}
											$this.data('params').map[Constant.pageIndex] = json.page;
											$this.data('params').map[Constant.total] = json.total;
											$this.toolBar.initPageBar(json.page, $this.data('params').map[Constant.size], json.total);
										}
									}
									$this.gridBody.setInnerHTML(json.data);
								}
								$this.data('isLoading', 'false');
							});
						},
						
						//检查是否正在加载数据，如果是添加加载的样式
						checkLoadingStatus: function(){
							var $this = this;
							return this.each(function(){
								if ($this.data('isLoading') == 'true') {
									if ($this.find('div.grid-loading').length == 0) {
										$('<div/>')
											.attr('id', $this.attr('id') + "Loading")
											.attr('class', 'grid-loading hide')
											.html('<div>&nbsp;</div>')
											.appendTo($this);
									}
									$this.find('div.grid-loading')
										.removeClass('hide')
										.css({
											width: _gridBody.width(),
											height: _gridBody.height(),
											top: _gridHeader.find('table tbody tr:eq(0)').height()
										});
									
								} else {
									$this.find('div.grid-loading').addClass('hide');
								}
							});
						},
						
						//初始化ToolBar
						initToolBar: function(o) {
							var $this = this;
							
							return this.each(function(){
								$("<div/>")
										.attr('id', $this.attr('id')+'_ToolBar')
										.addClass('toolbar')
										.appendTo($this)
										.vmsToolBar($this, o);
							});
						},
						
					//持有DataGrid Header对象
					gridHeader: _gridHeader,
					
					//持有DataGrid Body对象
					gridBody: _gridBody
				});
			
			//防止页面查询gid出错
			_gridHeader
				.find('table')
				.removeAttr('id')
				.find('tbody tr:eq(1)')
				.remove();
			
			_gridBody
				.find('table')
				.removeAttr('id')
				.find('tbody')
				.find('tr:eq(0)')
				.remove();
			
			//将DataGrid对象赋予window[gid]变量，方便页面上的调用
			window[_grid.attr('id')] = _grid;
			
			return this.each(function(){
				if (!_grid.data('isInit')) {
					_grid
						.initGrid(options)
						.loadData(
								args.length == 2 
								    ? callback 
								    : ((typeof args[0] == 'function')
								    		? args[0] 
								    		: null))
						.data('isInit', 'true');
				}
			}).extend({DataGrid: _grid});
			
	};
	
})(window.jQuery);