/**
 * DataList(缩略图)相应接口及处理方法
 */
(function($){
	$.fn.vmsDataList = function(options, callback) {
		//创建DataList body,并添加相应的处理方法
		var _listBody = $("<ul/>")
					.attr('id', this.attr("id") + "Body")
					.addClass('list-body')
					.appendTo(this.parent())
					.append($("<li/>").append(this))
					.on('mouseover mouseout', 'li', function(e){
						e.preventDefault();
						e.stopPropagation();
						
						var _this = $(this);
						if (e.type == 'mouseover') {
							_this.addClass('hover');
						} else {
							if (_this.find('input:checked').length == 1) {
								return false;
							}
							_this.removeClass('hover');
						}
					})
					.on('mouseover mouseout', 'div.tu', function(e){
						e.preventDefault();
						
						var _this = $(this);
						if (e.type == 'mouseover') {
							_this.children(".videoBtn").show();
						} else {
							_this.children(".videoBtn").hide();
						}
					})
					.on('click', 'input[type=checkbox]', function(e) {
						e.stopPropagation();
						
						var _this = $(this),
							_spanCheckedNum = $('span.checkedNum'),
							_operBtn = $('div.opersBtn'),
							_selectAll = $('input[id=selectAll]'); 
						
						if (_this.is(":checked")) {
							_operBtn.removeClass('hide');
							_spanCheckedNum.html(parseInt(_spanCheckedNum.html(), 10) + 1);
							if (_spanCheckedNum.html() == $('ul.list-body').find('li').length) {
								_selectAll.attr('checked', 'checked');
							}
						} else {
							_selectAll.removeAttr('checked');
							_spanCheckedNum.html(parseInt(_spanCheckedNum.html(), 10) - 1);
							if (_spanCheckedNum.html() == 0) {
								_operBtn.addClass('hide');
							}
						}
					})
					.extend({
						//设置模板HTML（包含${filed}）
						setTemplateHTML: function(){
							return this.each(function(){
								var $this = $(this);
								$this.data(Constant.templateBody, $this.html());
							});
						},
						
						//处理、解析模板HTML
						dealTemplateHTML: function(){
							return this.each(function(){
								var $this = $(this);
								if ($this.data(Constant.templateBody)) {
									var reg = new RegExp("\\$\\{(\\w+?)\\}", "g");
										temHtml = $this.data(Constant.templateBody),
										tempHtmlArr = [],
										tempValues = [],
										prevIndex = 0;
									
									while ((result = reg.exec(temHtml)) != null) 
									{
										tempValues.push(result[0].substring(2, result[0].length - 1).toLocaleLowerCase());
										tempHtmlArr.push(temHtml.substring(prevIndex, result.index));
										prevIndex = reg.lastIndex;
									}
									tempHtmlArr.push(temHtml.substring(prevIndex, temHtml.length));
									$this.data('tempHTMLArr', tempHtmlArr);
									$this.data('tempValues', tempValues);
								}
							});
						},
						
						//设置body的HTML
						setInnerHTML: function(data){
							if (!this.data('tempValues')) {
								this.dealTemplateHTML();
							}
							var tempHTML = [];
							for ( var i = 0; i < data.length; i++) {
								var item = data[i];
								for ( var j = 0; j < this.data('tempHTMLArr').length; j++) {
									tempHTML.push(this.data('tempHTMLArr')[j]);
									if (j < this.data('tempValues').length) {
										/*if (this.data('tempValues')[j] == 'ROW_NO') {
											tempHTML.push(i);
										} else {*/
											tempHTML.push(item[this.data('tempValues')[j]]);
										//}
									}
								}
							}
							if (tempHTML.length > 0) {
								this.html(tempHTML.join(""));
							} else if (tempHTML.length == 0) {
								this.html("");
							}
							this.find('div.liBox').removeClass('hide');
							this.data(Constant.listData, data);
						},
						
						//计算List-Body的高度，并自动设置PageSize的大小
						computeListBodyHeight: function(dc) {
							var $this = this;
							return this.each(function(){
								var topHeight = parseInt($(window.top.document.body).height(), 10),
									pageTopHeight = parseInt($(window.top.document.body).find('div.pageTop').height(), 10),
									listOperTop = parseInt(_listOpers.offset().top, 10);
									listOperHeight = parseInt(_listOpers.height(), 10),
									listToolBarHeight = _list.toolBar ? parseInt(_list.toolBar.height(), 10) : 0,
									listBodyHeight = topHeight - pageTopHeight - listOperTop - listOperHeight- listToolBarHeight - 30,
									listBodyWidth = _listOpers.width(),
									_li = $this.find('li:eq(0)'),
									_width = parseInt(_li.width(), 10) + parseInt(_li.css("marginRight"), 10),
									_height = parseInt(_li.height(), 10) + parseInt(_li.css("marginBottom"), 10);
									
								$this.css({
									width: listBodyWidth - 20,
									height: listBodyHeight 
								});
								if (dc.map['scroll'] == 'true') {
									$this.css({
										"overflow-x": 'hidden',
										"overflow-y": 'auto'
									});
								} else {
									dc.add(Constant.size, Math.floor(
											(listBodyWidth - 20)/_width) 
												* Math.floor((listBodyHeight - 20)/_height));
								}
						});
					},
					
					//获取选中的Libox,以jQuery数组对象的方式返回
					getCheckedItems: function(){
						return this.find('input[type=checkbox]:checked').parents("li.hover");
					},
					
					//获取选中的值，以数组形式返回被选中的行
					getCheckedItemsValue: function(){
						var values = [];
						
						this.getCheckedItems().each(function(){
							var _this = $(this);
							
							values.push(_this.find('input[type=checkbox]').val());
						});
						
						return values;
					},
					
					//获取选中的数据,以数组的形式返回
					getCheckedItemsData: function(){
						var checkedData = []
							$this = this;
						
						this.getCheckedItems().each(function(){
							var _this = $(this);
							
							checkedData.push($this.data(Constant.listData)[_this.index()]);
						});
						
						return checkedData;
					}
				}),
			//创建DataList Operations,并添加相应的处理方法
			_listOpers = $("<div/>")
					.attr('id', this.attr('id') + "Opers")
					.addClass('list-opers')
					.extend({
						//初始化Operations
						initOperations: function(o){
							var $this = this;
							return this.each(function(){
								if (o) {
									var operations = o.Opers,
										moreOpers = o.moreOpers,
										_input = $("<input/>")
											.attr('type', 'checkbox')
											.attr('name', 'AllCheck')
											.attr('id', 'selectAll')
											.on('click', function(){
												var _this = $(this),
													ulList = $this.siblings('ul.list-body');  
															
												if (_this.is(":checked")) {
													ulList
														.find('li')
														.removeClass('hover')
														.addClass('hover')
														.find('input[type=checkbox]')
														.attr('checked', 'checked');
													$this.find('div.opersBtn')
														.removeClass('hide')
														.find('span.checkedNum')
														.html(ulList.find('li').length);
												} else {
													ulList
														.find('li')
														.removeClass('hover')
														.find('input[type=checkbox]')
														.removeAttr('checked');
													$this.find('div.opersBtn')
														.addClass('hide')
														.find('span.checkedNum')
														.html(0);
												}
											})
											.appendTo($this),
										_operBtn = $("<div/>")
											.attr('id', $this.parent().attr('id') + 'OpersBtn')
											.attr('class', 'opersBtn hide')
											.append($('<span/>')
											.attr('class', 'tits')
											.text("已选中")
											.append($('<span/>')
												.addClass('checkedNum')
												.text('0'))
											.append('个文件'))
											.appendTo($this);
									
									if (typeof operations != 'undefined' && operations.length > 0) {
										var inputBtn = $('<input/>')
												.attr('type', 'button')
												.addClass('lm2Btn');
										
										for ( var i = 0; i < operations.length; i++) {
											var cloneInput = inputBtn.clone()
														.attr('id', "op_"+i+"")
														.val(operations[i].text)
														.on('click', (function(index) {
															return function(){
															operations[index].handler.call(this, operations[index].args);
															};
														})(i))
														.appendTo(_operBtn);
											
											if (operations[i].status == 'disabled') {
												cloneInput.attr('disabled', 'disabled');
											}
										}
									}
									
									if (typeof moreOpers != 'undefined' && moreOpers.length > 0) {
										var _select = $('<div/>')
												.addClass('select')
												.attr('id', $this.parent().attr('id') + 'Select')
												.append($('<span/>').css("display", "block"))
												.append($('<a/>').attr('href', 'javascript:void(0)').html('更多'))
												.appendTo(_operBtn),
											_ul = $('<ul/>')
												.insertBefore(_select.find('span'))
												.css("display", "none"),
												_li = $('<li/>');
										
										for ( var i = 0; i < moreOpers.length; i++) {
											var cloneLi = _li.clone()
														.attr('id', "moreOp_"+i+"")
														.html(moreOpers[i].text)
														.on('click', (function(index) {
															return function(){
																moreOpers[index].handler.call(this, moreOpers[index].args);
															};
														})(i))
														.appendTo(_ul);
											
											if (moreOpers[i].status == 'disabled') {
												cloneLi.addClass('dis');
											}
										}
										_select.selectCopy();
									}
								}
							});
						}
					}),
			//创建DataList,并添加相应的处理方法
			_list = $("<div/>")
				.attr("id", this.attr('id'))
				.addClass('data-list')
				.appendTo(_listBody.parent())
				.append(_listOpers)
				.append(_listBody)
				.extend({
					//默认的配置参数
					defaults: (function() {
						var dc = new DataCollection();
						
						dc.add(Constant.page, "true");
						dc.add(Constant.pageIndex, 0);
						dc.add(Constant.size, 10);
						dc.add(Constant.total, 0);
						dc.add(Constant.method, "");
						dc.add("multiselect", "false");
						dc.add("scroll", "false");
						dc.add("autofill", "false");
						dc.add("lazy", "false");
						dc.add("dealmethod", "com.sobey.bsp.framework.controls.DataListPage.doWork");
						
						return dc;
					})(),
					
					//初始化DataList
					initList: function(options){
						var $this = this;
						return this.each(function() {
							var dc = (function(_this, o){
								var dc = new DataCollection(),
									optionDC = (typeof o != 'undefined' && typeof o != 'function' 
											&& typeof o.dc != 'undefined' && o.dc instanceof DataCollection) 
											? o.dc 
											: new DataCollection(),
									attrs = _this.listBody.find('li:eq(0) div.liBox')[0].attributes;
								
								for ( var i = 0; i < attrs.length; i++) {
									var key = attrs[i].name;
									
									if (typeof Constant[key] != 'undefined') {
										dc.add(Constant[key], attrs[i].value);
									} else if (typeof _this.defaults.map[key] != 'undefined') {
										dc.add(key, attrs[i].value);
									} else {
										continue;
									}
								}
								dc.add(Constant.id, _this.attr('id'));
								
								dc.map = $.extend(true, new Object(), _this.defaults.map, dc.map, optionDC.map);
								dc.valuetype = $.extend(true, new Object(), _this.defaults.valuetype, dc.valuetype, optionDC.valuetype);
								$.merge(dc.keys, _this.defaults.keys);
								$.merge(dc.keys, optionDC.keys);
								//判断是否需要ToolBar(批量操作、分页)
								if (dc.get(Constant.page) == 'true' 
									|| (typeof o != 'undefined' 
										&& typeof o.operations != 'undefined')) {
									_this.initToolBar(
											(typeof o != 'undefined' 
												&& typeof o.operations != 'undefined') 
												? o.operations : null);
								} 
								if ((typeof o != 'undefined' && typeof o.moreOpers != 'undefined') 
									|| (typeof o != 'undefined' 
										&& typeof o.Opers != 'undefined')) {
									_this.listOpers.initOperations(o);
								}
								//_this.gridBody.checkAllConditions(dc);
								_this.listBody.computeListBodyHeight(dc).setTemplateHTML();
								
								return dc;
							})($this, options);
							
							$this.data('params', dc);
				});
			},
			
			//处理后台传回数据
			dealData: function(dc){
				var $this = this;
				return this.each(function(){
					if (typeof dc != 'undefined' && dc instanceof DataCollection) {
						$this.data(Constant.listData, dc.get(Constant.listData));
						dc.remove(Constant.listData);
						$.extend(true, $this.data('params').map, dc.map);
						$.extend(true, $this.data('params').valuetype, dc.valuetype);
						$.merge($this.data('params').keys, dc.keys);
						var json = eval('(' + $this.data(Constant.listData) + ')');
						
						if ($this.data('params').get(Constant.page) == 'true') {
							if (json.total == 0) {
								if ($this.toolBar && $this.toolBar.gridPageBar) {
									$this.toolBar.gridPageBar.addClass('hide');
								}
							} else {
								if (json.data.length == 0) {
									$this.data('params').map[Constant.pageIndex] = 0;
									$this.loadData();
									return;
								}
								$this.data('params').map[Constant.pageIndex] = json.page;
								$this.data('params').map[Constant.total] = json.total;
								$this.toolBar.initPageBar(json.page, $this.data('params').map[Constant.size], json.total);
							}
						}
						$this.listBody.setInnerHTML(json.data);
					}
					$this.data('isLoading', 'false');
				});
			},
			
			//更新DataList
			loadData: function(dc, callback){
				var args = arguments;
				var $this = this;
				return this.each(function(){
					$this.data('isLoading', 'true'); 
					$this.checkLoadingStatus();
					if (args.length >= 1) {
						var dCollection;
						if (typeof dc != 'undefined' && dc instanceof DataCollection){
							dCollection = dc;
						}
						if (dCollection) {
							$.extend(true, $this.data('params').map, dCollection.map);
							$.extend(true, $this.data('params').valuetype, dCollection.valuetype);
							$.merge($this.data('params').keys, dCollection.keys);
						}
					}
					$.vmsAjax({method: $this.data('params').get("dealmethod"), dc: $this.data('params')}, null, function(response){
						$this.dealData(response);
						$this.checkLoadingStatus();
						//$this.listBody.checkPublishStatus();
						
						if (typeof args[0] == 'function') {
							args[0]();
						} else if (typeof callback == 'function') {
							callback();
						}
					});
				});
			},
			
			//判断是否需要添加加载样式
			checkLoadingStatus: function(){
				var $this = this;
				return this.each(function(){
					if ($this.data('isLoading') == 'true') {
						if ($this.find('div.list-loading').length == 0) {
							$('<div/>')
								.attr('id', $this.attr('id') + "Loading")
								.attr('class', 'list-loading hide')
								.html('<div>&nbsp;</div>')
								.appendTo($this);
						}
						$this.find('div.list-loading')
							.removeClass('hide')
							.css({
								width: $this.listBody.width(),
								height: $this.listBody.height(),
								top: parseInt($this.listOpers.height(), 10) 
									+ parseInt($this.listOpers.css("paddingTop"), 10)
									+ parseInt($this.listOpers.css("borderBottom"), 10),
								left: 20
							});
						
					} else {
						$this.find('div.list-loading').addClass('hide');
					}
				});
			},
			
			//初始化toolbar
			initToolBar: function(o){
				var $this = this;
				
				return this.each(function(){
					$("<div/>")
							.attr('id', $this.attr('id')+'_ToolBar')
							.addClass('toolbar')
							.appendTo($this)
							.vmsToolBar($this, o);
				});
			},
			
			getCheckedItems: function(){
				return this.listBody.getCheckedItems();
			},
			
			getCheckedItemsValue: function(){
				return this.listBody.getCheckedItemsValue();
			},
			
			getCheckedItemsData: function(){
				return this.listBody.getCheckedItemsData();
			},
			
			//持有Operations对象
			listOpers: _listOpers,
			
			//持有Body对象
			listBody: _listBody
		}),
		args = arguments;
		
		//防止页面查询lid出错
		_listBody
			.find('li:eq(0) div.liBox')
			.removeAttr('id');
		
		//将DataList对象赋予window[lid]变量，方便页面上的调用
		window[_list.attr('id')] = _list;
		
		return this.each(function(){
			if (!_list.data('isInit')) {
				_list
					.initList(options)
					.loadData(
							args.length == 2 
							    ? callback 
							    : ((typeof args[0] == 'function')
							    		? args[0] 
							    		: null))
					.data('isInit', 'true');
			}
		}).extend({DataGrid: _list});
	}
})(window.jQuery);