/**
 * 用于处理页面Form相关接口
 */
(function($) {
	$.fn.vmsForm = function(options, callback) {
		var option = $.extend({callback: callback}, $.fn.vmsForm.defaults, options);
		
		if (typeof option == 'object') {
			if (option.autoCommit === true) {
				this.vmsForm.ajaxForm.call(this, option);
			} else if (typeof option.methodName != 'undefined') {
				this.vmsForm[option.methodName].call(this, option);
			}
		}
	};
	
	$.extend($.fn.vmsForm, {
		defaults: {
			//控制表单是否自动提交的开关（true:自动提交）
			autoCommit: false
		},
		
		//以DataCollection形式返回表单元素数据（包括非规范化的表单元素，如：div.select 自定义的下拉框）
		getData: function(option) {
			if (this[0].nodeName.toLowerCase() != 'form') {
				return;
			}
			var dc = new DataCollection();
			var selects = this.find('div.select');
			
			$(this[0].elements).each(function(){
				var _this = $(this);
				var id = _this.attr("id");
				var type = this.type;
				
				if (!type) {
					return;
				}
				if (type == 'checkbox' || type == 'radio') {
					if (_this.attr("name") && _this.is(":checked")) {
						dc.add(_this.attr("name"), _this.val());
					}
					return;
				}
				if (!id) {
					return;
				}
				if (type == 'select-one') {
					dc.add(id, _this.find("option:selected").attr("value"));
					return;
				}
				
				dc.add(id, _this.val());
			});
			selects.each(function(){
				var _this = $(this);
				
				if (_this.children('a').length > 0) {
					dc.add(_this.attr('id'), _this.children('a').attr('value'));
				}
			});
			
			return dc;
		},
		
		//autoCommit为true时，自动提交表单
		ajaxForm: function(option) {
			if (typeof option == 'undefined' || Verify.hasError()) {
				return;
			}
			var dc = $.extend(true, new DataCollection(), option.dc, this.vmsForm.getData.call(this, option));
			
			//$.extend(true, target, [,object1], [,objectN])只深拷贝对象，所以要重新把对象中的数组元素进行合并
			if (typeof option.dc != 'undefined' && option.dc.keys.length > 0) {
				for (var i = 0; i < option.dc.keys.length; i++) {
					dc.keys.push(option.dc.keys[i]);
				}
			}
			$.vmsAjax({method: option.method, dc: dc, callback: option.callback});
		}
	});
	
	
})(window.jQuery);