/**
 * 用于处理页面完全加载后的接口
 */
(function($) {
	$.vmsPage = (function() {
		return {
			defaults: {
				
			},
			
			//DOM完全加载前的Callbacks队列
			onLoadFunctions: $.Deferred(),
			
			//将Callback添加进Callbacks的队列的接口
			onLoad: function(callback) {
				if (typeof $.vmsPage.onLoadFunctions != 'undefined' 
					  && $.vmsPage.onLoadFunctions instanceof $.Deferred) {
					$.vmsPage.onLoadFunctions.promise();
				}
				if (typeof callback == 'function') {
					$.vmsPage.onLoadFunctions.done(callback);
				}
			},
			
			//DOM完全加载后触发事件的接口
			load: function() {
				//执行Callbacks队列中的Callback（按照添加顺序执行）
				$.vmsPage.onLoadFunctions.resolve( document, [ jQuery ] );
			}
		}
	})();
	
	$(window).on('load', $.vmsPage.load);
})(window.jQuery);