/**
 * 批量操作、分页相关接口和处理方法
 */
(function($){
	$.fn.vmsToolBar = function(ele, o) {
		//创建ToolBar对象并添加相关处理方法
		var $this = this,
			_toolBar = $this 
					.extend({
						//根据所传参数创建批量处理操作
						initBatchOperations: function(o){
							var $this = this;
							return this.each(function(){
								if (o) {
									var operations = eval(o);
										_gridOp = $("<div/>")
											.addClass('fl')
											.append($("<input/>")
														.attr('type', 'checkbox')
														.attr('name', 'AllCheck')
														.attr('id', 'AllCheck')
														.on('click', function(){
															var _this = $(this);
															
															if (_this.is(":checked")) {
																ele.find('input[type=checkbox]').attr('checked', 'checked');
															} else {
																ele.find('input[type=checkbox]').removeAttr('checked');
															}
														}))
											.appendTo($this);
										
									for ( var i = 0; i < operations.length; i++) {
										$('<a/>')
											.attr('href', 'javascript:void(0)')
											.attr('id', "op_"+i+"")
											.html(operations[i].text)
											.on('click', (function(index) {
												return function(){
													operations[index].handler.call(this, operations[index].args);
												};
											})(i))
											.appendTo(_gridOp);
									}
								}
							});
						},
						
						//初始化分页条
						initPageBar: function(page, size, total){
							var $this = this;
							
							return this.each(function(){
								if ($this.gridPageBar) {
									//如果分页对象已存在，则更新分页信息
									$this.gridPageBar.removeClass('hide').refreshPageData(page, size ,total);
								} else {
									var pages = Math.ceil(total/size),
										//创建分页对象
										_gridPageBar = $('<div/>')
												.addClass('fr')
												.appendTo($this)
												.extend({
													//上一页
													getPrevPageData: function(){
														var pageData = this.data('pageData'), 
															current = this.find('a.current'),
															aNum = this.find('a.num'),
															isMove = false;
														
														--pageData.page;
														if (aNum.first().hasClass('current')) {
															if (pageData.page >= 0) {
																if (aNum.length == 6) {
																	isMove = true;
																} else {
																	isMove = false;
																}
																$('<a/>')
																	.attr('href', 'javascript:void(0)')
																	.attr('class', 'num')
																	.attr('page', parseInt(this.find('a.num:first').html(), 10) - 1)
																	.text(parseInt(this.find('a.num:first').html(), 10) - 1)
																	.insertAfter(this.find('b.prev'));
															}
														} 
														
														current.removeClass('current').prev().addClass('current');
														if (isMove == true) {
															this.find('a.num:last').remove();
														}
														this.data('pageData').page = pageData.page;
														this.loadPageData();
													},
													
													//下一页
													getNextPageData: function(){
														var pageData = this.data('pageData'), 
															current = this.find('a.current'),
															aNum = this.find('a.num');
															isMove = false;
													
														++pageData.page;
														if (aNum.length == 6 && aNum.last().hasClass('current')) {
															if ((pageData.page + 1) <= pageData.pages) {
																$('<a/>')
																	.attr('href', 'javascript:void(0)')
																	.attr('class', 'num')
																	.attr('page', pageData.page + 1)
																	.text(pageData.page + 1)
																	.insertBefore(this.find('b.next'));
																isMove = true;
															}
														} 
														
														current.removeClass('current').next().addClass('current');
														if (isMove == true) {
															this.find('a.num:first').remove();
														}
														this.data('pageData').page = pageData.page;
														this.loadPageData();
													},
													
													//首页
													getFirstPageData: function(){
														var $this = this;
														
														this.each(function(){
															$this.find('a.current').removeClass('current');
															
															if ($this.find('a.num:first').html() == '1') {
																$this.find('a.num:first').addClass('current');
															} else {
																$this.find('a.num').each(function(index){
																	var _this = $(this);
																	
																	_this
																		.attr('page', index + 1)
																		.html(index + 1);
																	if (index == 0) {
																		_this.addClass('current');
																	}
																});
															}
															$this.data('pageData').page = 0;
															$this.loadPageData();
														})
													},
													
													//最后一页
													getLastPageData: function(){
														var $this = this;
														
														return this.each(function(){
															$this.find('a.current').removeClass('current');
															
															if ($this.find('a.num:last').html() == $this.data('pageData').pages) {
																$this.find('a.num:last').addClass('current');
															} else {
																$this.find('a.num').each(function(index){
																	var _this = $(this);
																	
																	_this
																		.attr('page', $this.data('pageData').pages - 5 + index)
																		.html($this.data('pageData').pages - 5 + index);
																}).last().addClass('current');
															}
															$this.data('pageData').page = $this.data('pageData').pages - 1;
															$this.loadPageData();
														});
													},
													
													//当前页
													getCurrentPageData: function(){
														var current = this.find('a.current');
														
														this.data('pageData').page = parseInt(current.html(), 10) - 1;
														this.loadPageData();
													},
													
													//跳转
													jumpToPage: function(page){
														var $this = this;
														
														return this.each(function(){
															var pageNum = page || $this.find('input[type=text]').val();
																
															if (pageNum > $this.data('pageData').pages || pageNum == 0) {
																return false;
															} else if (pageNum == $this.data('pageData').pages) {
																$this.find('a.last').trigger('click');
																return false;
															} else if (pageNum == 1) {
																$this.find('a.first').trigger('click');
																return false;
															} else if ($this.find("a.num[page="+pageNum+"]").length > 0) {
																$this.find("a.num[page="+pageNum+"]").trigger('click');
																return false;
															}
															$this.find('a.current').removeClass('current');
															var aLength = $this.find('a.num').length,
																pageDis = $this.data('pageData').pages - pageNum,
																index = (pageNum % aLength == 0) 
																	? aLength 
																	: ((6 - pageNum % aLength) > pageDis) 
																			? 6 - pageDis
																			: pageNum % aLength;
															
															for ( var i = 1; i <= index; i++) {
																var aCurrent = $this.find("a.num:eq("+(i - 1)+")"); 
																
																aCurrent
																	.attr('page', pageNum - index + i)
																	.html(pageNum - index + i);
																if (i == index) {
																	aCurrent.addClass('current');
																}
															}
															for ( var j = (index + 1); j <= aLength; j++) {
																$this.find("a.num:eq("+(j - 1)+")")
																		.attr('page', ++pageNum)
																		.html(pageNum);
															}
															$this.data('pageData').page = parseInt($this.find('a.current').html(), 10) - 1;
															$this.loadPageData();
														});
													},
													
													//更新分页信息
													refreshPageData: function(page, size , total){
														var $this = this;
														return this.each(function(){
															var pages = Math.ceil(total/size),
																pageData = $this.data('pageData'),
																eles = $this.find('a.num'),
																$bNext = $this.find('b.next');
															
															if (pages > pageData.pages) {
																if (eles.length < 6) {
																	var addedNum = ((6 - eles.length) > (pages - pageData.pages)) 
																			? (pages - pageData.pages) 
																			: (6 - eles.length),
																		startNum = eles.last().html();
																	for ( var i = 0; i < addedNum; i++) {
																		eles.last().clone()
																			.attr('page', ++startNum)
																			.html(startNum)
																			.removeClass('current')
																			.insertBefore($bNext);
																	}
																}
															} else if (pages < pageData.pages) {
																var pageNum = pages >= 6 ? 6 : pages,
																	cloneObj = eles.first().clone().removeClass('current');
																
																eles.remove();
																for ( var i = 0; i < pageNum; i++) {
																	cloneObj
																		.attr("page", i+1)
																		.html(i + 1)
																		.insertBefore($bNext);
																}
																$this.find('a.num').first().addClass('current');
															}
															pageData.page = page;
															pageData.pages = pages;
															pageData.total = total;
															$.extend($this.data('pageData'), pageData);
															$this.find('span:eq(0)').html('共'+pages+'页/'+total+'条');
															$this.checkFirstPage();
															$this.checkLastPage();
														});
													},
													
													//加载所选分页信息
													loadPageData: function(){
														var $this = this;
														
														this.each(function(){
															var dc = new DataCollection();
															
															dc.add(Constant.pageIndex, $this.data('pageData').page);
															ele.loadData(dc);
														});
													},
													
													//检查是否是首页
													checkFirstPage: function(){
														var $this = this;
														return this.each(function(){
															if ($this.find('a.num:first').html() == 1 
																	&& $this.find('a.num:first').hasClass('current')) {
																$this.find('a.first').addClass('dis');
																$this.find('b.prev').find('a').addClass('disable');
															} else {
																$this.find('a.first').removeClass('dis');
																$this.find('b.prev').find('a').removeClass('disable');
															}
														})
													},
													
													//检查是否是最后一页
													checkLastPage: function(){
														var $this = this;
														return this.each(function(){
															if ($this.find('a.num:last').html() == $this.data('pageData').pages
																	&& $this.find('a.num:last').hasClass('current')) {
																$this.find('a.last').addClass('dis');
																$this.find('b.next').find('a').addClass('disable');
															} else {
																$this.find('a.last').removeClass('dis');
																$this.find('b.next').find('a').removeClass('disable');
															}
														});
													},
													
													//设置分页HTML（初始化时调用）
													setInnerHTML: function(){
														var $this = this,
															pageData = $this.data('pageData'),
															pageNum = pageData.pages <= 5 ? pageData.pages : 6,
															pagingBar = $('<div/>')
																.addClass('paging')
																.append($('<span/>').text('共'+pageData.pages+'页/'+pageData.total+'条'))
																.append($('<a/>')
																	.attr('href', 'javascript:void(0)')
																	.attr('class', 'first')
																	.html('First')
																	.on('click', function(){
																		var _this = $(this);
																		
																		if (_this.hasClass('dis')) {
																			return false;
																		}
																		$this.getFirstPageData();
																	}))
																.append($('<b/>')
																	.addClass('prev')
																	.append($('<a/>')
																		.attr('href', 'javascript:void(0)')
																		.on('click', function(){
																			var _this = $(this);
																			
																			if (_this.hasClass('disable')) {
																				return false;
																			}
																			$this.getPrevPageData();
																		})))
																.appendTo($this);
															
														for ( var i = 0; i < pageNum; i++) {
															$('<a/>')
																.attr('href', 'javascript:void(0)')
																.attr('class', (i == 0) ? 'num current' : 'num')
																.attr('page', ""+(i+1)+"")
																.text(""+(i+1)+"")
																.appendTo(pagingBar);
														}
														pagingBar
															.append($('<b/>')
																.addClass('next')
																.append($('<a/>')
																	.attr('href', 'javascript:void(0)')
																	.on('click', function(){
																		var _this = $(this);
																		
																		if (_this.hasClass('disable')) {
																			return false;
																		}
																		$this.getNextPageData();
																	})))
															.append($('<a/>')
																.attr('href', 'javascript:void(0)')
																.attr('class', 'last')
																.html('Last')
																.on('click', function(){
																	var _this = $(this);
																	
																	if (_this.hasClass('dis')) {
																		return false;
																	}
																	$this.getLastPageData();
																}))
															.append($('<span/>').text('跳转到：'))
															.append($('<input/>').attr('type', 'text'))
															.append($('<a/>')
																.attr('href', 'javascript:void(0)')
																.attr('class', 'jump')
																.html('Go')
																.on('click', function(){
																	$this.jumpToPage();
																}))
															.on('click', 'a.num', function(){
																var _this = $(this);
																
																if (_this.hasClass('current')) {
																	return false;
																} else {
																	$('a.current').removeClass('current');
																	_this.addClass('current');
																	$this.getCurrentPageData();
																}
															});
														if (pagingBar.find('a.current').html() != pageData.page + 1) {
															$this.jumpToPage(pageData.page + 1);
															return;
														}
														$this.checkFirstPage();
														$this.checkLastPage();
													}
												});
									_gridPageBar.data('pageData', {page: page, size: size, pages: pages, total: total}).setInnerHTML();
									$.extend($this, {gridPageBar: _gridPageBar});
							}
						});
					}
		});
		
		ele.extend({toolBar:  _toolBar});
		
		return this.each(function(){
			$this.initBatchOperations(o);
		});
	}
})(window.jQuery);