/**
 * 播放标签打点信息处理接口
 * @param $
 */
(function($) {
	$.fn.vmsPM0 = function(options) {
		var $this = this;
		var _pm0Header = $("<div/>")
					.addClass("t")
					.extend({
						initHtml: function(){
							var $this = this;
							
							return $this.each(function(){
								var _span = $("<span/>")
										.html("播放标签列表："),
									_font = $("<font/>")
										.attr("color", "red")
										.html("(最多支持10个标签)"),
									_a = $("<a/>")
										.addClass("button02")
										.attr("href", "javascript:void(0)")
										.on("click", function(){
											
											var dc = _PM0.getItemsData();
											$.vmsAjax({method: "com.sobey.scms.pointmessage.PointMessageFactory.savePointMessages", dc: dc}, null, function(response) {
												Dialog.alert(response.Message);
											});
										}).appendTo($this).html("保存").css("float", "right"),
									_preview = $("<a/>")
										.addClass("button02")
										.attr("href", "javascript:void(0)")
										.appendTo($this)
										.html("预览")
										.on("click", function(){
											window.open("../Default/PlayerPreview.jsp?mediaType=5&contentId="+contentID+"&cid="+cid+"&d="+new Date().getTime());
										}).css("float", "right");
								
								_span.append(_font).appendTo($this);
							});
						}
					});
		
		var _line = $("<div/>")
				.addClass("line")
				.addClass("hide")
				.extend({
					initHtml: function(){
						var $this = this;
						
						return $this.each(function(){
							$("<i/>")
								.addClass("lineTop")
								.appendTo($this);
							$("<i/>")
								.addClass("lineBot")
								.appendTo($this);
						});
					},
					
					show: function(){
						var $this = this;
						
						return $this.each(function(){
							if ($this.hasClass("hide")) {
								$this.removeClass("hide");
							}
						});
					},
					
					hide: function(){
						var $this = this;
						
						return $this.each(function(){
							$this.addClass("hide");
						});
					}
				});
		
		var _body = $("<div/>")
				.addClass("c")
				.extend({
					total: 0,
					addItem: function(item) {
						var $this = this;
						
						return $this.each(function(){
							var _item = $("<dl/>")
									.addClass("biaoqian_num")
									.appendTo($this),
								_dt = $("<dt/>")
									.html(item.time)
									.appendTo(_item),
								_dd = $("<dd/>")
									.appendTo(_item),
								_img = $("<img/>")
									.attr("width", "90")
									.attr("height", "60")
									.attr("src", item.src)
									.appendTo(_dd),
								_a = $("<a/>")
									.addClass("deleBtn")
									.attr("href", "javascript:void(0);")
									.appendTo(_dd),
								_div = $("<div/>")
									.addClass("ddnr")
									.appendTo(_dd),
								_textArea = $("<textarea/>").attr("onkeyup","cutString(this,32);")
									.attr("onkeydown","cutString(this,32);")
									.attr("onchange","cutString(this,32);")
									.addClass("ts")
									.html(item.description ? item.description : "请填写标签内容")
									.appendTo(_div);
							
							if (!$this.parents("td.bfbqRight").hasClass("background_null")) {
								$this.parents("td.bfbqRight").addClass("background_null");
							}
							_line.show();
							++$this.total;
						});
					},
					
					insertItem: function(item){
						var $this = this;
						
						return $this.each(function(){
							var _item = $("<dl/>")
									.addClass("biaoqian_num"),
								_dt = $("<dt/>")
									.html(item.time)
									.appendTo(_item),
								_dd = $("<dd/>")
									.appendTo(_item),
								_img = $("<img/>")
									.attr("width", "90")
									.attr("height", "60")
									.attr("src", item.src)
									.appendTo(_dd),
								_a = $("<a/>")
									.addClass("deleBtn")
									.attr("href", "javascript:void(0);")
									.appendTo(_dd),
								_div = $("<div/>")
									.addClass("ddnr")
									.appendTo(_dd),
								_textArea = $("<textarea/>").attr("onkeyup","cutString(this,32);")
									.attr("onkeydown","cutString(this,32);")
									.attr("onchange","cutString(this,32);")
									.addClass("ts")
									.html(item.description ? item.description : "请填写标签内容")
									.appendTo(_div)
									.focusin(function(){
										var _this = $(this),
											text = _this.val();
									
										if (text == '请填写标签内容') {
											_this.val("");
										}
									}).focusout(function(){
										var _this = $(this),
											text = _this.val();
									
										if (text.length == 0) {
											_this.val("请填写标签内容");
										}
									});
							
							if ($this.find("dl.biaoqian_num").length > 0) {
								_item.insertBefore($this.find("dl.biaoqian_num:first"));
							} else {
								_item.appendTo($this);
							}
							_line.show();
							++$this.total;
						});
					},
					
					removeItem: function(index){
						var $this = this;
						
						return $this.each(function(){
							$this.children().eq(index).remove();
							--$this.total;
							if ($this.total == 0) {
								_line.hide();
								$this.parents("td.bfbqRight").removeClass("background_null");
							}
						});
							
					},
					
					addBatchItems: function(data) {
						 var $this = this;
						 
						 return $this.each(function(){
							 if (data.length > 0) {
								 for(var i = 0; i < data.length; i++) {
									 $this.addItem(data[i]);
								 }
							 }
						 });
					},
					
					getItemsData: function() {
						var $this = this,
							_items = $this.children(),
							data = [],
							dc = new DataCollection();
						
						if (_items.length > 0) {
							_items.each(function(){
								var _this = $(this),
									time =  DateUtil.getTimeMillis(_this.find("dt").html())/1000 + "",
									src = _this.find("img").attr("src"),
									description = _this.find("textarea").val().replace(/\"/g, "\\\""),
									obj = {
										time: time,
										description: description
									};
								
								data.push(obj);
								dc.add(time, src);
							});
						}
						
						dc.add("data", data);
						return dc;
					}
				}).on("click", "a.deleBtn", function(e) {
					e.preventDefault();
					e.stopPropagation();
					
					var $this = $(this),
						_delItem = $this.parents("dl.biaoqian_num"),
						index = _delItem.index();
					
					_body.removeItem(index);
				});
		var _list = $("<div/>")
				.addClass("list")
				.append(_pm0Header)
				.append(_body)
				.extend({
					header: _pm0Header,
					body: _body
				});
		
		var _PM0 = $this;
		
		_PM0
			.append(_line)
			.append(_list)
			.extend({
				flag : 1,
				curID: "",
				init: function(options) {
					var $this = this;
						
					return $this.each(function(){
						$this.list.header.initHtml();
							
						if (options.json) {
							if (options.json.id) {
								$this.flag = 2;
								$this.curID = options.json.id;
								$this.list.body.addBatchItems(options.json.messages);
								$this.line.show();
							}
							
						}
					});
				},
				
				addItem: function(item){
					var $this = this;
					
					if (!$this.parent().hasClass("background_null")) {
						$this.parent().addClass("background_null");
					}
					if ($this.list.body.total == 10) {
						Dialog.alert("超出打点标签数限制");
						return;
					}
					return $this.each(function() {
						$this.list.body.insertItem(item);
					});
				},
				
				getItemsData: function(){
					var data = this.list.body.getItemsData(),
						json = {},
						dc = new DataCollection();
					
					json.contentID = contentID;
					json.contentSourceID = cSourceId;
					json.id = ((this.curID+"").length > 0 ? this.curID : "");
					json.messages = data.get("data");
					
					if ((json.messages.length == 0) && (json.id.length > 0)) {
						this.flag = 3;
					}
					json.flag = this.flag;
					data.remove("data");
					dc.add("type", "0");
					dc.add("pointMessage", JSON.stringify(json));
					dc.addAll(data);
					return dc;
				},
				
				removeItem: function(index){
					var $this = this;
					
					return $this.each(function(){
						$this.list.body.removeItem(index);
					});
				},
				
				clear: function(){
					var $this = this;
					
					return $this.each(function(){
						window[$this.attr("id")] = null;
					});
				},
				
				list: _list,
					
				line: _line
			});
		
		if (!$this.data("isInit")) {
			_PM0.init(options);
			$this.data("isInit", true);
		}
		
		return _PM0;
	}
})(window.jQuery);

/**
 * 互动演讲打点信息处理接口
 * @param $
 */
(function($) {
	$.fn.vmsPM1 = function(options) {
		var $this = this;
		var _pm1Header = $("<div/>")
					.addClass("t")
					.extend({
						initHtml: function(){
							var $this = this;
							
							return $this.each(function(){
								var _span = $("<span/>")
										.html("互动演讲列表："),
									_font = $("<font/>")
										.attr("color", "red")
										.html("(最多支持10个标签)"),
									_a = $("<a/>")
										.addClass("button02")
										.attr("href", "javascript:void(0)")
										.on("click", function(){
											var dc = _PM1.getItemsData();
											
											if (-1 == dc) {
												Dialog.alert("有图片未上传，请上传后保存");
												
												return;
											} else if (dc instanceof DataCollection){
												$.vmsAjax({method: "com.sobey.scms.pointmessage.PointMessageFactory.savePointMessages", dc: dc}, null, function(response) {
													Dialog.alert(response.Message);
												});
											}
										}).appendTo($this).html("保存").css("float", "right"),
									_preview = $("<a/>")
										.addClass("button02")
										.attr("href", "javascript:void(0)")
										.appendTo($this)
										.html("预览")
										.on("click", function(){
											window.open("../Default/PlayerPreview.jsp?mediaType=5&contentId="+contentID+"&cid="+cid+"&d="+new Date().getTime());
										}).css("float", "right");
								
								_span.append(_font).appendTo($this);
							});
						}
					});
		
		var _line = $("<div/>")
				.addClass("line")
				.addClass("hide")
				.extend({
					initHtml: function(){
						var $this = this;
						
						return $this.each(function(){
							$("<i/>")
								.addClass("lineTop")
								.appendTo($this);
							$("<i/>")
								.addClass("lineBot")
								.appendTo($this);
						});
					},
					
					show: function(){
						var $this = this;
						
						return $this.each(function(){
							if ($this.hasClass("hide")) {
								$this.removeClass("hide");
							}
						});
					},
					
					hide: function(){
						var $this = this;
						
						return $this.each(function(){
							$this.addClass("hide");
						});
					}
				});
		
		var _body = $("<div/>")
				.addClass("c")
				.extend({
					total: 0,
					addItem: function(item) {
						var $this = this;
						
						return $this.each(function(){
							var _item = $("<div/>")
									.addClass("biaoqian_num")
									.appendTo($this),
								_p = $("<p/>")
									.addClass("ddtime")
									.html(item.time ? item.time : "00:00:00")
									.appendTo(_item),
								_h200 = $("<div/>")
									.addClass("clearfloat")
									.addClass("h200")
									.appendTo(_item),
								_titleWrapper = $("<div/>")
									.addClass("sphdtittle")
									.appendTo(_h200),
								_titleText = $("<p/>")
									.html("标题")
									.appendTo(_titleWrapper),
								_titleInput = $("<input/>")
									.attr("type", "text")
									.addClass("shadowinput")
									.addClass("inputtext")
									.val(item.description ? item.description : "请填写标题")
									.appendTo(_titleWrapper)
									.focusin(function(){
										var _this = $(this),
											text = _this.val();
									
										if (text == '请填写标题') {
											_this.val("");
										}
									}).focusout(function(){
										var _this = $(this),
											text = _this.val();
									
										if (text.length == 0) {
											_this.val("请填写标题");
										}
									}),
								_titleNote = $("<p/>")
									.html("上传图片支持jpg和png格式，为保证演示质量，请尽量选择4:3比例的图片")
									.appendTo(_titleWrapper),
								_viewWrapper = $("<div/>")
									.addClass("view_img")
									.appendTo(_h200),
								_viewP = $("<p/>")
									.html("演示图片")
									.appendTo(_viewWrapper),
								_viewDiv = $("<div/>")
									.appendTo(_viewWrapper),
								_viewImgSpan = $("<span/>")
									.addClass("view")
									.appendTo(_viewDiv),
								_delSpan = $("<span/>")
									.addClass("del_teach")
									.appendTo(_viewDiv);
							
							if (!$this.parents("div.bfbqRight").hasClass("background_null")) {
								$this.parents("div.bfbqRight").addClass("background_null");
							}
							if (item.src) {
								var _viewImg = $("<img/>")
										.attr("src", item.src)
										.addClass("upload_img")
										.appendTo(_viewImgSpan);
							} else {
								_viewImgSpan
									.html("<div id='view_"+$this.total+"' class='upload_img'></div>")
									.find("div")
									.trigger("upload");
							}
							_line.show();
							++$this.total;
						});
					},
					
					insertItem: function(item) {
						var $this = this;
						
						return $this.each(function(){
							var _item = $("<div/>")
									.addClass("biaoqian_num"),
								_p = $("<p/>")
									.addClass("ddtime")
									.html(item.time ? item.time : "00:00:00")
									.appendTo(_item),
								_h200 = $("<div/>")
									.addClass("clearfloat")
									.addClass("h200")
									.appendTo(_item),
								_titleWrapper = $("<div/>")
									.addClass("sphdtittle")
									.appendTo(_h200),
								_titleText = $("<p/>")
									.html("标题")
									.appendTo(_titleWrapper),
								_titleInput = $("<input/>")
									.attr("type", "text")
									.addClass("shadowinput")
									.addClass("inputtext")
									.val(item.description ? item.description : "请填写标题")
									.appendTo(_titleWrapper)
									.focusin(function(){
										var _this = $(this),
											text = _this.val();
									
										if (text == '请填写标题') {
											_this.val("");
										}
									}).focusout(function(){
										var _this = $(this),
											text = _this.val();
									
										if (text.length == 0) {
											_this.val("请填写标题");
										}
									}),
								_titleNote = $("<p/>")
									.html("上传图片支持jpg和png格式，为保证演示质量，请尽量选择4:3比例的图片")
									.appendTo(_titleWrapper),
								_viewWrapper = $("<div/>")
									.addClass("view_img")
									.appendTo(_h200),
								_viewP = $("<p/>")
									.html("演示图片")
									.appendTo(_viewWrapper),
								_viewDiv = $("<div/>")
									.appendTo(_viewWrapper),
								_viewImgSpan = $("<span/>")
									.addClass("view")
									.appendTo(_viewDiv),
								_delSpan = $("<span/>")
									.addClass("del_teach")
									.appendTo(_viewDiv);
							
							if ($this.find("div.biaoqian_num").length > 0) {
								_item.insertBefore($this.find("div.biaoqian_num:first"));
							} else {
								_item.appendTo($this);
							}
							if (item.src) {
								var _viewImg = $("<img/>")
										.attr("src", item.src)
										.addClass("upload_img")
										.appendTo(_viewImgSpan);
							} else {
								_viewImgSpan
									.html("<div id='view_"+$this.total+"' class='upload_img'></div>")
									.find("div")
									.trigger("upload");
							}
							_line.show();
							++$this.total;
						});
					},
					
					removeItem: function(index){
						var $this = this;
						
						return $this.each(function(){
							$this.children().eq(index).remove();
							--$this.total;
							if ($this.total == 0) {
								_line.hide();
								$this.parents("div.bfbqRight").removeClass("background_null");
							}
						});
							
					},
					
					addBatchItems: function(data) {
						 var $this = this;
						 
						 return $this.each(function(){
							 if (data.length > 0) {
								 for(var i = 0; i < data.length; i++) {
									 $this.addItem(data[i]);
								 }
							 }
						 });
					},
					
					getItemsData: function() {
						var $this = this,
							_items = $this.children(),
							data = [],
							dc = new DataCollection();
						
						if (_items.length > 0) {
							var isImgExist = true;
							
							_items.each(function(){
								var _this = $(this),
									time =  DateUtil.getTimeMillis(_this.find(".ddtime").html())/1000 + "",
									description = _this.find("input.shadowinput").val().replace(/\"/g, "\\\""),
									_img = _this.find(".view").children("img");
								
								if (_img.length > 0) {
									var src = _this.find(".view").find("img").attr("src"),
										obj = {
											time: time,
											description: description,
											src: src
										};
									
									data.push(obj);
								} else {
									isImgExist = false;
								}
							});
							
							if (!isImgExist) {
								return -1;
							}
						}
						
						dc.add("data", data);
						return dc;
					}
				}).on("click", "span.del_teach", function(e) {
					e.preventDefault();
					e.stopPropagation();
					
					var $this = $(this),
						_delItem = $this.parents("div.biaoqian_num"),
						index = _delItem.index();
					
					_body.removeItem(index);
				}).on("upload", "span.view > div", function(){
					var _this = $(this),
						_parent = _this.parent("span");
					_this.uploadify({
						'buttonText': '',
						'customClass': true,//使用自定义的class
						'buttonClass': '',
						'swf'       : bPath+'/Plugin/VideoUploadify/uploadify.swf',
						'uploader': '../../ImageFrameUpload?siteId='+sid,
						'multi' : true,
						'auto' : true,
						'fileTypeExts':'*.jpg;*.png;*.gif',
						'fileTypeDesc':'只能选择jpg,png,gif格式图片',
						'fileSizeLimit': 864000,
						'queueID'	: 'file_queue',
						'queueSizeLimit':1,
						'onUploadSuccess' : function(file,data,response){
							var imageInfo=eval("("+data+")");
				 			var url = imageInfo.url;
							img="<img src='"+url+"' class='upload_img'/>";
							//IE下调用_parent.html(img)无效，可能是_parent内部元素造成的，所以采用原生javascript
							_parent.get(0).innerHTML=img;
						},
						'onUploadError': function(event, queueID, fileObj,errorObj){
							if(errorObj.type=='HTTP'){
								alert("连接异常，请重新登录");
								window.close();
							}
						}
					});
				}).on("dblclick", "img.upload_img", function(){
					var _this = $(this),
						_parent = _this.parents("div.view_img"),
						_titleWrapper = _parent.siblings("div.sphdtittle"),
						diag = new Dialog("UploadImg");
					
					_this.attr("isEdit", "true");
					diag.Width = 550;
					diag.Height = 420;
					diag.Top = 240;
					diag.MoveDirection = false;
					diag.Title = "";
					diag.URL = "UploadSpeechImage.jsp";
					diag.onLoad = function(){
						$("div.scimg").find("img").attr("src", _this.attr("src"));
						$("input").val(_titleWrapper.find("input").val());
					};
					diag.show();
				});
		
		var _list = $("<div/>")
				.addClass("list")
				.addClass("teach_box")
				.append(_pm1Header)
				.append(_body)
				.extend({
					header: _pm1Header,
					body: _body
				});
		
		var _PM1 = $this;
		
		_PM1
			.append(_line)
			.append(_list)
			.extend({
				flag : 1,
				curID: "",
				init: function(options) {
					var $this = this;
						
					return $this.each(function(){
						$this.list.header.initHtml();
							
						if (options.json) {
							if (options.json.id) {
								$this.flag = 2;
								$this.curID = options.json.id;
								$this.list.body.addBatchItems(options.json.messages);
								$this.line.show();
							}
							
						}
					});
				},
				
				addItem: function(item){
					var $this = this;
					
					if (!$this.parent().hasClass("background_null")) {
						$this.parent().addClass("background_null");
					}
					if ($this.list.body.total == 10) {
						Dialog.alert("超出打点标签数限制");
						return;
					}
					return $this.each(function() {
						$this.list.body.insertItem(item);
					});
				},
				
				getItemsData: function(){
					var data = this.list.body.getItemsData(),
						json = {},
						dc = new DataCollection();
					
					if (-1 == data) {
						return -1;
					}
					json.contentID = contentID;
					json.contentSourceID = cSourceId;
					json.id = ((this.curID+"").length > 0 ? this.curID : "");
					json.messages = data.get("data");
					
					if ((json.messages.length == 0) && (json.id.length > 0)) {
						this.flag = 3;
					}
					json.flag = this.flag;
					data.remove("data");
					dc.add("type", "1");
					dc.add("pointMessage", JSON.stringify(json));
					dc.addAll(data);
					return dc;
				},
				
				removeItem: function(index){
					var $this = this;
					
					return $this.each(function(){
						$this.list.body.removeItem(index);
					});
				},
				
				clear: function(){
					var $this = this;
					
					return $this.each(function(){
						window[$this.attr("id")] = null;
					});
				},
				
				list: _list,
					
				line: _line
			});
		
		if (!$this.data("isInit")) {
			_PM1.init(options);
			$this.data("isInit", true);
		}
		
		return _PM1;
	}
})(window.jQuery);

/**
 * 互动问答打点信息处理接口
 * @param $
 */
(function($) {
	$.fn.vmsPM2 = function(options) {
		var $this = this;
		var _pm2Header = $("<div/>")
					.addClass("t")
					.extend({
						initHtml: function(){
							var $this = this;
							
							return $this.each(function(){
								var _span = $("<span/>")
										.html("互动问答列表："),
									_font = $("<font/>")
										.attr("color", "red")
										.html("(最多支持10个标签)"),
									_a = $("<a/>")
										.addClass("button02")
										.attr("href", "javascript:void(0)")
										.on("click", function(){
											var dc = _PM2.getItemsData(),
												pointMessage = eval('(' + dc.get("pointMessage") + ')'),
												data = pointMessage.messages;
											
											if (data && data.length > 0) {
												for (var i = 0; i < data.length; i++) {
													var answers = data[i].answers;
													
													if (answers && answers.length > 0) {
														for (var j = 0; j < answers.length; j++) {
															var answer = answers[j];
															
															if (answer.isCorrect) {
																break;
															} else {
																if (j == answers.length - 1) {
																	Dialog.alert("请给第"+(i+1)+"道问答填写正确答案");
																	
																	return;
																}
															}
														}
													}
												}
											}
											$.vmsAjax({method: "com.sobey.scms.pointmessage.PointMessageFactory.savePointMessages", dc: dc}, null, function(response) {
												Dialog.alert(response.Message);
											});
										}).appendTo($this).html("保存").css("float", "right"),
									_preview = $("<a/>")
										.addClass("button02")
										.attr("href", "javascript:void(0)")
										.appendTo($this)
										.html("预览")
										.on("click", function(){
											window.open("../Default/PlayerPreview.jsp?mediaType=5&contentId="+contentID+"&cid="+cid+"&d="+new Date().getTime());
										}).css("float", "right");
								
								_span.append(_font).appendTo($this);
							});
						}
					});
		
		var _line = $("<div/>")
				.addClass("line")
				.addClass("hide")
				.extend({
					initHtml: function(){
						var $this = this;
						
						return $this.each(function(){
							$("<i/>")
								.addClass("lineTop")
								.appendTo($this);
							$("<i/>")
								.addClass("lineBot")
								.appendTo($this);
						});
					},
					
					show: function(){
						var $this = this;
						
						return $this.each(function(){
							if ($this.hasClass("hide")) {
								$this.removeClass("hide");
							}
						});
					},
					
					hide: function(){
						var $this = this;
						
						return $this.each(function(){
							$this.addClass("hide");
						});
					}
				});
		
		var _body = $("<div/>")
				.addClass("c")
				.extend({
					total: 0,
					answersHandler : $.extend({}, {
							initAnswerHtml : function(item, parent){
								var _proBox = $("<div/>")
										.addClass("pro_box")
										.html("<p>答案：</p>" +
										"<p class='back'>答题错误回退到<input type='text' class='inp inputtext backTo' value=''/>秒<span style='color:red;margin-left:2px;'>(-1表示不回退)</span></p>")
										.appendTo(parent);
									
								if (item.answers) {
									this.setBackToVal.call(_proBox, item.backTo);
									this.addBatchAnswerItems.call(_proBox, item.answers);
								} else {
									this.addAnswerItem.apply(_proBox);
								}
							
							},
							addAnswerItem : function(aItem){
								var _this = this;
								
								return _this.each(function(){
									var _answerBox = $("<div/>")
										.html("<input type='text' class='inp inputtext result' value=''/>" +
											  "<span class='add_answer'></span>" +
											  "<span class='cut_answer'></span>" +
											  "<span class='set_correct'></span>" +
											  "<span class='del_answer'></span>")
										.insertBefore(_this.find("p.back"));
									
									if (aItem) {
										var _result = _answerBox.find("input.result");
										
										_result
											.attr("isCorrect", aItem.isCorrect)
											.val(aItem.result);
										if (aItem.isCorrect == true) {
											_result.addClass("an_correct");
										} else {
											_result.addClass("an_wrong");
										}
										
									}
								});
							},
							addBatchAnswerItems: function(answers) {
								var _this = this;
								
								return _this.each(function(){
									if (answers) {
										for(var i = 0; i < answers.length; i++) {
											_body.answersHandler.addAnswerItem.call(_this, answers[i]);
										}
									}
								});
							},
							removeAnswerItem : function(index) {
								var _this = this;
								
								return _this.each(function(){
									if (_this.children("div").length == 1) {
										alert("无法删除，问题至少需要一个答案");
										return;
									}
									_this.children().eq(index).remove();
								});
							},
							markAnswer : function(flag) {
								var _this = this;
								
								return _this.each(function(){
									var _result = _this.find("input.result");
									
									_result.attr("isCorrect", flag);
									if (flag) {
										_result.removeClass("an_wrong");
										if (!_result.hasClass("an_correct")) {
											_result.addClass("an_correct");
										}
									} else {
										_result.removeClass("an_correct");
										if (!_result.hasClass("an_wrong")) {
											_result.addClass("an_wrong");
										}
									}
								});
							},
							setBackToVal : function(backTo) {
								this.find("input.backTo").val(backTo);
							},
							getAllAnswers: function(){
								var _this = this,
									answers = [];
								
								_this.children("div").each(function(){
									var $this = $(this),
										_input = $this.find("input"),
										result = _input.val().replace(/\"/g, "\\\""),
										isCorrect = _input.attr("isCorrect") == "true" ? true : false,
										obj = {
											result: result,
											isCorrect: isCorrect
										};
									
									answers.push(obj);
								});
								return answers;
							},
							show: function(){
								var _this = this;
								
								return _this.each(function(){
									_this.removeClass("hide");
								});
							},
							hide: function(){
								var _this = this;
								
								return _this.each(function(){
									if (!_this.hasClass("hide")) {
										_this.addClass("hide");
									}
								});
							}
						}),
					addItem: function(item) {
						var $this = this;
						
						return $this.each(function(){
							var _biaoDiv = $("<div/>")
									.addClass("biaoqian_num")
									.appendTo($this),
								_p = $("<p/>")
									.addClass("ddtime")
									.appendTo(_biaoDiv),
								_notbottom = $("<div/>")
									.addClass("clearfloat")
									.addClass("notbottom")
									.appendTo(_biaoDiv),
								_proImgDiv = $("<div/>")
									.addClass("pro_icoimg")
									.appendTo(_notbottom),
								_proImg = $("<img/>")
									.appendTo(_proImgDiv),
								_addProDiv = $("<div/>")
									.addClass("addpro")
									.html("<textarea class='shadowarea'></textarea>" +
											"<span class='del_pro'></span>" +
											"<span class='show_pro toggle'></span>")
									.appendTo(_notbottom);
							
							if (!$this.parents("div.bfbqRight").hasClass("background_null")) {
								$this.parents("div.bfbqRight").addClass("background_null");
							}
							if (item) {
								_p.html(item.time);
								_proImg.attr("src", item.src);
								_addProDiv.find("textarea").focusin(function(){
									var _this = $(this),
									text = _this.val();
							
									if (text == '请填写问题') {
										_this.val("");
									}
								}).focusout(function(){
									var _this = $(this),
										text = _this.val();
								
									if (text.length == 0) {
										_this.val("请填写问题");
									}
								}).val(item.question ? item.question : "请填写问题");
							}
							$this.answersHandler.initAnswerHtml(item, _biaoDiv);
							_line.show();
							++$this.total;
						});
					},
					
					insertItem: function(item) {
						var $this = this;
						
						return $this.each(function(){
							var _biaoDiv = $("<div/>")
									.addClass("biaoqian_num"),
								_p = $("<p/>")
									.addClass("ddtime")
									.appendTo(_biaoDiv),
								_notbottom = $("<div/>")
									.addClass("clearfloat")
									.addClass("notbottom")
									.appendTo(_biaoDiv),
								_proImgDiv = $("<div/>")
									.addClass("pro_icoimg")
									.appendTo(_notbottom),
								_proImg = $("<img/>")
									.appendTo(_proImgDiv),
								_addProDiv = $("<div/>")
									.addClass("addpro")
									.html("<textarea class='shadowarea'></textarea>" +
											"<span class='del_pro'></span>" +
											"<span class='show_pro toggle'></span>")
									.appendTo(_notbottom);
							
							if ($this.find("div.biaoqian_num").length > 0) {
								_biaoDiv.insertBefore($this.find("div.biaoqian_num:first"));
							} else {
								_biaoDiv.appendTo($this);
							}
							if (item) {
								_p.html(item.time);
								_proImg.attr("src", item.src);
								_addProDiv.find("textarea").focusin(function(){
									var _this = $(this),
									text = _this.val();
							
									if (text == '请填写问题') {
										_this.val("");
									}
								}).focusout(function(){
									var _this = $(this),
										text = _this.val();
								
									if (text.length == 0) {
										_this.val("请填写问题");
									}
								}).val(item.question ? item.question : "请填写问题");
							}
							$this.answersHandler.initAnswerHtml(item, _biaoDiv);
							_line.show();
							++$this.total;
						});
					},
					
					removeItem: function(index){
						var $this = this;
						
						return $this.each(function(){
							$this.children().eq(index).remove();
							--$this.total;
							if ($this.total == 0) {
								_line.hide();
								$this.parents("div.bfbqRight").removeClass("background_null");
							}
						});
							
					},
					
					addBatchItems: function(data) {
						 var $this = this;
						 
						 return $this.each(function(){
							 if (data.length > 0) {
								 for(var i = 0; i < data.length; i++) {
									 $this.addItem(data[i]);
								 }
							 }
						 });
					},
					
					getItemsData: function() {
						var $this = this,
							_items = $this.children(),
							data = [],
							dc = new DataCollection();
						
						if (_items.length > 0) {
							_items.each(function(){
								var _this = $(this),
									time = DateUtil.getTimeMillis(_this.find(".ddtime").html())/1000 + "",
									src = _this.find("div.pro_icoimg img").attr("src"),
									question = _this.find("textarea").val().replace(/\"/g, "\\\""),
									_proBox = _this.find("div.pro_box"),
									_backNum =_proBox.find("input.backTo").val() + "", 
									backTo = (_backNum.length > 0) ? _backNum : "-1",
									obj = {
										time: time+"",
										question: question,
										answers: $this.answersHandler.getAllAnswers.apply(_proBox),
										backTo: backTo
									};
								
								data.push(obj);
								dc.add(time, src);
							});
						}
						
						dc.add("data", data);
						return dc;
					}
				}).on("click", "span.del_pro", function(e) {
					e.preventDefault();
					e.stopPropagation();
					
					var $this = $(this),
						_delItem = $this.parents("div.biaoqian_num"),
						index = _delItem.index();
					
					_body.removeItem(index);
				}).on("click", "span.toggle", function(){
					var _this = $(this),
						_proBox = _this.parents("div.notbottom").siblings("div.pro_box");
						
					if (_this.hasClass("show_pro")) {
						_this.removeClass("show_pro").addClass("hide_pro");
						_body.answersHandler.hide.apply(_proBox);
					} else {
						_this.removeClass("hide_pro").addClass("show_pro");
						_body.answersHandler.show.apply(_proBox);
					}
				}).on("click", "span.add_answer", function(){
					var _this = $(this),
						_proBox = _this.parents("div.pro_box");
					
					_body.answersHandler.addAnswerItem.apply(_proBox);
				}).on("click", "span.cut_answer", function(){
					var _this = $(this),
						_proBox = _this.parents("div.pro_box"),
						index = _this.parent().index();
					
					_body.answersHandler.removeAnswerItem.call(_proBox, index);
				}).on("click", "span.set_correct", function(){
					var _this = $(this),
						_anBox = _this.parent();
				
					_body.answersHandler.markAnswer.call(_anBox, true);
				}).on("click", "span.del_answer", function(){
					var _this = $(this),
						_anBox = _this.parent();
			
					_body.answersHandler.markAnswer.call(_anBox, false);
				}).on("focusout", "input.backTo", function(){
					var _this = $(this);
						_biaoqian = _this.parents("div.biaoqian_num"),
						time = DateUtil.getTimeMillis(_biaoqian.find("p.ddtime").html())/1000;
						
					if (_this.val() >= time) {
						Dialog.alert("回退时间应小于打点时间，请重新设置");
						_this.val("");
					}
				});
		
		var _list = $("<div/>")
				.addClass("list")
				.append(_pm2Header)
				.append(_body)
				.extend({
					header: _pm2Header,
					body: _body
				});
		
		var _PM2 = $this;
		
		_PM2
			.append(_line)
			.append(_list)
			.extend({
				flag : 1,
				curID: "",
				init: function(options) {
					var $this = this;
						
					return $this.each(function(){
						$this.list.header.initHtml();
							
						if (options.json) {
							if (options.json.id) {
								$this.flag = 2;
								$this.curID = options.json.id;
								$this.list.body.addBatchItems(options.json.messages);
								$this.line.show();
							}
							
						}
					});
				},
				
				addItem: function(item){
					var $this = this;
					
					if (!$this.parent().hasClass("background_null")) {
						$this.parent().addClass("background_null");
					}
					if ($this.list.body.total == 10) {
						Dialog.alert("超出打点标签数限制");
						return;
					}
					return $this.each(function() {
						$this.list.body.insertItem(item);
					});
				},
				
				getItemsData: function(){
					var data = this.list.body.getItemsData(),
						json = {},
						dc = new DataCollection();
					
					json.contentID = contentID;
					json.contentSourceID = cSourceId;
					json.id = ((this.curID+"").length > 0 ? this.curID : "");
					json.messages = data.get("data");
					
					if ((json.messages.length == 0) && (json.id.length > 0)) {
						this.flag = 3;
					}
					json.flag = this.flag;
					data.remove("data");
					dc.add("type", "2");
					dc.add("pointMessage", JSON.stringify(json));
					dc.addAll(data);
					return dc;
				},
				
				removeItem: function(index){
					var $this = this;
					
					return $this.each(function(){
						$this.list.body.removeItem(index);
					});
				},
				
				clear: function(){
					var $this = this;
					
					return $this.each(function(){
						window[$this.attr("id")] = null;
					});
				},
				
				list: _list,
					
				line: _line
			});
		
		if (!$this.data("isInit")) {
			_PM2.init(options);
			$this.data("isInit", true);
		}
		
		return _PM2;
	}
})(window.jQuery);

/**
 * 打点信息处理入口，根据不同类型，返回不同的打点信息处理类（工厂类）
 * @param $
 */
(function($) {
	$.fn.vmsPointMessage = function(options) {
		var _pointMessage = null,
			defaults = {
				type : 0
			},
			ops = $.extend({}, defaults, options),
			$this = this;
		
		//return $this.each(function(){
			if (ops.type == 0) {
				_pointMessage = $this.vmsPM0(ops);
			} else if (ops.type == 1) {
				_pointMessage = $this.vmsPM1(ops);
			} else if (ops.type == 2) {
				_pointMessage = $this.vmsPM2(ops);
			}
			
			window[$this.attr("id")] = _pointMessage;
		//});
		
	}
})(window.jQuery);