(function($){
var flashVersion = (function(){
	try {
		return (window.ActiveXObject
			? (new window.ActiveXObject('ShockwaveFlash.ShockwaveFlash')).GetVariable('$version')
			: navigator.plugins['Shockwave Flash'].description).match(/\d+/g).join('.') || null;
	} catch (e) {
		return null;
	}
})(), flashContainer = document.createElement('div'),
RE_PROTOCOL = /^\w{3,6}\:\/\//,
RE_WHITE = /\s+/,
OPTIONS = {
	/*
	guid:'',
	method:'POST',
	queueSizeLimit:0,
	scriptData:'',
	fileExt:'',
	fileDesc:'',
	multi:true,
	sizeLimit:0,
	fileDataName:'Filedata',
	start:function(){},
	select:function(){},
	selectend:function(){},
	queuefull:function(){},
	open:function(){},
	cancel:function(){},
	error:function(){},
	progress:function(){},
	complete:function(){},
	allcomplete:function(){},
	clear:function(){},
	*/
	movie  : 'Video/uploader/cmstop-uploader.swf',
	script : '',
	auto   : true,
	multi  : true
},
INSTS = {}, PULGINS = [],
TRIGGERS = {
	'before:complete':function(t, args){
		if (args) {
			var data = decodeURIComponent(args[0].data);
			if (t.jsonType) {
				try {
					data = window.JSON.parse(data);
				} catch (e) {
					data = (new Function('return ' + data))();
				}
			}
			args.unshift(data);
		}
	},
	'after:selectend':function(t, args){
		t.auto && t.upload();
	}
};
function each(o, fn){
	return $.each(o.split(RE_WHITE), fn);
}
function version_test(a, b) {
	if (!a) return false;
	a = a.split('.');
	b = b.split('.');
	for (var i=0, l=b.length; i < l; i++) {
		if (a[i]==undefined || parseInt(a[i]) < parseInt(b[i])) {
			return false;
		}
		if (parseInt(a[i]) > parseInt(b[i])) {
			return true;
		}
	}
	return true;
}

function _genValue(obj, enc) {
	if (obj instanceof Object) {
		var arr = [];
		for (var k in obj) {
			arr.push(k+'='+ _genValue(obj[k], 1));
		}
		obj = arr.join('&');
	}
	return enc ? encodeURIComponent(obj) : obj;
}

function _genAttrs(obj) {
	var arr = [];
	for (var k in obj) {
		obj[k] && arr.push([k,'="',obj[k],'"'].join(''));
	}
	return arr.join(' ');
}

function _genParams(obj) {
	var arr = [];
	for (var k in obj) {
		arr.push(['<param name="', k, '" value="', _genValue(obj[k]), '" />'].join(''));
	}
	return arr.join('');
}
function createFlash(opt) {
	if (!opt.movie) {
		return false;
	}

	if (!version_test(flashVersion, '9.0.24')) {
		alert('flash version not available');
		return false;
	}
	
	var attrs = {
		style:'position:absolute;left:0;top:0;display:block;z-index:1',
		data:opt.movie,
		type:'application/x-shockwave-flash'
	};
	each('width height id', function(i, k){
		opt[k] && (attrs[k] = opt[k]);
		delete opt[k];
	});
	if (window.ActiveXObject) {
		attrs.classid = "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000";
	}
	flashContainer.innerHTML = [
		'<object ', _genAttrs(attrs), '>',
			_genParams(opt),
		'</object>'
	].join('');
	return flashContainer.firstChild;
}
function bindPlugin(up) {
	for (var i=0, l=PULGINS.length;i<l;i++) {
		PULGINS[i](up);
	}
}

var uploader = function(elem, opt) {
	var t = this, guid = 'UPLOADER' + parseInt(Math.random()*10000);
	elem.jquery || (elem = $(elem));
	elem.data('uploader', t);
	INSTS[guid] = t;
	opt = $.extend({}, OPTIONS, opt || {});
	t.guid = guid;
	t.auto = opt.auto;
	t.jsonType = opt.jsonType;
	t.binds = {};
	var script = opt.script || '', pathname = location.pathname;
	if (script.substr(0, 1) != '/' && !RE_PROTOCOL.test(script)) {
		pathname = pathname.split('/');
		pathname[pathname.length-1] = script.substr(0,1) == '?'
			? (pathname[pathname.length-1]+script)
			: script;
		script = pathname.join('/');
	}
	var flashvars = {
		guid:guid,
		script:script
	};
	each('method queueSizeLimit fileExt fileDesc multi sizeLimit fileDataName scriptData', function(i, k){
		opt[k] && (flashvars[k] = opt[k]);
	});
	each('start select queuefull open progress cancel clear error allcomplete selectend complete', function(i, k){
		opt[k] && t.bind(k, opt[k]);
	});
	elem.css({position:'relative', overflow:'hidden', display:'inline-block'});
	bindPlugin(t);
	var ival = null;
	function display(){
		var e = elem[0], w = e.offsetWidth, h = e.offsetHeight;
		if (!w || !h) return;
		ival && clearInterval(ival);
		flashvars.width = w;
		flashvars.height = h;
		t.movie = createFlash({
			movie:opt.movie,
			id:guid,
			width:w,
			height:h,
			flashvars:flashvars,
			quality:'high',
			wmode:'transparent',
			allowScriptAccess:'always'
		});
		elem.append(t.movie);
	}
	ival = setInterval(display, 1000);
	display();
};
uploader.prototype = {
	bind:function(evt, fn) {
		var t = this;
		if (typeof evt == 'object') {
			for (var k in evt) {
				t.bind(k, evt[k]);
			}
		} else if (typeof fn == 'function') {
			if (!t.binds[evt]) {
				t.binds[evt] = [];
			}
			t.binds[evt].push(fn);
		}
	},
	upload:function(ID) {
		callFlash(this.movie, 'startUpload', [ID]);
	},
	set:function(key, val) {
		callFlash(this.movie, 'setUpload', [key, _genValue(val)]);
	},
	cancel:function(ID) {
		callFlash(this.movie, 'cancelUpload', [ID]);
	},
	clear:function() {
		callFlash(this.movie, 'clearUpload');
	}
};
function callFlash(movie, functionName, argumentArray) {
	try {
		movie.CallFunction('<invoke name="' + functionName + '" returntype="javascript">' + __flash__argumentsToXML(argumentArray||[], 0) + '</invoke>');
	} catch (ex) {
		throw "Call to " + functionName + " failed";
	}
}
$.uploader = function(elem, opt) {
	return new uploader(elem, opt);
};
$.uploader.addPlugin = function(plugin) {
	PULGINS.push(plugin);
};
$.uploader.trigger = function(guid, evt, args) {
	var t = INSTS[guid], f, listeners;
	if (t) {
		f = TRIGGERS['before:'+evt];
		f && f(t, args);
		listeners = t.binds[evt];
		if (listeners) {
			for (var i=0,l; l=listeners[i++];) {
				l.apply(t, args);
			}
		}
		f = TRIGGERS['after:'+evt];
		f && f(t, args);
	}
};
$.uploader.testExternalInterface = function(guid) {
	try {
		callFlash(INSTS[guid].movie, 'testExternalInterface');
	} catch (e) {}
};
$.fn.uploader = function(options) {
	if (typeof options == 'string') {
		var args = [].slice.call(arguments, 1);
		this.each(function(){
			up = $.data(this, 'uploader');
			up && up[options].apply(up, args);
		});
		return this;
	}
	options || (options = {});
	return this.each(function(){
		var opt = $.extend({}, options), t = this, $t = $(t), v;
		if ($t.data('uploader') instanceof uploader) return;
		each('script multi fileDesc fileExt sizeLimit fileDataName', function(i, k){
			(v = $t.attr(k)) != undefined && (opt[k] = v);
		});
		if (opt.buttonImg) {
			var img = new Image();
		    img.onload = function(){
		    	$t.html(img);
		    	new uploader($t, opt);
		    };
		    img.onerror = function(){
		    	new uploader($t, opt);
		    };
		    img.src = opt.buttonImg;
			delete opt.buttonImg;
		} else {
			new uploader($t, opt);
		}
	});
};
})(jQuery);

(function($){

var box = null, p = null, b = null;
function initbox(){
	if (!box) {
		box = $('<div class="upload-progress">'+
			'<div class="bar">'+
				'<div class="progress"></div>'+
				'<b class="percent"></b>'+
			'</div>'+
		'</div>').appendTo(document.body);
		p = box.find('.progress');
		b = box.find('.percent');
	}
}
function progress(up) {
	initbox();
	var count = 0, percentage = {};
	up.bind({
		start:function(){
			box.show();
			p.css('width', 0);
			b.html('0%');
		},
		selectend:function(data) {
			count = data.fileCount;
			percentage = {};
		},
		progress:function(data) {
			percentage[data.ID] = data.percentage;
			var s = 0;
			for (var k in percentage)
			{
				s += percentage[k];
			}
			s = (count ? (s / count).toFixed() : '100') + '%';
			p.css('width', s);
			b.html(s);
		},
		error:function() {
			if (data.ID) {
				percentage[data.ID] = 100;
			}
		},
		allcomplete:function(data) {
			p.css('width', '100%');
			b.html('100%');
			setTimeout(function(){
				box.fadeOut();
			}, 1000);
		}
	});
}
$.uploader.addPlugin(progress);
})(jQuery);