/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.docker.client.LogReader;
import com.spotify.docker.client.messages.Event;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LogReader.class);
    private final ObjectMapper objectMapper;
    private final CloseableHttpResponse response;
    private JsonParser parser;
    private volatile boolean closed;

    public EventReader(CloseableHttpResponse response, ObjectMapper objectMapper) {
        this.response = response;
        this.objectMapper = objectMapper;
    }

    public Event nextMessage() throws IOException {
        if (this.parser == null) {
            this.parser = this.objectMapper.getFactory().createParser(this.response.getEntity().getContent());
        }
        if (this.parser.isClosed()) {
            return null;
        }
        if (this.parser.nextToken() == null) {
            return null;
        }
        return (Event)this.parser.readValueAs(Event.class);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.response.close();
    }
}

