/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.WrapperImpl;
import com.taosdata.jdbc.enums.SchemalessProtocolType;
import com.taosdata.jdbc.enums.SchemalessTimestampType;
import com.taosdata.jdbc.utils.VersionUtil;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractConnection
extends WrapperImpl
implements Connection {
    protected AtomicLong idGenerator = new AtomicLong(0L);
    protected ConcurrentHashMap<Long, Statement> statementsMap = new ConcurrentHashMap();
    protected volatile boolean isClosed;
    protected volatile String catalog;
    protected final Properties clientInfoProps = new Properties();
    protected final boolean supportBlob;
    protected final boolean supportLineBind;
    protected final String serverVersion;

    protected AbstractConnection(Properties properties, String version) {
        Set<String> propNames = properties.stringPropertyNames();
        for (String propName : propNames) {
            this.clientInfoProps.setProperty(propName, properties.getProperty(propName));
        }
        this.serverVersion = version;
        this.supportLineBind = this.supportBlob = VersionUtil.surpportBlob(this.serverVersion);
    }

    public boolean isSupportBlob() {
        return this.supportBlob;
    }

    public void unregisterStatement(Long stmtId) {
        this.statementsMap.remove(stmtId);
    }

    public void registerStatement(Long stmtId, Statement stmt) {
        this.statementsMap.put(stmtId, stmt);
    }

    @Override
    public abstract Statement createStatement() throws SQLException;

    @Override
    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return true;
    }

    @Override
    public void commit() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
    }

    @Override
    public abstract void close() throws SQLException;

    @Override
    public abstract boolean isClosed() throws SQLException;

    @Override
    public abstract DatabaseMetaData getMetaData() throws SQLException;

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        this.catalog = catalog;
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return this.catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        switch (level) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                throw TSDBError.createSQLException(8962);
            }
            default: {
                throw TSDBError.createSQLException(8963);
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
    }

    private void checkResultSetTypeAndResultSetConcurrency(int resultSetType, int resultSetConcurrency) throws SQLException {
        switch (resultSetType) {
            case 1003: {
                break;
            }
            case 1004: 
            case 1005: {
                throw TSDBError.createSQLException(8962);
            }
            default: {
                throw TSDBError.createSQLException(8963);
            }
        }
        switch (resultSetConcurrency) {
            case 1007: {
                break;
            }
            case 1008: {
                throw TSDBError.createSQLException(8962);
            }
            default: {
                throw TSDBError.createSQLException(8963);
            }
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        this.checkResultSetTypeAndResultSetConcurrency(resultSetType, resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        this.checkResultSetTypeAndResultSetConcurrency(resultSetType, resultSetConcurrency);
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        switch (holdability) {
            case 1: {
                break;
            }
            case 2: {
                throw TSDBError.createSQLException(8962);
            }
            default: {
                throw TSDBError.createSQLException(8963);
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        switch (resultSetHoldability) {
            case 1: {
                break;
            }
            case 2: {
                throw TSDBError.createSQLException(8962);
            }
            default: {
                throw TSDBError.createSQLException(8963);
            }
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        switch (resultSetHoldability) {
            case 1: {
                break;
            }
            case 2: {
                throw TSDBError.createSQLException(8962);
            }
            default: {
                throw TSDBError.createSQLException(8963);
            }
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        switch (autoGeneratedKeys) {
            case 1: {
                throw TSDBError.createSQLException(8962);
            }
        }
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        if (timeout < 0) {
            throw TSDBError.createSQLException(8963);
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        Future<Boolean> future = executor.submit(() -> {
            int status;
            try (Statement stmt = this.createStatement();){
                ResultSet resultSet = stmt.executeQuery("select 1");
                resultSet.next();
                status = resultSet.getInt("1");
                resultSet.close();
            }
            return status == 1;
        });
        boolean status = false;
        try {
            status = timeout == 0 ? future.get().booleanValue() : future.get(timeout, TimeUnit.SECONDS).booleanValue();
        }
        catch (InterruptedException | ExecutionException exception) {
        }
        catch (TimeoutException e) {
            future.cancel(true);
        }
        finally {
            executor.shutdownNow();
        }
        return status;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.isClosed) {
            throw (SQLClientInfoException)TSDBError.createSQLException(8974);
        }
        this.clientInfoProps.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.isClosed) {
            throw (SQLClientInfoException)TSDBError.createSQLException(8974);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            this.clientInfoProps.put(name, properties.getProperty(name));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.isClosed) {
            throw TSDBError.createSQLException(8961);
        }
        return this.clientInfoProps.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.isClosed) {
            throw TSDBError.createSQLException(8961);
        }
        return this.clientInfoProps;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        if (milliseconds < 0) {
            throw TSDBError.createSQLException(8963);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return 0;
    }

    public void write(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        this.write(lines, protocolType, timestampType, null, null);
    }

    public abstract void write(String[] var1, SchemalessProtocolType var2, SchemalessTimestampType var3, Integer var4, Long var5) throws SQLException;

    public void write(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        this.write(new String[]{line}, protocolType, timestampType);
    }

    public void write(List<String> lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        String[] strings = lines.toArray(new String[0]);
        this.write(strings, protocolType, timestampType);
    }

    public int writeRaw(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        return this.writeRaw(line, protocolType, timestampType, null, null);
    }

    public abstract int writeRaw(String var1, SchemalessProtocolType var2, SchemalessTimestampType var3, Integer var4, Long var5) throws SQLException;
}

