/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.FieldBindType;
import com.taosdata.jdbc.enums.SchemalessProtocolType;
import com.taosdata.jdbc.enums.SchemalessTimestampType;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.StmtUtils;
import com.taosdata.jdbc.utils.StringUtils;
import com.taosdata.jdbc.ws.TSWSPreparedStatement;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSDatabaseMetaData;
import com.taosdata.jdbc.ws.WSEWPreparedStatement;
import com.taosdata.jdbc.ws.WSRowPreparedStatement;
import com.taosdata.jdbc.ws.WSStatement;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.CommonResp;
import com.taosdata.jdbc.ws.entity.ConCheckInfo;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.schemaless.InsertReq;
import com.taosdata.jdbc.ws.schemaless.SchemalessAction;
import com.taosdata.jdbc.ws.stmt2.entity.Field;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2PrepareResp;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSConnection
extends AbstractConnection {
    private static final Logger log = LoggerFactory.getLogger(WSConnection.class);
    public static final AtomicBoolean g_FirstConnection = new AtomicBoolean(true);
    private final Transport transport;
    private final DatabaseMetaData metaData;
    private String database;
    private final ConnectionParam param;
    private final AtomicLong insertId = new AtomicLong(0L);
    private final String jdbcUrl;
    private static final ConcurrentHashMap<String, ConCheckInfo> conCheckInfoMap = new ConcurrentHashMap();
    private static final Map<String, Object> jdbcUrlLocks = new ConcurrentHashMap<String, Object>();

    public WSConnection(String url, Properties properties, Transport transport, ConnectionParam param, String serverVersion) {
        super(properties, serverVersion);
        this.transport = transport;
        this.database = param.getDatabase();
        this.param = param;
        this.jdbcUrl = StringUtils.retainHostPortPart(url);
        this.metaData = new WSDatabaseMetaData(url, properties.getProperty("user"), this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        if (this.getClientInfo("dbname") != null) {
            this.database = this.getClientInfo("dbname");
        }
        WSStatement statement = new WSStatement(this.transport, this.database, this, this.idGenerator.getAndIncrement(), this.param.getZoneId());
        this.statementsMap.put(statement.getInstanceId(), statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        if (this.getClientInfo("dbname") != null) {
            this.database = this.getClientInfo("dbname");
        }
        boolean efficientWritingSql = false;
        if (sql.startsWith("ASYNC_INSERT")) {
            sql = sql.substring("ASYNC_".length());
            efficientWritingSql = true;
        }
        if (!sql.contains("?")) {
            return new TSWSPreparedStatement(this.transport, this.param, this.database, this, sql, this.idGenerator.getAndIncrement());
        }
        if (this.transport != null && !this.transport.isClosed()) {
            Stmt2PrepareResp prepareResp = StmtUtils.initStmtWithRetry(this.transport, sql, this.param.getRetryTimes());
            boolean isInsert = prepareResp.isInsert();
            boolean isSuperTable = false;
            if (isInsert) {
                for (Field field : prepareResp.getFields()) {
                    if (field.getBindType() != FieldBindType.TAOS_FIELD_TBNAME.getValue()) continue;
                    isSuperTable = true;
                    break;
                }
            }
            if ((efficientWritingSql || "STMT".equalsIgnoreCase(this.param.getAsyncWrite())) && isInsert && isSuperTable) {
                return new WSEWPreparedStatement(this.transport, this.param, this.database, this, sql, this.idGenerator.getAndIncrement(), prepareResp);
            }
            if ("line".equalsIgnoreCase(this.param.getPbsMode())) {
                if (this.supportLineBind) {
                    return new WSRowPreparedStatement(this.transport, this.param, this.database, this, sql, this.idGenerator.getAndIncrement(), prepareResp);
                }
                throw TSDBError.createSQLException(8996);
            }
            return new TSWSPreparedStatement(this.transport, this.param, this.database, this, sql, this.idGenerator.getAndIncrement(), prepareResp);
        }
        throw TSDBError.createSQLException(8961);
    }

    @Override
    public void close() throws SQLException {
        for (Map.Entry entry : this.statementsMap.entrySet()) {
            Statement value = (Statement)entry.getValue();
            value.close();
        }
        this.statementsMap.clear();
        this.transport.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.transport.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return this.metaData;
    }

    public ConnectionParam getParam() {
        return this.param;
    }

    @Override
    public void write(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, Integer ttl, Long reqId) throws SQLException {
        for (String line : lines) {
            InsertReq insertReq = new InsertReq();
            insertReq.setReqId(this.insertId.getAndIncrement());
            insertReq.setProtocol(protocolType.ordinal());
            insertReq.setPrecision(timestampType.getType());
            insertReq.setData(line);
            if (ttl != null) {
                insertReq.setTtl(ttl);
            }
            if (reqId != null) {
                insertReq.setReqId(reqId);
            }
            CommonResp response = (CommonResp)this.transport.send(new Request(SchemalessAction.INSERT.getAction(), insertReq), this.param.getRequestTimeout());
            if (Code.SUCCESS.getCode() == response.getCode()) continue;
            throw new SQLException("0x" + Integer.toHexString(response.getCode()) + ":" + response.getMessage());
        }
    }

    @Override
    public int writeRaw(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, Integer ttl, Long reqId) throws SQLException {
        InsertReq insertReq = new InsertReq();
        insertReq.setReqId(this.insertId.getAndIncrement());
        insertReq.setProtocol(protocolType.ordinal());
        insertReq.setPrecision(timestampType.getType());
        insertReq.setData(line);
        if (ttl != null) {
            insertReq.setTtl(ttl);
        }
        if (reqId != null) {
            insertReq.setReqId(reqId);
        }
        CommonResp response = (CommonResp)this.transport.send(new Request(SchemalessAction.INSERT.getAction(), insertReq), this.param.getRequestTimeout());
        if (Code.SUCCESS.getCode() != response.getCode()) {
            throw new SQLException("(0x" + Integer.toHexString(response.getCode()) + "):" + response.getMessage());
        }
        return 0;
    }

    private boolean noNeedCheck() {
        ConCheckInfo conCheckInfo = conCheckInfoMap.get(this.jdbcUrl);
        return conCheckInfo != null && conCheckInfo.isValid() && !this.transport.isConnectionLost() && !conCheckInfo.isExpired(this.param.getWsKeepAlive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        Object lock;
        if (this.isClosed()) {
            return false;
        }
        if (timeout < 0) {
            throw TSDBError.createSQLException(8963);
        }
        if (this.noNeedCheck()) {
            return true;
        }
        Object object = lock = jdbcUrlLocks.computeIfAbsent(this.jdbcUrl, k -> new Object());
        synchronized (object) {
            boolean bl;
            Statement stmt;
            block17: {
                if (this.noNeedCheck()) {
                    return true;
                }
                stmt = null;
                ResultSet resultSet = null;
                try {
                    stmt = this.createStatement();
                    stmt.setQueryTimeout(timeout);
                    resultSet = stmt.executeQuery("SHOW CLUSTER ALIVE");
                    resultSet.next();
                    int status = resultSet.getInt(1);
                    conCheckInfoMap.put(this.jdbcUrl, new ConCheckInfo(System.currentTimeMillis(), status != 0));
                    boolean bl2 = bl = status != 0;
                    if (resultSet == null) break block17;
                }
                catch (SQLException e) {
                    boolean bl3;
                    block18: {
                        try {
                            conCheckInfoMap.put(this.jdbcUrl, new ConCheckInfo(System.currentTimeMillis(), false));
                            log.error("check connection failed", (Throwable)e);
                            bl3 = false;
                            if (resultSet == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    return bl3;
                }
                resultSet.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            return bl;
        }
    }
}

