/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tione.v20211111.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTrainingTaskPodsResponse extends AbstractModel {

    /**
    * pod名称列表
    */
    @SerializedName("PodNames")
    @Expose
    private String [] PodNames;

    /**
    * 数量
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * pod详细信息
    */
    @SerializedName("PodInfoList")
    @Expose
    private PodInfo PodInfoList;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get pod名称列表 
     * @return PodNames pod名称列表
     */
    public String [] getPodNames() {
        return this.PodNames;
    }

    /**
     * Set pod名称列表
     * @param PodNames pod名称列表
     */
    public void setPodNames(String [] PodNames) {
        this.PodNames = PodNames;
    }

    /**
     * Get 数量 
     * @return TotalCount 数量
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set 数量
     * @param TotalCount 数量
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get pod详细信息 
     * @return PodInfoList pod详细信息
     */
    public PodInfo getPodInfoList() {
        return this.PodInfoList;
    }

    /**
     * Set pod详细信息
     * @param PodInfoList pod详细信息
     */
    public void setPodInfoList(PodInfo PodInfoList) {
        this.PodInfoList = PodInfoList;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTrainingTaskPodsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTrainingTaskPodsResponse(DescribeTrainingTaskPodsResponse source) {
        if (source.PodNames != null) {
            this.PodNames = new String[source.PodNames.length];
            for (int i = 0; i < source.PodNames.length; i++) {
                this.PodNames[i] = new String(source.PodNames[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.PodInfoList != null) {
            this.PodInfoList = new PodInfo(source.PodInfoList);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "PodNames.", this.PodNames);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamObj(map, prefix + "PodInfoList.", this.PodInfoList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

