/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.SplitStrategy;
import parquet.hadoop.api.ReadSupport;
import parquet.io.ParquetDecodingException;

class TaskSideMetadataSplitStrategy
extends SplitStrategy {
    TaskSideMetadataSplitStrategy() {
    }

    @Override
    List<ParquetInputSplit> getSplits(Configuration configuration, List<Footer> footers, long maxSplitSize, long minSplitSize, ReadSupport.ReadContext readContext) throws IOException {
        ArrayList<ParquetInputSplit> splits = new ArrayList<ParquetInputSplit>();
        for (Footer footer : footers) {
            Path file = footer.getFile();
            FileSystem fs = file.getFileSystem(configuration);
            FileStatus fileStatus = fs.getFileStatus(file);
            BlockLocation[] fileBlockLocations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
            splits.addAll(TaskSideMetadataSplitStrategy.generateTaskSideMDSplits(fileBlockLocations, fileStatus, readContext.getRequestedSchema().toString(), readContext.getReadSupportMetadata(), minSplitSize, maxSplitSize));
        }
        return splits;
    }

    private static int findBlockIndex(BlockLocation[] hdfsBlocksArray, long endOffset) {
        for (int i = 0; i < hdfsBlocksArray.length; ++i) {
            BlockLocation block = hdfsBlocksArray[i];
            if (endOffset <= block.getOffset() || endOffset > block.getOffset() + block.getLength()) continue;
            return i;
        }
        return -1;
    }

    static <T> List<ParquetInputSplit> generateTaskSideMDSplits(BlockLocation[] hdfsBlocksArray, FileStatus fileStatus, String requestedSchema, Map<String, String> readSupportMetadata, long minSplitSize, long maxSplitSize) throws IOException {
        BlockLocation lastBlock;
        if (maxSplitSize < minSplitSize || maxSplitSize < 0L || minSplitSize < 0L) {
            throw new ParquetDecodingException("maxSplitSize and minSplitSize should be positive and max should be greater or equal to the minSplitSize: maxSplitSize = " + maxSplitSize + "; minSplitSize is " + minSplitSize);
        }
        ArrayList<ParquetInputSplit> resultSplits = new ArrayList<ParquetInputSplit>();
        long startOffset = 0L;
        long endOffset = 0L;
        Arrays.sort(hdfsBlocksArray, new Comparator<BlockLocation>(){

            @Override
            public int compare(BlockLocation o1, BlockLocation o2) {
                return this.compare(o1.getOffset(), o2.getOffset());
            }

            @Override
            private int compare(long x, long y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        });
        BlockLocation blockLocation = lastBlock = hdfsBlocksArray.length == 0 ? null : hdfsBlocksArray[hdfsBlocksArray.length - 1];
        while (endOffset < fileStatus.getLen()) {
            BlockLocation blockLocation2;
            startOffset = endOffset;
            int nextBlockMin = TaskSideMetadataSplitStrategy.findBlockIndex(hdfsBlocksArray, startOffset + minSplitSize);
            int nextBlockMax = TaskSideMetadataSplitStrategy.findBlockIndex(hdfsBlocksArray, startOffset + maxSplitSize);
            if (nextBlockMax == nextBlockMin && nextBlockMax != -1) {
                endOffset = startOffset + maxSplitSize;
                blockLocation2 = hdfsBlocksArray[nextBlockMax];
            } else if (nextBlockMin > -1) {
                blockLocation2 = hdfsBlocksArray[nextBlockMin];
                endOffset = blockLocation2.getOffset() + blockLocation2.getLength();
            } else {
                endOffset = fileStatus.getLen();
                blockLocation2 = lastBlock;
            }
            resultSplits.add(new ParquetInputSplit(fileStatus.getPath(), startOffset, endOffset, endOffset - startOffset, blockLocation2 == null ? new String[]{} : blockLocation2.getHosts(), null, requestedSchema, readSupportMetadata));
        }
        return resultSplits;
    }
}

