/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.util.Debug;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class LDAPConnectionPoolHealthCheckThread
extends Thread {
    private final AtomicBoolean stopRequested;
    private final AbstractConnectionPool pool;
    private final LinkedBlockingQueue<Object> queue;
    private volatile Thread thread;

    LDAPConnectionPoolHealthCheckThread(AbstractConnectionPool pool) {
        this.setName("Health Check Thread for " + pool.toString());
        this.setDaemon(true);
        this.pool = pool;
        this.stopRequested = new AtomicBoolean(false);
        this.queue = new LinkedBlockingQueue(1);
        this.thread = null;
    }

    public void run() {
        this.thread = Thread.currentThread();
        long lastCheckTime = System.currentTimeMillis();
        while (!this.stopRequested.get()) {
            long timeSinceLastCheck = System.currentTimeMillis() - lastCheckTime;
            if (timeSinceLastCheck >= this.pool.getHealthCheckIntervalMillis()) {
                try {
                    this.pool.doHealthCheck();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                lastCheckTime = System.currentTimeMillis();
                continue;
            }
            long sleepTime = Math.min(this.pool.getHealthCheckIntervalMillis() - timeSinceLastCheck, 30000L);
            try {
                this.queue.poll(sleepTime, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.thread = null;
    }

    void stopRunning() {
        block3: {
            this.stopRequested.set(true);
            this.wakeUp();
            Thread t = this.thread;
            if (t != null) {
                try {
                    t.join();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (!(e instanceof InterruptedException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    void wakeUp() {
        this.queue.offer(new Object());
    }
}

