/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.beans;

import com.volcengine.model.beans.PartInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class ReUsePartFileInputStream
extends InputStream {
    private PartInputStream bis = null;
    private FileChannel fileChannel = null;
    private long markPos = 0L;

    public ReUsePartFileInputStream(PartInputStream bis) throws IOException {
        FileInputStream fin = (FileInputStream)bis.getWrappedInputStream();
        this.bis = bis;
        this.fileChannel = fin.getChannel();
        this.markPos = this.fileChannel.position();
    }

    @Override
    public void reset() throws IOException {
        this.bis.backoff(this.fileChannel.position() - this.markPos);
        this.fileChannel.position(this.markPos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.markPos = this.fileChannel.position();
        }
        catch (IOException var3) {
            throw new RuntimeException("Failed to mark file position", var3);
        }
    }

    @Override
    public int available() throws IOException {
        return this.bis.available();
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
    }

    @Override
    public int read() throws IOException {
        return this.bis.read();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    public InputStream getWrappedInputStream() {
        return this.bis;
    }
}

