/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.retryer;

import com.volcengine.ApiException;
import com.volcengine.ApiResponse;
import com.volcengine.model.AbstractResponse;
import com.volcengine.model.ResponseMetadata;
import com.volcengine.observability.debugger.SdkDebugLog;
import com.volcengine.retryer.RetryCondition;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultRetryCondition
extends RetryCondition {
    private static final Set<Integer> RETRY_STATUS_CODES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(429, 500, 502, 503, 504)));

    public DefaultRetryCondition() {
        this.retryErrorCodes = new HashSet();
    }

    protected DefaultRetryCondition(Set<String> retryErrorCodes) {
        this.retryErrorCodes = retryErrorCodes != null ? retryErrorCodes : new HashSet();
    }

    @Override
    public boolean shouldRetry(ApiResponse response, ApiException apiException) {
        int statusCode = -1;
        String errorCode = null;
        if (apiException != null) {
            Throwable cause = apiException.getCause();
            if (cause instanceof SocketTimeoutException || cause instanceof UnknownHostException || cause instanceof ConnectException || cause instanceof UnknownServiceException || cause instanceof SocketException) {
                SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Retry triggered by network exception: {}, message: {}", cause.getClass().getName(), cause.getMessage());
                return true;
            }
            statusCode = apiException.getCode();
            errorCode = this.getErrorCode(apiException.getResponseMetadata());
        }
        if (response != null) {
            statusCode = response.getStatusCode();
            if (response.getData() != null) {
                SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Response data type: {}", response.getData().getClass().getName());
                if (response.getData() instanceof AbstractResponse) {
                    AbstractResponse abstractResponse = (AbstractResponse)response.getData();
                    errorCode = this.getErrorCode(abstractResponse.getResponseMetadata());
                }
                if (response.getData() instanceof Map) {
                    Map map = (Map)response.getData();
                    errorCode = this.getErrorCodeFromMap(map, String.class, "ResponseMetadata", "Error", "Code");
                }
            }
        }
        if (RETRY_STATUS_CODES.contains(statusCode)) {
            SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Retry triggered by status code: {}", statusCode);
            return true;
        }
        if (this.retryErrorCodes.contains(errorCode)) {
            SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Retry triggered by error code: {}", errorCode);
            return true;
        }
        SdkDebugLog.SDK_CORE_LOGGER.debugRetry("No retry condition met. StatusCode: {}, ErrorCode: {}", statusCode, errorCode);
        return false;
    }

    private <T> T getErrorCodeFromMap(Map<String, Object> map, Class<T> responseType, String ... keys) {
        if (map == null || keys == null || keys.length == 0) {
            return null;
        }
        SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Try to get error code from map, keys: {}", Arrays.toString(keys));
        Map currentMap = map;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!currentMap.containsKey(key)) {
                SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Key '{}' not found in map.", key);
                break;
            }
            Object value = currentMap.get(key);
            if (i < keys.length - 1) {
                if (!(value instanceof Map)) {
                    SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Value for key '{}' is not a map.", key);
                    return null;
                }
            } else {
                SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Found value for keys '{}', value: {}", Arrays.toString(keys), value);
                return responseType.cast(value);
            }
            currentMap = (Map)value;
        }
        SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Error code not found with keys: {}", Arrays.toString(keys));
        return null;
    }

    private String getErrorCode(ResponseMetadata responseMetadata) {
        if (responseMetadata != null && responseMetadata.getError() != null) {
            return responseMetadata.getError().getCode();
        }
        SdkDebugLog.SDK_CORE_LOGGER.debugRetry("Failed to get error code, response metadata or error is null.", new Object[0]);
        return null;
    }
}

