/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

class SimpleJsonEncoder
implements Closeable {
    private static final char QUOTE = '\"';
    private final Writer writer;
    private boolean started;
    private boolean closed;

    SimpleJsonEncoder(Writer writer) {
        this.writer = writer;
        try {
            writer.write(123);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    SimpleJsonEncoder appendToJSON(String key, Object value) {
        if (this.closed) {
            throw new IllegalStateException("Encoder already closed");
        }
        if (value != null) {
            try {
                this.appendKey(key);
                if (value instanceof Number) {
                    this.writer.write(value.toString());
                } else {
                    this.writer.write(34);
                    this.escapeString(value.toString());
                    this.writer.write(34);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this;
    }

    SimpleJsonEncoder appendToJSONUnquoted(String key, Object value) {
        if (this.closed) {
            throw new IllegalStateException("Encoder already closed");
        }
        if (value != null) {
            try {
                this.appendKey(key);
                this.writer.write(value.toString());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this;
    }

    private void appendKey(String key) throws IOException {
        if (this.started) {
            this.writer.write(44);
        } else {
            this.started = true;
        }
        this.writer.write(34);
        this.escapeString(key);
        this.writer.write(34);
        this.writer.write(58);
    }

    private void escapeString(String str) throws IOException {
        block8: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '/': 
                case '\\': {
                    this.writer.write(92);
                    this.writer.write(ch);
                    continue block8;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block8;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block8;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block8;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block8;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block8;
                }
                default: {
                    if (ch < ' ') {
                        this.writer.write(SimpleJsonEncoder.escapeCharacter(ch));
                        continue block8;
                    }
                    this.writer.write(ch);
                }
            }
        }
    }

    private static String escapeCharacter(char ch) {
        String prefix = ch < '\u0010' ? "000" : (ch < '\u0100' ? "00" : (ch < '\u1000' ? "0" : ""));
        return "\\u" + prefix + Integer.toHexString(ch);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.writer.write(125);
            this.closed = true;
        }
        this.writer.close();
    }
}

