/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf.pool;

public abstract class AbstractPooledObject {
    private final long createdAt;
    private long lastBorrowed;

    public AbstractPooledObject() {
        this.lastBorrowed = this.createdAt = System.currentTimeMillis();
    }

    final long lifeTime() {
        return System.currentTimeMillis() - this.createdAt;
    }

    final long idleTime() {
        return System.currentTimeMillis() - this.lastBorrowed;
    }

    final void borrow() {
        this.lastBorrowed = System.currentTimeMillis();
    }

    protected void close() {
    }
}

