/*
 * Decompiled with CFR 0.152.
 */
package fr.ippon.spark.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.ippon.spark.metrics.measures.CounterMeasure;
import fr.ippon.spark.metrics.measures.GaugeMeasure;
import fr.ippon.spark.metrics.measures.HistogramMeasure;
import fr.ippon.spark.metrics.measures.MeterMeasure;
import fr.ippon.spark.metrics.measures.TimerMeasure;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkReporter.class);
    private String sparkHost;
    private int sparkPort;
    private Socket socket;
    private ObjectMapper mapper;
    private PrintWriter writer;

    private SparkReporter(MetricRegistry registry, String sparkHost, int sparkPort, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "spark-reporter", filter, rateUnit, durationUnit);
        this.sparkHost = sparkHost;
        this.sparkPort = sparkPort;
        this.mapper = new ObjectMapper();
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            this.connect();
            this.doReport(gauges, counters, histograms, meters, timers);
        }
        catch (IOException ioe1) {
            try {
                this.connect();
                this.doReport(gauges, counters, histograms, meters, timers);
            }
            catch (IOException ioe2) {
                LOGGER.warn("Unable to report to Spark : " + ioe2.getClass().getCanonicalName());
            }
        }
    }

    private void doReport(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) throws IOException {
        if (gauges.isEmpty() && counters.isEmpty() && histograms.isEmpty() && meters.isEmpty() && timers.isEmpty()) {
            return;
        }
        if (!gauges.isEmpty()) {
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue());
            }
        }
        if (!counters.isEmpty()) {
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue());
            }
        }
        if (!histograms.isEmpty()) {
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
            }
        }
        if (!meters.isEmpty()) {
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue());
            }
        }
        if (!timers.isEmpty()) {
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue());
            }
        }
    }

    private void connect() throws IOException {
        if (this.writer != null && this.writer.checkError()) {
            this.closeConnection();
        }
        if (this.socket == null) {
            this.socket = SocketFactory.getDefault().createSocket(this.sparkHost, this.sparkPort);
            this.writer = new PrintWriter(this.socket.getOutputStream());
        }
    }

    private void closeConnection() throws IOException {
        this.writer.close();
        this.socket.close();
        this.writer = null;
        this.socket = null;
    }

    private void reportGauge(String name, Gauge gauge) throws IOException {
        if (this.isANumber(gauge.getValue())) {
            this.writer.println(this.mapper.writeValueAsString((Object)new GaugeMeasure(name, gauge)));
        }
    }

    private void reportCounter(String name, Counter counter) throws IOException {
        this.writer.println(this.mapper.writeValueAsString((Object)new CounterMeasure(name, counter)));
    }

    private void reportHistogram(String name, Histogram histogram) throws IOException {
        this.writer.println(this.mapper.writeValueAsString((Object)new HistogramMeasure(name, histogram)));
    }

    private void reportMetered(String name, Metered meter) throws IOException {
        this.writer.println(this.mapper.writeValueAsString((Object)new MeterMeasure(name, meter)));
    }

    private void reportTimer(String name, Timer timer) throws IOException {
        this.writer.println(this.mapper.writeValueAsString((Object)new TimerMeasure(name, timer)));
    }

    private boolean isANumber(Object object) {
        return object instanceof Float || object instanceof Double || object instanceof Integer || object instanceof Long;
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public SparkReporter build(String sparkHost, int sparkPort) {
            return new SparkReporter(this.registry, sparkHost, sparkPort, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

