/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.charset.iso6937;

import fr.noop.charset.iso6937.Iso6937Charset;
import fr.noop.charset.iso6937.Iso6937CharsetMapping;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.text.Normalizer;

public class Iso6937CharsetDecoder
extends CharsetDecoder {
    public Iso6937CharsetDecoder(Iso6937Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        try {
            while (in.hasRemaining()) {
                int by = in.get() & 0xFF;
                char ch = (char)by;
                if (by >= 193 && by <= 200 || by >= 202 && by <= 203 || by >= 205 && by <= 207) {
                    String decomposed = String.format("%s%s", Character.valueOf((char)in.get()), Character.valueOf((char)Iso6937CharsetMapping.decode(by)));
                    String composed = Normalizer.normalize(decomposed, Normalizer.Form.NFC);
                    out.put(composed);
                    continue;
                }
                out.put((char)Iso6937CharsetMapping.decode(by));
            }
        }
        catch (BufferOverflowException x) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }
}

