/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

public class MimePartDataSource
implements DataSource,
MessageAware {
    private MimePart _part;

    public MimePartDataSource(MimePart part) {
        this._part = part;
    }

    public String getContentType() {
        try {
            return this._part.getContentType();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getInputStream() throws IOException {
        try {
            void var1_3;
            InputStream content;
            String encoding = this._part.getEncoding();
            if (this._part instanceof MimeMessage) {
                content = ((MimeMessage)this._part).getContentStream();
            } else if (this._part instanceof MimeBodyPart) {
                content = ((MimeBodyPart)this._part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            return MimeUtility.decode((InputStream)var1_3, encoding);
        }
        catch (MessagingException e) {
            throw new IOException(e.toString());
        }
    }

    public synchronized MessageContext getMessageContext() {
        return new MessageContext(this._part);
    }

    public String getName() {
        return "";
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }
}

