/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignRoleToMappingRuleCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignRoleToMappingRuleResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.AssignRoleToMappingRuleResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignRoleToMappingRuleCommandImpl
implements AssignRoleToMappingRuleCommandStep1,
AssignRoleToMappingRuleCommandStep1.AssignRoleToMappingRuleCommandStep2,
AssignRoleToMappingRuleCommandStep1.AssignRoleToMappingRuleCommandStep3 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String roleId;
    private String mappingRuleId;

    public AssignRoleToMappingRuleCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignRoleToMappingRuleCommandStep1.AssignRoleToMappingRuleCommandStep2 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public AssignRoleToMappingRuleCommandStep1.AssignRoleToMappingRuleCommandStep3 mappingRuleId(String mappingRuleId) {
        this.mappingRuleId = mappingRuleId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignRoleToMappingRuleResponse> requestTimeout(Duration timeout) {
        this.httpRequestConfig.setResponseTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignRoleToMappingRuleResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        ArgumentUtil.ensureNotNullNorEmpty("mappingRuleId", this.mappingRuleId);
        HttpCamundaFuture<AssignRoleToMappingRuleResponse> result = new HttpCamundaFuture<AssignRoleToMappingRuleResponse>();
        this.httpClient.put("/roles/" + this.roleId + "/mapping-rules/" + this.mappingRuleId, null, this.httpRequestConfig.build(), AssignRoleToMappingRuleResponseImpl::new, result);
        return result;
    }
}

