/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.util;

import io.camunda.client.api.command.ClientException;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.core5.net.URIBuilder;

public final class AddressUtil {
    public static final List<String> PLAINTEXT_SCHEMES = Arrays.asList("http", "grpc");
    public static final List<String> ENCRYPTED_SCHEMES = Arrays.asList("https", "grpcs");

    private AddressUtil() {
    }

    public static boolean isPlaintextConnection(URI address) {
        if (address == null) {
            return true;
        }
        String scheme = address.getScheme();
        if (PLAINTEXT_SCHEMES.contains(scheme)) {
            return true;
        }
        if (ENCRYPTED_SCHEMES.contains(scheme)) {
            return false;
        }
        throw new ClientException(String.format("Unrecognized scheme '%s'", scheme));
    }

    public static String composeGatewayAddress(URI grpcAddress) {
        int port = grpcAddress.getPort();
        if (port == -1) {
            return grpcAddress.getHost();
        }
        return String.format("%s:%d", grpcAddress.getHost(), port);
    }

    public static URI composeGrpcAddress(InetSocketAddress gatewayAddress, boolean plaintext) {
        return AddressUtil.composeGrpcAddress(NetUtil.toSocketAddressString((InetSocketAddress)gatewayAddress), plaintext);
    }

    public static URI composeGrpcAddress(String gatewayAddress, boolean plaintext) {
        String composedGrpcAddress = String.format("%s://%s", AddressUtil.scheme(plaintext), gatewayAddress);
        return URI.create(composedGrpcAddress);
    }

    public static String scheme(boolean plaintext) {
        return plaintext ? PLAINTEXT_SCHEMES.get(0) : ENCRYPTED_SCHEMES.get(0);
    }

    public static URI composeAddress(boolean plaintext, URI address) {
        String scheme = AddressUtil.scheme(plaintext);
        try {
            return new URIBuilder(address).setScheme(scheme).build();
        }
        catch (URISyntaxException e) {
            throw new ClientException("Error while composing address", e);
        }
    }
}

