/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.JsonMapper;
import io.camunda.process.test.api.CamundaAssert;
import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.api.CamundaProcessTestContext;
import io.camunda.process.test.api.CamundaProcessTestRuntimeMode;
import io.camunda.process.test.api.coverage.ProcessCoverage;
import io.camunda.process.test.api.coverage.ProcessCoverageBuilder;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.client.CamundaManagementClient;
import io.camunda.process.test.impl.containers.CamundaContainer;
import io.camunda.process.test.impl.extension.CamundaProcessTestContextImpl;
import io.camunda.process.test.impl.runtime.CamundaProcessTestContainerRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeBuilder;
import io.camunda.process.test.impl.testresult.CamundaProcessTestResultCollector;
import io.camunda.process.test.impl.testresult.CamundaProcessTestResultPrinter;
import io.camunda.process.test.impl.testresult.ProcessTestResult;
import io.camunda.zeebe.client.ZeebeClient;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaProcessTestExtension
implements BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CamundaProcessTestExtension.class});
    public static final String STORE_KEY_RUNTIME = "camunda-process-test-runtime";
    public static final String STORE_KEY_CONTEXT = "camunda-process-test-context";
    private static final Logger LOG = LoggerFactory.getLogger(CamundaProcessTestExtension.class);
    private final List<AutoCloseable> createdClients = new ArrayList<AutoCloseable>();
    private final CamundaProcessTestRuntimeBuilder runtimeBuilder;
    private final CamundaProcessTestResultPrinter processTestResultPrinter;
    private final ProcessCoverageBuilder processCoverageBuilder;
    private ProcessCoverage processCoverage;
    private CamundaProcessTestRuntime runtime;
    private CamundaProcessTestResultCollector processTestResultCollector;
    private JsonMapper jsonMapper;
    private io.camunda.zeebe.client.api.JsonMapper zeebeJsonMapper;
    private CamundaManagementClient camundaManagementClient;
    private CamundaProcessTestContext camundaProcessTestContext;

    CamundaProcessTestExtension(CamundaProcessTestRuntimeBuilder containerRuntimeBuilder, ProcessCoverageBuilder processCoverageBuilder, Consumer<String> testResultPrintStream) {
        this.runtimeBuilder = containerRuntimeBuilder;
        this.processCoverageBuilder = processCoverageBuilder.printStream(testResultPrintStream);
        this.processTestResultPrinter = new CamundaProcessTestResultPrinter(testResultPrintStream);
    }

    public CamundaProcessTestExtension() {
        this(CamundaProcessTestContainerRuntime.newBuilder(), ProcessCoverage.newBuilder(), arg_0 -> ((Logger)LOG).info(arg_0));
    }

    public void beforeAll(ExtensionContext context) {
        this.runtime = this.runtimeBuilder.build();
        this.runtime.start();
        this.camundaManagementClient = this.createManagementClient(this.runtimeBuilder);
        this.camundaProcessTestContext = new CamundaProcessTestContextImpl(this.runtime, this.createdClients::add, this.camundaManagementClient, CamundaAssert.getAwaitBehavior(), this.jsonMapper, this.zeebeJsonMapper);
        this.processCoverage = this.processCoverageBuilder.testClass(context.getRequiredTestClass()).dataSource(() -> new CamundaDataSource(this.camundaProcessTestContext.createClient())).reportDirectory(this.runtimeBuilder.getCoverageReportDirectory()).excludeProcessDefinitionIds(this.runtimeBuilder.getCoverageExcludedProcesses()).build();
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.put((Object)STORE_KEY_RUNTIME, (Object)this.runtime);
        store.put((Object)STORE_KEY_CONTEXT, (Object)this.camundaProcessTestContext);
        this.initializeJsonMapper(this.jsonMapper, this.zeebeJsonMapper);
    }

    private CamundaManagementClient createManagementClient(CamundaProcessTestRuntimeBuilder runtimeBuilder) {
        if (runtimeBuilder.isMultiTenancyEnabled()) {
            return CamundaManagementClient.createAuthenticatedClient(this.runtime.getCamundaMonitoringApiAddress(), this.runtime.getCamundaRestApiAddress(), CamundaContainer.MultiTenancyConfiguration.getBasicAuthCredentials());
        }
        return CamundaManagementClient.createClient(this.runtime.getCamundaMonitoringApiAddress(), this.runtime.getCamundaRestApiAddress());
    }

    private void initializeJsonMapper(JsonMapper jsonMapper, io.camunda.zeebe.client.api.JsonMapper zeebeJsonMapper) {
        if (jsonMapper != null) {
            CamundaAssert.setJsonMapper(jsonMapper);
        } else if (zeebeJsonMapper != null) {
            CamundaAssert.setJsonMapper(zeebeJsonMapper);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.runtime == null) {
            throw new IllegalStateException("The CamundaProcessTestExtension failed to start because the runtime is not created. Make sure that you registering the extension on a static field.");
        }
        try {
            this.injectField(context, CamundaClient.class, this.camundaProcessTestContext::createClient);
            this.injectField(context, ZeebeClient.class, this.camundaProcessTestContext::createZeebeClient);
            this.injectField(context, CamundaProcessTestContext.class, () -> this.camundaProcessTestContext);
        }
        catch (Exception e) {
            this.closeCreatedClients();
            this.runtime.close();
            throw e;
        }
        CamundaDataSource dataSource = new CamundaDataSource(this.camundaProcessTestContext.createClient());
        CamundaAssert.initialize(dataSource);
        this.processTestResultCollector = new CamundaProcessTestResultCollector(dataSource);
    }

    private <T> void injectField(ExtensionContext context, Class<T> injectionType, Supplier<T> injectionValue) {
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectField(instance, injectionType, injectionValue));
    }

    private <T> void injectField(Object testInstance, Class<T> injectionType, Supplier<T> injectionValue) {
        ReflectionUtils.findFields(testInstance.getClass(), field -> CamundaProcessTestExtension.isNotStatic(field) && field.getType().isAssignableFrom(injectionType), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(field -> {
            try {
                field.setAccessible(true);
                field.set(testInstance, injectionValue.get());
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
    }

    private static boolean isNotStatic(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    public void afterEach(ExtensionContext context) {
        if (this.runtime == null) {
            return;
        }
        try {
            this.processCoverage.collectTestRunCoverage(context.getDisplayName());
        }
        catch (Throwable t) {
            LOG.warn("Failed to collect test process coverage, skipping.", t);
        }
        if (CamundaProcessTestExtension.isTestFailed(context)) {
            this.printTestResults();
        }
        CamundaAssert.reset();
        this.closeCreatedClients();
        this.resetRuntimeClock();
        this.deleteRuntimeData();
    }

    private void printTestResults() {
        try {
            ProcessTestResult testResult = this.processTestResultCollector.collect();
            this.processTestResultPrinter.print(testResult);
        }
        catch (Throwable t) {
            LOG.warn("Failed to collect test results, skipping.", t);
        }
    }

    private void deleteRuntimeData() {
        try {
            LOG.debug("Deleting the runtime data");
            Instant startTime = Instant.now();
            this.camundaManagementClient.purgeCluster();
            Instant endTime = Instant.now();
            Duration duration = Duration.between(startTime, endTime);
            LOG.debug("Runtime data deleted in {}", (Object)duration);
        }
        catch (Throwable t) {
            LOG.warn("Failed to delete the runtime data, skipping. Check the runtime for details. Note that a dirty runtime may cause failures in other test cases.", t);
        }
    }

    private void resetRuntimeClock() {
        try {
            LOG.debug("Resetting the time");
            this.camundaManagementClient.resetTime();
            LOG.debug("Time reset");
        }
        catch (Throwable t) {
            LOG.warn("Failed to reset the time, skipping. Check the runtime for details. Note that a dirty runtime may cause failures in other test cases.", t);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.runtime == null) {
            return;
        }
        try {
            this.processCoverage.reportCoverage();
        }
        catch (Throwable t) {
            LOG.warn("Failed to report process coverage, skipping.", t);
        }
        this.runtime.close();
    }

    private static boolean isTestFailed(ExtensionContext extensionContext) {
        return extensionContext.getExecutionException().isPresent();
    }

    @Deprecated
    public CamundaProcessTestExtension withCamundaVersion(String camundaVersion) {
        return this.withCamundaDockerImageVersion(camundaVersion);
    }

    public CamundaProcessTestExtension withCamundaDockerImageVersion(String camundaDockerImageVersion) {
        this.runtimeBuilder.withCamundaDockerImageVersion(camundaDockerImageVersion);
        return this;
    }

    public CamundaProcessTestExtension withCamundaDockerImageName(String dockerImageName) {
        this.runtimeBuilder.withCamundaDockerImageName(dockerImageName);
        return this;
    }

    public CamundaProcessTestExtension withCamundaEnv(Map<String, String> envVars) {
        this.runtimeBuilder.withCamundaEnv(envVars);
        return this;
    }

    public CamundaProcessTestExtension withCamundaEnv(String name, String value) {
        this.runtimeBuilder.withCamundaEnv(name, value);
        return this;
    }

    public CamundaProcessTestExtension withCamundaExposedPort(int port) {
        this.runtimeBuilder.withCamundaExposedPort(port);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsEnabled(boolean enabled) {
        this.runtimeBuilder.withConnectorsEnabled(enabled);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsDockerImageName(String dockerImageName) {
        this.runtimeBuilder.withConnectorsDockerImageName(dockerImageName);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsDockerImageVersion(String dockerImageVersion) {
        this.runtimeBuilder.withConnectorsDockerImageVersion(dockerImageVersion);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsEnv(Map<String, String> envVars) {
        this.runtimeBuilder.withConnectorsEnv(envVars);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsEnv(String name, String value) {
        this.runtimeBuilder.withConnectorsEnv(name, value);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsSecret(String name, String value) {
        this.runtimeBuilder.withConnectorsSecret(name, value);
        return this;
    }

    public CamundaProcessTestExtension withRuntimeMode(CamundaProcessTestRuntimeMode runtimeMode) {
        this.runtimeBuilder.withRuntimeMode(runtimeMode);
        return this;
    }

    public CamundaProcessTestExtension withRemoteCamundaClientBuilderFactory(CamundaClientBuilderFactory camundaClientBuilderFactory) {
        this.runtimeBuilder.withRemoteCamundaClientBuilderFactory(camundaClientBuilderFactory);
        return this;
    }

    public CamundaProcessTestExtension withRemoteCamundaMonitoringApiAddress(URI remoteCamundaMonitoringApiAddress) {
        this.runtimeBuilder.withRemoteCamundaMonitoringApiAddress(remoteCamundaMonitoringApiAddress);
        return this;
    }

    public CamundaProcessTestExtension withRemoteConnectorsRestApiAddress(URI remoteConnectorsRestApiAddress) {
        this.runtimeBuilder.withRemoteConnectorsRestApiAddress(remoteConnectorsRestApiAddress);
        return this;
    }

    public CamundaProcessTestExtension withCoverageExcludedProcesses(String ... processDefinitionIds) {
        this.runtimeBuilder.withCoverageExcludedProcesses(Arrays.asList(processDefinitionIds));
        return this;
    }

    public CamundaProcessTestExtension withCoverageReportDirectory(String reportDirectory) {
        this.runtimeBuilder.withCoverageReportDirectory(reportDirectory);
        return this;
    }

    public CamundaProcessTestExtension withMultiTenancyEnabled(boolean enabled) {
        this.runtimeBuilder.withMultiTenancyEnabled(enabled);
        return this;
    }

    public CamundaProcessTestExtension withJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        return this;
    }

    @Deprecated
    public CamundaProcessTestExtension withJsonMapper(io.camunda.zeebe.client.api.JsonMapper jsonMapper) {
        this.zeebeJsonMapper = jsonMapper;
        return this;
    }

    private void closeCreatedClients() {
        for (AutoCloseable client : this.createdClients) {
            try {
                client.close();
            }
            catch (Exception e) {
                LOG.debug("Failed to close client, continue.", (Throwable)e);
            }
        }
    }
}

