/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.assertions;

import io.camunda.client.api.search.filter.ProcessInstanceFilter;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.process.test.api.assertions.ProcessInstanceSelector;

public class ProcessInstanceSelectors {
    public static ProcessInstanceSelector byKey(long processInstanceKey) {
        return new ProcessInstanceKeySelector(processInstanceKey);
    }

    public static ProcessInstanceSelector byProcessId(String processDefinitionId) {
        return new ProcessDefinitionIdSelector(processDefinitionId);
    }

    public static ProcessInstanceSelector byParentProcessInstanceKey(long parentProcessInstanceKey) {
        return new ParentProcessInstanceKeySelector(parentProcessInstanceKey);
    }

    private static final class ProcessInstanceKeySelector
    implements ProcessInstanceSelector {
        private final long processInstanceKey;

        private ProcessInstanceKeySelector(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
        }

        @Override
        public boolean test(ProcessInstance processInstance) {
            return processInstance.getProcessInstanceKey().equals(this.processInstanceKey);
        }

        @Override
        public String describe() {
            return String.format("key: %s", this.processInstanceKey);
        }

        @Override
        public void applyFilter(ProcessInstanceFilter filter) {
            filter.processInstanceKey(Long.valueOf(this.processInstanceKey));
        }
    }

    private static final class ProcessDefinitionIdSelector
    implements ProcessInstanceSelector {
        private final String processDefinitionId;

        private ProcessDefinitionIdSelector(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }

        @Override
        public boolean test(ProcessInstance processInstance) {
            return processInstance.getProcessDefinitionId().equals(this.processDefinitionId);
        }

        @Override
        public String describe() {
            return String.format("process-id: '%s'", this.processDefinitionId);
        }

        @Override
        public void applyFilter(ProcessInstanceFilter filter) {
            filter.processDefinitionId(this.processDefinitionId);
        }
    }

    private static final class ParentProcessInstanceKeySelector
    implements ProcessInstanceSelector {
        private final long parentProcessInstanceKey;

        private ParentProcessInstanceKeySelector(long parentProcessInstanceKey) {
            this.parentProcessInstanceKey = parentProcessInstanceKey;
        }

        @Override
        public boolean test(ProcessInstance processInstance) {
            return processInstance.getParentProcessInstanceKey().equals(this.parentProcessInstanceKey);
        }

        @Override
        public String describe() {
            return String.format("parent process instance key: %s", this.parentProcessInstanceKey);
        }

        @Override
        public void applyFilter(ProcessInstanceFilter filter) {
            filter.parentProcessInstanceKey(Long.valueOf(this.parentProcessInstanceKey));
        }
    }
}

