/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.coverage;

import io.camunda.process.test.api.coverage.ProcessCoverage;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ProcessCoverageBuilder {
    private String reportDirectory = null;
    private List<String> excludedProcessDefinitionIds = Collections.emptyList();
    private Class<?> testClass = null;
    private Supplier<CamundaDataSource> dataSourceSupplier;
    private Consumer<String> printStream;

    public ProcessCoverageBuilder excludeProcessDefinitionIds(List<String> processDefinitionIds) {
        this.excludedProcessDefinitionIds = processDefinitionIds;
        return this;
    }

    public ProcessCoverageBuilder reportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
        return this;
    }

    public ProcessCoverageBuilder testClass(Class<?> testClass) {
        this.testClass = testClass;
        return this;
    }

    public ProcessCoverageBuilder dataSource(Supplier<CamundaDataSource> dataSourceSupplier) {
        this.dataSourceSupplier = dataSourceSupplier;
        return this;
    }

    public ProcessCoverageBuilder printStream(Consumer<String> printStream) {
        this.printStream = printStream;
        return this;
    }

    public ProcessCoverage build() {
        return new ProcessCoverage(this.testClass, this.excludedProcessDefinitionIds, this.reportDirectory, this.printStream, this.dataSourceSupplier);
    }
}

