/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.coverage.core;

import io.camunda.process.test.api.coverage.core.CoverageCreator;
import io.camunda.process.test.api.coverage.core.ModelCreator;
import io.camunda.process.test.api.coverage.model.Coverage;
import io.camunda.process.test.api.coverage.model.Model;
import io.camunda.process.test.api.coverage.model.Run;
import io.camunda.process.test.api.coverage.model.Suite;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class CoverageCollector {
    private static final List<CoverageCollector> COLLECTORS = new ArrayList<CoverageCollector>();
    private final List<String> excludedProcessDefinitionIds;
    private final Supplier<CamundaDataSource> dataSourceSupplier;
    private final Map<String, Model> models = new HashMap<String, Model>();
    private final Suite suite;

    private CoverageCollector(Class<?> testClass, List<String> excludedProcessDefinitionIds, Supplier<CamundaDataSource> dataSourceSupplier) {
        this.excludedProcessDefinitionIds = excludedProcessDefinitionIds;
        this.dataSourceSupplier = dataSourceSupplier;
        this.suite = new Suite(testClass.getName(), testClass.getSimpleName());
    }

    public static CoverageCollector createCollector(Class<?> testClass, List<String> excludedProcessDefinitionIds, Supplier<CamundaDataSource> dataSourceSupplier) {
        CoverageCollector collector = new CoverageCollector(testClass, excludedProcessDefinitionIds, dataSourceSupplier);
        COLLECTORS.add(collector);
        return collector;
    }

    public static Collection<CoverageCollector> collectors() {
        return Collections.unmodifiableList(COLLECTORS);
    }

    public void collectTestRunCoverage(String runName) {
        CamundaDataSource dataSource = this.dataSourceSupplier.get();
        List processInstances = dataSource.findProcessInstances().stream().filter(processInstance -> !this.excludedProcessDefinitionIds.contains(processInstance.getProcessDefinitionId())).collect(Collectors.toList());
        List<Coverage> coverages = processInstances.stream().map(processInstance -> CoverageCreator.createCoverage(dataSource, processInstance, this.models.computeIfAbsent(processInstance.getProcessDefinitionId(), key -> ModelCreator.createModel(dataSource, key)))).collect(Collectors.toList());
        this.suite.addRun(new Run(runName, coverages));
    }

    public Suite getSuite() {
        return this.suite;
    }

    public Collection<Model> getModels() {
        return this.models.values();
    }
}

