/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.coverage.core;

import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.process.test.api.coverage.model.Model;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.SequenceFlow;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ModelCreator {
    public static Model createModel(CamundaDataSource dataSource, String processDefinitionId) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(dataSource.getProcessDefinitionXmlByProcessDefinitionId(processDefinitionId).getBytes());
        BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)inputStream);
        if (modelInstance == null) {
            throw new IllegalArgumentException("Cannot read model from process definition: " + processDefinitionId);
        }
        ProcessDefinition processDefinition = dataSource.findProcessDefinitionByProcessDefinitionId(processDefinitionId);
        Set definitionFlowNodes = modelInstance.getModelElementsByType(FlowNode.class).stream().filter(node -> ModelCreator.isExecutable((ModelElementInstance)node, processDefinition.getProcessDefinitionId())).collect(Collectors.toSet());
        Set definitionSequenceFlows = modelInstance.getModelElementsByType(SequenceFlow.class).stream().filter(s -> definitionFlowNodes.contains(s.getSource())).collect(Collectors.toSet());
        return new Model(processDefinition.getProcessDefinitionId(), definitionFlowNodes.size() + definitionSequenceFlows.size(), String.valueOf(processDefinition.getVersion()), Bpmn.convertToString((BpmnModelInstance)modelInstance));
    }

    private static boolean isExecutable(ModelElementInstance node, String processId) {
        if (node == null) {
            return false;
        }
        if (node instanceof Process) {
            Process process = (Process)node;
            return process.isExecutable() && process.getId().equals(processId);
        }
        return ModelCreator.isExecutable(node.getParentElement(), processId);
    }
}

