/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.coverage.report;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.process.test.api.coverage.report.HtmlCoverageReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class CoverageReportUtil {
    public static final String REPORT_RESOURCES = "coverage/static/";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String REPORT_TEMPLATE = "coverage/index.html";

    public static String toJson(Object report) {
        try {
            return OBJECT_MAPPER.writer().withDefaultPrettyPrinter().writeValueAsString(report);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize object to Json : " + (Object)((Object)e));
        }
    }

    public static String toHtml(HtmlCoverageReport coverageReport) {
        InputStream template = CoverageReportUtil.class.getClassLoader().getResourceAsStream(REPORT_TEMPLATE);
        Objects.requireNonNull(template, "Report template not found in classpath: coverage/index.html");
        String html = new BufferedReader(new InputStreamReader(template, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        return html.replace("{{ COVERAGE_DATA }}", CoverageReportUtil.toJson(coverageReport));
    }

    static void installReportDependencies(File reportDirectory) {
        File reportResourcesDir = new File(reportDirectory, REPORT_RESOURCES);
        if (!reportResourcesDir.exists()) {
            try {
                if (!reportDirectory.exists() && !reportDirectory.mkdirs()) {
                    throw new IllegalStateException("Could not create report parent directory: " + reportDirectory.getAbsolutePath());
                }
                URL resourceUrl = CoverageReportUtil.class.getResource("/coverage/static/");
                if (resourceUrl == null) {
                    throw new IllegalStateException("Report resources not found in classpath");
                }
                if (resourceUrl.getProtocol().equals("jar")) {
                    CoverageReportUtil.copyResourcesFromJar(reportDirectory);
                } else {
                    File source = new File(resourceUrl.toURI());
                    FileUtils.copyDirectoryToDirectory((File)source, (File)reportDirectory);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to copy report resources", e);
            }
        }
    }

    private static void copyResourcesFromJar(File reportDirectory) throws Exception {
        String jarPath = CoverageReportUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String tailFolder = Paths.get(REPORT_RESOURCES, new String[0]).getFileName().toString();
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith(REPORT_RESOURCES) || entry.isDirectory()) continue;
                String relativePath = entryName.substring(REPORT_RESOURCES.length());
                File targetFile = new File(reportDirectory, tailFolder + "/" + relativePath);
                if (!targetFile.toPath().normalize().startsWith(reportDirectory.toPath())) {
                    throw new RuntimeException("Bad jar entry: " + entryName);
                }
                File parentDir = targetFile.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    throw new IllegalStateException("Could not create directory: " + parentDir.getAbsolutePath());
                }
                InputStream inputStream = jarFile.getInputStream(entry);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }
}

