/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.coverage.report;

import io.camunda.process.test.api.coverage.core.CoverageCollector;
import io.camunda.process.test.api.coverage.core.CoverageCreator;
import io.camunda.process.test.api.coverage.model.Coverage;
import io.camunda.process.test.api.coverage.model.Suite;
import io.camunda.process.test.api.coverage.report.AggregatedCoverageReport;
import io.camunda.process.test.api.coverage.report.CoverageReportCreator;
import io.camunda.process.test.api.coverage.report.CoverageReportUtil;
import io.camunda.process.test.api.coverage.report.HtmlCoverageReport;
import io.camunda.process.test.api.coverage.report.SuiteCoverageReport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageReporter {
    public static final String TARGET_DIR_ROOT = System.getProperty("camunda-process-test-coverage.target-dir-root", "target/process-test-coverage/");
    private static final Logger LOG = LoggerFactory.getLogger(CoverageReporter.class);
    private final Consumer<String> printStream;
    private final File resourceDirectory;

    public CoverageReporter(String resourceDirectory, Consumer<String> printStream) {
        this.printStream = Optional.ofNullable(printStream).orElse(arg_0 -> ((Logger)LOG).info(arg_0));
        this.resourceDirectory = new File(Optional.ofNullable(resourceDirectory).orElse(TARGET_DIR_ROOT)).getAbsoluteFile();
    }

    public void reportCoverage(CoverageCollector coverageCollector) {
        Collection suites = CoverageCollector.collectors().stream().map(CoverageCollector::getSuite).collect(Collectors.toList());
        Collection models = CoverageCollector.collectors().stream().flatMap(c -> c.getModels().stream()).distinct().collect(Collectors.toList());
        this.writeJsonReport(CoverageReportCreator.createSuiteCoverageReport(coverageCollector.getSuite(), coverageCollector.getModels()));
        this.writeJsonReport(CoverageReportCreator.createAggregatedCoverageReport(suites, models));
        this.writeHtmlReport(CoverageReportCreator.createHtmlCoverageReport(suites, models));
    }

    public void printCoverage(CoverageCollector coverageCollector) {
        Suite suite = coverageCollector.getSuite();
        List<Coverage> coverages = CoverageCreator.aggregateCoverages(suite.getRuns().stream().flatMap(r -> r.getCoverages().stream()).collect(Collectors.toList()), coverageCollector.getModels());
        String coverageList = coverages.stream().map(coverage -> String.format("- %s: %.0f%%", coverage.getProcessDefinitionId(), coverage.getCoverage() * 100.0)).collect(Collectors.joining("\n"));
        String message = MessageFormat.format("Process coverage: {1} \n========================\n{2}\n\n Coverage report: file://{0}/report.html\n", this.resourceDirectory, suite.getId(), coverageList);
        this.printStream.accept(message);
    }

    private void writeJsonReport(SuiteCoverageReport report) {
        File destFile = new File(this.resourceDirectory, report.getId() + "/report.json");
        this.writeContent(destFile, () -> CoverageReportUtil.toJson(report));
    }

    private void writeJsonReport(AggregatedCoverageReport aggregatedReport) {
        File jsonFile = new File(this.resourceDirectory, "/report.json");
        this.writeContent(jsonFile, () -> CoverageReportUtil.toJson(aggregatedReport));
    }

    private void writeHtmlReport(HtmlCoverageReport htmlCoverageReport) {
        CoverageReportUtil.installReportDependencies(this.resourceDirectory);
        File destFile = new File(this.resourceDirectory, "report.html");
        this.writeContent(destFile, () -> CoverageReportUtil.toHtml(htmlCoverageReport));
    }

    private void writeContent(File destFile, Supplier<String> contentProvider) {
        try {
            if (destFile.getParentFile() != null && !destFile.getParentFile().exists()) {
                Files.createDirectories(destFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            Files.write(FileSystems.getDefault().getPath(destFile.getPath(), new String[0]), contentProvider.get().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write report.", ex);
        }
    }
}

