/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.search.filter.CorrelatedMessageSubscriptionFilter;
import io.camunda.client.api.search.filter.DecisionInstanceFilter;
import io.camunda.client.api.search.filter.ElementInstanceFilter;
import io.camunda.client.api.search.filter.IncidentFilter;
import io.camunda.client.api.search.filter.MessageSubscriptionFilter;
import io.camunda.client.api.search.filter.ProcessInstanceFilter;
import io.camunda.client.api.search.filter.UserTaskFilter;
import io.camunda.client.api.search.filter.VariableFilter;
import io.camunda.client.api.search.request.CorrelatedMessageSubscriptionSearchRequest;
import io.camunda.client.api.search.request.DecisionInstanceSearchRequest;
import io.camunda.client.api.search.request.ElementInstanceSearchRequest;
import io.camunda.client.api.search.request.IncidentSearchRequest;
import io.camunda.client.api.search.request.MessageSubscriptionSearchRequest;
import io.camunda.client.api.search.request.ProcessDefinitionSearchRequest;
import io.camunda.client.api.search.request.ProcessInstanceSearchRequest;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.UserTaskSearchRequest;
import io.camunda.client.api.search.request.VariableSearchRequest;
import io.camunda.client.api.search.response.CorrelatedMessageSubscription;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.MessageSubscription;
import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.api.search.response.ProcessInstanceSequenceFlow;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.client.api.search.response.Variable;
import java.util.List;
import java.util.function.Consumer;

public class CamundaDataSource {
    private static final Consumer<SearchRequestPage> DEFAULT_PAGE_REQUEST = page -> page.limit(Integer.valueOf(100));
    private final CamundaClient client;

    public CamundaDataSource(CamundaClient client) {
        this.client = client;
    }

    public List<ElementInstance> findElementInstancesByProcessInstanceKey(long processInstanceKey) {
        return this.findElementInstances(filter -> filter.processInstanceKey(processInstanceKey));
    }

    public List<ProcessInstanceSequenceFlow> findSequenceFlowsByProcessInstanceKey(long processInstanceKey) {
        return (List)this.client.newProcessInstanceSequenceFlowsRequest(processInstanceKey).send().join();
    }

    public List<ProcessDefinition> findProcessDefinitionsByProcessDefinitionId(String bpmnProcessId) {
        return ((SearchResponse)((ProcessDefinitionSearchRequest)((ProcessDefinitionSearchRequest)((ProcessDefinitionSearchRequest)this.client.newProcessDefinitionSearchRequest().filter(filter -> filter.processDefinitionId(bpmnProcessId))).page(DEFAULT_PAGE_REQUEST)).sort(sort -> sort.version().desc())).send().join()).items();
    }

    public ProcessDefinition findProcessDefinitionByProcessDefinitionId(String bpmnProcessId) {
        return (ProcessDefinition)this.findProcessDefinitionsByProcessDefinitionId(bpmnProcessId).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Process definition not found"));
    }

    public String getProcessDefinitionXmlByProcessDefinitionId(String bpmnProcessId) {
        return this.getProcessDefinitionXmlByProcessDefinitionKey(this.findProcessDefinitionByProcessDefinitionId(bpmnProcessId).getProcessDefinitionKey());
    }

    public String getProcessDefinitionXmlByProcessDefinitionKey(long processDefinitionKey) {
        return (String)this.client.newProcessDefinitionGetXmlRequest(processDefinitionKey).send().join();
    }

    public List<ElementInstance> findElementInstances(Consumer<ElementInstanceFilter> filter) {
        return ((SearchResponse)((ElementInstanceSearchRequest)((ElementInstanceSearchRequest)((ElementInstanceSearchRequest)this.client.newElementInstanceSearchRequest().filter(filter)).sort(sort -> sort.startDate().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<Variable> findGlobalVariablesByProcessInstanceKey(long processInstanceKey) {
        return this.findVariables(filter -> filter.processInstanceKey(Long.valueOf(processInstanceKey)).scopeKey(Long.valueOf(processInstanceKey)));
    }

    public List<Variable> findVariables(Consumer<VariableFilter> filter) {
        return ((SearchResponse)((VariableSearchRequest)((VariableSearchRequest)this.client.newVariableSearchRequest().filter(filter)).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public Variable getVariable(long variableKey) {
        return (Variable)this.client.newVariableGetRequest(variableKey).send().join();
    }

    public List<ProcessInstance> findProcessInstances() {
        return this.findProcessInstances(filter -> {});
    }

    public List<ProcessInstance> findProcessInstances(Consumer<ProcessInstanceFilter> filter) {
        return ((SearchResponse)((ProcessInstanceSearchRequest)((ProcessInstanceSearchRequest)((ProcessInstanceSearchRequest)this.client.newProcessInstanceSearchRequest().filter(filter)).sort(sort -> sort.startDate().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<Incident> findIncidents(Consumer<IncidentFilter> filter) {
        return ((SearchResponse)((IncidentSearchRequest)((IncidentSearchRequest)((IncidentSearchRequest)this.client.newIncidentSearchRequest().filter(filter)).sort(sort -> sort.creationTime().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<UserTask> findUserTasks(Consumer<UserTaskFilter> filter) {
        return ((SearchResponse)((UserTaskSearchRequest)((UserTaskSearchRequest)((UserTaskSearchRequest)this.client.newUserTaskSearchRequest().filter(filter)).sort(sort -> sort.creationDate().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<DecisionInstance> findDecisionInstances(Consumer<DecisionInstanceFilter> filter) {
        return ((SearchResponse)((DecisionInstanceSearchRequest)this.client.newDecisionInstanceSearchRequest().filter(filter)).send().join()).items();
    }

    public DecisionInstance getDecisionInstance(String decisionInstanceId) {
        return (DecisionInstance)this.client.newDecisionInstanceGetRequest(decisionInstanceId).send().join();
    }

    public List<MessageSubscription> findMessageSubscriptions(Consumer<MessageSubscriptionFilter> filter) {
        return ((SearchResponse)((MessageSubscriptionSearchRequest)((MessageSubscriptionSearchRequest)((MessageSubscriptionSearchRequest)this.client.newMessageSubscriptionSearchRequest().filter(filter)).sort(sort -> sort.lastUpdatedDate().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<CorrelatedMessageSubscription> findCorrelatedMessages(Consumer<CorrelatedMessageSubscriptionFilter> filter) {
        return ((SearchResponse)((CorrelatedMessageSubscriptionSearchRequest)((CorrelatedMessageSubscriptionSearchRequest)((CorrelatedMessageSubscriptionSearchRequest)this.client.newCorrelatedMessageSubscriptionSearchRequest().filter(filter)).sort(sort -> sort.correlationTime().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }
}

