/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.api.response.MatchedDecisionRule;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ListAssert;

public class DecisionMatchedRulesAssertj
extends AbstractAssert<DecisionMatchedRulesAssertj, String> {
    public DecisionMatchedRulesAssertj(String failureMessagePrefix) {
        super((Object)failureMessagePrefix, DecisionMatchedRulesAssertj.class);
    }

    public void hasNoMatchedRules(List<MatchedDecisionRule> matchedRules) {
        List actualMatchedRuleIndices = matchedRules.stream().map(MatchedDecisionRule::getRuleIndex).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(matchedRules).withFailMessage("%s to have no matches, but matched %s", new Object[]{this.actual, actualMatchedRuleIndices})).isEmpty();
    }

    public void hasMatchedRules(List<MatchedDecisionRule> matchedRules, int ... expectedMatchedRuleIndexes) {
        List<Integer> expectedMatches = this.validateExpectedRuleIndexes(expectedMatchedRuleIndexes);
        List actualMatchedRuleIndices = matchedRules.stream().map(MatchedDecisionRule::getRuleIndex).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(actualMatchedRuleIndices).withFailMessage("%s to have matched rules %s, but did not. Matches:\n\t- matched: %s\n\t- missing: %s\n\t- unexpected: %s", new Object[]{this.actual, Arrays.toString(expectedMatchedRuleIndexes), this.matchingRules(actualMatchedRuleIndices, expectedMatches), this.missingRules(actualMatchedRuleIndices, expectedMatches), this.unexpectedRules(actualMatchedRuleIndices, expectedMatches)})).containsAll(expectedMatches);
    }

    public void hasNotMatchedRules(List<MatchedDecisionRule> matchedRules, int ... expectedUnmatchedRuleIndexes) {
        List<Integer> expectedUnmatchedRuleIndexList = this.validateExpectedRuleIndexes(expectedUnmatchedRuleIndexes);
        List actualMatchedRuleIndexes = matchedRules.stream().map(MatchedDecisionRule::getRuleIndex).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(actualMatchedRuleIndexes).withFailMessage("%s to not have matched rules %s, but matched %s", new Object[]{this.actual, Arrays.toString(expectedUnmatchedRuleIndexes), this.matchingRules(actualMatchedRuleIndexes, expectedUnmatchedRuleIndexList)})).doesNotContainAnyElementsOf(expectedUnmatchedRuleIndexList);
    }

    private <T> List<T> matchingRules(List<T> actualMatches, List<T> expectedMatches) {
        return expectedMatches.stream().filter(actualMatches::contains).collect(Collectors.toList());
    }

    private <T> List<T> missingRules(List<T> actualMatches, List<T> expectedMatches) {
        return expectedMatches.stream().filter(e -> actualMatches.stream().noneMatch(a -> Objects.equals(a, e))).collect(Collectors.toList());
    }

    private <T> List<T> unexpectedRules(List<T> actualMatches, List<T> expectedMatches) {
        return actualMatches.stream().filter(e -> expectedMatches.stream().noneMatch(a -> Objects.equals(a, e))).collect(Collectors.toList());
    }

    private List<Integer> validateExpectedRuleIndexes(int ... ruleIndexes) {
        List<Integer> ruleIndexList;
        if (ruleIndexes.length == 0) {
            Fail.fail((String)"No matched rules given. Please provide at least one matched rule index.");
        }
        if ((ruleIndexList = Arrays.stream(ruleIndexes).boxed().collect(Collectors.toList())).stream().anyMatch(i -> i <= 0)) {
            Fail.fail((String)"Matched rule indexes contain illegal values: %s", (Object[])new Object[]{Arrays.toString(ruleIndexes)});
        }
        return ruleIndexList;
    }
}

