/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.api.search.enums.ElementInstanceState;
import io.camunda.client.api.search.filter.ElementInstanceFilter;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.process.test.api.assertions.ElementSelector;
import io.camunda.process.test.impl.assertions.AssertFormatUtil;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class ElementAssertj
extends AbstractAssert<ElementAssertj, String> {
    private final CamundaDataSource dataSource;
    private final CamundaAssertAwaitBehavior awaitBehavior;

    protected ElementAssertj(CamundaDataSource dataSource, CamundaAssertAwaitBehavior awaitBehavior, String failureMessagePrefix) {
        super((Object)failureMessagePrefix, ElementAssertj.class);
        this.dataSource = dataSource;
        this.awaitBehavior = awaitBehavior;
    }

    public void hasActiveElements(long processInstanceKey, List<ElementSelector> elementSelectors) {
        this.hasElementsInState(processInstanceKey, elementSelectors, ElementInstanceState.ACTIVE);
    }

    public void hasCompletedElements(long processInstanceKey, List<ElementSelector> elementSelectors) {
        this.hasElementsInState(processInstanceKey, elementSelectors, ElementInstanceState.COMPLETED);
    }

    public void hasTerminatedElements(long processInstanceKey, List<ElementSelector> elementSelectors) {
        this.hasElementsInState(processInstanceKey, elementSelectors, ElementInstanceState.TERMINATED);
    }

    private void hasElementsInState(long processInstanceKey, List<ElementSelector> elementSelectors, ElementInstanceState expectedState) {
        this.awaitElementInstanceAssertion(ElementAssertj.elementInstanceFilter(processInstanceKey, elementSelectors), elementInstances -> {
            List<ElementInstance> elementInstancesInState = ElementAssertj.getInstancesInState(elementInstances, expectedState);
            List<ElementSelector> selectorsNotMatched = ElementAssertj.getSelectorsWithoutInstances(elementSelectors, elementInstancesInState);
            ((ListAssert)Assertions.assertThat(selectorsNotMatched).withFailMessage("%s should have %s elements %s but the following elements were not %s:\n%s", new Object[]{this.actual, ElementAssertj.formatState(expectedState), ElementAssertj.formatElementSelectors(elementSelectors), ElementAssertj.formatState(expectedState), ElementAssertj.formatElementInstanceStates(selectorsNotMatched, elementInstances)})).isEmpty();
        });
    }

    public void hasActiveElement(long processInstanceKey, ElementSelector elementSelector, int expectedTimes) {
        this.hasElementInState(processInstanceKey, elementSelector, ElementInstanceState.ACTIVE, expectedTimes);
    }

    public void hasCompletedElement(long processInstanceKey, ElementSelector elementSelector, int expectedTimes) {
        this.hasElementInState(processInstanceKey, elementSelector, ElementInstanceState.COMPLETED, expectedTimes);
    }

    public void hasTerminatedElement(long processInstanceKey, ElementSelector elementSelector, int expectedTimes) {
        this.hasElementInState(processInstanceKey, elementSelector, ElementInstanceState.TERMINATED, expectedTimes);
    }

    private void hasElementInState(long processInstanceKey, ElementSelector elementSelector, ElementInstanceState expectedState, int expectedTimes) {
        if (expectedTimes < 0) {
            throw new IllegalArgumentException("The amount must be greater than or equal to zero.");
        }
        this.awaitElementInstanceAssertion(ElementAssertj.elementInstanceFilter(processInstanceKey, Collections.singletonList(elementSelector)), elementInstancesUnfiltered -> {
            List<ElementInstance> elementInstances = elementInstancesUnfiltered.stream().filter(elementSelector::test).collect(Collectors.toList());
            long actualTimes = ElementAssertj.getInstancesInState(elementInstances, expectedState).size();
            ((AbstractLongAssert)Assertions.assertThat((long)actualTimes).withFailMessage("%s should have %s element '%s' %d times but was %d. Element instances:\n%s", new Object[]{this.actual, ElementAssertj.formatState(expectedState), elementSelector.describe(), expectedTimes, actualTimes, elementInstances.isEmpty() ? "<None>" : ElementAssertj.formatElementInstanceStates(elementInstances, (ElementInstance elementInstance) -> elementSelector.describe())})).isEqualTo((long)expectedTimes);
        });
    }

    public void hasNotActivatedElements(long processInstanceKey, List<ElementSelector> elementSelectors) {
        List<ElementInstance> elementInstances = this.dataSource.findElementInstances(ElementAssertj.elementInstanceFilter(processInstanceKey, elementSelectors));
        List<ElementSelector> activatedElements = ElementAssertj.getSelectorsWithInstances(elementSelectors, elementInstances);
        ((ListAssert)Assertions.assertThat(activatedElements).withFailMessage("%s should have not activated elements %s but the following elements were activated:\n%s", new Object[]{this.actual, ElementAssertj.formatElementSelectors(elementSelectors), ElementAssertj.formatElementInstanceStates(activatedElements, elementInstances)})).isEmpty();
    }

    public void hasNoActiveElements(long processInstanceKey, List<ElementSelector> elementSelectors) {
        Consumer<ElementInstanceFilter> elementInstanceFilter = ElementAssertj.elementInstanceFilter(processInstanceKey, elementSelectors).andThen(filter -> filter.state(ElementInstanceState.ACTIVE));
        this.awaitElementInstanceAssertion(elementInstanceFilter, elementInstances -> {
            List<ElementSelector> selectorsWithActiveElements = ElementAssertj.getSelectorsWithInstances(elementSelectors, elementInstances);
            ((ListAssert)Assertions.assertThat(selectorsWithActiveElements).withFailMessage("%s should have no active elements %s but the following elements were active:\n%s", new Object[]{this.actual, ElementAssertj.formatElementSelectors(elementSelectors), ElementAssertj.formatElementInstanceStates(selectorsWithActiveElements, elementInstances)})).isEmpty();
        });
    }

    public void hasActiveElementsExactly(long processInstanceKey, List<ElementSelector> elementSelectors) {
        this.awaitElementInstanceAssertion(ElementAssertj.processInstanceFilter(processInstanceKey), elementInstances -> {
            List<ElementInstance> activeElementInstances = ElementAssertj.getInstancesInState(elementInstances, ElementInstanceState.ACTIVE);
            List<ElementSelector> selectorsNotMatched = ElementAssertj.getSelectorsWithoutInstances(elementSelectors, activeElementInstances);
            List<ElementInstance> otherActiveElements = activeElementInstances.stream().filter(elementInstance -> elementSelectors.stream().noneMatch(selector -> selector.test((ElementInstance)elementInstance))).collect(Collectors.toList());
            ArrayList<String> failureMessages = new ArrayList<String>();
            if (!selectorsNotMatched.isEmpty()) {
                failureMessages.add(String.format("%s should have active elements %s but the following elements were not active:\n%s", this.actual, ElementAssertj.formatElementSelectors(elementSelectors), ElementAssertj.formatElementInstanceStates(selectorsNotMatched, elementInstances)));
            }
            if (!otherActiveElements.isEmpty()) {
                failureMessages.add(String.format("%s should have no active elements except %s but the following elements were active:\n%s", this.actual, ElementAssertj.formatElementSelectors(elementSelectors), ElementAssertj.formatElementInstanceStates(otherActiveElements, ElementInstance::getElementId)));
            }
            String combinedFailureMessage = String.join((CharSequence)"\n\n", failureMessages);
            ((ListAssert)Assertions.assertThat(selectorsNotMatched).withFailMessage(combinedFailureMessage, new Object[0])).isEmpty();
            ((ListAssert)Assertions.assertThat(otherActiveElements).withFailMessage(combinedFailureMessage, new Object[0])).isEmpty();
        });
    }

    public void hasCompletedElementsInOrder(long processInstanceKey, List<ElementSelector> elementSelectors) {
        this.awaitElementInstanceAssertion(ElementAssertj.processInstanceFilter(processInstanceKey), elementInstances -> {
            List<ElementInstance> relevantElementInstances = ElementAssertj.getInstancesInState(elementInstances, ElementInstanceState.COMPLETED).stream().filter(i -> elementSelectors.stream().anyMatch(e -> e.test((ElementInstance)i))).collect(Collectors.toList());
            boolean sequenceFound = IntStream.rangeClosed(0, relevantElementInstances.size() - elementSelectors.size()).mapToObj(index -> relevantElementInstances.subList(index, relevantElementInstances.size())).anyMatch(sublist -> ElementAssertj.containsSequence(sublist, elementSelectors));
            if (!sequenceFound) {
                Assertions.fail((String)String.format("%s should have completed elements %s in order, but only the following elements were completed:\n%s", this.actual, ElementAssertj.formatElementSelectors(elementSelectors), ElementAssertj.formatElementInstanceStates(relevantElementInstances, ElementInstance::getElementId)));
            }
        });
    }

    private static boolean containsSequence(List<ElementInstance> elementInstances, List<ElementSelector> elementSelectors) {
        for (int i = 0; i < elementSelectors.size(); ++i) {
            if (elementSelectors.get(i).test(elementInstances.get(i))) continue;
            return false;
        }
        return true;
    }

    private void awaitElementInstanceAssertion(Consumer<ElementInstanceFilter> filter, Consumer<List<ElementInstance>> assertion) {
        this.awaitBehavior.untilAsserted(() -> this.dataSource.findElementInstances(filter), assertion);
    }

    private static List<ElementInstance> getInstancesInState(List<ElementInstance> elementInstances, ElementInstanceState state) {
        return elementInstances.stream().filter(elementInstance -> elementInstance.getState().equals((Object)state)).collect(Collectors.toList());
    }

    private static List<ElementSelector> getSelectorsWithoutInstances(List<ElementSelector> elementSelectors, List<ElementInstance> elementInstances) {
        return elementSelectors.stream().filter(elementSelector -> elementInstances.stream().noneMatch(elementSelector::test)).collect(Collectors.toList());
    }

    private static List<ElementSelector> getSelectorsWithInstances(List<ElementSelector> elementSelectors, List<ElementInstance> elementInstances) {
        return elementSelectors.stream().filter(elementSelector -> elementInstances.stream().anyMatch(elementSelector::test)).collect(Collectors.toList());
    }

    private static String formatElementInstanceStates(List<ElementSelector> elementSelectors, List<ElementInstance> elementInstances) {
        return elementSelectors.stream().map(elementSelector -> {
            ElementInstanceState elementInstanceState = ElementAssertj.getElementInstanceStateForSelector(elementInstances, elementSelector);
            return String.format("\t- '%s': %s", elementSelector.describe(), ElementAssertj.formatState(elementInstanceState));
        }).collect(Collectors.joining("\n"));
    }

    private static ElementInstanceState getElementInstanceStateForSelector(List<ElementInstance> elementInstances, ElementSelector elementSelector) {
        return elementInstances.stream().filter(elementSelector::test).findFirst().map(ElementInstance::getState).orElse(ElementInstanceState.UNKNOWN_ENUM_VALUE);
    }

    private static String formatElementInstanceStates(List<ElementInstance> elementInstances, Function<ElementInstance, String> elementDescriptor) {
        return elementInstances.stream().map(elementInstance -> String.format("\t- '%s': %s", elementDescriptor.apply((ElementInstance)elementInstance), ElementAssertj.formatState(elementInstance.getState()))).collect(Collectors.joining("\n"));
    }

    private static String formatState(ElementInstanceState state) {
        if (state == null || state == ElementInstanceState.UNKNOWN_ENUM_VALUE) {
            return "not activated";
        }
        return state.name().toLowerCase();
    }

    private static String formatElementSelectors(List<ElementSelector> elementSelectors) {
        List<String> selectorList = elementSelectors.stream().map(ElementSelector::describe).collect(Collectors.toList());
        return AssertFormatUtil.formatNames(selectorList);
    }

    private static Consumer<ElementInstanceFilter> processInstanceFilter(long processInstanceKey) {
        return filter -> filter.processInstanceKey(processInstanceKey);
    }

    private static Consumer<ElementInstanceFilter> elementInstanceFilter(long processInstanceKey, List<ElementSelector> elementSelectors) {
        return elementSelectors.size() == 1 ? ElementAssertj.processInstanceFilter(processInstanceKey).andThen(elementSelectors.get(0)::applyFilter) : ElementAssertj.processInstanceFilter(processInstanceKey);
    }
}

