/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.api.search.enums.IncidentState;
import io.camunda.client.api.search.filter.IncidentFilter;
import io.camunda.client.api.search.response.Incident;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.ElementAssertj;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class IncidentAssertj
extends AbstractAssert<ElementAssertj, String> {
    private static final int MAX_ERROR_MESSAGE_LENGTH = 500;
    private static final List<IncidentState> ACTIVE_INCIDENT_STATES = Arrays.asList(IncidentState.ACTIVE, IncidentState.PENDING, IncidentState.MIGRATED);
    private final CamundaDataSource dataSource;
    private final CamundaAssertAwaitBehavior awaitBehavior;

    protected IncidentAssertj(CamundaDataSource dataSource, CamundaAssertAwaitBehavior awaitBehavior, String failureMessagePrefix) {
        super((Object)failureMessagePrefix, IncidentAssertj.class);
        this.dataSource = dataSource;
        this.awaitBehavior = awaitBehavior;
    }

    public void hasNoActiveIncidents(long processInstanceKey) {
        this.awaitIncidentAssertion(f -> f.processInstanceKey(Long.valueOf(processInstanceKey)), incidents -> {
            List<Incident> activeIncidents = this.activeIncidents((List<Incident>)incidents);
            ((ListAssert)Assertions.assertThat(activeIncidents).withFailMessage("%s should have no incidents, but the following incidents were active:\n%s", new Object[]{this.actual, this.collectIncidentReports(activeIncidents)})).isEmpty();
        });
    }

    public void hasActiveIncidents(long processInstanceKey) {
        this.awaitIncidentAssertion(f -> f.processInstanceKey(Long.valueOf(processInstanceKey)), incidents -> {
            List<Incident> activeIncidents = this.activeIncidents((List<Incident>)incidents);
            ((ListAssert)Assertions.assertThat(activeIncidents).withFailMessage("%s should have at least one active incident, but none were found", new Object[]{this.actual})).isNotEmpty();
        });
    }

    private List<Incident> activeIncidents(List<Incident> incidents) {
        return incidents.stream().filter(i -> ACTIVE_INCIDENT_STATES.contains(i.getState())).collect(Collectors.toList());
    }

    private void awaitIncidentAssertion(Consumer<IncidentFilter> filter, Consumer<List<Incident>> assertion) {
        this.awaitBehavior.untilAsserted(() -> this.dataSource.findIncidents(filter), assertion);
    }

    private String collectIncidentReports(List<Incident> incidents) {
        return incidents.stream().map(i -> String.format("\t- '%s' [type: %s] \"%s\"", i.getElementId(), i.getErrorType(), StringUtils.abbreviate((String)i.getErrorMessage(), (int)500))).collect(Collectors.joining("\n"));
    }
}

