/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.api.search.enums.MessageSubscriptionState;
import io.camunda.client.api.search.filter.CorrelatedMessageSubscriptionFilter;
import io.camunda.client.api.search.filter.MessageSubscriptionFilter;
import io.camunda.client.api.search.response.CorrelatedMessageSubscription;
import io.camunda.client.api.search.response.MessageSubscription;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class MessageSubscriptionAssertj
extends AbstractAssert<MessageSubscriptionAssertj, String> {
    private final CamundaDataSource dataSource;
    private final CamundaAssertAwaitBehavior awaitBehavior;

    public MessageSubscriptionAssertj(CamundaDataSource dataSource, CamundaAssertAwaitBehavior awaitBehavior, String failureMessagePrefix) {
        super((Object)failureMessagePrefix, MessageSubscriptionAssertj.class);
        this.dataSource = dataSource;
        this.awaitBehavior = awaitBehavior;
    }

    public void isWaitingForMessage(long processInstanceKey, String messageName) {
        this.awaitMessageSubscription(processInstanceKey, filter -> filter.messageName(messageName).messageSubscriptionState(MessageSubscriptionState.CREATED), messageSubscriptions -> ((ListAssert)Assertions.assertThat((List)messageSubscriptions).withFailMessage("%s should have an active message subscription [message-name: '%s'], but no such subscription was found.", new Object[]{this.actual, messageName})).isNotEmpty());
    }

    public void isWaitingForMessage(long processInstanceKey, String messageName, String correlationKey) {
        this.awaitMessageSubscription(processInstanceKey, f -> f.messageName(messageName).correlationKey(correlationKey), messageSubscriptions -> ((ListAssert)Assertions.assertThat((List)messageSubscriptions).withFailMessage("%s should have a message subscription [message-name: '%s', correlation-key: '%s'], but no such subscription was found.", new Object[]{this.actual, messageName, correlationKey})).isNotEmpty());
    }

    public void isNotWaitingForMessage(long processInstanceKey, String messageName) {
        this.awaitMessageSubscription(processInstanceKey, f -> f.messageName(messageName), messageSubscriptions -> ((ListAssert)Assertions.assertThat((List)messageSubscriptions).withFailMessage("%s should have no active message subscription [message-name: '%s'], but found <%d> active subscriptions.", new Object[]{this.actual, messageName, messageSubscriptions.size()})).isEmpty());
    }

    public void isNotWaitingForMessage(long processInstanceKey, String messageName, String correlationKey) {
        this.awaitMessageSubscription(processInstanceKey, filter -> filter.messageSubscriptionState(MessageSubscriptionState.CREATED).messageName(messageName).correlationKey(correlationKey), messageSubscriptions -> ((ListAssert)Assertions.assertThat((List)messageSubscriptions).withFailMessage("%s should have no active message subscription [message-name: '%s', correlation-key: '%s'], but found <%d> active subscriptions.", new Object[]{this.actual, messageName, correlationKey, messageSubscriptions.size()})).isEmpty());
    }

    public void hasCorrelatedMessage(long processInstanceKey, String messageName) {
        this.awaitCorrelatedMessages(processInstanceKey, filter -> filter.messageName(messageName), correlatedMessages -> ((ListAssert)Assertions.assertThat((List)correlatedMessages).withFailMessage("%s should have at least one correlated message [message-name: '%s'], but found none.", new Object[]{this.actual, messageName})).isNotEmpty());
    }

    public void hasCorrelatedMessage(long processInstanceKey, String messageName, String correlationKey) {
        this.awaitCorrelatedMessages(processInstanceKey, filter -> filter.messageName(messageName).correlationKey(correlationKey), correlatedMessages -> ((ListAssert)Assertions.assertThat((List)correlatedMessages).withFailMessage("%s should have at least one correlated message [message-name: '%s', correlation-key: '%s'], but found none.", new Object[]{this.actual, messageName, correlationKey})).isNotEmpty());
    }

    private void awaitMessageSubscription(long processInstanceKey, Consumer<MessageSubscriptionFilter> filter, Consumer<List<MessageSubscription>> assertionCallback) {
        this.awaitBehavior.untilAsserted(() -> this.dataSource.findMessageSubscriptions(f -> filter.accept(f.processInstanceKey(Long.valueOf(processInstanceKey)))), assertionCallback);
    }

    private void awaitCorrelatedMessages(long processInstanceKey, Consumer<CorrelatedMessageSubscriptionFilter> filter, Consumer<List<CorrelatedMessageSubscription>> assertionCallback) {
        this.awaitBehavior.untilAsserted(() -> this.dataSource.findCorrelatedMessages(f -> filter.accept(f.processInstanceKey(Long.valueOf(processInstanceKey)))), assertionCallback);
    }
}

